/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.egf.common.repository;

import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class BankIncreasingSequenceRepository {
    private String entityName = "aqap_increasing_sequence";
    private String selectName = "sequence_key,sequence_date,create_time,sequence_no";
    private static BankIncreasingSequenceRepository instance = new BankIncreasingSequenceRepository();

    public static BankIncreasingSequenceRepository getInstance() {
        return instance;
    }

    public void init(String key) {
        long bankSerialNo = 1L;
        DynamicObject dynamicObject = this.pack(key, bankSerialNo);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
    }

    private DynamicObject pack(String key, long bankSerialNo) {
        Date now = Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant());
        DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)this.entityName);
        dynamicObject.set("create_time", (Object)now);
        dynamicObject.set("sequence_key", (Object)key);
        dynamicObject.set("sequence_no", (Object)bankSerialNo);
        dynamicObject.set("sequence_date", (Object)LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        return dynamicObject;
    }

    public boolean update(DynamicObject dynamicObject) {
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
        return true;
    }

    public DynamicObject getBankSerialNo(String key, String queryDate) {
        QFilter filter = QFilter.of((String)"sequence_key = ? and sequence_date = ?", (Object[])new Object[]{key, queryDate});
        DynamicObject dynamicObjects = BusinessDataServiceHelper.loadSingle((String)this.entityName, (String)this.selectName, (QFilter[])filter.toArray());
        return dynamicObjects;
    }
}

