/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.egf.common.repository;

import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.ebg.egf.common.model.bank.BankSerialNo;

public class BankSerialNoRepository {
    private String entityName = "aqap_bank_serial_no";
    private static BankSerialNoRepository instance = new BankSerialNoRepository();

    public static BankSerialNoRepository getInstance() {
        return instance;
    }

    public void save(BankSerialNo bankSerialNo) {
        DynamicObject dynamicObject = this.pack(bankSerialNo);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
    }

    private DynamicObject pack(BankSerialNo bankSerialNo) {
        Date now = Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant());
        DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)this.entityName);
        dynamicObject.set("create_time", (Object)now);
        dynamicObject.set("number", (Object)bankSerialNo.getNumber());
        dynamicObject.set("custom_id", (Object)bankSerialNo.getCustomId());
        dynamicObject.set("bank_version", (Object)bankSerialNo.getBankVersionId());
        return dynamicObject;
    }

    public boolean isExsist(String number, String customId, String bankVersion) {
        QFilter filter = QFilter.of((String)"number=? and custom_id=? and bank_version=?", (Object[])new Object[]{number, customId, bankVersion});
        return QueryServiceHelper.exists((String)this.entityName, (QFilter[])filter.toArray());
    }
}

