/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.egf.common.repository.acnt;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Stack;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.model.data.Page;
import kd.ebg.egf.common.model.data.PageImpl;
import kd.ebg.egf.common.model.data.Pageable;
import kd.ebg.egf.common.model.properties.ObjectProperties;
import kd.ebg.egf.common.repository.acnt.MappingAcctRepository;
import kd.ebg.egf.common.repository.properties.ObjectPropertiesRepository;
import kd.ebg.egf.common.utils.db.QueryCacheUtil;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.sdk.annotation.SdkDeprecated;

public class BankAcntRepository {
    private String entityName = "aqap_bank_acnt";
    private String selectFields = "number,name,bank_name,bank_login.number,group.number,group.bank_name,bank_short_name,currency.number,addr,custom_id,has_receipt,country,province,city,has_note,branch_no,branch_name,cnapname,en_accname,swift_code";
    ObjectPropertiesRepository objectPropertiesRepository = ObjectPropertiesRepository.getInstance();
    private static BankAcntRepository instance = new BankAcntRepository();
    private MappingAcctRepository mappingAcctRepository = MappingAcctRepository.getInstance();

    public static BankAcntRepository getInstance() {
        return instance;
    }

    public boolean isExsist(String accNo, String customID) {
        QFilter filter = QFilter.of((String)"number=? and enable='1' and custom_id=?", (Object[])new Object[]{accNo, customID});
        return QueryServiceHelper.exists((String)this.entityName, (QFilter[])filter.toArray());
    }

    public BankAcnt findEnableByAccNo(String account) {
        BankAcnt bankAcnt = null;
        QFilter filter = QFilter.of((String)"number=? and enable='1'", (Object[])new Object[]{account});
        List<DynamicObject> collections = QueryCacheUtil.getDynamicObjectList(this.entityName, this.selectFields, filter.toArray());
        if (collections.size() == 1) {
            bankAcnt = new BankAcnt();
            bankAcnt.setAccNo(account);
            bankAcnt.setCustomID(collections.get(0).getString("custom_id"));
            bankAcnt.setAccName(collections.get(0).getString("name"));
            bankAcnt.setBankLoginId(collections.get(0).getString("bank_login.number"));
            bankAcnt.setBankName(collections.get(0).getString("bank_name"));
            bankAcnt.setBankShortName(collections.get(0).getString("bank_short_name"));
            bankAcnt.setBankVersionId(collections.get(0).getString("group.number"));
            bankAcnt.setCurrency(collections.get(0).getString("currency.number"));
            bankAcnt.setBankAddress(this.getDomainFullName(collections.get(0).getString("addr")));
            ObjectProperties objectProperties = this.objectPropertiesRepository.findByAttrKeyAndObjectNameAndObjectID("bank_area_code", "BANK_BUSINESS", account);
            bankAcnt.setAreaCode(objectProperties == null ? "" : objectProperties.getAttrValue());
            objectProperties = this.objectPropertiesRepository.findByAttrKeyAndObjectNameAndObjectID("bank_cnap", "BANK_BUSINESS", account);
            bankAcnt.setCnaps(objectProperties == null ? "" : objectProperties.getAttrValue());
            bankAcnt.setCountry(collections.get(0).getString("country"));
            bankAcnt.setProvince(collections.get(0).getString("province"));
            bankAcnt.setCity(collections.get(0).getString("city"));
            bankAcnt.setBranchNo(collections.get(0).getString("branch_no"));
            bankAcnt.setBranchName(collections.get(0).getString("branch_name"));
            bankAcnt.setCnapname(collections.get(0).getString("cnapname"));
            bankAcnt.setEnAccName(collections.get(0).getString("en_accname"));
            bankAcnt.setSwiftCode(collections.get(0).getString("swift_code"));
            objectProperties = this.objectPropertiesRepository.findByAttrKeyAndObjectNameAndObjectID("bank_ecny_type", "BANK_BUSINESS", bankAcnt.getAccNo());
            bankAcnt.setAccEcnyType(objectProperties == null ? "" : objectProperties.getAttrValue());
            objectProperties = this.objectPropertiesRepository.findByAttrKeyAndObjectNameAndObjectID("bank_ecny_level", "BANK_BUSINESS", bankAcnt.getAccNo());
            bankAcnt.setAccEcnyLevel(objectProperties == null ? "" : objectProperties.getAttrValue());
            String[] domains = bankAcnt.getBankAddress().split(",");
            if (StringUtils.isEmpty(bankAcnt.getProvince()) && domains.length > 0) {
                bankAcnt.setProvince(domains[0]);
            }
            if (StringUtils.isEmpty(bankAcnt.getCity()) && domains.length > 1) {
                bankAcnt.setCity(domains[1]);
            }
        }
        return this.mappingAcctRepository.loadProxy(bankAcnt);
    }

    @SdkDeprecated
    public BankAcnt findByAccNoAndCustomID(String account, String customID) {
        BankAcnt bankAcnt = null;
        QFilter filter = QFilter.of((String)"number=? and custom_id=? and enable='1'", (Object[])new Object[]{account, customID});
        List<DynamicObject> collections = QueryCacheUtil.getDynamicObjectList(this.entityName, this.selectFields, filter.toArray());
        if (collections.size() == 1) {
            bankAcnt = new BankAcnt();
            bankAcnt.setAccNo(account);
            bankAcnt.setCustomID(collections.get(0).getString("custom_id"));
            bankAcnt.setAccName(collections.get(0).getString("name"));
            bankAcnt.setBankLoginId(collections.get(0).getString("bank_login.number"));
            bankAcnt.setBankName(collections.get(0).getString("bank_name"));
            bankAcnt.setBankShortName(collections.get(0).getString("bank_short_name"));
            bankAcnt.setBankVersionId(collections.get(0).getString("group.number"));
            bankAcnt.setCurrency(collections.get(0).getString("currency.number"));
            bankAcnt.setBankAddress(this.getDomainFullName(collections.get(0).getString("addr")));
            ObjectProperties objectProperties = this.objectPropertiesRepository.findByAttrKeyAndObjectNameAndObjectID("bank_area_code", "BANK_BUSINESS", account);
            bankAcnt.setAreaCode(objectProperties == null ? "" : objectProperties.getAttrValue());
            objectProperties = this.objectPropertiesRepository.findByAttrKeyAndObjectNameAndObjectID("bank_cnap", "BANK_BUSINESS", account);
            bankAcnt.setCnaps(objectProperties == null ? "" : objectProperties.getAttrValue());
            bankAcnt.setCountry(collections.get(0).getString("country"));
            bankAcnt.setProvince(collections.get(0).getString("province"));
            bankAcnt.setCity(collections.get(0).getString("city"));
            bankAcnt.setBranchNo(collections.get(0).getString("branch_no"));
            bankAcnt.setBranchName(collections.get(0).getString("branch_name"));
            bankAcnt.setCnapname(collections.get(0).getString("cnapname"));
            bankAcnt.setEnAccName(collections.get(0).getString("en_accname"));
            bankAcnt.setSwiftCode(collections.get(0).getString("swift_code"));
            objectProperties = this.objectPropertiesRepository.findByAttrKeyAndObjectNameAndObjectID("bank_ecny_type", "BANK_BUSINESS", bankAcnt.getAccNo());
            bankAcnt.setAccEcnyType(objectProperties == null ? "" : objectProperties.getAttrValue());
            objectProperties = this.objectPropertiesRepository.findByAttrKeyAndObjectNameAndObjectID("bank_ecny_level", "BANK_BUSINESS", bankAcnt.getAccNo());
            bankAcnt.setAccEcnyLevel(objectProperties == null ? "" : objectProperties.getAttrValue());
            String[] domains = bankAcnt.getBankAddress().split(",");
            if (StringUtils.isEmpty(bankAcnt.getProvince()) && domains.length > 0) {
                bankAcnt.setProvince(domains[0]);
            }
            if (StringUtils.isEmpty(bankAcnt.getCity()) && domains.length > 1) {
                bankAcnt.setCity(domains[1]);
            }
        }
        return this.mappingAcctRepository.loadProxy(bankAcnt);
    }

    private String getDomainFullName(String addrCode) {
        if (StringUtils.isEmpty(addrCode)) {
            return "";
        }
        DynamicObject domainObject = BusinessDataServiceHelper.loadSingleFromCache((Object)addrCode, (String)"bd_admindivision", (String)"name,level,parent.id");
        if (domainObject == null) {
            domainObject = BusinessDataServiceHelper.loadSingle((Object)addrCode, (String)"bd_admindivision", (String)"name,level,parent.id");
        }
        long level = domainObject.getLong("level");
        long pid = domainObject.getLong("parent.id");
        String domainName = domainObject.getString("name");
        Stack<String> container = new Stack<String>();
        this.getDomainFullName(level, domainName, pid, container);
        StringBuilder sb = new StringBuilder();
        while (!container.empty()) {
            sb.append(container.pop()).append(',');
        }
        String domainFullName = sb.toString();
        if (domainFullName.endsWith(",")) {
            domainFullName = domainFullName.substring(0, domainFullName.length() - 1);
        }
        return domainFullName;
    }

    private void getDomainFullName(long level, String name, long parentID, Stack<String> container) {
        container.push(name);
        if (level == 1L) {
            return;
        }
        QFilter filter = QFilter.of((String)"id = ?", (Object[])new Object[]{parentID});
        DynamicObjectCollection dynamicObjectCollection = QueryServiceHelper.query((String)"bd_admindivision", (String)"name,level,parent.id", (QFilter[])filter.toArray());
        if (dynamicObjectCollection.size() > 0) {
            long lv = ((DynamicObject)dynamicObjectCollection.get(0)).getLong("level");
            long pid = ((DynamicObject)dynamicObjectCollection.get(0)).getLong("parent.id");
            String domainName = ((DynamicObject)dynamicObjectCollection.get(0)).getString("name");
            this.getDomainFullName(lv, domainName, pid, container);
        }
    }

    public List<BankAcnt> findByCustomID(String customID) {
        ArrayList<BankAcnt> bankAcnts = new ArrayList<BankAcnt>(1);
        QFilter filter = QFilter.of((String)"custom_id = ?", (Object[])new Object[]{customID});
        List<DynamicObject> dynamicObjects = QueryCacheUtil.getDynamicObjectList(this.entityName, this.selectFields, filter.toArray());
        for (DynamicObject dynamicObject : dynamicObjects) {
            bankAcnts.add(this.packBankAcnt(dynamicObject));
        }
        return bankAcnts;
    }

    public List<BankAcnt> findByCustomIDAndBankLoginID(String customID, String bankLoginID) {
        ArrayList<BankAcnt> bankAcnts = new ArrayList<BankAcnt>(1);
        QFilter filter = QFilter.of((String)"custom_id = ? and bank_login.number = ?", (Object[])new Object[]{customID, bankLoginID});
        List<DynamicObject> dynamicObjects = QueryCacheUtil.getDynamicObjectList(this.entityName, this.selectFields, filter.toArray());
        for (DynamicObject dynamicObject : dynamicObjects) {
            bankAcnts.add(this.packBankAcnt(dynamicObject));
        }
        return bankAcnts;
    }

    public List<BankAcnt> findListByCustomIDAndBankLoginIDAndEnable(String customID, String bankLoginID, String enable) {
        ArrayList<BankAcnt> bankAcnts = new ArrayList<BankAcnt>(1);
        QFilter filter = QFilter.of((String)"custom_id = ? and bank_login.number = ? and enable = ?", (Object[])new Object[]{customID, bankLoginID, enable});
        List<DynamicObject> dynamicObjects = QueryCacheUtil.getDynamicObjectList(this.entityName, this.selectFields, filter.toArray());
        for (DynamicObject dynamicObject : dynamicObjects) {
            bankAcnts.add(this.packBankAcnt(dynamicObject));
        }
        return bankAcnts;
    }

    public Page<BankAcnt> findByCustomIDAndBankLoginIDAndEnable(String customID, String bankLoginID, String enable, Pageable pageRequest) {
        int pageNumber = pageRequest.getPageNumber();
        int pageSize = pageRequest.getPageSize();
        PageImpl<BankAcnt> result = new PageImpl();
        ArrayList<BankAcnt> bankAcnts = new ArrayList<BankAcnt>(1);
        QFilter filter = QFilter.of((String)"custom_id = ? and bank_login.number = ? and enable = ?", (Object[])new Object[]{customID, bankLoginID, enable});
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)this.entityName, (String)this.selectFields, (QFilter[])filter.toArray(), (String)"", (int)pageNumber, (int)pageSize);
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)this.entityName, (String)"id", (QFilter[])filter.toArray(), (String)"");){
            for (DynamicObject dynamicObject : dynamicObjects) {
                bankAcnts.add(this.packBankAcnt(dynamicObject));
            }
            long total = 0L;
            if (ds != null) {
                total = ds.count("id", Boolean.FALSE.booleanValue());
            }
            PageImpl<BankAcnt> pageImpl = result = new PageImpl(bankAcnts, pageRequest, total);
            return pageImpl;
        }
    }

    public Page<BankAcnt> findByCustomIDAndBankLoginIDAndAcntAndEnable(String customID, String bankLoginID, String acnt, String enable, Pageable pageRequest) {
        int pageNumber = pageRequest.getPageNumber();
        int pageSize = pageRequest.getPageSize();
        PageImpl<BankAcnt> result = new PageImpl();
        ArrayList<BankAcnt> bankAcnts = new ArrayList<BankAcnt>(1);
        QFilter filter = QFilter.of((String)"custom_id = ? and bank_login.number = ? and enable = ?", (Object[])new Object[]{customID, bankLoginID, enable});
        QFilter filter2 = QFilter.like((String)"number", (String)acnt);
        String selectF = "name,bank_login, group,currency,addr,custom_id,has_receipt,country,province,city";
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)this.entityName, (String)this.selectFields, (QFilter[])new QFilter[]{filter, filter2}, (String)"", (int)pageNumber, (int)pageSize);
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)this.entityName, (String)"id", (QFilter[])filter.toArray(), (String)"");){
            for (DynamicObject dynamicObject : dynamicObjects) {
                bankAcnts.add(this.packBankAcnt(dynamicObject));
            }
            long total = 0L;
            if (ds != null) {
                total = ds.count("id", Boolean.FALSE.booleanValue());
            }
            PageImpl<BankAcnt> pageImpl = result = new PageImpl(bankAcnts, pageRequest, total);
            return pageImpl;
        }
    }

    public DynamicObject findDataByAccNoAndCustomId(String account, String customID) {
        StringBuilder expression = new StringBuilder();
        expression.append("number=?");
        QFilter filter = QFilter.of((String)expression.toString(), (Object[])new Object[]{account});
        if (!StringUtils.isEmpty(customID)) {
            expression.append(" and custom_id=?");
            filter = QFilter.of((String)expression.toString(), (Object[])new Object[]{account, customID});
        }
        DynamicObject data = BusinessDataServiceHelper.loadSingle((String)this.entityName, (String)this.selectFields, (QFilter[])filter.toArray());
        return data;
    }

    private BankAcnt packBankAcnt(DynamicObject dynamicObject) {
        BankAcnt bankAcnt = new BankAcnt();
        bankAcnt.setAccNo(dynamicObject.getString("number"));
        bankAcnt.setCustomID(dynamicObject.getString("custom_id"));
        bankAcnt.setAccName(dynamicObject.getString("name"));
        bankAcnt.setBankLoginId(dynamicObject.getString("bank_login.number"));
        bankAcnt.setBankName(dynamicObject.getString("bank_name"));
        bankAcnt.setBankShortName(dynamicObject.getString("bank_short_name"));
        bankAcnt.setBankVersionId(dynamicObject.getString("group.number"));
        bankAcnt.setCurrency(dynamicObject.getString("currency.number"));
        String hasReceipt = dynamicObject.getString("has_receipt");
        bankAcnt.setBranchNo(dynamicObject.getString("branch_no"));
        bankAcnt.setBranchName(dynamicObject.getString("branch_name"));
        bankAcnt.setCnapname(dynamicObject.getString("cnapname"));
        bankAcnt.setEnAccName(dynamicObject.getString("en_accname"));
        bankAcnt.setSwiftCode(dynamicObject.getString("swift_code"));
        if (Objects.equals(hasReceipt, "1")) {
            bankAcnt.setHasReceipt(true);
        } else {
            bankAcnt.setHasReceipt(false);
        }
        bankAcnt.setBankAddress(this.getDomainFullName(dynamicObject.getString("addr")));
        ObjectProperties objectProperties = this.objectPropertiesRepository.findByAttrKeyAndObjectNameAndObjectID("bank_area_code", "BANK_BUSINESS", bankAcnt.getAccNo());
        bankAcnt.setAreaCode(objectProperties == null ? "" : objectProperties.getAttrValue());
        objectProperties = this.objectPropertiesRepository.findByAttrKeyAndObjectNameAndObjectID("bank_cnap", "BANK_BUSINESS", bankAcnt.getAccNo());
        bankAcnt.setCnaps(objectProperties == null ? "" : objectProperties.getAttrValue());
        objectProperties = this.objectPropertiesRepository.findByAttrKeyAndObjectNameAndObjectID("bank_ecny_type", "BANK_BUSINESS", bankAcnt.getAccNo());
        bankAcnt.setAccEcnyType(objectProperties == null ? "" : objectProperties.getAttrValue());
        objectProperties = this.objectPropertiesRepository.findByAttrKeyAndObjectNameAndObjectID("bank_ecny_level", "BANK_BUSINESS", bankAcnt.getAccNo());
        bankAcnt.setAccEcnyLevel(objectProperties == null ? "" : objectProperties.getAttrValue());
        return this.mappingAcctRepository.loadProxy(bankAcnt);
    }

    public List<BankAcnt> findByCustomIDAndBankVersionIdAndHasReceipt(String customID, String bankVersion, boolean hasReceipt) {
        int hasReceiptInt = 0;
        if (hasReceipt) {
            hasReceiptInt = 1;
        }
        ArrayList<BankAcnt> bankAcntList = new ArrayList<BankAcnt>(1);
        QFilter filter = QFilter.of((String)"custom_id=? and group.number=? and has_receipt=?", (Object[])new Object[]{customID, bankVersion, hasReceiptInt});
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)this.entityName, (String)this.selectFields, (QFilter[])filter.toArray());
        BankAcnt bankAcnt = null;
        for (DynamicObject dynamicObject : dynamicObjects) {
            bankAcnt = new BankAcnt();
            bankAcnt.setAccNo(dynamicObject.getString("number"));
            bankAcnt.setCustomID(dynamicObject.getString("custom_id"));
            bankAcnt.setAccName(dynamicObject.getString("name"));
            bankAcnt.setBankLoginId(dynamicObject.getString("bank_login.number"));
            bankAcnt.setBankName(dynamicObject.getString("bank_name"));
            bankAcnt.setBankShortName(dynamicObject.getString("bank_short_name"));
            bankAcnt.setBankVersionId(dynamicObject.getString("group.number"));
            bankAcnt.setCurrency(dynamicObject.getString("currency.number"));
            bankAcnt.setHasReceipt(hasReceipt);
            bankAcnt.setBankAddress(this.getDomainFullName(dynamicObject.getString("addr")));
            bankAcnt.setBranchNo(dynamicObject.getString("branch_no"));
            bankAcnt.setBranchName(dynamicObject.getString("branch_name"));
            bankAcnt.setCnapname(dynamicObject.getString("cnapname"));
            bankAcnt.setSwiftCode(dynamicObject.getString("swift_code"));
            bankAcntList.add(this.mappingAcctRepository.loadProxy(bankAcnt));
        }
        return bankAcntList;
    }

    public List<BankAcnt> findByCustomIDAndBankVersionIdAndBankLoginIdAndHasReceipt(String customID, String bankVersion, String bankLoginId, boolean hasReceipt) {
        int hasReceiptInt = 0;
        if (hasReceipt) {
            hasReceiptInt = 1;
        }
        ArrayList<BankAcnt> bankAcntList = new ArrayList<BankAcnt>(1);
        QFilter filter = QFilter.of((String)"custom_id=? and group.number=? and has_receipt=? and bank_login.number=?", (Object[])new Object[]{customID, bankVersion, hasReceiptInt, bankLoginId});
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)this.entityName, (String)this.selectFields, (QFilter[])filter.toArray());
        BankAcnt bankAcnt = null;
        for (DynamicObject dynamicObject : dynamicObjects) {
            bankAcnt = new BankAcnt();
            bankAcnt.setAccNo(dynamicObject.getString("number"));
            bankAcnt.setCustomID(dynamicObject.getString("custom_id"));
            bankAcnt.setAccName(dynamicObject.getString("name"));
            bankAcnt.setBankLoginId(dynamicObject.getString("bank_login.number"));
            bankAcnt.setBankName(dynamicObject.getString("bank_name"));
            bankAcnt.setBankShortName(dynamicObject.getString("bank_short_name"));
            bankAcnt.setBankVersionId(dynamicObject.getString("group.number"));
            bankAcnt.setCurrency(dynamicObject.getString("currency.number"));
            bankAcnt.setHasReceipt(hasReceipt);
            bankAcnt.setBankAddress(this.getDomainFullName(dynamicObject.getString("addr")));
            bankAcnt.setBranchNo(dynamicObject.getString("branch_no"));
            bankAcnt.setBranchName(dynamicObject.getString("branch_name"));
            bankAcnt.setCnapname(dynamicObject.getString("cnapname"));
            bankAcnt.setSwiftCode(dynamicObject.getString("swift_code"));
            bankAcntList.add(this.mappingAcctRepository.loadProxy(bankAcnt));
        }
        return bankAcntList;
    }

    public List<BankAcnt> findByBankVersionIdAndBankLoginIdAndHasReceipt(String bankVersion, String bankLoginId, boolean hasReceipt) {
        int hasReceiptInt = 0;
        if (hasReceipt) {
            hasReceiptInt = 1;
        }
        ArrayList<BankAcnt> bankAcntList = new ArrayList<BankAcnt>(1);
        QFilter filter = QFilter.of((String)"group.number=? and has_receipt=? and bank_login.number=?", (Object[])new Object[]{bankVersion, String.valueOf(hasReceiptInt), bankLoginId});
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)this.entityName, (String)this.selectFields, (QFilter[])filter.toArray());
        BankAcnt bankAcnt = null;
        for (DynamicObject dynamicObject : dynamicObjects) {
            bankAcnt = new BankAcnt();
            bankAcnt.setAccNo(dynamicObject.getString("number"));
            bankAcnt.setCustomID(dynamicObject.getString("custom_id"));
            bankAcnt.setAccName(dynamicObject.getString("name"));
            bankAcnt.setBankLoginId(dynamicObject.getString("bank_login.number"));
            bankAcnt.setBankName(dynamicObject.getString("group.bank_name"));
            bankAcnt.setBankShortName(dynamicObject.getString("bank_short_name"));
            bankAcnt.setBankVersionId(dynamicObject.getString("group.number"));
            bankAcnt.setCurrency(dynamicObject.getString("currency.number"));
            bankAcnt.setHasReceipt(hasReceipt);
            bankAcnt.setBankAddress(this.getDomainFullName(dynamicObject.getString("addr")));
            bankAcnt.setBranchNo(dynamicObject.getString("branch_no"));
            bankAcnt.setBranchName(dynamicObject.getString("branch_name"));
            bankAcnt.setCnapname(dynamicObject.getString("cnapname"));
            bankAcnt.setSwiftCode(dynamicObject.getString("swift_code"));
            bankAcntList.add(this.mappingAcctRepository.loadProxy(bankAcnt));
        }
        return bankAcntList;
    }

    public int countByCustomIDAndBankVersionIdAndHasReceipt(String customID, String bankVersion, boolean hasReceipt) {
        int hasReceiptInt = 0;
        if (hasReceipt) {
            hasReceiptInt = 1;
        }
        QFilter filter = QFilter.of((String)"custom_id=? and group.number=? and has_receipt=?", (Object[])new Object[]{customID, bankVersion, String.valueOf(hasReceiptInt)});
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)this.entityName, (String)"count(id) as rc_acnt_count", (QFilter[])filter.toArray());
        return dynamicObject.getInt("rc_acnt_count");
    }

    public int countByCustomIDAndBankVersionIdAndHasReceipt(String customID, Long bankVersionID, boolean hasReceipt) {
        int hasReceiptInt = 0;
        if (hasReceipt) {
            hasReceiptInt = 1;
        }
        QFilter filter = QFilter.of((String)"custom_id=? and group.id=? and has_receipt=?", (Object[])new Object[]{customID, bankVersionID, String.valueOf(hasReceiptInt)});
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)this.entityName, (String)"count(id) as rc_acnt_count", (QFilter[])filter.toArray());
        return dynamicObject.getInt("rc_acnt_count");
    }

    public DynamicObject findById(Long id) {
        return BusinessDataServiceHelper.loadSingleFromCache((String)this.entityName, (String)"id, number, name, group.id, group, bank_login", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)id)});
    }

    public int countAcnt() {
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)this.entityName, (String)"id", (QFilter[])new QFilter[]{new QFilter("enable", "=", (Object)"1"), new QFilter("group.enable", "=", (Object)"1")}, (String)"");){
            int total;
            int n = total = ds.count("id", Boolean.FALSE.booleanValue());
            return n;
        }
    }

    public int countReceiptAcnt() {
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)this.entityName, (String)"id", (QFilter[])new QFilter[]{QFilter.of((String)"enable='1' and has_receipt='1' and group.enable='1'", (Object[])new Object[0])}, (String)"");){
            int total;
            int n = total = ds.count("id", Boolean.FALSE.booleanValue());
            return n;
        }
    }

    public int countNoteAcnt() {
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)this.entityName, (String)"id", (QFilter[])new QFilter[]{QFilter.of((String)"enable='1' and has_note='1' and group.enable='1'", (Object[])new Object[0])}, (String)"");){
            int total;
            int n = total = ds.count("id", Boolean.FALSE.booleanValue());
            return n;
        }
    }

    public DynamicObject countReceiptAcntByBankVersionID(String bankVersionID) {
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)this.entityName, (String)"count(1) as acnt_count, sum(case when has_receipt= '1' then 1 else 0 end) as rc_acnt_count", (QFilter[])new QFilter[]{QFilter.of((String)"enable='1' and group.number=?", (Object[])new Object[]{bankVersionID})});
        return dynamicObject;
    }

    public DynamicObject countNoteAcntByBankVersionID(String bankVersionID) {
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)this.entityName, (String)"count(1) as acnt_count, sum(case when has_note= '1' then 1 else 0 end) as rc_acnt_count", (QFilter[])new QFilter[]{QFilter.of((String)"enable='1' and group.number=?", (Object[])new Object[]{bankVersionID})});
        return dynamicObject;
    }

    public DynamicObject loadSingleByAccno(String accno) {
        return BusinessDataServiceHelper.loadSingle((String)this.entityName, (String)this.selectFields, (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)accno)});
    }

    public void update(String accountID, String newAccountID) {
        DynamicObject[] dynamicObject;
        for (DynamicObject dynamicObject1 : dynamicObject = this.findOneById(accountID)) {
            dynamicObject1.set("custom_id", (Object)newAccountID);
        }
        SaveServiceHelper.update((DynamicObject[])dynamicObject);
    }

    public DynamicObject[] findOneById(String customID) {
        QFilter filter = QFilter.of((String)"custom_id=?", (Object[])new Object[]{customID});
        DynamicObject[] dynamicObject = BusinessDataServiceHelper.load((String)this.entityName, (String)this.selectFields, (QFilter[])filter.toArray());
        return dynamicObject;
    }

    public List<BankAcnt> findByCustomIDAndBankVersionIdAndHasReconciliation(String customID, String bankVersion, boolean hasReconciliation) {
        int hasReceiptInt = 0;
        if (hasReconciliation) {
            hasReceiptInt = 1;
        }
        ArrayList<BankAcnt> bankAcntList = new ArrayList<BankAcnt>(16);
        QFilter filter = QFilter.of((String)"custom_id=? and group.number=? and has_receipt=? and enable=?", (Object[])new Object[]{customID, bankVersion, String.valueOf(hasReceiptInt), "1"});
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)this.entityName, (String)this.selectFields, (QFilter[])filter.toArray());
        BankAcnt bankAcnt = null;
        for (DynamicObject dynamicObject : dynamicObjects) {
            bankAcnt = new BankAcnt();
            bankAcnt.setAccNo(dynamicObject.getString("number"));
            bankAcnt.setCustomID(dynamicObject.getString("custom_id"));
            bankAcnt.setAccName(dynamicObject.getString("name"));
            bankAcnt.setBankLoginId(dynamicObject.getString("bank_login.number"));
            bankAcnt.setBankName(dynamicObject.getString("bank_name"));
            bankAcnt.setBankShortName(dynamicObject.getString("bank_short_name"));
            bankAcnt.setBankVersionId(dynamicObject.getString("group.number"));
            bankAcnt.setCurrency(dynamicObject.getString("currency.number"));
            bankAcnt.setHasReceipt(hasReconciliation);
            bankAcnt.setBankAddress(this.getDomainFullName(dynamicObject.getString("addr")));
            bankAcnt.setBranchNo(dynamicObject.getString("branch_no"));
            bankAcnt.setBranchName(dynamicObject.getString("branch_name"));
            bankAcnt.setCnapname(dynamicObject.getString("cnapname"));
            bankAcntList.add(bankAcnt);
        }
        return bankAcntList;
    }

    public List<BankAcnt> findByBankVersionIdAndBankLoginIdAndHasReconciliation(String bankVersion, String bankLoginId, boolean hasReconciliation) {
        int hasReceiptInt = 0;
        if (hasReconciliation) {
            hasReceiptInt = 1;
        }
        ArrayList<BankAcnt> bankAcntList = new ArrayList<BankAcnt>(16);
        QFilter filter = QFilter.of((String)"group.number=? and has_receipt=? and bank_login.number=? and enable=?", (Object[])new Object[]{bankVersion, String.valueOf(hasReceiptInt), bankLoginId, "1"});
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)this.entityName, (String)this.selectFields, (QFilter[])filter.toArray());
        BankAcnt bankAcnt = null;
        for (DynamicObject dynamicObject : dynamicObjects) {
            bankAcnt = new BankAcnt();
            bankAcnt.setAccNo(dynamicObject.getString("number"));
            bankAcnt.setCustomID(dynamicObject.getString("custom_id"));
            bankAcnt.setAccName(dynamicObject.getString("name"));
            bankAcnt.setBankLoginId(dynamicObject.getString("bank_login.number"));
            bankAcnt.setBankName(dynamicObject.getString("bank_name"));
            bankAcnt.setBankShortName(dynamicObject.getString("bank_short_name"));
            bankAcnt.setBankVersionId(dynamicObject.getString("group.number"));
            bankAcnt.setCurrency(dynamicObject.getString("currency.number"));
            bankAcnt.setHasReceipt(hasReconciliation);
            bankAcnt.setBankAddress(this.getDomainFullName(dynamicObject.getString("addr")));
            bankAcnt.setBranchNo(dynamicObject.getString("branch_no"));
            bankAcnt.setBranchName(dynamicObject.getString("branch_name"));
            bankAcnt.setCnapname(dynamicObject.getString("cnapname"));
            bankAcntList.add(this.mappingAcctRepository.loadProxy(bankAcnt));
        }
        return bankAcntList;
    }

    public DynamicObject[] loadByCustomID(String customID) {
        QFilter filter = QFilter.of((String)"custom_id = ?", (Object[])new Object[]{customID});
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)this.entityName, (String)this.selectFields, (QFilter[])filter.toArray());
        return dynamicObjects;
    }
}

