/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.egf.common.repository.bank.login;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.ebg.egf.common.model.bank.login.BankLoginRel;
import kd.ebg.egf.common.utils.collect.CollectionUtil;

public class BankLoginRelRepository {
    public String ENTITY_KEY = "aqap_bank_login_rel";
    public String SELECT_PROPERTIES = "master_number, config_type, exclusive_number";
    private static BankLoginRelRepository instance = new BankLoginRelRepository();

    public static BankLoginRelRepository getInstance() {
        return instance;
    }

    public DynamicObjectCollection findByMasterNumberIn(List<String> bankLoginIds) {
        return QueryServiceHelper.query((String)this.ENTITY_KEY, (String)this.SELECT_PROPERTIES, (QFilter[])new QFilter[]{new QFilter("master_number", "in", bankLoginIds)});
    }

    public DynamicObjectCollection findByConfigTypeAndMasterNumberIn(String configType, List<String> bankLoginIds) {
        return QueryServiceHelper.query((String)this.ENTITY_KEY, (String)this.SELECT_PROPERTIES, (QFilter[])new QFilter[]{new QFilter("config_type", "=", (Object)configType), new QFilter("master_number", "in", bankLoginIds)});
    }

    public DynamicObject findByMasterNumber(String masterNumer) {
        return QueryServiceHelper.queryOne((String)this.ENTITY_KEY, (String)this.SELECT_PROPERTIES, (QFilter[])new QFilter[]{new QFilter("master_number", "=", (Object)masterNumer)});
    }

    public DynamicObject findByConfigTypeAndMasterNumber(String configType, String masterNumer) {
        return QueryServiceHelper.queryOne((String)this.ENTITY_KEY, (String)this.SELECT_PROPERTIES, (QFilter[])new QFilter[]{new QFilter("config_type", "=", (Object)configType), new QFilter("master_number", "=", (Object)masterNumer)});
    }

    public DynamicObject findByMasterNumberAndConfigType(String masterNumer, String configType) {
        return QueryServiceHelper.queryOne((String)this.ENTITY_KEY, (String)this.SELECT_PROPERTIES, (QFilter[])new QFilter[]{QFilter.of((String)"master_number=? and config_type=?", (Object[])new Object[]{masterNumer, configType})});
    }

    public void deleteByExclusiveNumber(String bankLoginID) {
        DeleteServiceHelper.delete((String)this.ENTITY_KEY, (QFilter[])new QFilter[]{new QFilter("exclusive_number", "=", (Object)bankLoginID)});
    }

    public void save(String masterNumber, String configType, String exclusiveNumber) {
        DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)this.ENTITY_KEY);
        Date date = new Date();
        dynamicObject.set("createtime", (Object)date);
        dynamicObject.set("modifytime", (Object)date);
        dynamicObject.set("master_number", (Object)masterNumber);
        dynamicObject.set("config_type", (Object)configType);
        dynamicObject.set("exclusive_number", (Object)exclusiveNumber);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
    }

    public List<BankLoginRel> findByConfigType(String configType) {
        ArrayList<BankLoginRel> result = new ArrayList<BankLoginRel>(16);
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)this.ENTITY_KEY, (String)this.SELECT_PROPERTIES, (QFilter[])new QFilter[]{new QFilter("config_type", "=", (Object)configType)});
        if (CollectionUtil.isNotEmpty((Collection)dynamicObjects)) {
            for (DynamicObject dynamicObject : dynamicObjects) {
                result.add(this.dynamicObject2BankLoginRel(dynamicObject));
            }
        }
        return result;
    }

    BankLoginRel dynamicObject2BankLoginRel(DynamicObject dynamicObject) {
        BankLoginRel bankLoginRel = new BankLoginRel();
        bankLoginRel.setConfigType(dynamicObject.getString("config_type"));
        bankLoginRel.setExclusiveNumber(dynamicObject.getString("exclusive_number"));
        bankLoginRel.setMasterNumber(dynamicObject.getString("master_number"));
        return bankLoginRel;
    }
}

