/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.egf.common.repository.bank.login;

import java.util.ArrayList;
import java.util.List;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.ebg.egf.common.constant.BankTypeEnum;
import kd.ebg.egf.common.model.bank.login.BankLogin;
import kd.ebg.egf.common.model.bank.login.BankLoginKey;
import kd.ebg.egf.common.utils.string.StringUtils;

public class BankLoginRepository {
    public static String ENTITY_NAME = "aqap_bank_login";
    public static String SELECT_PROPERTIES = "number, name, alias, group.name, group.number, group.bank_name, custom_id, config_type, enable,group.bank_type";
    private static BankLoginRepository instance = new BankLoginRepository();

    public static BankLoginRepository getInstance() {
        return instance;
    }

    public List<BankLogin> findByBankVersionId(String bankVersionId) {
        return new ArrayList<BankLogin>(1);
    }

    public List<BankLogin> findOverseaBankByCustomId(String customId) {
        ArrayList<BankLogin> logins = new ArrayList<BankLogin>(1);
        String selectProperties = SELECT_PROPERTIES;
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)ENTITY_NAME, (String)selectProperties, (QFilter[])new QFilter[]{new QFilter("group.bank_type", "=", (Object)String.valueOf(BankTypeEnum.waizi.getValue())), new QFilter("custom_id", "=", (Object)customId), new QFilter("enable", "=", (Object)"1")});
        for (int i = 0; i < dynamicObjects.length; ++i) {
            BankLogin bankLogin = new BankLogin();
            BankLoginKey bankLoginKey = new BankLoginKey();
            String bankLoginId = dynamicObjects[i].getString("number");
            bankLoginKey.setBankLoginId(bankLoginId);
            bankLoginKey.setCustomId(customId);
            bankLogin.setKey(bankLoginKey);
            String bankVersionName = dynamicObjects[i].getString("group.name");
            String bankVersionId = dynamicObjects[i].getString("group.number");
            String bankName = dynamicObjects[i].getString("group.bank_name");
            int bankLoginCount = 1;
            String bankLoginName = dynamicObjects[i].getString("name");
            bankLogin.setBankVersionId(bankVersionId);
            bankLogin.setBankVersionName(bankVersionName);
            bankLogin.setBankName(bankName);
            bankLogin.setBankLoginCount(bankLoginCount);
            bankLogin.setBankLoginName(bankLoginName);
            bankLogin.setConfigType(dynamicObjects[i].getString("config_type"));
            logins.add(bankLogin);
        }
        return logins;
    }

    public List<BankLogin> findByBankVersionIdAndCustomId(String bankVersionId, String customId) {
        ArrayList<BankLogin> logins = new ArrayList<BankLogin>(1);
        String selectProperties = SELECT_PROPERTIES;
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)ENTITY_NAME, (String)selectProperties, (QFilter[])new QFilter[]{new QFilter("group.number", "=", (Object)bankVersionId), new QFilter("custom_id", "=", (Object)customId)});
        for (int i = 0; i < dynamicObjects.length; ++i) {
            BankLogin bankLogin = new BankLogin();
            BankLoginKey bankLoginKey = new BankLoginKey();
            String bankLoginId = dynamicObjects[i].getString("number");
            bankLoginKey.setBankLoginId(bankLoginId);
            bankLoginKey.setCustomId(customId);
            bankLogin.setKey(bankLoginKey);
            String bankVersionName = dynamicObjects[i].getString("group.name");
            String bankName = dynamicObjects[i].getString("group.bank_name");
            int bankLoginCount = 1;
            String bankLoginName = dynamicObjects[i].getString("name");
            bankLogin.setBankVersionId(bankVersionId);
            bankLogin.setBankVersionName(bankVersionName);
            bankLogin.setBankName(bankName);
            bankLogin.setBankLoginCount(bankLoginCount);
            bankLogin.setBankLoginName(bankLoginName);
            bankLogin.setConfigType(dynamicObjects[i].getString("config_type"));
            logins.add(bankLogin);
        }
        return logins;
    }

    public List<BankLogin> findByBankVersionsAndCustomerID(List<String> bankVersionId, String customerId) {
        return new ArrayList<BankLogin>(1);
    }

    public long countByBankVersionIdAndCustomerId(String bankVersionId, String customerId) {
        return 0L;
    }

    public List<BankLogin> findAllByCustomerID(String customerId) {
        ArrayList<BankLogin> logins = new ArrayList<BankLogin>(1);
        StringBuilder expression = new StringBuilder();
        ArrayList<String> paramsList = new ArrayList<String>(1);
        if (StringUtils.isNotEmpty(customerId)) {
            expression.append("custom_id=?").append(' ');
            paramsList.add(customerId);
        }
        QFilter filter = QFilter.of((String)expression.toString(), (Object[])paramsList.toArray());
        String selectProperties = SELECT_PROPERTIES;
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)ENTITY_NAME, (String)selectProperties, (QFilter[])filter.toArray());
        for (int i = 0; i < dynamicObjects.length; ++i) {
            BankLogin bankLogin = new BankLogin();
            BankLoginKey bankLoginKey = new BankLoginKey();
            String bankLoginId = dynamicObjects[i].getString("number");
            String customId = "";
            bankLoginKey.setBankLoginId(bankLoginId);
            bankLoginKey.setCustomId(customId);
            bankLogin.setKey(bankLoginKey);
            String bankVersionId = dynamicObjects[i].getString("group.number");
            String bankVersionName = dynamicObjects[i].getString("group.name");
            String bankName = dynamicObjects[i].getString("group.bank_name");
            int bankLoginCount = 1;
            String bankLoginName = dynamicObjects[i].getString("name");
            bankLogin.setBankVersionId(bankVersionId);
            bankLogin.setBankVersionName(bankVersionName);
            bankLogin.setBankName(bankName);
            bankLogin.setBankLoginCount(bankLoginCount);
            bankLogin.setBankLoginName(bankLoginName);
            bankLogin.setBankLoginAlias(dynamicObjects[i].getString("alias"));
            bankLogin.setEnable(dynamicObjects[i].getString("enable"));
            bankLogin.setConfigType(dynamicObjects[i].getString("config_type"));
            logins.add(bankLogin);
        }
        return logins;
    }

    public List<BankLogin> findAllByCustomerIDAndEnable(String customerId, String enable) {
        ArrayList<BankLogin> logins = new ArrayList<BankLogin>(1);
        QFilter filter = QFilter.of((String)"custom_id=?  and enable=?", (Object[])new Object[]{customerId, enable});
        String selectProperties = SELECT_PROPERTIES;
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)ENTITY_NAME, (String)selectProperties, (QFilter[])filter.toArray(), (String)"number asc");
        for (int i = 0; i < dynamicObjects.length; ++i) {
            BankLogin bankLogin = new BankLogin();
            BankLoginKey bankLoginKey = new BankLoginKey();
            String bankLoginId = dynamicObjects[i].getString("number");
            String customId = "";
            bankLoginKey.setBankLoginId(bankLoginId);
            bankLoginKey.setCustomId(customId);
            bankLogin.setKey(bankLoginKey);
            String bankVersionId = dynamicObjects[i].getString("group.number");
            String bankVersionName = dynamicObjects[i].getString("group.name");
            String bankName = dynamicObjects[i].getString("group.bank_name");
            int bankLoginCount = 1;
            String bankLoginName = dynamicObjects[i].getString("name");
            bankLogin.setBankVersionId(bankVersionId);
            bankLogin.setBankVersionName(bankVersionName);
            bankLogin.setBankName(bankName);
            bankLogin.setBankLoginCount(bankLoginCount);
            bankLogin.setBankLoginName(bankLoginName);
            bankLogin.setEnable(dynamicObjects[i].getString("enable"));
            bankLogin.setConfigType(dynamicObjects[i].getString("config_type"));
            logins.add(bankLogin);
        }
        return logins;
    }

    public BankLogin findById(String bankLoginId, String customID) {
        BankLoginKey key = new BankLoginKey();
        key.setCustomId(customID);
        key.setBankLoginId(bankLoginId);
        return this.findById(key);
    }

    public BankLogin findById(BankLoginKey key) {
        BankLogin bankLogin = null;
        String selectProperties = SELECT_PROPERTIES;
        QFilter filter = QFilter.of((String)"number=? and custom_id=?", (Object[])new Object[]{key.getBankLoginId(), key.getCustomId()});
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)ENTITY_NAME, (String)selectProperties, (QFilter[])filter.toArray());
        if (dynamicObject != null) {
            String bankVersionId = dynamicObject.getString("group.number");
            String bankVersionName = dynamicObject.getString("group.name");
            String bankName = dynamicObject.getString("group.bank_name");
            int bankLoginCount = 1;
            String bankLoginName = dynamicObject.getString("name");
            bankLogin = new BankLogin();
            bankLogin.setBankVersionId(bankVersionId);
            bankLogin.setBankVersionName(bankVersionName);
            bankLogin.setBankName(bankName);
            bankLogin.setBankLoginCount(bankLoginCount);
            bankLogin.setBankLoginName(bankLoginName);
            bankLogin.setEnable(dynamicObject.getString("enable"));
            bankLogin.setKey(key);
            bankLogin.setConfigType(dynamicObject.getString("config_type"));
        }
        return bankLogin;
    }

    public BankLogin findByFId(String id, String customId) {
        BankLogin bankLogin = null;
        String selectProperties = SELECT_PROPERTIES;
        QFilter filter = QFilter.of((String)"id=? and custom_id=?", (Object[])new Object[]{Long.parseLong(id), customId});
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)ENTITY_NAME, (String)selectProperties, (QFilter[])filter.toArray());
        if (dynamicObject != null) {
            String bankVersionId = dynamicObject.getString("group.number");
            String bankVersionName = dynamicObject.getString("group.name");
            String bankName = dynamicObject.getString("group.bank_name");
            int bankLoginCount = 1;
            String bankLoginName = dynamicObject.getString("number");
            bankLogin = new BankLogin();
            bankLogin.setBankVersionId(bankVersionId);
            bankLogin.setBankVersionName(bankVersionName);
            bankLogin.setBankName(bankName);
            bankLogin.setBankLoginCount(bankLoginCount);
            bankLogin.setBankLoginName(bankLoginName);
            bankLogin.setEnable(dynamicObject.getString("enable"));
            BankLoginKey key = new BankLoginKey();
            key.setCustomId(customId);
            key.setBankLoginId(id);
            bankLogin.setKey(key);
            bankLogin.setConfigType(dynamicObject.getString("config_type"));
        }
        return bankLogin;
    }

    public DynamicObject findDynamicByIdAndCustomId(BankLoginKey key) {
        StringBuilder expression = new StringBuilder();
        expression.append("number=?");
        String customID = key.getCustomId();
        QFilter filter = QFilter.of((String)expression.toString(), (Object[])new Object[]{key.getBankLoginId()});
        if (!StringUtils.isEmpty(customID)) {
            expression.append(" and custom_id=?");
            filter = QFilter.of((String)expression.toString(), (Object[])new Object[]{key.getBankLoginId(), customID});
        }
        String selectProperties = SELECT_PROPERTIES;
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)ENTITY_NAME, (String)selectProperties, (QFilter[])filter.toArray());
        return dynamicObject;
    }

    public OperationResult saveOperate(DynamicObject bankVersionDynamicObject) {
        DynamicObject[] dynamicObjects = new DynamicObject[]{bankVersionDynamicObject};
        OperationResult result = SaveServiceHelper.saveOperate((String)ENTITY_NAME, (DynamicObject[])dynamicObjects, (OperateOption)OperateOption.create());
        return result;
    }

    public void save(DynamicObject bankVersionDynamicObject) {
        Object[] dynamicObjects = new DynamicObject[]{bankVersionDynamicObject};
        BusinessDataWriter.save((IDataEntityType)bankVersionDynamicObject.getDataEntityType(), (Object[])dynamicObjects);
    }

    public void update(String accountID, String newAccountID) {
        DynamicObject[] dynamicObject;
        for (DynamicObject dynamicObject1 : dynamicObject = this.findOneById(accountID)) {
            dynamicObject1.set("custom_id", (Object)newAccountID);
        }
        SaveServiceHelper.update((DynamicObject[])dynamicObject);
    }

    public DynamicObject[] findOneById(String customID) {
        String selectProperties = "id, custom_id";
        QFilter filter = QFilter.of((String)"custom_id=?", (Object[])new Object[]{customID});
        DynamicObject[] dynamicObject = BusinessDataServiceHelper.load((String)ENTITY_NAME, (String)selectProperties, (QFilter[])filter.toArray());
        return dynamicObject;
    }

    public BankLogin findEnableByBankLoginIdAndCustomId(String bankLoginId, String customId) {
        String selectProperties = SELECT_PROPERTIES;
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)ENTITY_NAME, (String)selectProperties, (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)bankLoginId), new QFilter("custom_id", "=", (Object)customId), new QFilter("enable", "=", (Object)"1")});
        if (dynamicObjects == null || dynamicObjects.length == 0) {
            return null;
        }
        DynamicObject dynamicObject = dynamicObjects[0];
        BankLogin bankLogin = new BankLogin();
        BankLoginKey bankLoginKey = new BankLoginKey();
        bankLoginKey.setBankLoginId(bankLoginId);
        bankLoginKey.setCustomId(customId);
        bankLogin.setKey(bankLoginKey);
        String bankVersionId = dynamicObject.getString("group.number");
        String bankVersionName = dynamicObject.getString("group.name");
        String bankName = dynamicObject.getString("group.bank_name");
        int bankLoginCount = 1;
        String bankLoginName = dynamicObject.getString("name");
        bankLogin.setBankVersionId(bankVersionId);
        bankLogin.setBankVersionName(bankVersionName);
        bankLogin.setBankName(bankName);
        bankLogin.setBankLoginCount(bankLoginCount);
        bankLogin.setBankLoginName(bankLoginName);
        bankLogin.setConfigType(dynamicObject.getString("config_type"));
        return bankLogin;
    }

    public List<BankLogin> findEnableByBankVersionIdAndCustomId(String bankVersionId, String customId) {
        ArrayList<BankLogin> logins = new ArrayList<BankLogin>(1);
        String selectProperties = SELECT_PROPERTIES;
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)ENTITY_NAME, (String)selectProperties, (QFilter[])new QFilter[]{new QFilter("group.number", "=", (Object)bankVersionId), new QFilter("custom_id", "=", (Object)customId), new QFilter("enable", "=", (Object)"1")});
        for (int i = 0; i < dynamicObjects.length; ++i) {
            BankLogin bankLogin = new BankLogin();
            BankLoginKey bankLoginKey = new BankLoginKey();
            String bankLoginId = dynamicObjects[i].getString("number");
            bankLoginKey.setBankLoginId(bankLoginId);
            bankLoginKey.setCustomId(customId);
            bankLogin.setKey(bankLoginKey);
            String bankVersionName = dynamicObjects[i].getString("group.name");
            String bankName = dynamicObjects[i].getString("group.bank_name");
            int bankLoginCount = 1;
            String bankLoginName = dynamicObjects[i].getString("name");
            bankLogin.setBankVersionId(bankVersionId);
            bankLogin.setBankVersionName(bankVersionName);
            bankLogin.setBankName(bankName);
            bankLogin.setBankLoginCount(bankLoginCount);
            bankLogin.setBankLoginName(bankLoginName);
            bankLogin.setConfigType(dynamicObjects[i].getString("config_type"));
            logins.add(bankLogin);
        }
        return logins;
    }

    public BankLogin findEnableBankLogin(BankLoginKey key) {
        BankLogin bankLogin = null;
        String selectProperties = "number,enable, name, group.name, group.number,group.bank_name";
        QFilter filter = QFilter.of((String)"number=? and enable=? ", (Object[])new Object[]{key.getBankLoginId(), "1"});
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)ENTITY_NAME, (String)selectProperties, (QFilter[])filter.toArray());
        if (dynamicObject != null) {
            bankLogin = new BankLogin();
            String bankVersionId = dynamicObject.getString("group.number");
            String bankVersionName = dynamicObject.getString("group.name");
            String bankName = dynamicObject.getString("group.bank_name");
            bankLogin.setEnable("true");
            int bankLoginCount = 1;
            String bankLoginName = dynamicObject.getString("name");
            bankLogin.setBankVersionId(bankVersionId);
            bankLogin.setBankVersionName(bankVersionName);
            bankLogin.setBankName(bankName);
            bankLogin.setBankLoginCount(bankLoginCount);
            bankLogin.setBankLoginName(bankLoginName);
            bankLogin.setKey(key);
        }
        return bankLogin;
    }

    public DynamicObject[] loadByCustomID(String customID) {
        QFilter filter = QFilter.of((String)"custom_id = ?", (Object[])new Object[]{customID});
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)ENTITY_NAME, (String)SELECT_PROPERTIES, (QFilter[])filter.toArray());
        return dynamicObjects;
    }

    public List<BankLogin> findNoteLoginByCustomerIDAndEnable(String customerId, String enable) {
        ArrayList<BankLogin> logins = new ArrayList<BankLogin>(1);
        QFilter filter = QFilter.of((String)"custom_id=?  and enable=? and group.note_status=?", (Object[])new Object[]{customerId, enable, ResManager.loadKDString((String)"\u652f\u6301", (String)"BankLoginRepository_0", (String)"ebg-egf-common", (Object[])new Object[0])});
        String selectProperties = SELECT_PROPERTIES;
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)ENTITY_NAME, (String)selectProperties, (QFilter[])new QFilter[]{filter}, (String)"number asc");
        for (int i = 0; i < dynamicObjects.length; ++i) {
            BankLogin bankLogin = new BankLogin();
            BankLoginKey bankLoginKey = new BankLoginKey();
            String bankLoginId = dynamicObjects[i].getString("number");
            String customId = "";
            bankLoginKey.setBankLoginId(bankLoginId);
            bankLoginKey.setCustomId(customId);
            bankLogin.setKey(bankLoginKey);
            String bankVersionId = dynamicObjects[i].getString("group.number");
            String bankVersionName = dynamicObjects[i].getString("group.name");
            String bankName = dynamicObjects[i].getString("group.bank_name");
            int bankLoginCount = 1;
            String bankLoginName = dynamicObjects[i].getString("name");
            bankLogin.setBankVersionId(bankVersionId);
            bankLogin.setBankVersionName(bankVersionName);
            bankLogin.setBankName(bankName);
            bankLogin.setBankLoginCount(bankLoginCount);
            bankLogin.setBankLoginName(bankLoginName);
            bankLogin.setEnable(dynamicObjects[i].getString("enable"));
            bankLogin.setConfigType(dynamicObjects[i].getString("config_type"));
            logins.add(bankLogin);
        }
        return logins;
    }
}

