/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.egf.common.repository.license;

import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.ebg.egf.common.license.EbgLicenseModuleEnum;
import kd.ebg.egf.common.model.license.LicenseDetail;
import kd.ebg.egf.common.utils.LocalDateUtil;

public class LicenseDetailRepository {
    private String LICENSE_DETAIL_ENTITY = "aqap_license_detail";
    private String SELECT_ALL_PROPERTIES = "id,module_name,module_code,modifytime,createtime,creatorid,modifierid,custom_id,bank_version,bank_login_id";
    private static LicenseDetailRepository instance = new LicenseDetailRepository();

    public static LicenseDetailRepository getInstance() {
        return instance;
    }

    public List<LicenseDetail> findLicenseDetailByModuleCodeAndCustomId(String moduleCode, String customId) {
        DynamicObject[] dynamicObjects;
        ArrayList<LicenseDetail> list = new ArrayList<LicenseDetail>(16);
        QFilter filter = QFilter.of((String)"module_code = ? and custom_id = ?", (Object[])new Object[]{moduleCode, customId});
        for (DynamicObject dynamicObject : dynamicObjects = BusinessDataServiceHelper.load((String)this.LICENSE_DETAIL_ENTITY, (String)this.SELECT_ALL_PROPERTIES, (QFilter[])filter.toArray())) {
            list.add(this.transferLicenseInfo(dynamicObject));
        }
        return list;
    }

    public List<LicenseDetail> findLicenseDetailByCustomId(String customId) {
        DynamicObject[] dynamicObjects;
        ArrayList<LicenseDetail> list = new ArrayList<LicenseDetail>(16);
        QFilter filter = QFilter.of((String)"custom_id = ?", (Object[])new Object[]{customId});
        for (DynamicObject dynamicObject : dynamicObjects = BusinessDataServiceHelper.load((String)this.LICENSE_DETAIL_ENTITY, (String)this.SELECT_ALL_PROPERTIES, (QFilter[])filter.toArray())) {
            list.add(this.transferLicenseInfo(dynamicObject));
        }
        return list;
    }

    public boolean isModuleExist(String moduleCode, String bankVersion, String customId) {
        QFilter filter = QFilter.of((String)"module_code = ? and bank_version = ? and custom_id = ?", (Object[])new Object[]{moduleCode, bankVersion, customId});
        return QueryServiceHelper.exists((String)this.LICENSE_DETAIL_ENTITY, (QFilter[])filter.toArray());
    }

    private LicenseDetail transferLicenseInfo(DynamicObject dynamicObject) {
        LicenseDetail licenseDetail = new LicenseDetail();
        licenseDetail.setId(dynamicObject.getLong("id"));
        licenseDetail.setCreatorid(dynamicObject.getString("creatorid"));
        licenseDetail.setModifierid(dynamicObject.getString("modifierid"));
        licenseDetail.setModuleName(dynamicObject.getString("module_name"));
        licenseDetail.setModuleCode(dynamicObject.getString("module_code"));
        licenseDetail.setCreatetime(LocalDateUtil.date2LocalDateTime(dynamicObject.getDate("createtime")));
        licenseDetail.setModifytime(LocalDateUtil.date2LocalDateTime(dynamicObject.getDate("modifytime")));
        licenseDetail.setBankVersion(dynamicObject.getString("bank_version"));
        licenseDetail.setBankLoginId(dynamicObject.getString("bank_login_id"));
        licenseDetail.setCustomId(dynamicObject.getString("custom_id"));
        return licenseDetail;
    }

    public void save(LicenseDetail licenseDetail) {
        DynamicObject dynamicObject = this.packLicenseInfo(null, licenseDetail);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
    }

    public void update(LicenseDetail licenseDetail) {
        DynamicObject dynamicObject = this.findOneById(licenseDetail.getId());
        dynamicObject = this.packLicenseInfo(dynamicObject, licenseDetail);
        SaveServiceHelper.update((DynamicObject[])new DynamicObject[]{dynamicObject});
    }

    private DynamicObject packLicenseInfo(DynamicObject dynamicObject, LicenseDetail licenseDetail) {
        Date now = Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant());
        if (dynamicObject == null) {
            dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)this.LICENSE_DETAIL_ENTITY);
            dynamicObject.set("createtime", (Object)now);
            dynamicObject.set("creatorid", (Object)Long.parseLong(licenseDetail.getCreatorid()));
        } else {
            dynamicObject.set("id", (Object)licenseDetail.getId());
            dynamicObject.set("modifytime", (Object)now);
        }
        dynamicObject.set("module_name", (Object)licenseDetail.getModuleName());
        dynamicObject.set("module_code", (Object)licenseDetail.getModuleCode());
        dynamicObject.set("custom_id", (Object)licenseDetail.getCustomId());
        dynamicObject.set("bank_version", (Object)licenseDetail.getBankVersion());
        dynamicObject.set("bank_login_id", (Object)licenseDetail.getBankLoginId());
        return dynamicObject;
    }

    public DynamicObject findOneById(long id) {
        QFilter filter = QFilter.of((String)"id=?", (Object[])new Object[]{id});
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)this.LICENSE_DETAIL_ENTITY, (String)this.SELECT_ALL_PROPERTIES, (QFilter[])filter.toArray());
        return dynamicObject;
    }

    public List<LicenseDetail> findNoteLicenseDetailByCustomId(String customId) {
        ArrayList<LicenseDetail> list = new ArrayList<LicenseDetail>(16);
        QFilter filter = QFilter.of((String)"custom_id = ? and module_code = ?", (Object[])new Object[]{customId, EbgLicenseModuleEnum.NOTE.getModuleCode()});
        Map objectDynamicObjectMap = BusinessDataServiceHelper.loadFromCache((String)this.LICENSE_DETAIL_ENTITY, (String)this.SELECT_ALL_PROPERTIES, (QFilter[])filter.toArray());
        for (Map.Entry map : objectDynamicObjectMap.entrySet()) {
            list.add(this.transferLicenseInfo((DynamicObject)map.getValue()));
        }
        return list;
    }

    public List<LicenseDetail> findLicenseDetailByCustomIdExcludeNote(String customId) {
        ArrayList<LicenseDetail> list = new ArrayList<LicenseDetail>(16);
        QFilter filter = QFilter.of((String)"custom_id = ? and module_code <> ?", (Object[])new Object[]{customId, EbgLicenseModuleEnum.NOTE.getModuleCode()});
        Map objectDynamicObjectMap = BusinessDataServiceHelper.loadFromCache((String)this.LICENSE_DETAIL_ENTITY, (String)this.SELECT_ALL_PROPERTIES, (QFilter[])filter.toArray());
        for (Map.Entry map : objectDynamicObjectMap.entrySet()) {
            list.add(this.transferLicenseInfo((DynamicObject)map.getValue()));
        }
        return list;
    }
}

