/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.egf.common.utils;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.ebg.egf.common.framework.security.manage.AESCipherSecurity;
import kd.ebg.egf.common.framework.security.manage.CipherInfo;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StringUtils;

public class CipherCertUtil {
    static EBGLogger logger = EBGLogger.getInstance().getLogger(CipherCertUtil.class);

    public static String encrypt(String data) {
        if (StringUtils.isEmptyExcludeSpace(data)) {
            return data;
        }
        AESCipherSecurity security = AESCipherSecurity.getInstance();
        return security.encrypt(data);
    }

    public static String desEncrypt(String data, Long id) {
        if (StringUtils.isEmptyExcludeSpace(data)) {
            return data;
        }
        AESCipherSecurity cipherSecurity = AESCipherSecurity.getInstance();
        CipherInfo cipherInfo = CipherCertUtil.getCipherInfo(data);
        int version = cipherInfo.getCipherVersion();
        String plainData = "";
        if (cipherSecurity.getVersion() != version) {
            plainData = version == 0 ? data : cipherSecurity.decrypt(data, version);
            CipherCertUtil.updateCipherData(cipherSecurity, plainData, id);
        } else {
            plainData = cipherSecurity.decrypt(data);
        }
        return plainData;
    }

    private static CipherInfo getCipherInfo(String cipherData) {
        CipherInfo cInfo = new CipherInfo();
        int version = 0;
        String[] data = cipherData.split("\\|");
        if (data.length == 2) {
            version = Integer.parseInt(data[1]);
        }
        cInfo.setCipherData(data[0]);
        cInfo.setCipherVersion(version);
        return cInfo;
    }

    private static void updateCipherData(AESCipherSecurity cipherSecurity, String plainData, Long id) {
        String toUpdateCipherData = cipherSecurity.encrypt(plainData);
        CipherCertUtil.updateCipher("aqap_bd_cert", id, "cert_password", toUpdateCipherData);
    }

    private static void updateCipher(String entity, Long id, String column, String toUpdateCipherData) {
        try {
            QFilter filter = QFilter.of((String)"id=?", (Object[])new Object[]{id});
            DynamicObject object = BusinessDataServiceHelper.loadSingle((String)entity, (String)column, (QFilter[])filter.toArray());
            object.set(column, (Object)toUpdateCipherData);
            SaveServiceHelper.update((DynamicObject[])new DynamicObject[]{object});
        }
        catch (Exception e) {
            logger.error(e.toString(), e);
        }
    }
}

