/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.egf.common.utils;

import java.security.Key;
import java.security.SecureRandom;
import java.util.Locale;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.security.manage.AESCipherSecurity;
import kd.ebg.egf.common.framework.security.manage.CipherInfo;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.BASE64Util;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.sdk.annotation.SdkDeprecated;
import org.apache.commons.codec.binary.Base64;

public class DesUtil {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(DesUtil.class);
    private static String CIPHER_PD;
    private static String CIPHER_ADMIN_PD;

    private static String getCipherPD() {
        if (StringUtils.isEmpty(CIPHER_PD)) {
            QFilter filter = QFilter.of((String)"algo=? and group=? and enable=?", (Object[])new Object[]{"DES", "USER", "1"});
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)"aqap_cipher", (QFilter[])filter.toArray());
            String key = dynamicObject.getString("key");
            CIPHER_PD = BASE64Util.decodeBase64(key);
        }
        return CIPHER_PD;
    }

    private static String getAdminCipherPD() {
        if (StringUtils.isEmpty(CIPHER_ADMIN_PD)) {
            QFilter filter = QFilter.of((String)"algo=? and group=? and enable=?", (Object[])new Object[]{"DES", "ADMIN", "1"});
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)"aqap_cipher", (QFilter[])filter.toArray());
            String key = dynamicObject.getString("key");
            CIPHER_ADMIN_PD = BASE64Util.decodeBase64(key);
        }
        return CIPHER_ADMIN_PD;
    }

    public static byte[] encrypt(byte[] datasource, String password) {
        AESCipherSecurity security = AESCipherSecurity.getInstance();
        try {
            return security.encryptToByte(datasource);
        }
        catch (Throwable e) {
            logger.error("DES \u52a0\u5bc6\u5f02\u5e38\uff0c\u8be6\u60c5\uff1a" + e.toString());
            return datasource;
        }
    }

    public static byte[] decrypt(byte[] src, String password) {
        try {
            SecureRandom random = new SecureRandom();
            DESKeySpec desKey = new DESKeySpec(password.getBytes());
            SecretKeyFactory keyFactory = SecretKeyFactory.getInstance("DES");
            SecretKey securekey = keyFactory.generateSecret(desKey);
            Cipher cipher = Cipher.getInstance("DES");
            cipher.init(2, (Key)securekey, random);
            return cipher.doFinal(src);
        }
        catch (Exception e) {
            logger.monitorError("ebg Cipher desEncrypt error: " + e.toString(), e);
            throw EBExceiptionUtil.serviceException(e);
        }
    }

    public static String parseByte2HexStr(byte[] buf) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < buf.length; ++i) {
            String hex = Integer.toHexString(buf[i] & 0xFF);
            if (hex.length() == 1) {
                hex = '0' + hex;
            }
            sb.append(hex.toUpperCase(Locale.ENGLISH));
        }
        return sb.toString();
    }

    public static byte[] parseHexStr2Byte(String hexStr) {
        if (hexStr.length() < 1) {
            return null;
        }
        byte[] result = new byte[hexStr.length() / 2];
        for (int i = 0; i < hexStr.length() / 2; ++i) {
            int high = Integer.parseInt(hexStr.substring(i * 2, i * 2 + 1), 16);
            int low = Integer.parseInt(hexStr.substring(i * 2 + 1, i * 2 + 2), 16);
            result[i] = (byte)(high * 16 + low);
        }
        return result;
    }

    public static String decryptPwd(String pwd, String customId) {
        try {
            String desPwd = DesUtil.encryptPwd(customId);
            String newPwd = StringUtils.byteToString(DesUtil.decrypt(DesUtil.parseHexStr2Byte(pwd), desPwd));
            return newPwd;
        }
        catch (Exception e) {
            return pwd;
        }
    }

    public static String decryptPwd(String pwd, String customId, String entity, String id, String column) {
        AESCipherSecurity cipherSecurity = AESCipherSecurity.getInstance();
        CipherInfo cipherInfo = cipherSecurity.getCipherInfo(pwd);
        int version = cipherInfo.getCipherVersion();
        String plainData = "";
        if (version == 0) {
            plainData = DesUtil.decryptPwd(pwd, customId);
            String toUpdateCipherData = cipherSecurity.encrypt(plainData);
            DesUtil.updateCipher(entity, id, column, toUpdateCipherData);
        } else if (cipherSecurity.getVersion() != version) {
            plainData = cipherSecurity.decrypt(pwd, version);
            String toUpdateCipherData = cipherSecurity.encrypt(plainData);
            DesUtil.updateCipher(entity, id, column, toUpdateCipherData);
        } else {
            plainData = cipherSecurity.decrypt(pwd);
        }
        return plainData;
    }

    private static void updateCipher(String entity, String id, String column, String toUpdateCipherData) {
        try {
            QFilter filter = QFilter.of((String)"id=? and custom_id=?", (Object[])new Object[]{Long.parseLong(id), RequestContext.get().getTenantId()});
            DynamicObject object = BusinessDataServiceHelper.loadSingle((String)entity, (String)column, (QFilter[])filter.toArray());
            object.set(column, (Object)toUpdateCipherData);
            SaveServiceHelper.update((DynamicObject[])new DynamicObject[]{object});
        }
        catch (Exception e) {
            logger.error(e.toString(), e);
        }
    }

    public static String encryptPwd(String pwd, String customId) {
        AESCipherSecurity cipherSecurity = AESCipherSecurity.getInstance();
        return cipherSecurity.encrypt(pwd);
    }

    public static String encryptProxyCert(byte[] bytes, String customId) {
        AESCipherSecurity cipherSecurity = AESCipherSecurity.getInstance();
        byte[] fileBytes = cipherSecurity.encryptToByte(bytes);
        StringBuilder sb = new StringBuilder();
        sb.append(Base64.encodeBase64String((byte[])fileBytes));
        sb.append('|');
        sb.append(cipherSecurity.getVersion());
        return sb.toString();
    }

    public static byte[] decryptProxyCert(byte[] cert, String customId, int version, String id) {
        byte[] plainData;
        AESCipherSecurity cipherSecurity = AESCipherSecurity.getInstance();
        if (version == 0) {
            plainData = DesUtil.decryptProxyCert(cert, customId);
            DesUtil.updateCipherData(cipherSecurity, plainData, id);
        } else if (cipherSecurity.getVersion() != version) {
            plainData = cipherSecurity.decryptToBytes(cert, version);
            DesUtil.updateCipherData(cipherSecurity, plainData, id);
        } else {
            plainData = cipherSecurity.decryptToBytes(cert, cipherSecurity.getVersion());
        }
        return plainData;
    }

    @SdkDeprecated
    public static byte[] decryptProxyCert(byte[] bytes, String customId) {
        try {
            String chiperPd = DesUtil.encryptPwd(customId);
            return DesUtil.decrypt(bytes, chiperPd);
        }
        catch (Exception e) {
            return bytes;
        }
    }

    public static String encryptPwd(String cipherPd) {
        if (StringUtils.isEmpty(cipherPd)) {
            cipherPd = DesUtil.getAdminCipherPD();
        }
        return DesUtil.parseByte2HexStr(DesUtil.encrypt(cipherPd.getBytes(), DesUtil.getCipherPD()));
    }

    private static void updateCipherData(AESCipherSecurity cipherSecurity, byte[] plainData, String id) {
        String toUpdateCipherData = cipherSecurity.encrypt(plainData);
        DesUtil.updateCipher("aqap_bd_cert", id, "bank_config_value_tag", toUpdateCipherData);
    }
}

