/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.egf.common.utils.crypto;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import kd.ebg.egf.common.utils.crypto.DigestAlgorithm;
import kd.ebg.egf.common.utils.crypto.HexUtil;
import kd.ebg.egf.common.utils.string.StrUtil;

public class Digester {
    private MessageDigest digest;

    public Digester(DigestAlgorithm algorithm) {
        this(algorithm.getValue());
    }

    public Digester(String algorithm) {
        this.init(algorithm);
    }

    public final Digester init(String algorithm) {
        try {
            this.digest = MessageDigest.getInstance(algorithm);
            return this;
        }
        catch (NoSuchAlgorithmException var3) {
            return null;
        }
    }

    public byte[] digest(String data, String charset) {
        return this.digest(StrUtil.bytes((CharSequence)data, charset));
    }

    public byte[] digest(String data) {
        return this.digest(data, "UTF-8");
    }

    public String digestHex(String data, String charset) {
        return HexUtil.encodeHexStr(this.digest(data, charset));
    }

    public String digestHex(String data) {
        return this.digestHex(data, "UTF-8");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] digest(File file) {
        BufferedInputStream in = null;
        byte[] var3 = null;
        try {
            in = new BufferedInputStream(new FileInputStream(file));
            var3 = this.digest(in);
        }
        catch (Exception exception) {
        }
        finally {
            if (null != in) {
                try {
                    in.close();
                }
                catch (Exception exception) {}
            }
        }
        return var3;
    }

    public String digestHex(File file) {
        return HexUtil.encodeHexStr(this.digest(file));
    }

    public byte[] digest(byte[] data) {
        byte[] result;
        try {
            result = this.digest.digest(data);
        }
        finally {
            this.digest.reset();
        }
        return result;
    }

    public String digestHex(byte[] data) {
        return HexUtil.encodeHexStr(this.digest(data));
    }

    public byte[] digest(InputStream data) {
        return this.digest(data, 1024);
    }

    public String digestHex(InputStream data) {
        return HexUtil.encodeHexStr(this.digest(data));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] digest(InputStream data, int bufferLength) {
        if (bufferLength < 1) {
            bufferLength = 1024;
        }
        byte[] buffer = new byte[bufferLength];
        Object var4 = null;
        try {
            byte[] result;
            int read = data.read(buffer, 0, bufferLength);
            while (read > -1) {
                this.digest.update(buffer, 0, read);
                read = data.read(buffer, 0, bufferLength);
            }
            byte[] byArray = result = this.digest.digest();
            return byArray;
        }
        catch (IOException var9) {
            byte[] byArray = null;
            return byArray;
        }
        finally {
            this.digest.reset();
        }
    }

    public String digestHex(InputStream data, int bufferLength) {
        return HexUtil.encodeHexStr(this.digest(data, bufferLength));
    }

    public MessageDigest getDigest() {
        return this.digest;
    }
}

