/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.egf.common.utils.file;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Base64;
import java.util.zip.ZipFile;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.file.CleanPathUtil;
import org.apache.commons.io.FileUtils;

public class FileCommonUtils {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(FileCommonUtils.class);
    private static final String FILE_NAME_SUFFIX = ".";

    public static String checkPath(String path) {
        path = CleanPathUtil.cleanString(path);
        return path;
    }

    public static File getFileByPath(String path) {
        File file = FileUtils.getFile((String[])new String[]{path});
        return file;
    }

    public static File getFileByPath(String path, String fileName) {
        String url = path + File.separator + fileName;
        File file = FileUtils.getFile((String[])new String[]{url});
        return file;
    }

    public static ZipFile getZipFileByPath(String filePath, Charset charset) throws IOException {
        File file = FileUtils.getFile((String[])new String[]{filePath});
        ZipFile zipFile = new ZipFile(file.getPath(), charset);
        return zipFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean base64ToFile(String fileContent, String filepath) {
        logger.info("\u6b63\u5728\u4ece\u54cd\u5e94\u62a5\u6587\u4e2d\u63d0\u53d6zip\u6587\u4ef6...");
        File file = null;
        FileOutputStream out = null;
        ByteArrayInputStream in = null;
        try {
            file = FileCommonUtils.getFileByPath(filepath);
            if (!file.exists()) {
                boolean isCreate = file.createNewFile();
                logger.info("\u521b\u5efa\u6587\u4ef6\uff1a{}\uff0c\u662f\u5426\u6210\u529f\uff1a{}", filepath, isCreate);
            }
            byte[] bytes = Base64.getDecoder().decode(fileContent);
            in = new ByteArrayInputStream(bytes);
            byte[] buffer = new byte[1024];
            out = new FileOutputStream(file);
            int byteread = 0;
            while ((byteread = in.read(buffer)) != -1) {
                out.write(buffer, 0, byteread);
            }
            out.flush();
        }
        catch (IOException ioe) {
            logger.error(ioe.getMessage());
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException e) {
                logger.error(e.getMessage());
            }
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException e) {
                logger.error(e.getMessage());
            }
            logger.info("\u54cd\u5e94\u62a5\u6587\u4e2d\u63d0\u53d6zip\u6587\u4ef6\u5b8c\u6210");
        }
        return true;
    }
}

