/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.egf.common.utils.string;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kd.ebg.egf.common.utils.NumberUtil;
import kd.ebg.egf.common.utils.collect.ArrayUtil;
import kd.ebg.egf.common.utils.collect.CollectionUtil;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.sdk.annotation.SdkDeprecated;

public class StrUtil {
    public static final String CRLF = "\r\n";
    public static final String EMPTY = "";
    private static final String[] EMPTY_STRING_ARRAY = new String[0];

    public static boolean isBlank(CharSequence str) {
        int length;
        if (str != null && (length = str.length()) != 0) {
            for (int i = 0; i < length; ++i) {
                if (StrUtil.isBlankChar(str.charAt(i))) continue;
                return false;
            }
            return true;
        }
        return true;
    }

    @SdkDeprecated
    public static boolean isNotBlank(CharSequence str) {
        return !StrUtil.isBlank(str);
    }

    public static boolean isBlankChar(int c) {
        return Character.isWhitespace(c) || Character.isSpaceChar(c);
    }

    public static StringBuilder builder() {
        return new StringBuilder();
    }

    public static String format(CharSequence template, Object ... params) {
        if (null == template) {
            return null;
        }
        return !StrUtil.isEmpty(params) && !StrUtil.isBlank(template) ? StrUtil.format(template.toString(), params) : template.toString();
    }

    public static <T> boolean isEmpty(T ... array) {
        return array == null || array.length == 0;
    }

    public static boolean isEmpty(String str) {
        return str == null || str.length() == 0;
    }

    public static String format(String strPattern, Object ... argArray) {
        if (!StrUtil.isBlank(strPattern) && !StrUtil.isEmpty(argArray)) {
            int strPatternLength = strPattern.length();
            StringBuilder sbuf = new StringBuilder(strPatternLength + 50);
            int handledPosition = 0;
            for (int argIndex = 0; argIndex < argArray.length; ++argIndex) {
                int delimIndex = strPattern.indexOf("{}", handledPosition);
                if (delimIndex == -1) {
                    if (handledPosition == 0) {
                        return strPattern;
                    }
                    sbuf.append(strPattern, handledPosition, strPatternLength);
                    return sbuf.toString();
                }
                if (delimIndex > 0 && strPattern.charAt(delimIndex - 1) == '\\') {
                    if (delimIndex > 1 && strPattern.charAt(delimIndex - 2) == '\\') {
                        sbuf.append(strPattern, handledPosition, delimIndex - 1);
                        sbuf.append(StrUtil.utf8Str(argArray[argIndex]));
                        handledPosition = delimIndex + 2;
                        continue;
                    }
                    --argIndex;
                    sbuf.append(strPattern, handledPosition, delimIndex - 1);
                    sbuf.append('{');
                    handledPosition = delimIndex + 1;
                    continue;
                }
                sbuf.append(strPattern, handledPosition, delimIndex);
                sbuf.append(StrUtil.utf8Str(argArray[argIndex]));
                handledPosition = delimIndex + 2;
            }
            sbuf.append(strPattern, handledPosition, strPattern.length());
            return sbuf.toString();
        }
        return strPattern;
    }

    public static String utf8Str(Object obj) {
        return StrUtil.str(obj, Charset.forName("UTF-8"));
    }

    public static String str(Object obj, Charset charset) {
        if (null == obj) {
            return null;
        }
        if (obj instanceof String) {
            return (String)obj;
        }
        if (obj instanceof byte[]) {
            return StringUtils.byteToString((byte[])obj, charset);
        }
        return StrUtil.isArray(obj) ? StrUtil.toString(obj) : obj.toString();
    }

    public static boolean isArray(Object obj) {
        return null == obj ? false : obj.getClass().isArray();
    }

    public static String toString(Object obj) {
        if (null == obj) {
            return null;
        }
        if (StrUtil.isArray(obj)) {
            try {
                return Arrays.deepToString((Object[])obj);
            }
            catch (Exception var5) {
                String className = obj.getClass().getComponentType().getName();
                int var4 = -1;
                switch (className.hashCode()) {
                    case -1325958191: {
                        if (!className.equalsIgnoreCase("double")) break;
                        var4 = 7;
                        break;
                    }
                    case 104431: {
                        if (!className.equalsIgnoreCase("int")) break;
                        var4 = 1;
                        break;
                    }
                    case 3039496: {
                        if (!className.equalsIgnoreCase("byte")) break;
                        var4 = 4;
                        break;
                    }
                    case 3052374: {
                        if (!className.equalsIgnoreCase("char")) break;
                        var4 = 3;
                        break;
                    }
                    case 3327612: {
                        if (!className.equalsIgnoreCase("long")) break;
                        var4 = 0;
                        break;
                    }
                    case 64711720: {
                        if (!className.equalsIgnoreCase("boolean")) break;
                        var4 = 5;
                        break;
                    }
                    case 97526364: {
                        if (!className.equalsIgnoreCase("float")) break;
                        var4 = 6;
                        break;
                    }
                    case 109413500: {
                        if (!className.equalsIgnoreCase("short")) break;
                        var4 = 2;
                    }
                }
                switch (var4) {
                    case 0: {
                        return Arrays.toString((long[])obj);
                    }
                    case 1: {
                        return Arrays.toString((int[])obj);
                    }
                    case 2: {
                        return Arrays.toString((short[])obj);
                    }
                    case 3: {
                        return Arrays.toString((char[])obj);
                    }
                    case 4: {
                        return Arrays.toString((byte[])obj);
                    }
                    case 5: {
                        return Arrays.toString((boolean[])obj);
                    }
                    case 6: {
                        return Arrays.toString((float[])obj);
                    }
                    case 7: {
                        return Arrays.toString((double[])obj);
                    }
                }
                throw new RuntimeException(var5);
            }
        }
        return obj.toString();
    }

    public static boolean equals(String str1, String str2) {
        if (str1 == null || str2 == null) {
            return false;
        }
        return str1.equalsIgnoreCase(str2);
    }

    public static byte[] bytes(CharSequence str, String charset) {
        return StrUtil.bytes(str, StrUtil.isBlank(charset) ? Charset.defaultCharset() : Charset.forName(charset));
    }

    public static byte[] bytes(CharSequence str, Charset charset) {
        if (str == null) {
            return null;
        }
        return null == charset ? str.toString().getBytes() : str.toString().getBytes(charset);
    }

    public static String nullToEmpty(CharSequence str) {
        return StrUtil.nullToDefault(str, EMPTY);
    }

    public static String nullToDefault(CharSequence str, String defaultStr) {
        return str == null ? defaultStr : str.toString();
    }

    public static String trim(CharSequence str, int mode) {
        int start;
        if (str == null) {
            return null;
        }
        int length = str.length();
        int end = length;
        if (mode <= 0) {
            for (start = 0; start < end && NumberUtil.isBlankChar(str.charAt(start)); ++start) {
            }
        }
        if (mode >= 0) {
            while (start < end && NumberUtil.isBlankChar(str.charAt(end - 1))) {
                --end;
            }
        }
        return start <= 0 && end >= length ? str.toString() : str.toString().substring(start, end);
    }

    public static String trim(CharSequence str) {
        return null == str ? null : StrUtil.trim(str, 0);
    }

    public static void trim(String[] strs) {
        if (null != strs) {
            for (int i = 0; i < strs.length; ++i) {
                String str = strs[i];
                if (null == str) continue;
                strs[i] = str.trim();
            }
        }
    }

    public static String[] split(String str, String s) {
        return str.split(s);
    }

    public static List<String> split(String str, char c) {
        String[] strings = str.split(String.valueOf(c));
        return Arrays.asList(strings);
    }

    public static String padEnd(CharSequence str, int minLength, char padChar) {
        if (null == str) {
            str = EMPTY;
        } else if (str.length() >= minLength) {
            return str.toString();
        }
        return str.toString().concat(StrUtil.repeat(padChar, minLength - str.length()));
    }

    public static String repeat(char c, int count) {
        if (count <= 0) {
            return EMPTY;
        }
        char[] result = new char[count];
        for (int i = 0; i < count; ++i) {
            result[i] = c;
        }
        return new String(result);
    }

    public static String join(String conjunction, String s1, String s2) {
        if (s1 == null) {
            s1 = EMPTY;
        }
        if (s2 == null) {
            s2 = EMPTY;
        }
        return s1 + conjunction + s2;
    }

    public static String str(byte[] bytes, String charset) {
        return StrUtil.str((Object)bytes, StrUtil.isBlank(charset) ? Charset.defaultCharset() : Charset.forName(charset));
    }

    public static String removeAll(CharSequence str, char ... chars) {
        if (null == str || ArrayUtil.isEmpty(chars)) {
            return StrUtil.str(str);
        }
        int len = str.length();
        if (0 == len) {
            return StrUtil.str(str);
        }
        StringBuilder builder = new StringBuilder(len);
        for (int i = 0; i < len; ++i) {
            char c = str.charAt(i);
            if (ArrayUtil.contains(chars, c)) continue;
            builder.append(c);
        }
        return builder.toString();
    }

    public static String str(CharSequence cs) {
        return null == cs ? null : cs.toString();
    }

    public static String padPre(CharSequence str, int minLength, char padChar) {
        if (null == str) {
            return null;
        }
        int strLen = str.length();
        if (strLen == minLength) {
            return str.toString();
        }
        if (strLen > minLength) {
            return StrUtil.subPre(str, minLength);
        }
        return StrUtil.repeat(padChar, minLength - strLen).concat(str.toString());
    }

    public static String subPre(CharSequence string, int toIndex) {
        return StrUtil.sub(string, 0, toIndex);
    }

    public static String sub(CharSequence str, int fromIndex, int toIndex) {
        if (StrUtil.isEmpty(str)) {
            return StrUtil.str(str);
        }
        int len = str.length();
        if (fromIndex < 0) {
            if ((fromIndex = len + fromIndex) < 0) {
                fromIndex = 0;
            }
        } else if (fromIndex > len) {
            fromIndex = len;
        }
        if (toIndex < 0) {
            if ((toIndex = len + toIndex) < 0) {
                toIndex = len;
            }
        } else if (toIndex > len) {
            toIndex = len;
        }
        if (toIndex < fromIndex) {
            int tmp = fromIndex;
            fromIndex = toIndex;
            toIndex = tmp;
        }
        if (fromIndex == toIndex) {
            return EMPTY;
        }
        return str.toString().substring(fromIndex, toIndex);
    }

    public static Set<String> commaDelimitedListToSet(String str) {
        String[] tokens = StrUtil.commaDelimitedListToStringArray(str);
        return new LinkedHashSet<String>(Arrays.asList(tokens));
    }

    public static String[] commaDelimitedListToStringArray(String str) {
        return StrUtil.delimitedListToStringArray(str, ",");
    }

    public static String[] delimitedListToStringArray(String str, String delimiter) {
        return StrUtil.delimitedListToStringArray(str, delimiter, null);
    }

    public static String[] delimitedListToStringArray(String str, String delimiter, String charsToDelete) {
        if (str == null) {
            return EMPTY_STRING_ARRAY;
        }
        if (delimiter == null) {
            return new String[]{str};
        }
        ArrayList<String> result = new ArrayList<String>();
        if (delimiter.isEmpty()) {
            for (int pos = 0; pos < str.length(); ++pos) {
                result.add(StrUtil.deleteAny(str.substring(pos, pos + 1), charsToDelete));
            }
        } else {
            int delPos;
            int pos = 0;
            while ((delPos = str.indexOf(delimiter, pos)) != -1) {
                result.add(StrUtil.deleteAny(str.substring(pos, delPos), charsToDelete));
                pos = delPos + delimiter.length();
            }
            if (str.length() > 0 && pos <= str.length()) {
                result.add(StrUtil.deleteAny(str.substring(pos), charsToDelete));
            }
        }
        return StrUtil.toStringArray(result);
    }

    public static String[] toStringArray(Collection<String> collection) {
        return !CollectionUtil.isEmpty(collection) ? collection.toArray(EMPTY_STRING_ARRAY) : EMPTY_STRING_ARRAY;
    }

    public static String deleteAny(String inString, String charsToDelete) {
        if (!StrUtil.isEmpty(inString) && !StrUtil.isEmpty(charsToDelete)) {
            int lastCharIndex = 0;
            char[] result = new char[inString.length()];
            for (int i = 0; i < inString.length(); ++i) {
                char c = inString.charAt(i);
                if (charsToDelete.indexOf(c) != -1) continue;
                result[lastCharIndex++] = c;
            }
            if (lastCharIndex == inString.length()) {
                return inString;
            }
            return new String(result, 0, lastCharIndex);
        }
        return inString;
    }
}

