/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.egf.common.utils.xml;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.sdk.annotation.SdkDeprecated;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.jdom2.input.SAXBuilder;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;

public class JDomUtils {
    @SdkDeprecated
    public static Element createRoot(String rootName) {
        Element root = new Element(rootName);
        return root;
    }

    @SdkDeprecated
    public static Element addChild(Element parent, String childName) {
        Element child = new Element(childName);
        parent.addContent((Content)child);
        return child;
    }

    @SdkDeprecated
    public static Element addChild(Element parent, String childName, Namespace ns) {
        Element child = new Element(childName);
        child.setNamespace(ns);
        parent.addContent((Content)child);
        return child;
    }

    @SdkDeprecated
    public static void addChild(Element parent, Element childName) {
        parent.addContent((Content)childName);
    }

    @SdkDeprecated
    public static Element addChild(Element parent, String childName, String childValue, Namespace ns) {
        Element child = new Element(childName);
        child.setText(childValue == null ? "" : childValue);
        child.setNamespace(ns);
        parent.addContent((Content)child);
        return child;
    }

    @SdkDeprecated
    public static Element addChild(Element parent, String childName, String childValue) {
        Element child = new Element(childName);
        child.setText(childValue == null ? "" : childValue);
        parent.addContent((Content)child);
        return child;
    }

    public static String root2StringWithoutXMLDeclaration(Element root, String encoding) {
        return JDomUtils.root2StringWithoutXMLDeclaration(root, encoding, false);
    }

    public static String root2StringWithoutXMLDeclaration(Element root, String encoding, boolean formated) {
        XMLOutputter outputter = new XMLOutputter();
        Format newFormat = Format.getPrettyFormat();
        newFormat.setEncoding(encoding);
        newFormat.setIndent("    ");
        newFormat.setExpandEmptyElements(true);
        outputter.setFormat(newFormat);
        if (formated) {
            String msg = outputter.outputString(root);
            root = JDomUtils.string2Root(msg, encoding);
        }
        return outputter.outputString(root);
    }

    public static String root2StringWithoutXMLDecAndPrettyFormat(Element root, String encoding) {
        XMLOutputter outputter = new XMLOutputter();
        Document document = null;
        try {
            int index;
            if (root.getParent() != null) {
                root.detach();
            }
            document = new Document(root);
            Format newFormat = Format.getPrettyFormat();
            newFormat.setEncoding(encoding);
            newFormat.setIndent("    ");
            newFormat.setExpandEmptyElements(true);
            newFormat.setOmitDeclaration(true);
            outputter.setFormat(newFormat);
            String str = outputter.outputString(document);
            while (str.endsWith("\r\n")) {
                index = str.lastIndexOf("\r\n");
                str = str.substring(0, index);
            }
            while (str.endsWith("\n")) {
                index = str.lastIndexOf("\n");
                str = str.substring(0, index);
            }
            return str;
        }
        catch (Throwable t) {
            throw EBExceiptionUtil.serviceException(t);
        }
    }

    @SdkDeprecated
    public static String root2String(Element root, String encoding) {
        return JDomUtils.root2String(root, encoding, false);
    }

    private static String root2String(Element root, String encoding, boolean formated) {
        XMLOutputter outputter = new XMLOutputter();
        Format newFormat = Format.getPrettyFormat();
        newFormat.setEncoding(encoding);
        newFormat.setIndent("    ");
        newFormat.setExpandEmptyElements(true);
        outputter.setFormat(newFormat);
        Document document = null;
        try {
            int index;
            if (root.getParent() != null) {
                root.detach();
            }
            document = new Document(root);
            String str = outputter.outputString(document);
            while (str.endsWith("\r\n")) {
                index = str.lastIndexOf("\r\n");
                str = str.substring(0, index);
            }
            while (str.endsWith("\n")) {
                index = str.lastIndexOf("\n");
                str = str.substring(0, index);
            }
            return str;
        }
        catch (Throwable t) {
            throw EBExceiptionUtil.serviceException(t);
        }
    }

    public static String xml2XmlWithOutIndentLineSeparator(String xml, String encoding) {
        Element root = JDomUtils.string2Root(xml, encoding);
        root.detach();
        return JDomUtils.root2StringNoIndentLineNoSeparator(root, encoding);
    }

    public static String root2StringNoIndentLineNoSeparator(Element root, String encoding) {
        XMLOutputter outputter = new XMLOutputter();
        Format newFormat = Format.getPrettyFormat();
        newFormat.setEncoding(encoding);
        newFormat.setIndent("");
        newFormat.setLineSeparator("");
        newFormat.setExpandEmptyElements(true);
        outputter.setFormat(newFormat);
        Document document = null;
        try {
            if (root.getParent() != null) {
                root.detach();
            }
            document = new Document(root);
            String str = outputter.outputString(document);
            while (str.endsWith("\r\n")) {
                int index = str.lastIndexOf("\r\n");
                str = str.substring(0, index);
            }
            return str;
        }
        catch (Throwable t) {
            throw EBExceiptionUtil.serviceException(t);
        }
    }

    @SdkDeprecated
    public static Element string2Root(String content, String encoding) {
        Document document = JDomUtils.string2Document(content, encoding);
        return document.getRootElement();
    }

    private static String copyStr(String content) {
        if (content == null) {
            return "";
        }
        char[] charArrays = content.toCharArray();
        return String.copyValueOf(charArrays);
    }

    public static Document str2DocGBK(String content) {
        return JDomUtils.str2Doc(content, "GBK");
    }

    public static Document str2DocUTF8(String content) {
        return JDomUtils.str2Doc(content, "UTF-8");
    }

    public static Document string2Document(String contentStr, String encoding) {
        String xmlHead;
        int i;
        EBGLogger logger = EBGLogger.getInstance().getLogger(JDomUtils.class);
        String content = JDomUtils.copyStr(contentStr);
        int startPoint = (content = JDomUtils.filterMsg(content)).indexOf("<?xml");
        if (-1 != startPoint) {
            content = content.substring(startPoint);
        }
        if (-1 == content.indexOf("<?xml")) {
            content = "<?xml version=\"1.0\" encoding = \"" + encoding + "\"?>" + content;
        }
        if (-1 == (i = (xmlHead = content.substring(0, content.indexOf("?>") + 2).toLowerCase(Locale.ENGLISH)).indexOf(encoding.toLowerCase(Locale.ENGLISH)))) {
            content = "<?xml version=\"1.0\" encoding=\"" + encoding + "\"?>" + content.substring(content.indexOf("?>") + 2);
        }
        ByteArrayInputStream bais = null;
        try {
            bais = new ByteArrayInputStream(content.getBytes(encoding));
            SAXBuilder builder = new SAXBuilder();
            builder.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            builder.setFeature("http://xml.org/sax/features/external-general-entities", false);
            builder.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            builder.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            Document document = builder.build((InputStream)bais);
            return document;
        }
        catch (Exception e) {
            if (StringUtils.isEmpty(contentStr)) {
                throw EBExceiptionUtil.serviceException(ResManager.loadKDString((String)"\u62a5\u6587\u5185\u5bb9\u89e3\u6790\u5931\u8d25\uff0c\u8fd4\u56de\u62a5\u6587\u4e3a\u7a7a\u3002", (String)"JDomUtils_0", (String)"ebg-egf-common", (Object[])new Object[0]), e);
            }
            String subContent = JDomUtils.copyStr(contentStr);
            if (subContent.length() > 50) {
                subContent = subContent.substring(0, 50);
            }
            String errorMsg = String.format(ResManager.loadKDString((String)"\u62a5\u6587\u5185\u5bb9\u89e3\u6790\u5931\u8d25\uff0c\u8fd4\u56de\u62a5\u6587\u4e3a\uff1a%s", (String)"JDomUtils_1", (String)"ebg-egf-common", (Object[])new Object[0]), subContent);
            throw EBExceiptionUtil.serviceException(errorMsg, e);
        }
        finally {
            if (bais != null) {
                try {
                    bais.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static String getUnNullChildText(Element parent, String childName) {
        String childText = parent.getChildText(childName);
        if (childText != null) {
            return childText;
        }
        throw new RuntimeException(String.format(ResManager.loadKDString((String)"\u8282\u70b9<%s", (String)"JDomUtils_7", (String)"ebg-egf-common", (Object[])new Object[0]), parent.getName()) + String.format(ResManager.loadKDString((String)">\u4e0b\u5b50\u8282\u70b9<%s>\u7684Text\u503c\u4e3aNULL.", (String)"JDomUtils_8", (String)"ebg-egf-common", (Object[])new Object[0]), childName));
    }

    public static String getUnNullChildTextTrim(Element parent, String childName) {
        return JDomUtils.getUnNullChildText(parent, childName).trim();
    }

    public static String e2Str(Element element, String indent, String encoding, boolean newlines) {
        String newLineString = "";
        if (newlines) {
            newLineString = "\n";
        }
        XMLOutputter outputter = new XMLOutputter();
        Format newFormat = Format.getPrettyFormat();
        newFormat.setEncoding(encoding);
        newFormat.setIndent(indent);
        newFormat.setLineSeparator(newLineString);
        newFormat.setExpandEmptyElements(true);
        outputter.setFormat(newFormat);
        return outputter.outputString(element);
    }

    public static String e2StrGBK(Element element) {
        return JDomUtils.e2Str(element, "    ", "GBK", true);
    }

    public static String e2StrUTF8(Element element) {
        return JDomUtils.e2Str(element, "    ", "UTF-8", true);
    }

    public static Document str2Doc(String content, String encoding) {
        try {
            if (null == content) {
                return null;
            }
            if (-1 != content.indexOf("<?")) {
                content = content.substring(content.indexOf("<?"));
            }
            if (-1 == content.indexOf("<?")) {
                content = "<?xml version=\"1.0\" encoding=\"" + encoding + "\" ?>\n" + content;
            }
            SAXBuilder builder = new SAXBuilder();
            ByteArrayInputStream bais = new ByteArrayInputStream(content.getBytes(encoding));
            Document document = builder.build((InputStream)bais);
            return document;
        }
        catch (Exception e) {
            throw new RuntimeException(String.format(ResManager.loadKDString((String)"\u8f6c\u5316\u5f02\u5e38%s", (String)"JDomUtils_2", (String)"ebg-egf-common", (Object[])new Object[0]), e.getMessage()), e);
        }
    }

    public static String doc2Str(Document document, String indent, String encoding, boolean newlines) {
        int index;
        XMLOutputter outputter = new XMLOutputter();
        String newLineString = "";
        if (newlines) {
            newLineString = "\n";
        }
        Format newFormat = Format.getPrettyFormat();
        newFormat.setEncoding(encoding);
        newFormat.setIndent(indent);
        newFormat.setLineSeparator(newLineString);
        newFormat.setExpandEmptyElements(true);
        outputter.setFormat(newFormat);
        String str = outputter.outputString(document);
        while (str.endsWith("\r\n")) {
            index = str.lastIndexOf("\r\n");
            str = str.substring(0, index);
        }
        while (str.endsWith("\n")) {
            index = str.lastIndexOf("\n");
            str = str.substring(0, index);
        }
        return str;
    }

    public static String doc2StrGBK(Document document) {
        return JDomUtils.doc2Str(document, "    ", "GBK", true);
    }

    public static String doc2StrGB2312(Document document) {
        return JDomUtils.doc2Str(document, "    ", "GB2312", true);
    }

    public static String doc2StrGB18030(Document document) {
        String content = JDomUtils.doc2Str(document, "    ", "GB18030", true);
        return content;
    }

    public static String doc2StrUTF8(Document document) {
        return JDomUtils.doc2Str(document, "    ", "UTF-8", true);
    }

    public static Element getUnNullChildElement(Element parent, String childName) {
        Element child = parent.getChild(childName);
        if (child != null) {
            return child;
        }
        throw new RuntimeException(String.format(ResManager.loadKDString((String)"\u8282\u70b9<%s", (String)"JDomUtils_7", (String)"ebg-egf-common", (Object[])new Object[0]), parent.getName()) + String.format(ResManager.loadKDString((String)">\u4e0b\u672a\u5305\u542b\u8282\u70b9<%s>", (String)"JDomUtils_9", (String)"ebg-egf-common", (Object[])new Object[0]), childName));
    }

    private static String filterMsg(String content) {
        content = content.replaceAll("&nbsp;", "");
        content = content.replaceAll("&(?!amp)", "&amp;");
        return content;
    }

    public static String element2StringPlain(Element element, String encoding) {
        return JDomUtils.element2String(element, encoding, "", true);
    }

    public static String element2String(Element element, String encoding, String ident, boolean newLine) {
        XMLOutputter localXMLOutputter = new XMLOutputter();
        String newLineString = "";
        if (newLine) {
            newLineString = "\n";
        }
        Format newFormat = Format.getPrettyFormat();
        newFormat.setEncoding(encoding);
        newFormat.setIndent(ident);
        newFormat.setExpandEmptyElements(true);
        newFormat.setLineSeparator(newLineString);
        localXMLOutputter.setFormat(newFormat);
        String str = localXMLOutputter.outputString(element).trim();
        return str;
    }

    public static String getChildTextNotNull(Element element, String childName) {
        String text = element.getChildText(childName);
        if (null == text) {
            throw EBExceiptionUtil.serviceException(String.format(ResManager.loadKDString((String)"\u6570\u636e\u4e2d\u672a\u5305\u542b\u5b50\u8282\u70b9 <%s>,\u8bf7\u68c0\u67e5\u6570\u636e\u662f\u5426\u6b63\u786e", (String)"JDomUtils_3", (String)"ebg-egf-common", (Object[])new Object[0]), childName));
        }
        return text;
    }

    public static String getChildTextNotNull(Element element, String childName, String tips) {
        String text = element.getChildText(childName);
        if (null == text) {
            throw EBExceiptionUtil.serviceException(String.format(ResManager.loadKDString((String)"\u6570\u636e\u4e2d\u672a\u5305\u542b\u5b50\u8282\u70b9 <%1$s>(%2$s),\u8bf7\u68c0\u67e5\u6570\u636e\u662f\u5426\u6b63\u786e", (String)"JDomUtils_4", (String)"ebg-egf-common", (Object[])new Object[0]), childName, tips));
        }
        return text;
    }

    @SdkDeprecated
    public static String getChildText(Element element, String childName) {
        String text = element.getChildText(childName);
        return text;
    }

    public static String getChildTextTrimNotNull(Element element, String childName) {
        String text = element.getChildTextTrim(childName);
        if (null == text) {
            throw EBExceiptionUtil.serviceException(String.format(ResManager.loadKDString((String)"\u6570\u636e\u4e2d\u672a\u5305\u542b\u5b50\u8282\u70b9 <%s>,\u8bf7\u68c0\u67e5\u6570\u636e\u662f\u5426\u6b63\u786e", (String)"JDomUtils_3", (String)"ebg-egf-common", (Object[])new Object[0]), childName));
        }
        return text;
    }

    public static String getChildTextTrimNotNull(Element element, String childName, String tips) {
        String text = element.getChildTextTrim(childName);
        if (null == text) {
            throw EBExceiptionUtil.serviceException(String.format(ResManager.loadKDString((String)"\u6570\u636e\u4e2d\u672a\u5305\u542b\u5b50\u8282\u70b9 <%1$s>(%2$s),\u8bf7\u68c0\u67e5\u6570\u636e\u662f\u5426\u6b63\u786e", (String)"JDomUtils_4", (String)"ebg-egf-common", (Object[])new Object[0]), childName, tips));
        }
        return text;
    }

    public static String getChildTextTrim(Element element, String childName) {
        String text = element.getChildText(childName);
        return text;
    }

    @SdkDeprecated
    public static String getChildTextNullAsBlank(Element element, String childName) {
        String text = element.getChildTextTrim(childName);
        if (null == text) {
            return "";
        }
        return text;
    }

    public static String getAttributeValueNullAsBlank(Element element, String attributeName) {
        String value = element.getAttributeValue(attributeName);
        return null == value ? "" : value;
    }

    public static String getAttributeValueNotNull(Element element, String attributeName) {
        String value = element.getAttributeValue(attributeName);
        if (null == value) {
            throw EBExceiptionUtil.serviceException(String.format(ResManager.loadKDString((String)"\u6570\u636e\u4e2d\u672a\u5305\u542b\u5c5e\u6027<%s>,\u8bf7\u68c0\u67e5\u6570\u636e\u662f\u5426\u6b63\u786e", (String)"JDomUtils_5", (String)"ebg-egf-common", (Object[])new Object[0]), attributeName));
        }
        return value;
    }

    public static Element getChildElementNotNull(Element element, String childName) {
        Element childEelement = element.getChild(childName);
        if (null == childEelement) {
            throw EBExceiptionUtil.serviceException(String.format(ResManager.loadKDString((String)"\u6570\u636e\u4e2d\u672a\u5305\u542b\u8282\u70b9<%s>,\u8bf7\u68c0\u67e5\u6570\u636e\u662f\u5426\u6b63\u786e", (String)"JDomUtils_6", (String)"ebg-egf-common", (Object[])new Object[0]), childName));
        }
        return childEelement;
    }

    @SdkDeprecated
    public static Element getChildElement(Element element, String childName) {
        return element.getChild(childName);
    }

    public static Element addChildAttribute(Element parent, String childName, String attr, String arg1) {
        Element child = new Element(childName);
        parent.addContent((Content)child);
        child.setAttribute(attr, arg1);
        return child;
    }

    @SdkDeprecated
    public static Element getChildElement(Element element, String childName, Namespace ns) {
        return element.getChild(childName, ns);
    }

    public static String getChildText(Element element, String childName, Namespace ns) {
        String text = element.getChildText(childName, ns);
        return text;
    }
}

