/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.egf.common.zookeeper.cluster;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class URL
implements Serializable {
    private String username;
    private String password;
    private String connectString;
    private String path;
    private final Map<String, String> parameters;

    protected URL() {
        this.username = null;
        this.password = null;
        this.connectString = null;
        this.path = null;
        this.parameters = null;
    }

    public URL(String connectString, String path) {
        this(null, null, connectString, path, null);
    }

    public URL(String connectString, String path, Map<String, String> parameters) {
        this(null, null, connectString, path, parameters);
    }

    public URL(String username, String password, String connectString, String path, Map<String, String> parameters) {
        this.username = username;
        this.password = password;
        this.connectString = connectString;
        while (path != null && path.startsWith("/")) {
            path = path.substring(1);
        }
        this.path = path;
        parameters = parameters == null ? new HashMap<String, String>(16) : new HashMap<String, String>(parameters);
        this.parameters = Collections.unmodifiableMap(parameters);
    }

    public static String encode(String value) {
        if (value == null || value.length() == 0) {
            return "";
        }
        try {
            return URLEncoder.encode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static String decode(String value) {
        if (value == null || value.length() == 0) {
            return "";
        }
        try {
            return URLDecoder.decode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getConnectString() {
        return this.connectString;
    }

    public String getAuthority() {
        if (!(this.username != null && this.username.length() != 0 || this.password != null && this.password.length() != 0)) {
            return null;
        }
        return (this.username == null ? "" : this.username) + ":" + (this.password == null ? "" : this.password);
    }

    public String getPath() {
        return this.path;
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }
}

