/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.egf.formplugin.plugin.codeless;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.SaveAndNew;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.CellClickEvent;
import kd.bos.form.control.events.CellClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.id.ID;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.formplugin.plugin.common.NoteCodeLessCommonFormPlugin;
import kd.ebg.egf.formplugin.plugin.util.CodeFieldEnum;
import kd.ebg.egf.formplugin.plugin.util.FilterCompareEnum;
import kd.ebg.egf.formplugin.plugin.util.FilterLinkEnum;
import kd.ebg.egf.formplugin.plugin.util.FormPluginUtils;
import kd.ebg.egf.formplugin.plugin.util.JudgingConditionUtil;

public class JudgingConditionFormPlugin
extends NoteCodeLessCommonFormPlugin
implements CellClickListener,
BeforeF7SelectListener {
    private static final String CODE_FIELD_KEY = "code_field";
    private static final String CONTENT_KEY = "content";
    private static String SAVE_YES_KEY = "save_yes";

    public void afterCopyData(EventObject e) {
        this.setNewNumber();
    }

    public void afterCreateNewData(EventObject e) {
        this.setBankVersion();
        this.setNewNumber();
        this.hideSelecet();
    }

    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        this.changeCodeField();
        this.hideSelecet();
    }

    private void setNewNumber() {
        String bankVersionID = this.getBankVersionID();
        if (StringUtils.isEmpty((String)((String)this.getModel().getValue("number")))) {
            String number = "EBG-" + bankVersionID + "-" + ID.genStringId();
            this.getModel().setValue("number", (Object)number);
        }
    }

    private void setBankVersion() {
        String isFromOldPage = this.getView().getPageCache().get("isFromOldPage");
        if (StringUtils.isNotEmpty((String)isFromOldPage)) {
            String groupID = this.getView().getPageCache().get("groupID");
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((String)"note_bank_app_list", (QFilter[])new QFilter[]{QFilter.of((String)"id = ?", (Object[])new Object[]{Long.valueOf(groupID)})});
            if (dynamicObject != null) {
                this.getModel().setValue("group", (Object)dynamicObject);
            }
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid entryGrid = (EntryGrid)this.getControl("note_judging_body");
        entryGrid.addCellClickListener((CellClickListener)this);
        BasedataEdit biztype = (BasedataEdit)this.getView().getControl("biz_type_new");
        biztype.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void cellClick(CellClickEvent evt) {
        if ("ebg_field".equals(evt.getFieldKey())) {
            String ebgparam_source;
            String bankVersionID = this.getBankVersionID();
            String bizType = this.getModel().getDataEntity().getString("biz_type_new.number");
            if ("parse".equals(this.getModel().getValue("type")) && !"ebg_field".equals(ebgparam_source = (String)this.getModel().getValue("ebgparam_source", evt.getRow()))) {
                return;
            }
            this.clickReqEbgField("note_judging_body", evt.getRow(), bizType, bankVersionID);
        }
    }

    public String getBankVersionID() {
        return this.getModel().getDataEntity().getString("group.longnumber").split("\\.")[0];
    }

    public void cellDoubleClick(CellClickEvent cellClickEvent) {
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if (closedCallBackEvent.getReturnData() != null && closedCallBackEvent.getReturnData() instanceof ListSelectedRowCollection) {
            ListSelectedRowCollection selectCollections = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
            String rowStr = closedCallBackEvent.getActionId();
            int row = Integer.parseInt(rowStr);
            for (ListSelectedRow selectedRow : selectCollections) {
                this.closedCallBackByEbgField(selectedRow, row);
            }
            this.changeContent();
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs evt) {
        AbstractOperate operate = (AbstractOperate)evt.getSource();
        String operateKey = operate.getOperateKey();
        String saveYes = this.getView().getPageCache().get(SAVE_YES_KEY);
        if (("save".equals(operateKey) || "submit".equals(operateKey)) && StringUtils.isEmpty((String)saveYes)) {
            boolean validResult = this.validSave();
            if (!validResult) {
                evt.setCancel(true);
            }
            this.newDataSetPageCache();
            String statusName = FormPluginUtils.getStatusName((IFormView)this.getView());
            if ("EDIT".equalsIgnoreCase(statusName)) {
                ArrayList<Long> listIds = new ArrayList<Long>();
                listIds.add((Long)this.getModel().getValue("id"));
                JudgingConditionUtil judgingConditionUtil = new JudgingConditionUtil();
                String numbers = judgingConditionUtil.getQuoteNumbers(listIds);
                if (StringUtils.isNotEmpty((String)numbers)) {
                    String callBackId = "save".equals(operateKey) ? "judging_condition_save_id" : "judging_condition_submit_id";
                    callBackId = operate instanceof SaveAndNew ? "judging_condition_saveAndNew_id" : callBackId;
                    this.getView().showConfirm(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u9009\u62e9\u7684\u57fa\u7840\u8d44\u6599\u5df2\u88ab\u5339\u914d\u89c4\u5219\u96c6\u5408%s\u5f15\u7528\uff0c\u662f\u5426\u7ee7\u7eed\u4fee\u6539\uff1f", (String)"JudgingConditionFormPlugin_6", (String)"ebg-egf-formplugin", (Object[])new Object[0]), numbers), MessageBoxOptions.YesNo, ConfirmTypes.Wait, new ConfirmCallBackListener(callBackId, (IFormPlugin)this));
                    evt.setCancel(true);
                    return;
                }
                numbers = judgingConditionUtil.getCodeLessQuoteNumbers(listIds);
                if (StringUtils.isNotEmpty((String)numbers)) {
                    String callBackId = "save".equals(operateKey) ? "judging_condition_save_id" : "judging_condition_submit_id";
                    callBackId = operate instanceof SaveAndNew ? "judging_condition_saveAndNew_id" : callBackId;
                    this.getView().showConfirm(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u9009\u62e9\u7684\u57fa\u7840\u8d44\u6599\u5df2\u88ab\u94f6\u884c\u7535\u7968\u63a5\u53e3%s\u5f15\u7528\uff0c\u662f\u5426\u7ee7\u7eed\u4fee\u6539\uff1f", (String)"JudgingConditionFormPlugin_7", (String)"ebg-egf-formplugin", (Object[])new Object[0]), numbers), MessageBoxOptions.YesNo, ConfirmTypes.Wait, new ConfirmCallBackListener(callBackId, (IFormPlugin)this));
                    evt.setCancel(true);
                    return;
                }
            }
        } else if ("new".equals(operateKey)) {
            this.newDataSetPageCache();
        } else if ("disable".equals(operateKey)) {
            ArrayList<Long> listIds = new ArrayList<Long>();
            listIds.add((Long)this.getModel().getValue("id"));
            JudgingConditionUtil judgingConditionUtil = new JudgingConditionUtil();
            String numbers = judgingConditionUtil.getQuoteNumbers(listIds);
            if (StringUtils.isNotEmpty((String)numbers)) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u9009\u62e9\u7684\u57fa\u7840\u8d44\u6599\u5df2\u88ab\u5339\u914d\u89c4\u5219\u96c6\u5408%s\u5f15\u7528\uff0c\u4e0d\u5141\u8bb8\u7981\u7528\u3002", (String)"JudgingConditionFormPlugin_8", (String)"ebg-egf-formplugin", (Object[])new Object[0]), numbers));
                evt.setCancel(true);
                return;
            }
            numbers = judgingConditionUtil.getCodeLessQuoteNumbers(listIds);
            if (StringUtils.isNotEmpty((String)numbers)) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u9009\u62e9\u7684\u57fa\u7840\u8d44\u6599\u5df2\u88ab\u94f6\u884c\u7535\u7968\u63a5\u53e3%s\u5f15\u7528\uff0c\u4e0d\u5141\u8bb8\u7981\u7528\u3002", (String)"JudgingConditionFormPlugin_9", (String)"ebg-egf-formplugin", (Object[])new Object[0]), numbers));
                evt.setCancel(true);
                return;
            }
        } else if ("unaudit".equals(operateKey) && StringUtils.isEmpty((String)saveYes)) {
            ArrayList<Long> listIds = new ArrayList<Long>();
            listIds.add((Long)this.getModel().getValue("id"));
            JudgingConditionUtil judgingConditionUtil = new JudgingConditionUtil();
            String numbers = judgingConditionUtil.getQuoteNumbers(listIds);
            String callBackId = "judging_condition_unaudit_id";
            if (StringUtils.isNotEmpty((String)numbers)) {
                this.getView().showConfirm(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u9009\u62e9\u7684\u57fa\u7840\u8d44\u6599\u5df2\u88ab\u5339\u914d\u89c4\u5219\u96c6\u5408%s\u5f15\u7528\uff0c\u4fee\u6539\u540e\u4f1a\u5f71\u54cd\u5230\u5df2\u5f15\u7528\u7684\u5bf9\u8c61\uff0c\u662f\u5426\u7ee7\u7eed\u4fee\u6539\uff1f", (String)"JudgingConditionFormPlugin_10", (String)"ebg-egf-formplugin", (Object[])new Object[0]), numbers), MessageBoxOptions.YesNo, ConfirmTypes.Wait, new ConfirmCallBackListener(callBackId, (IFormPlugin)this));
                evt.setCancel(true);
                return;
            }
            numbers = judgingConditionUtil.getCodeLessQuoteNumbers(listIds);
            if (StringUtils.isNotEmpty((String)numbers)) {
                this.getView().showConfirm(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u9009\u62e9\u7684\u57fa\u7840\u8d44\u6599\u5df2\u88ab\u94f6\u884c\u7535\u7968\u63a5\u53e3%s\u5f15\u7528\uff0c\u4fee\u6539\u540e\u4f1a\u5f71\u54cd\u5230\u5df2\u5f15\u7528\u7684\u5bf9\u8c61\uff0c\u662f\u5426\u7ee7\u7eed\u4fee\u6539\uff1f", (String)"JudgingConditionFormPlugin_11", (String)"ebg-egf-formplugin", (Object[])new Object[0]), numbers), MessageBoxOptions.YesNo, ConfirmTypes.Wait, new ConfirmCallBackListener(callBackId, (IFormPlugin)this));
                evt.setCancel(true);
                return;
            }
        }
    }

    private void newDataSetPageCache() {
        this.getView().getPageCache().put("isFromOldPage", "true");
        String groupID = this.getModel().getDataEntity().getString("group.id");
        this.getView().getPageCache().put("groupID", groupID);
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String key = args.getOperateKey();
        if ("save".equals(key) || "submit".equals(key) || "unaudit".equals(key)) {
            this.getView().getPageCache().put(SAVE_YES_KEY, "");
        } else if ("moveentryup".equals(key) || "moveentrydown".equals(key) || "copyentryrow".equals(key) || "deleteentry".equals(key)) {
            this.changeContent();
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if ("Yes".equals(messageBoxClosedEvent.getResultValue())) {
            this.getView().getPageCache().put(SAVE_YES_KEY, "true");
            if ("judging_condition_save_id".equals(messageBoxClosedEvent.getCallBackId())) {
                this.getView().invokeOperation("save");
            } else if ("judging_condition_saveAndNew_id".equals(messageBoxClosedEvent.getCallBackId())) {
                this.getView().invokeOperation("saveAndNew");
            } else if ("judging_condition_unaudit_id".equals(messageBoxClosedEvent.getCallBackId())) {
                this.getView().invokeOperation("unaudit");
            } else {
                this.getView().invokeOperation("submit");
            }
        } else {
            this.getView().getPageCache().put(SAVE_YES_KEY, "");
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String fieldKey = e.getProperty().getName();
        if (StringUtils.equals((String)CODE_FIELD_KEY, (String)fieldKey) || StringUtils.equals((String)"filter_compare", (String)fieldKey) || StringUtils.equals((String)"value", (String)fieldKey) || StringUtils.equals((String)"filter_link", (String)fieldKey)) {
            this.changeContent();
        } else if (StringUtils.equals((String)"biz_type_new", (String)fieldKey)) {
            this.clearDataAfterChangeBizType();
        } else if (StringUtils.equals((String)"type", (String)fieldKey)) {
            this.hideSelecet();
            this.changeCodeField();
            this.clearBizType();
            this.clearCodeAfterChangeType();
        }
    }

    public void changeContent() {
        DynamicObjectCollection responses = this.getModel().getEntryEntity("note_judging_body");
        if (CollectionUtils.isEmpty((Collection)responses)) {
            this.getModel().setValue(CONTENT_KEY, (Object)"");
        }
        StringBuilder content = new StringBuilder();
        for (int i = 0; i < responses.size(); ++i) {
            DynamicObject dynamicObject = (DynamicObject)responses.get(i);
            String ebgField = dynamicObject.getString("ebg_field");
            String codeField = dynamicObject.getString(CODE_FIELD_KEY);
            String filterCompare = dynamicObject.getString("filter_compare");
            String value = dynamicObject.getString("value");
            String filterLink = dynamicObject.getString("filter_link");
            if (this.isRequest()) {
                if (StringUtils.isEmpty((String)ebgField)) {
                    content.append(' ');
                } else {
                    ebgField = ebgField.substring(0, ebgField.indexOf("("));
                    content.append(ebgField);
                }
            } else {
                content.append(CodeFieldEnum.getNameByKey(codeField));
            }
            content.append(' ').append(FilterCompareEnum.getNameByKey((String)filterCompare)).append(' ').append(value).append(' ');
            if (i == responses.size() - 1) continue;
            content.append(FilterLinkEnum.getNameByKey(filterLink)).append(' ');
        }
        this.getModel().setValue(CONTENT_KEY, (Object)content.toString());
    }

    public void changeCodeField() {
        if (this.isOut()) {
            ComboEdit comboEdit = (ComboEdit)this.getControl(CODE_FIELD_KEY);
            ArrayList<ComboItem> data = new ArrayList<ComboItem>(16);
            data.add(new ComboItem(new LocaleString(CodeFieldEnum.out_code.getName()), CodeFieldEnum.out_code.getKey()));
            comboEdit.setComboItems(data);
        } else if (this.isInner()) {
            ComboEdit comboEdit = (ComboEdit)this.getControl(CODE_FIELD_KEY);
            ArrayList<ComboItem> data = new ArrayList<ComboItem>(16);
            data.add(new ComboItem(new LocaleString(CodeFieldEnum.inner_code.getName()), CodeFieldEnum.inner_code.getKey()));
            data.add(new ComboItem(new LocaleString(CodeFieldEnum.inner_code2.getName()), CodeFieldEnum.inner_code2.getKey()));
            data.add(new ComboItem(new LocaleString(CodeFieldEnum.inner_code3.getName()), CodeFieldEnum.inner_code3.getKey()));
            comboEdit.setComboItems(data);
        }
    }

    public void clearBizType() {
        if (this.isOut() || this.isInner()) {
            this.getModel().setValue("biz_type_new", (Object)"");
        }
    }

    private boolean validSave() {
        if (!this.validBizType()) {
            return false;
        }
        DynamicObjectCollection responses = this.getModel().getEntryEntity("note_judging_body");
        for (int i = 0; i < responses.size(); ++i) {
            DynamicObject dynamicObject = (DynamicObject)responses.get(i);
            String ebgField = dynamicObject.getString("ebg_field");
            String codeField = dynamicObject.getString(CODE_FIELD_KEY);
            if (this.isRequest() && StringUtils.isEmpty((String)ebgField)) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5339\u914d\u6761\u4ef6\u7b2c%s\u884c\uff0c\u94f6\u4f01\u5c5e\u6027\u4e0d\u80fd\u8bbe\u7f6e\u4e3a\u7a7a\u3002", (String)"JudgingConditionFormPlugin_3", (String)"ebg-egf-formplugin", (Object[])new Object[0]), i + 1));
                return false;
            }
            if (!this.isInner() && !this.isOut() || !StringUtils.isEmpty((String)codeField)) continue;
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5339\u914d\u6761\u4ef6\u7b2c%s\u884c\uff0c\u72b6\u6001\u7801\u5b57\u6bb5\u4e0d\u80fd\u8bbe\u7f6e\u4e3a\u7a7a\u3002", (String)"JudgingConditionFormPlugin_4", (String)"ebg-egf-formplugin", (Object[])new Object[0]), i + 1));
            return false;
        }
        return true;
    }

    private boolean validBizType() {
        if (this.isRequest() && StringUtils.isEmpty((String)this.getModel().getDataEntity().getString("biz_type_new.number"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e1a\u52a1\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"JudgingConditionFormPlugin_5", (String)"ebg-egf-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private String getType() {
        return (String)this.getModel().getValue("type");
    }

    private boolean isRequest() {
        String type = this.getType();
        return "request".equals(type);
    }

    private boolean isOut() {
        String type = this.getType();
        return "out_stat".equals(type);
    }

    private boolean isInner() {
        String type = this.getType();
        return "inner_stat".equals(type);
    }

    private boolean isParse() {
        String type = this.getType();
        return "parse".equals(type);
    }

    private void hideSelecet() {
        String type = (String)this.getModel().getValue("type");
        if ("request".equals(type)) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"ebg_field"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"ebgparam_source"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"node"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{CODE_FIELD_KEY});
        } else if ("parse".equals(type)) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"ebgparam_source"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"node"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"ebg_field"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{CODE_FIELD_KEY});
        } else if (type.contains("stat")) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{CODE_FIELD_KEY});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"ebg_field"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"ebgparam_source"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"node"});
        }
    }

    private void clearDataAfterChangeBizType() {
        DynamicObjectCollection note_judging_body = this.getModel().getEntryEntity("note_judging_body");
        for (DynamicObject row : note_judging_body) {
            row.set("ebg_field", (Object)"");
            row.set(CODE_FIELD_KEY, (Object)"");
        }
        this.getView().updateView("note_judging_body");
    }

    private void clearCodeAfterChangeType() {
        DynamicObjectCollection note_judging_body = this.getModel().getEntryEntity("note_judging_body");
        for (DynamicObject row : note_judging_body) {
            row.set(CODE_FIELD_KEY, (Object)"");
        }
        this.getView().updateView("note_judging_body");
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String fieldKey = beforeF7SelectEvent.getProperty().getName();
        if (StringUtils.equals((String)fieldKey, (String)"biz_type_new")) {
            String longnumber = this.getModel().getDataEntity().getString("group.longnumber");
            String type = "";
            if (longnumber.endsWith("NOTE")) {
                type = "NOTE";
            } else if (longnumber.endsWith("CREDIT")) {
                type = "CREDIT";
            } else if (longnumber.endsWith("PAY")) {
                type = "PAY";
            } else if (longnumber.endsWith("DETAIL")) {
                type = "DETAIL";
            } else if (longnumber.endsWith("BALANCE")) {
                type = "BALANCE";
            } else if (longnumber.endsWith("QUERY")) {
                type = "QUERY";
            }
            if (StringUtils.isNotEmpty((String)type)) {
                QFilter qFilter = new QFilter("biz_type", "=", (Object)type);
                ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                showParameter.getListFilterParameter().setFilter(qFilter);
            }
        }
    }
}

