/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.cib.dc.services;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.note.banks.cib.dc.services.Common;
import kd.ebg.note.banks.cib.dc.services.Constants;
import kd.ebg.note.banks.cib.dc.services.util.CIB_DC_Parser;
import kd.ebg.note.business.notePayable.util.EBGNotePayableUtils;
import kd.ebg.note.business.noteReceivable.util.EBGNoteReceivableUtils;
import kd.ebg.note.common.entity.biz.status.PaymentState;
import kd.ebg.note.common.model.NotePayableInfo;
import kd.ebg.note.common.model.NoteReceivableInfo;
import org.jdom2.Element;

public class CIB_DC_Notepc_QueryPayParser {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(CIB_DC_Notepc_QueryPayParser.class);

    public static void parseQueryPay(List<NotePayableInfo> notePayableInfos, String rspStr) {
        logger.info("\u7968\u636e\u540c\u6b65\u8fd4\u56de-\u89e3\u6790\u54cd\u5e94\u62a5\u6587\u83b7\u53d6\u8d26\u5355\u72b6\u6001:[" + rspStr + "]");
        Element root = CIB_DC_Parser.parseString2Root(rspStr);
        Element eb1 = root.getChild("SECURITIES_MSGSRSV1");
        Element EBSTMTQUERYTRNRS = eb1.getChild("EBSTMTQUERYTRNRS");
        Element STATUS = EBSTMTQUERYTRNRS.getChild("STATUS");
        String code = JDomUtils.getChildText((Element)STATUS, (String)"CODE");
        String MESSAGE = JDomUtils.getChildText((Element)STATUS, (String)"MESSAGE");
        logger.info("code:" + code + ",MESSAGE:" + MESSAGE);
        if (!"0".equals(code)) {
            EBGNotePayableUtils.setPaymentState(notePayableInfos, (PaymentState)PaymentState.FAIL, (String)code, (String)MESSAGE);
            return;
        }
        Element RSBODY = EBSTMTQUERYTRNRS.getChild("RSBODY");
        List list = RSBODY.getChildren("CONTENT");
        Element rs = null;
        String rsBillNo = "";
        String BILLSTATUS = "";
        HashMap<String, NotePayableInfo> infoMap = new HashMap<String, NotePayableInfo>(notePayableInfos.size());
        for (NotePayableInfo notePayableInfo : notePayableInfos) {
            infoMap.put(notePayableInfo.getBillNo(), notePayableInfo);
        }
        HashMap<String, Element> elementMap = new HashMap<String, Element>(list.size());
        for (int i = 0; i < list.size(); ++i) {
            rs = (Element)list.get(i);
            rsBillNo = rs.getChildText("BILLCODE");
            elementMap.put(rsBillNo, rs);
        }
        for (Map.Entry element : elementMap.entrySet()) {
            NotePayableInfo notePayableInfo = (NotePayableInfo)infoMap.get(element.getKey());
            if (notePayableInfo == null) continue;
            rs = (Element)element.getValue();
            rsBillNo = rs.getChildText("BILLCODE");
            notePayableInfo.setBillNo(rsBillNo);
            String operType = rs.getChildText("OPERTYPE");
            BILLSTATUS = rs.getChildText("BILLSTATUS");
            String DEALSTATUS = rs.getChildText("DEALSTATUS");
            logger.info("\u7968\u636e\u540c\u6b65\u8fd4\u56de-\u89e3\u6790\u54cd\u5e94\u62a5\u6587:BILLSTATUS:" + BILLSTATUS + ",rsBillNo:" + rsBillNo + ",DEALSTATUS=" + DEALSTATUS);
            PaymentState PaymentState2 = CIB_DC_Notepc_QueryPayParser.getResultState(operType, DEALSTATUS);
            String bankMsg = "";
            if ("01".equals(operType)) {
                bankMsg = Constants.SendDealStatus.getNameByValue(DEALSTATUS);
            } else if ("02".equals(operType)) {
                bankMsg = Constants.receiveDealStatus.getNameByValue(DEALSTATUS);
            }
            EBGNotePayableUtils.setPaymentState((NotePayableInfo)notePayableInfo, (PaymentState)PaymentState2, (String)DEALSTATUS, (String)bankMsg);
            notePayableInfo.setNoteStatus(BILLSTATUS);
        }
        elementMap.clear();
        infoMap.clear();
    }

    public static void QueryNodeReceivableStatusParser(List<NoteReceivableInfo> infos, String rspStr) {
        logger.info("\u7968\u636e\u540c\u6b65\u8fd4\u56de-\u89e3\u6790\u54cd\u5e94\u62a5\u6587\u83b7\u53d6\u8d26\u5355\u72b6\u6001:[" + rspStr + "]");
        Element root = CIB_DC_Parser.parseString2Root(rspStr);
        Element eb1 = root.getChild("SECURITIES_MSGSRSV1");
        Element EBSTMTQUERYTRNRS = eb1.getChild("EBSTMTQUERYTRNRS");
        Element STATUS = EBSTMTQUERYTRNRS.getChild("STATUS");
        String code = JDomUtils.getChildText((Element)STATUS, (String)"CODE");
        String MESSAGE = JDomUtils.getChildText((Element)STATUS, (String)"MESSAGE");
        logger.info("code:" + code + ",MESSAGE:" + MESSAGE);
        if (!"0".equals(code)) {
            EBGNoteReceivableUtils.setPaymentState(infos, (PaymentState)PaymentState.FAIL, (String)code, (String)MESSAGE);
            return;
        }
        Element RSBODY = EBSTMTQUERYTRNRS.getChild("RSBODY");
        List list = RSBODY.getChildren("CONTENT");
        Element rs = null;
        String rsBillNo = "";
        String BILLSTATUS = "";
        HashMap<String, NoteReceivableInfo> infoMap = new HashMap<String, NoteReceivableInfo>(infos.size());
        for (NoteReceivableInfo noteReceivableInfo : infos) {
            infoMap.put(noteReceivableInfo.getBillNo(), noteReceivableInfo);
        }
        HashMap<String, Element> elementMap = new HashMap<String, Element>(list.size());
        for (int i = 0; i < list.size(); ++i) {
            rs = (Element)list.get(i);
            rsBillNo = rs.getChildText("BILLCODE");
            elementMap.put(rsBillNo, rs);
        }
        for (Map.Entry element : elementMap.entrySet()) {
            NoteReceivableInfo noteReceivableInfo = (NoteReceivableInfo)infoMap.get(element.getKey());
            if (noteReceivableInfo == null) continue;
            rs = (Element)element.getValue();
            rsBillNo = rs.getChildText("BILLCODE");
            noteReceivableInfo.setBillNo(rsBillNo);
            String operType = rs.getChildText("OPERTYPE");
            BILLSTATUS = rs.getChildText("BILLSTATUS");
            String DEALSTATUS = rs.getChildText("DEALSTATUS");
            logger.info("\u7968\u636e\u540c\u6b65\u8fd4\u56de-\u89e3\u6790\u54cd\u5e94\u62a5\u6587:BILLSTATUS:" + BILLSTATUS + ",rsBillNo:" + rsBillNo + ",DEALSTATUS=" + DEALSTATUS);
            PaymentState PaymentState2 = CIB_DC_Notepc_QueryPayParser.getResultState(operType, DEALSTATUS);
            String bankMsg = "";
            if ("01".equals(operType)) {
                bankMsg = Constants.SendDealStatus.getNameByValue(DEALSTATUS);
            } else if ("02".equals(operType)) {
                bankMsg = Constants.receiveDealStatus.getNameByValue(DEALSTATUS);
            }
            EBGNoteReceivableUtils.setPaymentState((NoteReceivableInfo)noteReceivableInfo, (PaymentState)PaymentState2, (String)DEALSTATUS, (String)bankMsg);
            noteReceivableInfo.setNoteStatus(BILLSTATUS);
            if (PaymentState2 == null) continue;
            if (PaymentState2.getId() != PaymentState.SUCCESS.getId()) {
                if (PaymentState2.getId() != PaymentState.FAIL.getId()) continue;
            }
            Common.appDateMap.remove(rsBillNo);
            Common.deletAppDate(rsBillNo);
        }
        elementMap.clear();
        infoMap.clear();
    }

    private static PaymentState getResultState(String type, String dealStatus) {
        if ("01".equals(type)) {
            if (dealStatus.equals(Constants.SendDealStatus.SIGNED.getValue()) || dealStatus.equals(Constants.SendDealStatus.LIQUIDATED.getValue()) || dealStatus.equals(Constants.SendDealStatus.SENDCONFIRMED.getValue())) {
                return PaymentState.SUCCESS;
            }
            if (dealStatus.equals(Constants.SendDealStatus.REJECTED.getValue()) || dealStatus.equals(Constants.SendDealStatus.LIQUIDATEDFAIL.getValue())) {
                return PaymentState.FAIL;
            }
            if (dealStatus.equals(Constants.SendDealStatus.ENTERED.getValue()) || dealStatus.equals(Constants.SendDealStatus.SEND.getValue())) {
                return PaymentState.SUBMITED;
            }
            return PaymentState.UNKNOWN;
        }
        if ("02".equals(type)) {
            if (dealStatus.equals(Constants.receiveDealStatus.SIGNED.getValue()) || dealStatus.equals(Constants.receiveDealStatus.CONFIRMED.getValue()) || dealStatus.equals(Constants.receiveDealStatus.REJECTIONCONFIRMED.getValue()) || dealStatus.equals(Constants.receiveDealStatus.LIQUIDATED.getValue())) {
                return PaymentState.SUCCESS;
            }
            if (dealStatus.equals(Constants.receiveDealStatus.REJECTED.getValue()) || dealStatus.equals(Constants.receiveDealStatus.LIQUIDATEDFAIL.getValue()) || dealStatus.equals(Constants.receiveDealStatus.CLEAREDFAILED.getValue())) {
                return PaymentState.FAIL;
            }
            if (dealStatus.equals(Constants.receiveDealStatus.NOTSIGNED.getValue())) {
                return PaymentState.SUBMITED;
            }
            return PaymentState.UNKNOWN;
        }
        return null;
    }

    public static void parseQueryPay2(List<NotePayableInfo> notePayableInfos, String rspStr) {
        logger.info("\u5e94\u4ed8\u7968\u636e\u540c\u6b65\u8fd4\u56de\u62a5\u6587\uff1a" + rspStr);
        Element root = CIB_DC_Parser.parseString2Root(rspStr);
        Element eb1 = root.getChild("SECURITIES_MSGSRSV1");
        Element EBBATCHSTATUSTRNRS = eb1.getChild("EBBATCHSTATUSTRNRS");
        Element STATUS = EBBATCHSTATUSTRNRS.getChild("STATUS");
        String code = JDomUtils.getChildText((Element)STATUS, (String)"CODE");
        String MESSAGE = JDomUtils.getChildText((Element)STATUS, (String)"MESSAGE");
        logger.info("code:" + code + ",MESSAGE:" + MESSAGE);
        if (!"0".equals(code)) {
            EBGNotePayableUtils.setPaymentState(notePayableInfos, (PaymentState)PaymentState.UNKNOWN, (String)code, (String)MESSAGE);
            return;
        }
        Element RSBODY = EBBATCHSTATUSTRNRS.getChild("RSBODY");
        List list = RSBODY.getChildren("CONTENT");
        Element rs = null;
        String rsBillNo = "";
        String BILLSTATUS = "";
        HashMap<String, NotePayableInfo> infoMap = new HashMap<String, NotePayableInfo>(notePayableInfos.size());
        for (NotePayableInfo notePayableInfo : notePayableInfos) {
            infoMap.put(notePayableInfo.getBillNo(), notePayableInfo);
        }
        HashMap<String, Element> elementMap = new HashMap<String, Element>(list.size());
        for (int i = 0; i < list.size(); ++i) {
            rs = (Element)list.get(i);
            rsBillNo = rs.getChildText("BILLCODE");
            elementMap.put(rsBillNo, rs);
        }
        for (Map.Entry element : elementMap.entrySet()) {
            NotePayableInfo notePayableInfo = (NotePayableInfo)infoMap.get(element.getKey());
            if (notePayableInfo == null) continue;
            rs = (Element)element.getValue();
            BILLSTATUS = rs.getChildText("BILLSTATUS");
            rsBillNo = rs.getChildText("BILLCODE");
            notePayableInfo.setBillNo(rsBillNo);
            logger.info("BILLSTATUS:" + BILLSTATUS + ",rsBillNo:" + rsBillNo);
            if ("000002".equals(BILLSTATUS)) {
                EBGNotePayableUtils.setPaymentState((NotePayableInfo)notePayableInfo, (PaymentState)PaymentState.SUCCESS, (String)BILLSTATUS, (String)ResManager.loadKDString((String)"\u7968\u636e\u5df2\u4f5c\u5e9f", (String)"CIB_DC_Notepc_QueryPayParser_0", (String)"ebg-note-banks-cib-dc", (Object[])new Object[0]));
                notePayableInfo.setNoteStatus("000002");
                continue;
            }
            if ("010004".equals(BILLSTATUS)) {
                EBGNotePayableUtils.setPaymentState((NotePayableInfo)notePayableInfo, (PaymentState)PaymentState.SUCCESS, (String)BILLSTATUS, (String)ResManager.loadKDString((String)"\u51fa\u7968\u5df2\u767b\u8bb0", (String)"CIB_DC_Notepc_QueryPayParser_1", (String)"ebg-note-banks-cib-dc", (Object[])new Object[0]));
                notePayableInfo.setNoteStatus("010004");
                continue;
            }
            if ("020001".equals(BILLSTATUS)) {
                EBGNotePayableUtils.setPaymentState((NotePayableInfo)notePayableInfo, (PaymentState)PaymentState.SUBMITED, (String)BILLSTATUS, (String)ResManager.loadKDString((String)"\u63d0\u793a\u627f\u5151\u5f85\u7b7e\u6536", (String)"CIB_DC_Notepc_QueryPayParser_2", (String)"ebg-note-banks-cib-dc", (Object[])new Object[0]));
                notePayableInfo.setNoteStatus("020001");
                continue;
            }
            if ("020006".equals(BILLSTATUS)) {
                EBGNotePayableUtils.setPaymentState((NotePayableInfo)notePayableInfo, (PaymentState)PaymentState.SUCCESS, (String)BILLSTATUS, (String)ResManager.loadKDString((String)"\u63d0\u793a\u627f\u5151\u5df2\u7b7e\u6536", (String)"CIB_DC_Notepc_QueryPayParser_3", (String)"ebg-note-banks-cib-dc", (Object[])new Object[0]));
                notePayableInfo.setNoteStatus("020006");
                continue;
            }
            if ("030001".equals(BILLSTATUS)) {
                EBGNotePayableUtils.setPaymentState((NotePayableInfo)notePayableInfo, (PaymentState)PaymentState.SUBMITED, (String)BILLSTATUS, (String)ResManager.loadKDString((String)"\u63d0\u793a\u6536\u7968\u5f85\u7b7e\u6536", (String)"CIB_DC_Notepc_QueryPayParser_4", (String)"ebg-note-banks-cib-dc", (Object[])new Object[0]));
                notePayableInfo.setNoteStatus("030001");
                continue;
            }
            if ("030006".equals(BILLSTATUS)) {
                EBGNotePayableUtils.setPaymentState((NotePayableInfo)notePayableInfo, (PaymentState)PaymentState.SUCCESS, (String)BILLSTATUS, (String)ResManager.loadKDString((String)"\u63d0\u793a\u6536\u7968\u5df2\u7b7e\u6536", (String)"CIB_DC_Notepc_QueryPayParser_5", (String)"ebg-note-banks-cib-dc", (Object[])new Object[0]));
                notePayableInfo.setNoteStatus("030006");
                continue;
            }
            if ("100001".equals(BILLSTATUS)) {
                EBGNotePayableUtils.setPaymentState((NotePayableInfo)notePayableInfo, (PaymentState)PaymentState.SUBMITED, (String)BILLSTATUS, (String)ResManager.loadKDString((String)"\u80cc\u4e66\u5f85\u7b7e\u6536", (String)"CIB_DC_Notepc_QueryPayParser_6", (String)"ebg-note-banks-cib-dc", (Object[])new Object[0]));
                notePayableInfo.setNoteStatus("100001");
                continue;
            }
            if ("100006".equals(BILLSTATUS)) {
                EBGNotePayableUtils.setPaymentState((NotePayableInfo)notePayableInfo, (PaymentState)PaymentState.SUCCESS, (String)BILLSTATUS, (String)ResManager.loadKDString((String)"\u80cc\u4e66\u5df2\u7b7e\u6536", (String)"CIB_DC_Notepc_QueryPayParser_7", (String)"ebg-note-banks-cib-dc", (Object[])new Object[0]));
                notePayableInfo.setNoteStatus("100006");
                continue;
            }
            EBGNotePayableUtils.setPaymentState((NotePayableInfo)notePayableInfo, (PaymentState)PaymentState.SUBMITED, (String)BILLSTATUS, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4e2d", (String)"CIB_DC_Notepc_QueryPayParser_8", (String)"ebg-note-banks-cib-dc", (Object[])new Object[0]));
        }
        elementMap.clear();
        infoMap.clear();
    }

    public static void QueryNodeReceivableStatusParser2(List<NoteReceivableInfo> infos, String rspStr) {
        logger.info("\u5e94\u6536\u7968\u636e\u540c\u6b65\u8fd4\u56de\u62a5\u6587\uff1a" + rspStr);
        Element root = CIB_DC_Parser.parseString2Root(rspStr);
        Element eb1 = root.getChild("SECURITIES_MSGSRSV1");
        Element EBBATCHSTATUSTRNRS = eb1.getChild("EBBATCHSTATUSTRNRS");
        Element STATUS = EBBATCHSTATUSTRNRS.getChild("STATUS");
        String code = JDomUtils.getChildText((Element)STATUS, (String)"CODE");
        String MESSAGE = JDomUtils.getChildText((Element)STATUS, (String)"MESSAGE");
        logger.info("code:" + code + ",MESSAGE:" + MESSAGE);
        if (!"0".equals(code)) {
            EBGNoteReceivableUtils.setPaymentState(infos, (PaymentState)PaymentState.FAIL, (String)code, (String)MESSAGE);
            return;
        }
        Element RSBODY = EBBATCHSTATUSTRNRS.getChild("RSBODY");
        List list = RSBODY.getChildren("CONTENT");
        Element rs = (Element)list.get(0);
        String rsBillNo = rs.getChildText("BILLCODE");
        String BILLSTATUS = rs.getChildText("BILLSTATUS");
        String RSLTID = rs.getChildText("RSLTID");
        String RSLTMSG = rs.getChildText("RSLTMSG");
        infos.get(0).setBillNo(rsBillNo);
        logger.info("BILLSTATUS:" + BILLSTATUS + ",rsBillNo:" + rsBillNo);
        if ("000002".equals(BILLSTATUS)) {
            EBGNoteReceivableUtils.setPaymentState(infos, (PaymentState)PaymentState.SUCCESS, (String)BILLSTATUS, (String)ResManager.loadKDString((String)"\u7968\u636e\u5df2\u4f5c\u5e9f", (String)"CIB_DC_Notepc_QueryPayParser_0", (String)"ebg-note-banks-cib-dc", (Object[])new Object[0]));
            infos.get(0).setNoteStatus("000002");
        } else if ("010004".equals(BILLSTATUS)) {
            EBGNoteReceivableUtils.setPaymentState(infos, (PaymentState)PaymentState.SUCCESS, (String)BILLSTATUS, (String)ResManager.loadKDString((String)"\u51fa\u7968\u5df2\u767b\u8bb0", (String)"CIB_DC_Notepc_QueryPayParser_1", (String)"ebg-note-banks-cib-dc", (Object[])new Object[0]));
            infos.get(0).setNoteStatus("010004");
        } else if ("020001".equals(BILLSTATUS)) {
            EBGNoteReceivableUtils.setPaymentState(infos, (PaymentState)PaymentState.SUBMITED, (String)BILLSTATUS, (String)ResManager.loadKDString((String)"\u63d0\u793a\u627f\u5151\u5f85\u7b7e\u6536", (String)"CIB_DC_Notepc_QueryPayParser_2", (String)"ebg-note-banks-cib-dc", (Object[])new Object[0]));
            infos.get(0).setNoteStatus("020001");
        } else if ("020006".equals(BILLSTATUS)) {
            EBGNoteReceivableUtils.setPaymentState(infos, (PaymentState)PaymentState.SUCCESS, (String)BILLSTATUS, (String)ResManager.loadKDString((String)"\u63d0\u793a\u627f\u5151\u5df2\u7b7e\u6536", (String)"CIB_DC_Notepc_QueryPayParser_3", (String)"ebg-note-banks-cib-dc", (Object[])new Object[0]));
            infos.get(0).setNoteStatus("020006");
        } else if ("030001".equals(BILLSTATUS)) {
            EBGNoteReceivableUtils.setPaymentState(infos, (PaymentState)PaymentState.SUBMITED, (String)BILLSTATUS, (String)ResManager.loadKDString((String)"\u63d0\u793a\u6536\u7968\u5f85\u7b7e\u6536", (String)"CIB_DC_Notepc_QueryPayParser_4", (String)"ebg-note-banks-cib-dc", (Object[])new Object[0]));
            infos.get(0).setNoteStatus("030001");
        } else if ("030006".equals(BILLSTATUS)) {
            EBGNoteReceivableUtils.setPaymentState(infos, (PaymentState)PaymentState.SUCCESS, (String)BILLSTATUS, (String)ResManager.loadKDString((String)"\u63d0\u793a\u6536\u7968\u5df2\u7b7e\u6536", (String)"CIB_DC_Notepc_QueryPayParser_5", (String)"ebg-note-banks-cib-dc", (Object[])new Object[0]));
            infos.get(0).setNoteStatus("030006");
        } else if ("100001".equals(BILLSTATUS)) {
            EBGNoteReceivableUtils.setPaymentState(infos, (PaymentState)PaymentState.SUBMITED, (String)BILLSTATUS, (String)ResManager.loadKDString((String)"\u80cc\u4e66\u5f85\u7b7e\u6536", (String)"CIB_DC_Notepc_QueryPayParser_6", (String)"ebg-note-banks-cib-dc", (Object[])new Object[0]));
            infos.get(0).setNoteStatus("100001");
        } else if ("100006".equals(BILLSTATUS)) {
            EBGNoteReceivableUtils.setPaymentState(infos, (PaymentState)PaymentState.SUCCESS, (String)BILLSTATUS, (String)ResManager.loadKDString((String)"\u80cc\u4e66\u5df2\u7b7e\u6536", (String)"CIB_DC_Notepc_QueryPayParser_7", (String)"ebg-note-banks-cib-dc", (Object[])new Object[0]));
            infos.get(0).setNoteStatus("100006");
        } else if ("200001".equals(BILLSTATUS)) {
            EBGNoteReceivableUtils.setPaymentState(infos, (PaymentState)PaymentState.SUCCESS, (String)BILLSTATUS, (String)ResManager.loadKDString((String)"\u63d0\u793a\u4ed8\u6b3e\u5f85\u7b7e\u6536", (String)"CIB_DC_Notepc_QueryPayParser_9", (String)"ebg-note-banks-cib-dc", (Object[])new Object[0]));
            infos.get(0).setNoteStatus("200001");
        } else if ("200003".equals(BILLSTATUS)) {
            EBGNoteReceivableUtils.setPaymentState(infos, (PaymentState)PaymentState.SUCCESS, (String)BILLSTATUS, (String)ResManager.loadKDString((String)"\u63d0\u793a\u4ed8\u6b3e\u5df2\u7b7e\u6536\u5f85\u6e05\u7b97", (String)"CIB_DC_Notepc_QueryPayParser_10", (String)"ebg-note-banks-cib-dc", (Object[])new Object[0]));
            infos.get(0).setNoteStatus("200003");
        } else if ("180001".equals(BILLSTATUS)) {
            EBGNoteReceivableUtils.setPaymentState(infos, (PaymentState)PaymentState.SUCCESS, (String)BILLSTATUS, (String)ResManager.loadKDString((String)"\u8d28\u62bc\u5f85\u7b7e\u6536", (String)"CIB_DC_Notepc_QueryPayParser_11", (String)"ebg-note-banks-cib-dc", (Object[])new Object[0]));
            infos.get(0).setNoteStatus("180001");
        } else if ("180006".equals(BILLSTATUS)) {
            EBGNoteReceivableUtils.setPaymentState(infos, (PaymentState)PaymentState.SUCCESS, (String)BILLSTATUS, (String)ResManager.loadKDString((String)"\u8d28\u62bc\u5df2\u7b7e\u6536", (String)"CIB_DC_Notepc_QueryPayParser_12", (String)"ebg-note-banks-cib-dc", (Object[])new Object[0]));
            infos.get(0).setNoteStatus("180006");
        } else if ("190001".equals(BILLSTATUS)) {
            EBGNoteReceivableUtils.setPaymentState(infos, (PaymentState)PaymentState.SUCCESS, (String)BILLSTATUS, (String)ResManager.loadKDString((String)"\u8d28\u62bc\u89e3\u9664\u5f85\u7b7e\u6536\u3002", (String)"CIB_DC_Notepc_QueryPayParser_13", (String)"ebg-note-banks-cib-dc", (Object[])new Object[0]));
            infos.get(0).setNoteStatus("190001");
        } else if ("190006".equals(BILLSTATUS)) {
            EBGNoteReceivableUtils.setPaymentState(infos, (PaymentState)PaymentState.SUCCESS, (String)BILLSTATUS, (String)ResManager.loadKDString((String)"\u8d28\u62bc\u89e3\u9664\u5df2\u7b7e\u6536\u3002", (String)"CIB_DC_Notepc_QueryPayParser_14", (String)"ebg-note-banks-cib-dc", (Object[])new Object[0]));
            infos.get(0).setNoteStatus("190006");
        } else {
            EBGNoteReceivableUtils.setPaymentState(infos, (PaymentState)PaymentState.SUBMITED, (String)BILLSTATUS, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4e2d", (String)"CIB_DC_Notepc_QueryPayParser_8", (String)"ebg-note-banks-cib-dc", (Object[])new Object[0]));
        }
    }
}

