/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.cib.dc.services;

import com.google.common.collect.Maps;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.frame.Sequence;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.datetime.DateTimeUtils;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.note.banks.cib.dc.services.SendMsg;
import kd.ebg.note.banks.cib.dc.services.newnote.NoteHandlerHelper;
import kd.ebg.note.banks.cib.dc.services.util.CIB_DC_Packer;
import kd.ebg.note.banks.cib.dc.services.util.CIB_DC_Parser;
import kd.ebg.note.common.model.NoteReceivableInfo;
import org.jdom2.Element;

public class CommonPacker {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(CommonPacker.class);

    public static String getEndOrseInfo(NoteReceivableInfo info) throws Exception {
        logger.info("\u67e5\u8be2\u80cc\u4e66\u4fe1\u606f\u7684\u7968\u636e\u53f7:" + info.getBillNo());
        String packerStr = CommonPacker.packEndOrse(info);
        logger.info("\u67e5\u8be2\u80cc\u4e66\u4fe1\u606f\u7968\u636e\u62a5\u6587:" + packerStr);
        String rsq = new SendMsg().sendAndRecvMsg(packerStr);
        logger.info("\u80cc\u4e66\u4fe1\u606f\u7968\u636e\u8fd4\u56de\u5185\u5bb9:" + rsq);
        return rsq;
    }

    public static Map<String, String> getSeqInfo(NoteReceivableInfo info) throws Exception {
        logger.info("\u67e5\u8be2\u53ef\u64cd\u4f5c\u7968\u636e\u62a5\u6587\u7684\u7968\u636e\u53f7:" + info.getBillNo());
        String packerStr = CommonPacker.packOperable(info);
        logger.info("\u67e5\u8be2\u53ef\u64cd\u4f5c\u7968\u636e\u62a5\u6587:" + packerStr);
        String rsq = new SendMsg().sendAndRecvMsg(packerStr);
        logger.info("\u53ef\u64cd\u4f5c\u7968\u636e\u8fd4\u56de\u5185\u5bb9:" + rsq);
        HashMap<String, String> result = new HashMap<String, String>();
        Map<String, String> map = CommonPacker.parserOperable(rsq);
        result.put("SEQ", map.get(info.getBillNo() + "SEQ"));
        result.put("BIZFLAG", map.get(info.getBillNo() + "BIZFLAG"));
        result.put("APPDATE", map.get(info.getBillNo() + "APPDATE"));
        return result;
    }

    public static Map<String, String> getSeqInfoNew(NoteReceivableInfo info) throws Exception {
        logger.info("\u67e5\u8be2\u53ef\u64cd\u4f5c\u7968\u636e\u62a5\u6587\u7684\u7968\u636e\u53f7:" + info.getBillNo());
        String packerStr = CommonPacker.packOperableNew(info);
        logger.info("\u67e5\u8be2\u53ef\u64cd\u4f5c\u7968\u636e\u62a5\u6587:" + packerStr);
        String rsq = new SendMsg().sendAndRecvMsg(packerStr);
        logger.info("\u53ef\u64cd\u4f5c\u7968\u636e\u8fd4\u56de\u5185\u5bb9:" + rsq);
        HashMap<String, String> result = new HashMap<String, String>();
        Map<String, String> map = CommonPacker.parserOperableNew(rsq);
        result.put("SEQ", map.get(info.getBillNo() + "SEQ"));
        result.put("BIZFLAG", map.get(info.getBillNo() + "BIZFLAG"));
        result.put("APPDATE", map.get(info.getBillNo() + "APPDATE"));
        result.put("fixSubBillRng", map.get(info.getBillNo() + "fixSubBillRng"));
        return result;
    }

    public static String packOperableNew(NoteReceivableInfo info) {
        String TRNUID = DateTimeUtils.format((Date)new Date(), (String)"yyyyMMdd") + Sequence.gen14Sequence();
        info.setReserved1(TRNUID);
        String operationCode = info.getOperationCode();
        String BUSINESSTYPE = "";
        if ("02".equals(operationCode)) {
            BUSINESSTYPE = "BC02";
        } else if ("03".equals(operationCode)) {
            BUSINESSTYPE = "BC03";
        } else if ("10".equals(operationCode)) {
            BUSINESSTYPE = "BC07";
        } else if ("18".equals(operationCode)) {
            BUSINESSTYPE = "BC11";
        } else if ("19".equals(operationCode)) {
            BUSINESSTYPE = "BC12";
        } else if ("20".equals(operationCode)) {
            BUSINESSTYPE = "BC13";
        } else if ("11".equals(operationCode)) {
            BUSINESSTYPE = "BC08";
        } else {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u7684\u64a4\u9500\u7c7b\u578b\uff1a%s\u3002", (String)"CommonPacker_1", (String)"ebg-note-banks-cib-dc", (Object[])new Object[0]), operationCode));
        }
        Element cms = CIB_DC_Packer.buildHeadMessage();
        Element msgsv = JDomUtils.addChild((Element)cms, (String)"SECURITIES_MSGSRQV1");
        Element EBRECEDETRNRQ = JDomUtils.addChild((Element)msgsv, (String)"RDYCANCELQUERYTRNRQ");
        JDomUtils.addChild((Element)EBRECEDETRNRQ, (String)"TRNUID", (String)TRNUID);
        Element EBRECEDETRNRQ_RQBODY = JDomUtils.addChildAttribute((Element)EBRECEDETRNRQ, (String)"RQBODY", (String)"PAGE", (String)"1");
        EBRECEDETRNRQ_RQBODY.setAttribute("SIZE", "100");
        JDomUtils.addChild((Element)EBRECEDETRNRQ_RQBODY, (String)"RDYCANCELBIZTYPE", (String)BUSINESSTYPE);
        JDomUtils.addChild((Element)EBRECEDETRNRQ_RQBODY, (String)"DRAFTNO", (String)info.getBillNo());
        JDomUtils.addChild((Element)EBRECEDETRNRQ_RQBODY, (String)"DRAFTRANGE", (String)NoteHandlerHelper.getFixSubBillRng(info));
        JDomUtils.addChild((Element)EBRECEDETRNRQ_RQBODY, (String)"ACCTID", (String)info.getDrawerAccNo());
        String encoding = RequestContextUtils.getCharset();
        String str = JDomUtils.root2String((Element)cms, (String)encoding);
        return str;
    }

    public static Map<String, String> parserOperableNew(String rsq) {
        Element root = CIB_DC_Parser.parseString2Root(rsq);
        Element SECURITIES_MSGSRSV1 = root.getChild("SECURITIES_MSGSRSV1");
        Element EBSIGNQUERYTRNRS = SECURITIES_MSGSRSV1.getChild("RDYCANCELQUERYTRNRS");
        Element STATUS = EBSIGNQUERYTRNRS.getChild("STATUS");
        String code = JDomUtils.getChildText((Element)STATUS, (String)"CODE");
        String MESSAGE = JDomUtils.getChildText((Element)STATUS, (String)"MESSAGE");
        if (!"0".equals(code)) {
            throw EBExceiptionUtil.serviceException((String)MESSAGE);
        }
        Element RSBODY = EBSIGNQUERYTRNRS.getChild("RSBODY");
        List contentList = RSBODY.getChildren("CONTENT");
        Element rs = null;
        String billCode = null;
        int size = contentList.size();
        HashMap map = Maps.newHashMapWithExpectedSize((int)(size * 3));
        for (int i = 0; i < size; ++i) {
            rs = (Element)contentList.get(i);
            billCode = rs.getChildText("DRAFTNO");
            map.put(billCode + "SEQ", rs.getChildText("RDYCANCELBIZNO"));
            map.put(billCode + "fixSubBillRng", rs.getChildText("DRAFTRANGE"));
            map.put(billCode + "APPDATE", rs.getChildText("REQDATE"));
        }
        return map;
    }

    public static String packOperable(NoteReceivableInfo info) {
        String TRNUID = DateTimeUtils.format((Date)new Date(), (String)"yyyyMMdd") + Sequence.gen16Sequence();
        info.setRqstserialno(TRNUID);
        String operationCode = info.getOperationCode();
        String BUSINESSTYPE = "";
        if ("02".equals(operationCode)) {
            BUSINESSTYPE = "22";
        } else if ("03".equals(operationCode)) {
            BUSINESSTYPE = "23";
        } else if ("10".equals(operationCode)) {
            BUSINESSTYPE = "24";
        } else if ("18".equals(operationCode)) {
            BUSINESSTYPE = "33";
        } else if ("19".equals(operationCode)) {
            BUSINESSTYPE = "34";
        } else if ("20".equals(operationCode)) {
            BUSINESSTYPE = "35";
        } else if ("25".equals(operationCode)) {
            BUSINESSTYPE = "36";
        } else if ("11".equals(operationCode)) {
            BUSINESSTYPE = "25";
        } else {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u7684\u64a4\u9500\u7c7b\u578b\uff1a%s\u3002", (String)"CommonPacker_1", (String)"ebg-note-banks-cib-dc", (Object[])new Object[0]), operationCode));
        }
        Element cms = CIB_DC_Packer.buildHeadMessage();
        Element msgsv = JDomUtils.addChild((Element)cms, (String)"SECURITIES_MSGSRQV1");
        Element EBRECEDETRNRQ = JDomUtils.addChild((Element)msgsv, (String)"EBOPRNQUERYTRNRQ");
        JDomUtils.addChild((Element)EBRECEDETRNRQ, (String)"TRNUID", (String)TRNUID);
        Element EBRECEDETRNRQ_RQBODY = JDomUtils.addChildAttribute((Element)EBRECEDETRNRQ, (String)"RQBODY", (String)"PAGE", (String)"1");
        EBRECEDETRNRQ_RQBODY.setAttribute("SIZE", "100");
        JDomUtils.addChild((Element)EBRECEDETRNRQ_RQBODY, (String)"BUSINESSTYPE", (String)BUSINESSTYPE);
        if (!StringUtils.isEmpty((String)info.getBillNo())) {
            JDomUtils.addChild((Element)EBRECEDETRNRQ_RQBODY, (String)"BILLCODE", (String)info.getBillNo());
        }
        JDomUtils.addChild((Element)EBRECEDETRNRQ_RQBODY, (String)"ACCTID", (String)info.getDrawerAccNo());
        JDomUtils.addChild((Element)EBRECEDETRNRQ_RQBODY, (String)"BILLTYPE", (String)info.getDraftType());
        String encoding = RequestContextUtils.getCharset();
        String str = JDomUtils.root2String((Element)cms, (String)encoding);
        return str;
    }

    public static Map<String, String> parserOperable(String rsq) {
        Element root = CIB_DC_Parser.parseString2Root(rsq);
        Element SECURITIES_MSGSRSV1 = root.getChild("SECURITIES_MSGSRSV1");
        Element EBSIGNQUERYTRNRS = SECURITIES_MSGSRSV1.getChild("EBOPRNQUERYTRNRS");
        Element STATUS = EBSIGNQUERYTRNRS.getChild("STATUS");
        String code = JDomUtils.getChildText((Element)STATUS, (String)"CODE");
        String MESSAGE = JDomUtils.getChildText((Element)STATUS, (String)"MESSAGE");
        if (!"0".equals(code)) {
            throw EBExceiptionUtil.serviceException((String)MESSAGE);
        }
        Element RSBODY = EBSIGNQUERYTRNRS.getChild("RSBODY");
        List contentList = RSBODY.getChildren("CONTENT");
        Element rs = null;
        String billCode = null;
        int size = contentList.size();
        HashMap<String, String> map = new HashMap<String, String>(size * 4);
        for (int i = 0; i < size; ++i) {
            rs = (Element)contentList.get(i);
            billCode = rs.getChildText("BILLCODE");
            map.put(billCode + "SEQ", rs.getChildText("SEQ"));
            map.put(billCode + "BIZFLAG", rs.getChildText("BIZFLAG"));
            map.put(billCode + "APPDATE", rs.getChildText("APPDATE"));
        }
        return map;
    }

    public static String packEndOrse(NoteReceivableInfo info) {
        String TRNUID = DateTimeUtils.format((Date)new Date(), (String)"yyyyMMdd") + Sequence.gen16Sequence();
        info.setRqstserialno(TRNUID);
        Element cms = CIB_DC_Packer.buildHeadMessage();
        Element msgsv = JDomUtils.addChild((Element)cms, (String)"SECURITIES_MSGSRQV1");
        Element EBBACKQUERYTRNRQ = JDomUtils.addChild((Element)msgsv, (String)"EBBACKQUERYTRNRQ");
        JDomUtils.addChild((Element)EBBACKQUERYTRNRQ, (String)"TRNUID", (String)TRNUID);
        Element EBBACKQUERYTRNRQ_RQBODY = JDomUtils.addChildAttribute((Element)EBBACKQUERYTRNRQ, (String)"RQBODY", (String)"PAGE", (String)"1");
        JDomUtils.addChild((Element)EBBACKQUERYTRNRQ_RQBODY, (String)"BILLCODE", (String)info.getBillNo());
        JDomUtils.addChild((Element)EBBACKQUERYTRNRQ_RQBODY, (String)"ACCTID", (String)info.getDrawerAccNo());
        String encoding = RequestContextUtils.getCharset();
        String str = JDomUtils.root2String((Element)cms, (String)encoding);
        return str;
    }
}

