/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.cib.dc.services.newnote.payable.register;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.egf.common.utils.Sequence;
import kd.ebg.egf.common.utils.datetime.DateTimeUtils;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.note.banks.cib.dc.services.util.CIB_DC_Packer;
import kd.ebg.note.common.model.NotePayableInfo;
import org.jdom2.Element;

public class NotePacker {
    private EBGLogger logger = EBGLogger.getInstance().getLogger(NotePacker.class);

    public String packOnline(List<NotePayableInfo> notePayableInfos) {
        NotePayableInfo info = notePayableInfos.get(0);
        String TRNUID = DateTimeUtils.format((Date)new Date(), (String)"yyyyMMdd") + Sequence.gen14Sequence();
        Element cms = CIB_DC_Packer.buildHeadMessage();
        Element msgsv = JDomUtils.addChild((Element)cms, (String)"SECURITIES_MSGSRQV1");
        Element EBDRAWTRNRQ = JDomUtils.addChild((Element)msgsv, (String)"NEWEBDRAWFINANCETRNRQ");
        JDomUtils.addChild((Element)EBDRAWTRNRQ, (String)"TRNUID", (String)TRNUID);
        Element EBDRAWTRNRQ_RQBODY = JDomUtils.addChild((Element)EBDRAWTRNRQ, (String)"RQBODY");
        JDomUtils.addChild((Element)EBDRAWTRNRQ_RQBODY, (String)"BIZCODE", (String)"301");
        JDomUtils.addChild((Element)EBDRAWTRNRQ_RQBODY, (String)"CURRENCY", (String)"01");
        JDomUtils.addChild((Element)EBDRAWTRNRQ_RQBODY, (String)"FINPURPOSE", (String)info.getExplanation());
        JDomUtils.addChild((Element)EBDRAWTRNRQ_RQBODY, (String)"DRAWACCTID", (String)info.getDrawerAccNo());
        JDomUtils.addChild((Element)EBDRAWTRNRQ_RQBODY, (String)"TOTALCOUNT");
        JDomUtils.addChild((Element)EBDRAWTRNRQ_RQBODY, (String)"TOTALAMT");
        if ("Y".equals(info.getIsOnlineBal())) {
            boolean isAllOnlineBal = notePayableInfos.stream().allMatch(notePayableInfo -> "Y".equals(notePayableInfo.getIsOnlineBal()));
            if (!isAllOnlineBal) {
                throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u540c\u4e00\u6279\u6b21\u4e0d\u80fd\u540c\u65f6\u5305\u542b\u5728\u7ebf\u5f00\u7acb\u4fdd\u8bc1\u91d1\u548c\u975e\u5728\u7ebf\u5f00\u7acb\u4fdd\u8bc1\u91d1\u3002", (String)"NotePacker_10", (String)"ebg-note-banks-cib-dc", (Object[])new Object[0]));
            }
            if (StringUtils.isEmpty((String)info.getBalEpayAc()) || StringUtils.isEmpty((String)info.getBalEpayAcName())) {
                throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u4fdd\u8bc1\u91d1\u8d26\u6237\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"NotePacker_5", (String)"ebg-note-banks-cib-dc", (Object[])new Object[0]));
            }
            if (info.getBalAmount() == null) {
                throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u4fdd\u8bc1\u91d1\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a", (String)"NotePacker_7", (String)"ebg-note-banks-cib-dc", (Object[])new Object[0]));
            }
            if (StringUtils.isEmpty((String)info.getBalTyp())) {
                throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u4fdd\u8bc1\u91d1\u5f00\u7acb\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", (String)"NotePacker_8", (String)"ebg-note-banks-cib-dc", (Object[])new Object[0]));
            }
            JDomUtils.addChild((Element)EBDRAWTRNRQ_RQBODY, (String)"OPEN_MARGIN_ACCT_FLAG", (String)info.getIsOnlineBal());
            Element MARGIN_ACCT_INFO = JDomUtils.addChild((Element)EBDRAWTRNRQ_RQBODY, (String)"MARGIN_ACCT_INFO");
            JDomUtils.addChild((Element)MARGIN_ACCT_INFO, (String)"PAY_ACCT_ID", (String)info.getBalEpayAc());
            JDomUtils.addChild((Element)MARGIN_ACCT_INFO, (String)"PAY_ACCT_NAME", (String)info.getBalEpayAcName());
            JDomUtils.addChild((Element)MARGIN_ACCT_INFO, (String)"CURRENCY", (String)"01");
            JDomUtils.addChild((Element)MARGIN_ACCT_INFO, (String)"DEPOSITAMT", (String)info.getBalAmount().setScale(2).toPlainString());
            if ("01".equals(info.getBalTyp())) {
                JDomUtils.addChild((Element)MARGIN_ACCT_INFO, (String)"OPENTYPE", (String)"1");
            } else {
                JDomUtils.addChild((Element)MARGIN_ACCT_INFO, (String)"OPENTYPE", (String)"2");
            }
        }
        int count = 0;
        BigDecimal totalAmt = BigDecimal.ZERO;
        for (NotePayableInfo notePayableInfo2 : notePayableInfos) {
            Element EBDRAWTRNRQ_CONTENT = JDomUtils.addChild((Element)EBDRAWTRNRQ_RQBODY, (String)"CONTENT");
            JDomUtils.addChild((Element)EBDRAWTRNRQ_CONTENT, (String)"INDX", (String)(++count + ""));
            if (!"AC01".equals(notePayableInfos.get(0).getDraftType())) {
                throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u5728\u7ebf\u878d\u8d44\u51fa\u7968\u4ec5\u652f\u6301\u94f6\u7968", (String)"NotePacker_0", (String)"ebg-note-banks-cib-dc", (Object[])new Object[0]));
            }
            JDomUtils.addChild((Element)EBDRAWTRNRQ_CONTENT, (String)"DRAFTTYPE", (String)notePayableInfos.get(0).getDraftType());
            JDomUtils.addChild((Element)EBDRAWTRNRQ_CONTENT, (String)"DRAFTAMT", (String)(notePayableInfo2.getAmount() + ""));
            JDomUtils.addChild((Element)EBDRAWTRNRQ_CONTENT, (String)"DUEDATE", (String)(notePayableInfo2.getDueDate() != null ? LocalDateUtil.formatDate((LocalDate)notePayableInfo2.getDueDate(), (String)"yyyyMMdd") : ""));
            JDomUtils.addChild((Element)EBDRAWTRNRQ_CONTENT, (String)"ENDORSEFLAG", (String)notePayableInfo2.getTransferFlag());
            String grdBag = info.getGrdBag();
            if (StringUtils.isEmpty((String)grdBag)) {
                JDomUtils.addChild((Element)EBDRAWTRNRQ_CONTENT, (String)"SPLITFLAG", (String)"0");
            } else {
                JDomUtils.addChild((Element)EBDRAWTRNRQ_CONTENT, (String)"SPLITFLAG", (String)grdBag);
            }
            Element EBDRAWTRNRQ_ACACCT = JDomUtils.addChild((Element)EBDRAWTRNRQ_CONTENT, (String)"ACACCT");
            JDomUtils.addChild((Element)EBDRAWTRNRQ_ACACCT, (String)"NAME", (String)notePayableInfo2.getAcceptorAccName());
            JDomUtils.addChild((Element)EBDRAWTRNRQ_ACACCT, (String)"ACCTID", (String)notePayableInfo2.getAcceptorAccNo());
            JDomUtils.addChild((Element)EBDRAWTRNRQ_ACACCT, (String)"BANKNUM", (String)notePayableInfo2.getAcceptorBankCnaps());
            Element EBDRAWTRNRQ_PAYEEACCT = JDomUtils.addChild((Element)EBDRAWTRNRQ_CONTENT, (String)"PAYEEACCT");
            JDomUtils.addChild((Element)EBDRAWTRNRQ_PAYEEACCT, (String)"NAME", (String)notePayableInfo2.getPayeeAccName());
            JDomUtils.addChild((Element)EBDRAWTRNRQ_PAYEEACCT, (String)"ACCTID", (String)notePayableInfo2.getPayeeAccNo());
            JDomUtils.addChild((Element)EBDRAWTRNRQ_PAYEEACCT, (String)"BANKNUM", (String)notePayableInfo2.getPayeeBankCnaps());
            JDomUtils.addChild((Element)EBDRAWTRNRQ_CONTENT, (String)"EXPUCNDENTRSTMARK", (String)"CC00");
            if ("1".equals(grdBag)) {
                JDomUtils.addChild((Element)EBDRAWTRNRQ_CONTENT, (String)"ACCEPTAMT", (String)(notePayableInfo2.getAmount() + ""));
            }
            Element PAYNOS = JDomUtils.addChild((Element)EBDRAWTRNRQ_CONTENT, (String)"PAYNOS");
            JDomUtils.addChild((Element)PAYNOS, (String)"PAYNO", (String)notePayableInfo2.getDetailSeqId());
            notePayableInfo2.setBankSerialNo(TRNUID);
            notePayableInfo2.setBankRefKey(TRNUID + "@" + count);
            totalAmt = totalAmt.add(notePayableInfo2.getAmount());
        }
        JDomUtils.getChildElement((Element)EBDRAWTRNRQ_RQBODY, (String)"TOTALCOUNT").addContent(count + "");
        JDomUtils.getChildElement((Element)EBDRAWTRNRQ_RQBODY, (String)"TOTALAMT").addContent(totalAmt + "");
        String encoding = RequestContextUtils.getCharset();
        String str = JDomUtils.root2String((Element)cms, (String)encoding);
        return str;
    }

    private String getfinPurpose(String str) {
        for (String reserved : str.split("\\|")) {
            if (!"finpurpose".equals(reserved.split("=")[0])) continue;
            return reserved.split("=")[1];
        }
        return "";
    }

    public String packCommon(List<NotePayableInfo> notePayableInfos) {
        NotePayableInfo info = notePayableInfos.get(0);
        String TRNUID = DateTimeUtils.format((Date)new Date(), (String)"yyyyMMdd") + Sequence.gen14Sequence();
        Element cms = CIB_DC_Packer.buildHeadMessage();
        Element msgsv = JDomUtils.addChild((Element)cms, (String)"SECURITIES_MSGSRQV1");
        Element EBDRAWTRNRQ = JDomUtils.addChild((Element)msgsv, (String)"NEWEBDRAWTRNRQ");
        JDomUtils.addChild((Element)EBDRAWTRNRQ, (String)"TRNUID", (String)TRNUID);
        Element EBDRAWTRNRQ_RQBODY = JDomUtils.addChild((Element)EBDRAWTRNRQ, (String)"RQBODY");
        if ("1".equals(info.getAutoAccept()) || "1".equals(info.getAutoReceive())) {
            JDomUtils.addChild((Element)EBDRAWTRNRQ_RQBODY, (String)"TYPE", (String)"05");
        } else {
            JDomUtils.addChild((Element)EBDRAWTRNRQ_RQBODY, (String)"TYPE", (String)"01");
            info.setAutoAccept("0");
            info.setAutoReceive("0");
        }
        JDomUtils.addChild((Element)EBDRAWTRNRQ_RQBODY, (String)"ACCTID", (String)info.getDrawerAccNo());
        int count = 0;
        for (NotePayableInfo notePayableInfo : notePayableInfos) {
            Element EBDRAWTRNRQ_CONTENT = JDomUtils.addChild((Element)EBDRAWTRNRQ_RQBODY, (String)"CONTENT");
            JDomUtils.addChild((Element)EBDRAWTRNRQ_CONTENT, (String)"APPLYID", (String)(++count + ""));
            JDomUtils.addChild((Element)EBDRAWTRNRQ_CONTENT, (String)"DRAFTAMT", (String)(notePayableInfo.getAmount() + ""));
            JDomUtils.addChild((Element)EBDRAWTRNRQ_CONTENT, (String)"DRAFTTYPE", (String)notePayableInfo.getDraftType());
            JDomUtils.addChild((Element)EBDRAWTRNRQ_CONTENT, (String)"DUEDATE", (String)(notePayableInfo.getDueDate() != null ? LocalDateUtil.formatDate((LocalDate)notePayableInfo.getDueDate()) : ""));
            JDomUtils.addChild((Element)EBDRAWTRNRQ_CONTENT, (String)"ENDORSEFLAG", (String)notePayableInfo.getTransferFlag());
            String grdBag = info.getGrdBag();
            if (StringUtils.isEmpty((String)grdBag)) {
                JDomUtils.addChild((Element)EBDRAWTRNRQ_CONTENT, (String)"SPLITFLAG", (String)"0");
            } else {
                JDomUtils.addChild((Element)EBDRAWTRNRQ_CONTENT, (String)"SPLITFLAG", (String)grdBag);
            }
            JDomUtils.addChild((Element)EBDRAWTRNRQ_CONTENT, (String)"DRAWBTNO", (String)notePayableInfo.getBankBatchSeqId());
            JDomUtils.addChild((Element)EBDRAWTRNRQ_CONTENT, (String)"DRAWREMARK", (String)notePayableInfo.getExplanation());
            JDomUtils.addChild((Element)EBDRAWTRNRQ_CONTENT, (String)"ACCEPTERACCTNAME", (String)notePayableInfo.getAcceptorAccName());
            JDomUtils.addChild((Element)EBDRAWTRNRQ_CONTENT, (String)"ACCEPTERACCTID", (String)notePayableInfo.getAcceptorAccNo());
            JDomUtils.addChild((Element)EBDRAWTRNRQ_CONTENT, (String)"ACCEPTERBANKNO", (String)notePayableInfo.getAcceptorBankCnaps());
            JDomUtils.addChild((Element)EBDRAWTRNRQ_CONTENT, (String)"PAYEEACCTNAME", (String)notePayableInfo.getPayeeAccName());
            JDomUtils.addChild((Element)EBDRAWTRNRQ_CONTENT, (String)"PAYEEACCTID", (String)notePayableInfo.getPayeeAccNo());
            JDomUtils.addChild((Element)EBDRAWTRNRQ_CONTENT, (String)"PAYEEBANKNO", (String)notePayableInfo.getPayeeBankCnaps());
            JDomUtils.addChild((Element)EBDRAWTRNRQ_CONTENT, (String)"EXPUCNDENTRSTMARK", (String)"CC00");
            notePayableInfo.setReserved1(TRNUID);
            notePayableInfo.setReserved2(count + "");
        }
        String encoding = RequestContextUtils.getCharset();
        String str = JDomUtils.root2String((Element)cms, (String)encoding);
        return str;
    }
}

