/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.cib.dc.services.newnote.payable.register;

import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.note.banks.cib.dc.services.util.CIB_DC_Parser;
import kd.ebg.note.business.notePayable.util.EBGNotePayableUtils;
import kd.ebg.note.common.entity.biz.status.PaymentState;
import kd.ebg.note.common.model.NotePayableInfo;
import org.jdom2.Element;

public class NoteParser {
    private EBGLogger logger = EBGLogger.getInstance().getLogger(NoteParser.class);

    public void parseCommon(List<NotePayableInfo> notePayableInfos, String rspStr) {
        Element root = CIB_DC_Parser.parseString2Root(rspStr);
        BankResponse bankResponse = CIB_DC_Parser.noteParseString2Root(root);
        if (!"0".equals(bankResponse.getResponseCode())) {
            EBGNotePayableUtils.setPaymentState(notePayableInfos, (PaymentState)PaymentState.UNKNOWN, (String)bankResponse.getResponseCode(), (String)bankResponse.getResponseMessage());
            return;
        }
        Element eb1 = root.getChild("SECURITIES_MSGSRSV1");
        Element EBDRAWTRNRS = eb1.getChild("NEWEBDRAWTRNRS");
        Element STATUS = EBDRAWTRNRS.getChild("STATUS");
        String code = JDomUtils.getChildText((Element)STATUS, (String)"CODE");
        String MESSAGE = JDomUtils.getChildText((Element)STATUS, (String)"MESSAGE");
        if (!"0".equals(code)) {
            EBGNotePayableUtils.setPaymentState(notePayableInfos, (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25", (String)"NoteParser_0", (String)"ebg-note-banks-cib-dc", (Object[])new Object[0]), (String)MESSAGE);
        } else {
            EBGNotePayableUtils.setPaymentState(notePayableInfos, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4e2d", (String)"NoteParser_1", (String)"ebg-note-banks-cib-dc", (Object[])new Object[0]), (String)MESSAGE);
        }
    }

    public void parseOnline(List<NotePayableInfo> notePayableInfos, String rspStr) {
        Element root = CIB_DC_Parser.parseString2Root(rspStr);
        Element eb1 = root.getChild("SECURITIES_MSGSRSV1");
        Element DRAWFINANCETRNRS = eb1.getChild("NEWEBDRAWFINANCETRNRS");
        Element STATUS = DRAWFINANCETRNRS.getChild("STATUS");
        String code = JDomUtils.getChildText((Element)STATUS, (String)"CODE");
        String MESSAGE = JDomUtils.getChildText((Element)STATUS, (String)"MESSAGE");
        this.logger.info("code:" + code + ",MESSAGE:" + MESSAGE);
        if (!"0".equals(code)) {
            EBGNotePayableUtils.setPaymentState(notePayableInfos, (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25", (String)"NoteParser_0", (String)"ebg-note-banks-cib-dc", (Object[])new Object[0]), (String)MESSAGE);
        } else {
            String srvrid = JDomUtils.getChildText((Element)DRAWFINANCETRNRS.getChild("RSBODY"), (String)"SRVRID");
            notePayableInfos.get(0).setRspserialno(srvrid);
            EBGNotePayableUtils.setPaymentState(notePayableInfos, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4e2d", (String)"NoteParser_1", (String)"ebg-note-banks-cib-dc", (Object[])new Object[0]), (String)MESSAGE);
        }
    }
}

