/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.cib.dc.services.newnote.receivable.signin;

import java.util.Date;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.Sequence;
import kd.ebg.egf.common.utils.datetime.DateTimeUtils;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.note.banks.cib.dc.services.newnote.NoteHandlerHelper;
import kd.ebg.note.banks.cib.dc.services.newnote.receivable.QueryNoteReceivableImpl;
import kd.ebg.note.banks.cib.dc.services.util.CIB_DC_Packer;
import kd.ebg.note.banks.cib.dc.services.util.CIB_DC_Parser;
import kd.ebg.note.business.noteReceivable.atomic.AbstractNoteReceivableImpl;
import kd.ebg.note.business.noteReceivable.atomic.IQueryNoteReceivable;
import kd.ebg.note.business.noteReceivable.bank.BankNoteReceivableRequest;
import kd.ebg.note.business.noteReceivable.util.EBGNoteReceivableUtils;
import kd.ebg.note.common.entity.biz.status.PaymentState;
import kd.ebg.note.common.model.NoteReceivableInfo;
import org.jdom2.Element;

public class ReceivableSigninNoteImpl
extends AbstractNoteReceivableImpl {
    private EBGLogger logger = EBGLogger.getInstance().getLogger(ReceivableSigninNoteImpl.class);

    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryNoteReceivable> defaultQueryClass() {
        return QueryNoteReceivableImpl.class;
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "NEWEBSIGNTRNRQ";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u7968\u636e\u7b7e\u6536", (String)"ReceivableSigninNoteImpl_0", (String)"ebg-note-banks-cib-dc", (Object[])new Object[0]);
    }

    public boolean match(NoteReceivableInfo noteReceivableInfo) {
        return true;
    }

    public String pack(BankNoteReceivableRequest bankNoteReceivableRequest, String s) {
        List receivableInfos = bankNoteReceivableRequest.getNoteReceivableInfos();
        NoteReceivableInfo info = (NoteReceivableInfo)receivableInfos.get(0);
        String TRNUID = DateTimeUtils.format((Date)new Date(), (String)"yyyyMMdd") + Sequence.gen14Sequence();
        Element cms = CIB_DC_Packer.buildHeadMessage();
        Element msgsv = JDomUtils.addChild((Element)cms, (String)"SECURITIES_MSGSRQV1");
        Element EBRECEDETRNRQ = JDomUtils.addChild((Element)msgsv, (String)"NEWEBSIGNTRNRQ");
        JDomUtils.addChild((Element)EBRECEDETRNRQ, (String)"TRNUID", (String)TRNUID);
        Element EBSIGNTRNRQ_RQBODY = JDomUtils.addChild((Element)EBRECEDETRNRQ, (String)"RQBODY");
        JDomUtils.addChild((Element)EBSIGNTRNRQ_RQBODY, (String)"ACCTID", (String)info.getDrawerAccNo());
        for (NoteReceivableInfo noteReceivableInfo : receivableInfos) {
            String operationCode = noteReceivableInfo.getOperationCode();
            String BUSINESSTYPE = "";
            if ("10".equals(operationCode)) {
                BUSINESSTYPE = "BC07";
            } else if ("02".equals(operationCode)) {
                BUSINESSTYPE = "BC02";
            } else if ("03".equals(operationCode)) {
                BUSINESSTYPE = "BC03";
            } else if ("20".equals(operationCode)) {
                BUSINESSTYPE = "BC13";
            }
            this.logger.info("operationCode:" + operationCode + ";BUSINESSTYPE:" + BUSINESSTYPE);
            if (StringUtils.isEmpty((String)BUSINESSTYPE)) {
                throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u7684\u7b7e\u6536\u7c7b\u578b\uff1a%s", (String)"ReceivableSigninNoteImpl_4", (String)"ebg-note-banks-cib-dc", (Object[])new Object[0]), operationCode));
            }
            noteReceivableInfo.setReserved1(TRNUID);
            Element RQBODY_CONTENT = JDomUtils.addChild((Element)EBSIGNTRNRQ_RQBODY, (String)"CONTENT");
            JDomUtils.addChild((Element)RQBODY_CONTENT, (String)"DRAFTNO", (String)noteReceivableInfo.getBillNo());
            JDomUtils.addChild((Element)RQBODY_CONTENT, (String)"DRAFTRANGE", (String)NoteHandlerHelper.getFixSubBillRng(noteReceivableInfo));
            JDomUtils.addChild((Element)RQBODY_CONTENT, (String)"DRAFTAMT", (String)(noteReceivableInfo.getAmount() + ""));
            JDomUtils.addChild((Element)RQBODY_CONTENT, (String)"RSPBIZNO", (String)noteReceivableInfo.getBankRefKey());
            JDomUtils.addChild((Element)RQBODY_CONTENT, (String)"RSPBIZTYPE", (String)BUSINESSTYPE);
            JDomUtils.addChild((Element)RQBODY_CONTENT, (String)"RSPFLAG", (String)info.getOtherInfo());
            if (StringUtils.isNotEmpty((String)info.getExplanation())) {
                JDomUtils.addChild((Element)RQBODY_CONTENT, (String)"RSPRMK", (String)info.getExplanation());
            }
            if (!"SU00".equals(info.getOtherInfo())) {
                JDomUtils.addChild((Element)RQBODY_CONTENT, (String)"REJECTREASON", (String)"CP06");
                JDomUtils.addChild((Element)RQBODY_CONTENT, (String)"REJECTRMK", (String)info.getExplanation());
                continue;
            }
            JDomUtils.addChild((Element)RQBODY_CONTENT, (String)"ENTRSPAY", (String)"CC00");
        }
        String encoding = RequestContextUtils.getCharset();
        String str = JDomUtils.root2String((Element)cms, (String)encoding);
        return str;
    }

    public List<NoteReceivableInfo> parse(BankNoteReceivableRequest bankNoteReceivableRequest, String rsp) {
        List receivableInfos = bankNoteReceivableRequest.getNoteReceivableInfos();
        Element root = CIB_DC_Parser.parseString2Root(rsp);
        BankResponse bankResponse = CIB_DC_Parser.noteParseString2Root(root);
        if (!"0".equals(bankResponse.getResponseCode())) {
            EBGNoteReceivableUtils.setPaymentState((List)receivableInfos, (PaymentState)PaymentState.UNKNOWN, (String)bankResponse.getResponseCode(), (String)bankResponse.getResponseMessage());
            return receivableInfos;
        }
        Element eb1 = root.getChild("SECURITIES_MSGSRSV1");
        Element EBRECEDETRNRS = eb1.getChild("NEWEBSIGNTRNRS");
        Element STATUS = EBRECEDETRNRS.getChild("STATUS");
        String code = JDomUtils.getChildText((Element)STATUS, (String)"CODE");
        String MESSAGE = JDomUtils.getChildText((Element)STATUS, (String)"MESSAGE");
        this.logger.info("code:" + code + ",MESSAGE:" + MESSAGE);
        Element RSBODY = EBRECEDETRNRS.getChild("RSBODY");
        if (!"0".equals(code)) {
            EBGNoteReceivableUtils.setPaymentState((List)receivableInfos, (PaymentState)PaymentState.FAIL, (String)code, (String)MESSAGE);
        } else {
            Element XFERPRCSTS = RSBODY.getChild("XFERPRCSTS");
            String XFERPRCCODE = JDomUtils.getChildText((Element)XFERPRCSTS, (String)"XFERPRCCODE");
            String DTXFERPRC = JDomUtils.getChildText((Element)XFERPRCSTS, (String)"DTXFERPRC");
            String XFERPRCSTS_MESSAGE = JDomUtils.getChildText((Element)XFERPRCSTS, (String)"MESSAGE");
            if ("WAIT_FOR_AUDIT".equals(XFERPRCCODE)) {
                EBGNoteReceivableUtils.setPaymentState((List)receivableInfos, (PaymentState)PaymentState.SUBMITED, (String)"", (String)XFERPRCSTS_MESSAGE);
            } else {
                EBGNoteReceivableUtils.setPaymentState((List)receivableInfos, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)XFERPRCSTS_MESSAGE);
            }
        }
        return receivableInfos;
    }
}

