/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.cib.dc.services.note.detail;

import java.text.ParseException;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.frame.Sequence;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.datetime.DateTimeUtils;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.note.banks.cib.dc.services.Common;
import kd.ebg.note.banks.cib.dc.services.note.detail.endorseinfo.EndorseInfoImpl;
import kd.ebg.note.banks.cib.dc.services.util.CIB_DC_Packer;
import kd.ebg.note.banks.cib.dc.services.util.CIB_DC_Parser;
import kd.ebg.note.business.noteDetail.atomic.AbstractNoteDetailImpl;
import kd.ebg.note.business.noteDetail.bank.BankNoteDetailRequest;
import kd.ebg.note.business.noteDetail.bank.BankNoteDetailRequestBody;
import kd.ebg.note.common.entity.biz.notedetail.Detail;
import kd.ebg.note.common.entity.biz.notedetail.NoteDetailRequest;
import kd.ebg.note.common.entity.biz.notedetail.NoteSidesInfo;
import org.jdom2.Element;

public class NoteDetailImpl
extends AbstractNoteDetailImpl {
    private final EBGLogger logger = EBGLogger.getInstance().getLogger(NoteDetailImpl.class);

    public String pack(BankNoteDetailRequest request, String pageTag) {
        String subBizType = request.getHeader().getSubBizType();
        if ("hold".equals(subBizType)) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u8be5\u94f6\u884c\u6682\u4e0d\u652f\u6301\u6301\u7968\u67e5\u8be2\u3002", (String)"NoteDetailImpl_0", (String)"ebg-note-banks-cib-dc", (Object[])new Object[0]));
        }
        BankNoteDetailRequestBody body = request.getBody();
        String transType = request.getBody().getTranType();
        String BUSINESSTYPE = "";
        if ("02".equals(transType)) {
            BUSINESSTYPE = "03";
        } else if ("03".equals(transType)) {
            BUSINESSTYPE = "05";
        } else if ("10".equals(transType)) {
            BUSINESSTYPE = "07";
        } else if ("19".equals(transType)) {
            BUSINESSTYPE = "16";
        } else if ("20".equals(transType)) {
            BUSINESSTYPE = "17";
        } else if ("21".equals(transType)) {
            BUSINESSTYPE = "18";
        } else {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u6ca1\u6709\u5339\u914d\u7684\u4e1a\u52a1\u53f7\u3002", (String)"NoteDetailImpl_1", (String)"ebg-note-banks-cib-dc", (Object[])new Object[0]));
        }
        String TRNUID = DateTimeUtils.format((Date)new Date(), (String)"yyyyMMdd") + Sequence.gen16Sequence();
        Element cms = CIB_DC_Packer.buildHeadMessage();
        Element msgsv = JDomUtils.addChild((Element)cms, (String)"SECURITIES_MSGSRQV1");
        Element EBSIGNQUERYTRNRQ = JDomUtils.addChild((Element)msgsv, (String)"EBSIGNQUERYTRNRQ");
        JDomUtils.addChild((Element)EBSIGNQUERYTRNRQ, (String)"TRNUID", (String)TRNUID);
        Element EBSIGNQUERYTRNRQ_RQBODY = JDomUtils.addChildAttribute((Element)EBSIGNQUERYTRNRQ, (String)"RQBODY", (String)"PAGE", (String)"1");
        JDomUtils.addChild((Element)EBSIGNQUERYTRNRQ_RQBODY, (String)"BUSINESSTYPE", (String)BUSINESSTYPE);
        JDomUtils.addChild((Element)EBSIGNQUERYTRNRQ_RQBODY, (String)"ACCTID", (String)request.getAcnt().getAccNo());
        Element RQBODY_APPDTSTART = JDomUtils.addChild((Element)EBSIGNQUERYTRNRQ_RQBODY, (String)"APPDTSTART");
        this.logger.info("\u7968\u636e\u660e\u7ec6\u67e5\u8be2\u8bf7\u6c42\u53c2\u6570\u4e2d\u65e5\u671f\uff1aStartDueDate:" + body.getStartDueDate() + ",EndDueDate:" + body.getEndDueDate() + ",StartIssueDate:" + body.getStartIssueDate() + ",EndIssueDate:" + body.getEndIssueDate());
        JDomUtils.addChild((Element)RQBODY_APPDTSTART, (String)"DTSTART", (String)body.getStartIssueDate().format(DateTimeFormatter.ofPattern("yyyy-MM-dd")));
        JDomUtils.addChild((Element)RQBODY_APPDTSTART, (String)"DTEND", (String)body.getEndIssueDate().format(DateTimeFormatter.ofPattern("yyyy-MM-dd")));
        String encoding = RequestContextUtils.getCharset();
        String str = JDomUtils.root2String((Element)cms, (String)encoding);
        this.logger.info("\u67e5\u8be2\u56de\u590d\u4fe1\u606f\u62a5\u6587\uff1a" + str);
        return str;
    }

    public List<Detail> parse(BankNoteDetailRequest request, String responseStr) {
        this.logger.info("\u660e\u7ec6\u8fd4\u56de\u62a5\u6587\uff1a" + responseStr);
        String transType = request.getBody().getTranType();
        ArrayList<Detail> result = new ArrayList<Detail>();
        Element root = CIB_DC_Parser.parseString2Root(responseStr);
        Element SECURITIES_MSGSRSV1 = root.getChild("SECURITIES_MSGSRSV1");
        Element EBSIGNQUERYTRNRS = SECURITIES_MSGSRSV1.getChild("EBSIGNQUERYTRNRS");
        Element STATUS = EBSIGNQUERYTRNRS.getChild("STATUS");
        String code = JDomUtils.getChildText((Element)STATUS, (String)"CODE");
        String MESSAGE = JDomUtils.getChildText((Element)STATUS, (String)"MESSAGE");
        if (!"0".equals(code)) {
            throw EBExceiptionUtil.serviceException((String)MESSAGE);
        }
        Element RSBODY = EBSIGNQUERYTRNRS.getChild("RSBODY");
        if (RSBODY != null) {
            List contentList = RSBODY.getChildren("CONTENT");
            for (int i = 0; i < contentList.size(); ++i) {
                Detail detailInfo = new Detail();
                result.add(detailInfo);
                Element rs = (Element)contentList.get(i);
                String BILLCODE = rs.getChildText("BILLCODE");
                String BILLTYPE = rs.getChildText("BILLTYPE");
                String BILLAMT = rs.getChildText("BILLAMT");
                String DRAWDATE = rs.getChildText("DRAWDATE");
                String DUEDATE = rs.getChildText("DUEDATE");
                String NEGTBL = rs.getChildText("NEGTBL");
                Element RSBODY_DRAWERACCT = rs.getChild("DRAWERACCT");
                String ACCTID = RSBODY_DRAWERACCT.getChildText("ACCTID");
                String NAME = RSBODY_DRAWERACCT.getChildText("NAME");
                String BANKNUM = RSBODY_DRAWERACCT.getChildText("BANKNUM");
                Element RSBODY_PAYEEACCT = rs.getChild("PAYEEACCT");
                String PAY_ACCTID = RSBODY_PAYEEACCT.getChildText("ACCTID");
                String PAY_NAME = RSBODY_PAYEEACCT.getChildText("NAME");
                String PAY_BANKNUM = RSBODY_PAYEEACCT.getChildText("BANKNUM");
                Element RSBODY_ACPTRACCT = rs.getChild("ACPTRACCT");
                String ACP_ACCTID = RSBODY_ACPTRACCT.getChildText("ACCTID");
                String ACP_NAME = RSBODY_ACPTRACCT.getChildText("NAME");
                String ACP_BANKNUM = RSBODY_ACPTRACCT.getChildText("BANKNUM");
                Element RSBODY_PROPSRINFO = rs.getChild("PROPSRINFO");
                String PRO_ACCTID = RSBODY_PROPSRINFO.getChildText("ACCTID");
                String PRO_NAME = RSBODY_PROPSRINFO.getChildText("NAME");
                String PRO_BANKNUM = RSBODY_PROPSRINFO.getChildText("BANKNUM");
                String BIZFLAG = rs.getChildText("BIZFLAG");
                String APPDATE = rs.getChildText("APPDATE");
                detailInfo.setNoteNo(BILLCODE);
                detailInfo.setDraftType(BILLTYPE);
                try {
                    detailInfo.setIssueDate(DateTimeUtils.format((Date)DateTimeUtils.parseDate((String)DRAWDATE, (String)"yyyy-MM-dd"), (String)"yyyyMMdd"));
                    detailInfo.setApplicationDate(DateTimeUtils.format((Date)DateTimeUtils.parseDate((String)DRAWDATE, (String)"yyyy-MM-dd"), (String)"yyyyMMdd"));
                    detailInfo.setDueDate(DateTimeUtils.format((Date)DateTimeUtils.parseDate((String)DUEDATE, (String)"yyyy-MM-dd"), (String)"yyyyMMdd"));
                }
                catch (ParseException e1) {
                    this.logger.error("", (Throwable)e1);
                }
                detailInfo.setAmount(BILLAMT);
                detailInfo.setTransferFlag(NEGTBL);
                detailInfo.setPayeeAccName(PAY_NAME);
                detailInfo.setDrawerAccName(NAME);
                detailInfo.setDrawerAccNo(ACCTID);
                detailInfo.setDrawerCnapsCode(BANKNUM);
                detailInfo.setPayeeAccNo(PAY_ACCTID);
                detailInfo.setPayeeCnapsCode(PAY_BANKNUM);
                detailInfo.setApplicantAcName(PRO_NAME);
                detailInfo.setApplicantAcNo(PRO_ACCTID);
                detailInfo.setApplicantBankCnaps(PRO_BANKNUM);
                detailInfo.setAcceptorAccName(ACP_NAME);
                detailInfo.setAcceptorAccNo(ACP_ACCTID);
                detailInfo.setAcceptorCnapsCode(ACP_BANKNUM);
                detailInfo.setCurrency("CNY");
                detailInfo.setBankRefKey(BIZFLAG);
                this.logger.info("transType:" + transType);
                EndorseInfoImpl impl = new EndorseInfoImpl();
                this.logger.info("\u67e5\u8be2\u80cc\u4e66\u8054\uff1a" + i + "---" + BILLCODE);
                List<NoteSidesInfo> sidesDetails = impl.getinfo(BILLCODE, request.getAcnt().getAccNo());
                detailInfo.setBusinessCode(request.getBody().getTranType());
                detailInfo.setNoteSidesInfo(sidesDetails);
                if (StringUtils.isEmpty((String)APPDATE) || DRAWDATE.equals(APPDATE)) continue;
                Common.appDateMap.put(BILLCODE, APPDATE);
                Common.insertAppDate(BILLCODE, APPDATE);
            }
        }
        this.logger.info("\u660e\u7ec6\u8fd4\u56de\u7ed3\u679c:result\u7684\u5927\u5c0f:" + result.size());
        return result;
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return null;
    }

    public String getBizDesc() {
        return null;
    }

    public boolean match(NoteDetailRequest noteDetailRequest) {
        return !"0".equals(noteDetailRequest.getBody().getIsNewECDS());
    }

    public long getBankInterval() {
        return 0L;
    }
}

