/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.cib.dc.services.note.payable.confirm;

import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.frame.Sequence;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.datetime.DateTimeUtils;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.note.banks.cib.dc.services.note.payable.confirm.ConfirmNotePayableImpl;
import kd.ebg.note.banks.cib.dc.services.util.CIB_DC_Packer;
import kd.ebg.note.banks.cib.dc.services.util.CIB_DC_Parser;
import kd.ebg.note.business.notePayable.atomic.AbstractQueryNotePayableImpl;
import kd.ebg.note.business.notePayable.bank.BankNotePayableRequest;
import kd.ebg.note.business.notePayable.util.EBGNotePayableUtils;
import kd.ebg.note.common.entity.biz.status.PaymentState;
import kd.ebg.note.common.model.NotePayableInfo;
import org.jdom2.Element;

public class QueryConfirmNotePayableImpl
extends AbstractQueryNotePayableImpl {
    private final EBGLogger logger = EBGLogger.getInstance().getLogger(ConfirmNotePayableImpl.class);

    public String pack(BankNotePayableRequest request, String pageTag) {
        List notePayableInfos = request.getNotePayableInfoList();
        NotePayableInfo info = (NotePayableInfo)notePayableInfos.get(0);
        if (StringUtils.isEmpty((String)info.getRqstserialno())) {
            this.logger.info("******\u5728\u7ebf\u878d\u8d44\u51fa\u7968\u540c\u6b65-\u67e5\u8be2\u7533\u8bf7\u5217\u8868");
            String TRNUID = DateTimeUtils.format((Date)new Date(), (String)"yyyyMMdd") + Sequence.gen16Sequence();
            Element cms = CIB_DC_Packer.buildHeadMessage();
            Element msgsv = JDomUtils.addChild((Element)cms, (String)"SECURITIES_MSGSRQV1");
            Element QUERYDRAWFINDTLTRNRQ = JDomUtils.addChild((Element)msgsv, (String)"QUERYDRAWFINLISTTRNRQ");
            JDomUtils.addChild((Element)QUERYDRAWFINDTLTRNRQ, (String)"TRNUID", (String)TRNUID);
            String pageNo = pageTag.substring(0, pageTag.indexOf("_"));
            Element EBSIGNQUERYTRNRQ_RQBODY = JDomUtils.addChildAttribute((Element)QUERYDRAWFINDTLTRNRQ, (String)"RQBODY", (String)"PAGE", (String)pageNo);
            JDomUtils.addChild((Element)EBSIGNQUERYTRNRQ_RQBODY, (String)"OPERATEFLAG", (String)"1");
            JDomUtils.addChild((Element)EBSIGNQUERYTRNRQ_RQBODY, (String)"BIZCODE", (String)"301");
            JDomUtils.addChild((Element)EBSIGNQUERYTRNRQ_RQBODY, (String)"ACCTID", (String)info.getDrawerAccNo());
            JDomUtils.addChild((Element)EBSIGNQUERYTRNRQ_RQBODY, (String)"STAPPLYDATE", (String)info.getBookingDate().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
            JDomUtils.addChild((Element)EBSIGNQUERYTRNRQ_RQBODY, (String)"ENDAPPLYDATE", (String)info.getBookingDate().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
            String encoding = RequestContextUtils.getCharset();
            String str = JDomUtils.root2String((Element)cms, (String)encoding);
            return str;
        }
        this.logger.info("********\u5728\u7ebf\u878d\u8d44\u51fa\u7968\u7533\u8bf7\u540c\u6b65-\u878d\u8d44\u7533\u8bf7\u8be6\u60c5\u67e5\u8be2");
        String TRNUID = DateTimeUtils.format((Date)new Date(), (String)"yyyyMMdd") + Sequence.gen16Sequence();
        Element cms = CIB_DC_Packer.buildHeadMessage();
        Element msgsv = JDomUtils.addChild((Element)cms, (String)"SECURITIES_MSGSRQV1");
        Element QUERYDRAWFINDTLTRNRQ = JDomUtils.addChild((Element)msgsv, (String)"QUERYDRAWFINDTLTRNRQ");
        JDomUtils.addChild((Element)QUERYDRAWFINDTLTRNRQ, (String)"TRNUID", (String)TRNUID);
        String pageNo = pageTag.substring(0, pageTag.indexOf("_"));
        Element body = JDomUtils.addChildAttribute((Element)QUERYDRAWFINDTLTRNRQ, (String)"RQBODY", (String)"PAGE", (String)pageNo);
        JDomUtils.addChild((Element)body, (String)"VERSION", (String)"2.0");
        JDomUtils.addChild((Element)body, (String)"OPERATEFLAG", (String)"1");
        JDomUtils.addChild((Element)body, (String)"APPLYCODE", (String)info.getRqstserialno());
        JDomUtils.addChild((Element)body, (String)"SRVRID", (String)info.getRspserialno());
        String encoding = RequestContextUtils.getCharset();
        String str = JDomUtils.root2String((Element)cms, (String)encoding);
        return str;
    }

    public List<NotePayableInfo> parse(BankNotePayableRequest request, String responseStr) {
        List notePayableInfos = request.getNotePayableInfoList();
        NotePayableInfo notePayableInfo = (NotePayableInfo)notePayableInfos.get(0);
        if (StringUtils.isEmpty((String)notePayableInfo.getRqstserialno())) {
            Element root = CIB_DC_Parser.parseString2Root(responseStr);
            Element SECURITIES_MSGSRSV1 = root.getChild("SECURITIES_MSGSRSV1");
            Element EBSIGNQUERYTRNRS = SECURITIES_MSGSRSV1.getChild("QUERYDRAWFINLISTTRNRS");
            Element STATUS = EBSIGNQUERYTRNRS.getChild("STATUS");
            String code = JDomUtils.getChildText((Element)STATUS, (String)"CODE");
            String MESSAGE = JDomUtils.getChildText((Element)STATUS, (String)"MESSAGE");
            if (!"0".equals(code)) {
                if (!StringUtils.isEmpty((String)MESSAGE) && MESSAGE.contains(ResManager.loadKDString((String)"\u67e5\u8be2\u65e0\u6570\u636e", (String)"QueryConfirmNotePayableImpl_0", (String)"ebg-note-banks-cib-dc", (Object[])new Object[0]))) {
                    this.logger.info("\u672a\u67e5\u8be2\u5230\u6570\u636e\uff1a" + MESSAGE);
                    return notePayableInfos;
                }
                throw EBExceiptionUtil.serviceException((String)MESSAGE);
            }
            Element RSBODY = EBSIGNQUERYTRNRS.getChild("RSBODY");
            if (RSBODY == null) {
                return notePayableInfos;
            }
            String srvrID = notePayableInfo.getObssid();
            this.logger.info("\u7f51\u94f6\u8ddf\u8e2a\u53f7\uff1a" + srvrID);
            List contentList = RSBODY.getChildren("CONTENT");
            for (int i = 0; i < contentList.size(); ++i) {
                Element rs = (Element)contentList.get(i);
                String applyCode = rs.getChildText("APPLYCODE");
                if (!rs.getChildText("SRVRID").equals(srvrID)) continue;
                this.logger.info("\u5339\u914d\u6210\u529f");
                notePayableInfo.setRspserialno(srvrID);
                notePayableInfo.setRqstserialno(applyCode);
                EBGNotePayableUtils.setPaymentState((NotePayableInfo)notePayableInfo, (PaymentState)PaymentState.SUBMITED, (String)"ok", (String)ResManager.loadKDString((String)"\u878d\u8d44\u5217\u8868\u67e5\u8be2\u6210\u529f\uff0c\u5c06\u8fdb\u884c\u8be6\u60c5\u67e5\u8be2\u3002", (String)"QueryConfirmNotePayableImpl_1", (String)"ebg-note-banks-cib-dc", (Object[])new Object[0]));
                break;
            }
        } else {
            Element root = CIB_DC_Parser.parseString2Root(responseStr);
            Element SECURITIES_MSGSRSV1 = root.getChild("SECURITIES_MSGSRSV1");
            Element EBSIGNQUERYTRNRS = SECURITIES_MSGSRSV1.getChild("QUERYDRAWFINDTLTRNRS");
            Element STATUS = EBSIGNQUERYTRNRS.getChild("STATUS");
            String code = JDomUtils.getChildText((Element)STATUS, (String)"CODE");
            String MESSAGE = JDomUtils.getChildText((Element)STATUS, (String)"MESSAGE");
            if (!"0".equals(code)) {
                throw EBExceiptionUtil.serviceException((String)MESSAGE);
            }
            Element RSBODY = EBSIGNQUERYTRNRS.getChild("RSBODY");
            String applyStatus = JDomUtils.getChildText((Element)RSBODY, (String)"APPLYSTATUS");
            String returnReason = JDomUtils.getChildText((Element)RSBODY, (String)"RETURNREASON");
            String applyStatusName = JDomUtils.getChildText((Element)RSBODY, (String)"APPLYSTATUSNAME");
            List contentList = RSBODY.getChildren("CONTENT");
            this.logger.info("******contentList\u5927\u5c0f\uff1a" + contentList.size());
            HashMap<String, NotePayableInfo> notePayableInfoMap = new HashMap<String, NotePayableInfo>(10);
            notePayableInfoMap.put(notePayableInfo.getBankSerialNo(), notePayableInfo);
            this.logger.info("\u4e3b\u952e\u503c\uff1a" + notePayableInfo.getBankSerialNo());
            for (Element content : contentList) {
                String billCode = content.getChildText("BILLCODE");
                String billStatus = content.getChildText("BILLSTATUS");
                String indx = content.getChildText("INDEX");
                this.logger.info("******\u5728\u7ebf\u878d\u8d44\u51fa\u7968\u540c\u6b65-\u878d\u8d44\u7533\u8bf7\u8be6\u60c5\u67e5\u8be2:\u5e8f\u53f7\uff1a" + indx);
                NotePayableInfo info = (NotePayableInfo)notePayableInfoMap.get(indx);
                if (info == null) continue;
                info.setBillNo(billCode);
                this.logger.info("******\u5728\u7ebf\u878d\u8d44\u51fa\u7968\u540c\u6b65-\u878d\u8d44\u7533\u8bf7\u8be6\u60c5\u67e5\u8be2:\u7968\u636e\u53f7\uff1a" + billCode + ",\u72b6\u6001\uff1a" + billStatus);
                PaymentState noteState = null;
                if ("YT".equals(applyStatus) || "YF".equals(applyStatus)) {
                    noteState = PaymentState.SUBMITED;
                }
                if ("TH".equals(applyStatus)) {
                    noteState = PaymentState.UNKNOWN;
                }
                info.setNoteStatus(billStatus);
                if ("000002".equals(billStatus)) {
                    EBGNotePayableUtils.setPaymentState((NotePayableInfo)info, (PaymentState)PaymentState.SUCCESS, (String)billStatus, (String)ResManager.loadKDString((String)"\u7968\u636e\u5df2\u4f5c\u5e9f", (String)"QueryConfirmNotePayableImpl_2", (String)"ebg-note-banks-cib-dc", (Object[])new Object[0]));
                } else if ("010004".equals(billStatus)) {
                    EBGNotePayableUtils.setPaymentState((NotePayableInfo)info, (PaymentState)PaymentState.SUCCESS, (String)billStatus, (String)ResManager.loadKDString((String)"\u51fa\u7968\u5df2\u767b\u8bb0", (String)"QueryConfirmNotePayableImpl_3", (String)"ebg-note-banks-cib-dc", (Object[])new Object[0]));
                } else if ("020001".equals(billStatus)) {
                    EBGNotePayableUtils.setPaymentState((NotePayableInfo)info, (PaymentState)PaymentState.SUBMITED, (String)billStatus, (String)ResManager.loadKDString((String)"\u63d0\u793a\u627f\u5151\u5f85\u7b7e\u6536", (String)"QueryConfirmNotePayableImpl_4", (String)"ebg-note-banks-cib-dc", (Object[])new Object[0]));
                } else if ("020006".equals(billStatus)) {
                    EBGNotePayableUtils.setPaymentState((NotePayableInfo)info, (PaymentState)PaymentState.SUCCESS, (String)billStatus, (String)ResManager.loadKDString((String)"\u63d0\u793a\u627f\u5151\u5df2\u7b7e\u6536", (String)"QueryConfirmNotePayableImpl_5", (String)"ebg-note-banks-cib-dc", (Object[])new Object[0]));
                } else if ("030001".equals(billStatus)) {
                    EBGNotePayableUtils.setPaymentState((NotePayableInfo)info, (PaymentState)PaymentState.SUBMITED, (String)billStatus, (String)ResManager.loadKDString((String)"\u63d0\u793a\u6536\u7968\u5f85\u7b7e\u6536", (String)"QueryConfirmNotePayableImpl_6", (String)"ebg-note-banks-cib-dc", (Object[])new Object[0]));
                } else if ("030006".equals(billStatus)) {
                    EBGNotePayableUtils.setPaymentState((NotePayableInfo)info, (PaymentState)PaymentState.SUCCESS, (String)billStatus, (String)ResManager.loadKDString((String)"\u63d0\u793a\u6536\u7968\u5df2\u7b7e\u6536", (String)"QueryConfirmNotePayableImpl_7", (String)"ebg-note-banks-cib-dc", (Object[])new Object[0]));
                } else if ("100001".equals(billStatus)) {
                    EBGNotePayableUtils.setPaymentState((NotePayableInfo)info, (PaymentState)PaymentState.SUBMITED, (String)billStatus, (String)ResManager.loadKDString((String)"\u80cc\u4e66\u5f85\u7b7e\u6536", (String)"QueryConfirmNotePayableImpl_8", (String)"ebg-note-banks-cib-dc", (Object[])new Object[0]));
                } else if ("100006".equals(billStatus)) {
                    EBGNotePayableUtils.setPaymentState((NotePayableInfo)info, (PaymentState)PaymentState.SUCCESS, (String)billStatus, (String)ResManager.loadKDString((String)"\u80cc\u4e66\u5df2\u7b7e\u6536", (String)"QueryConfirmNotePayableImpl_9", (String)"ebg-note-banks-cib-dc", (Object[])new Object[0]));
                } else {
                    EBGNotePayableUtils.setPaymentState((NotePayableInfo)info, (PaymentState)PaymentState.SUBMITED, (String)billStatus, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4e2d", (String)"QueryConfirmNotePayableImpl_10", (String)"ebg-note-banks-cib-dc", (Object[])new Object[0]));
                }
                StringBuilder sb = new StringBuilder(info.getBankMsg());
                if (noteState == null) continue;
                info.setStatus(Integer.valueOf(noteState.getId()));
                sb.append(StringUtils.isEmpty((String)applyStatusName) ? "" : "," + applyStatusName);
                sb.append(StringUtils.isEmpty((String)returnReason) ? "" : "," + returnReason);
                info.setBankMsg(sb.toString());
            }
        }
        return notePayableInfos;
    }

    public int getBatchSize() {
        return 1;
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return null;
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u51fa\u7968\u7ed3\u679c\u540c\u6b65", (String)"QueryConfirmNotePayableImpl_11", (String)"ebg-note-banks-cib-dc", (Object[])new Object[0]);
    }

    public boolean match(NotePayableInfo notePayableInfo) {
        return false;
    }

    public boolean isNeedPage() {
        return true;
    }

    public String getFirstPageTag() {
        return "1_Y";
    }

    public String getNextPageTag(String rspStr, String pageTag) {
        Element status;
        String iRetCode;
        int currentPage = Integer.parseInt(pageTag.substring(0, pageTag.indexOf("_"))) + 1;
        Element root = CIB_DC_Parser.parseString2Root(rspStr);
        Element eb1 = root.getChild("SECURITIES_MSGSRSV1");
        Element eb = eb1.getChild("QUERYDRAWFINLISTTRNRS");
        if (eb == null) {
            eb = eb1.getChild("QUERYDRAWFINDTLTRNRS");
        }
        if ("6421".equals(iRetCode = (status = eb.getChild("STATUS")).getChildTextTrim("CODE"))) {
            return currentPage + "_N";
        }
        Element stmtrs = eb.getChild("RSBODY");
        String more = stmtrs.getAttributeValue("MORE");
        if ("Y".equals(more)) {
            return currentPage + "_Y";
        }
        return currentPage + "_N";
    }

    public boolean isLastPage(String rspStr, String pageTag) {
        int underlineIndex = pageTag.indexOf("_");
        return "N".equals(pageTag.substring(underlineIndex + 1));
    }
}

