/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.cib.dc.services.note.receivable.cancel;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.frame.Sequence;
import kd.ebg.egf.common.utils.datetime.DateTimeUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.note.banks.cib.dc.services.CommonPacker;
import kd.ebg.note.banks.cib.dc.services.note.receivable.cancel.QueryCancleNoteReceivableImpl;
import kd.ebg.note.banks.cib.dc.services.util.CIB_DC_Packer;
import kd.ebg.note.banks.cib.dc.services.util.CIB_DC_Parser;
import kd.ebg.note.business.noteReceivable.atomic.AbstractNoteReceivableImpl;
import kd.ebg.note.business.noteReceivable.atomic.IQueryNoteReceivable;
import kd.ebg.note.business.noteReceivable.bank.BankNoteReceivableRequest;
import kd.ebg.note.business.noteReceivable.util.EBGNoteReceivableUtils;
import kd.ebg.note.common.entity.biz.status.PaymentState;
import kd.ebg.note.common.model.NoteReceivableInfo;
import org.jdom2.Element;

public class CancleNoteReceivableImpl
extends AbstractNoteReceivableImpl {
    public int getBatchSize() {
        return 10;
    }

    public Class<? extends IQueryNoteReceivable> defaultQueryClass() {
        return QueryCancleNoteReceivableImpl.class;
    }

    public String pack(BankNoteReceivableRequest request, String pageTag) {
        List noteReceivableInfos = request.getNoteReceivableInfos();
        NoteReceivableInfo info = (NoteReceivableInfo)noteReceivableInfos.get(0);
        String TRNUID = DateTimeUtils.format((Date)new Date(), (String)"yyyyMMdd") + Sequence.gen16Sequence();
        Element cms = CIB_DC_Packer.buildHeadMessage();
        Element msgsv = JDomUtils.addChild((Element)cms, (String)"SECURITIES_MSGSRQV1");
        Element EBRECEDETRNRQ = JDomUtils.addChild((Element)msgsv, (String)"EBRECEDETRNRQ");
        JDomUtils.addChild((Element)EBRECEDETRNRQ, (String)"TRNUID", (String)TRNUID);
        Element EBRECEDETRNRQ_RQBODY = JDomUtils.addChild((Element)EBRECEDETRNRQ, (String)"RQBODY");
        JDomUtils.addChild((Element)EBRECEDETRNRQ_RQBODY, (String)"TOTALCOUNT");
        JDomUtils.addChild((Element)EBRECEDETRNRQ_RQBODY, (String)"TOTALAMT");
        JDomUtils.addChild((Element)EBRECEDETRNRQ_RQBODY, (String)"ACCTID", (String)info.getDrawerAccNo());
        int count = 0;
        BigDecimal totalAmt = BigDecimal.ZERO;
        Map<String, String> map = null;
        for (NoteReceivableInfo noteReceivableInfo : noteReceivableInfos) {
            try {
                map = CommonPacker.getSeqInfo(noteReceivableInfo);
            }
            catch (Exception e) {
                throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u5728\u67e5\u8be2\u53ef\u64cd\u4f5c\u6570\u636e\u65f6\u53d1\u751f\u5f02\u5e38\uff1a", (String)"CancleNoteReceivableImpl_0", (String)"ebg-note-banks-cib-dc", (Object[])new Object[0]), (Throwable)e);
            }
            String operationCode = noteReceivableInfo.getOperationCode();
            String BUSINESSTYPE = "";
            if ("02".equals(operationCode)) {
                BUSINESSTYPE = "22";
            } else if ("03".equals(operationCode)) {
                BUSINESSTYPE = "23";
            } else if ("10".equals(operationCode)) {
                BUSINESSTYPE = "24";
            } else if ("18".equals(operationCode)) {
                BUSINESSTYPE = "33";
            } else if ("19".equals(operationCode)) {
                BUSINESSTYPE = "34";
            } else if ("20".equals(operationCode)) {
                BUSINESSTYPE = "35";
            } else if ("25".equals(operationCode)) {
                BUSINESSTYPE = "36";
            } else if ("11".equals(operationCode)) {
                BUSINESSTYPE = "25";
            } else {
                throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u7684\u64a4\u9500\u7c7b\u578b\uff1a%s\u3002", (String)"CancleNoteReceivableImpl_4", (String)"ebg-note-banks-cib-dc", (Object[])new Object[0]), operationCode));
            }
            noteReceivableInfo.setRqstserialno(TRNUID);
            Element CONTENT = JDomUtils.addChild((Element)EBRECEDETRNRQ_RQBODY, (String)"CONTENT");
            JDomUtils.addChild((Element)CONTENT, (String)"INDX", (String)(++count + ""));
            JDomUtils.addChild((Element)CONTENT, (String)"BILLCODE", (String)noteReceivableInfo.getBillNo());
            JDomUtils.addChild((Element)CONTENT, (String)"BILLAMT", (String)(noteReceivableInfo.getAmount() + ""));
            JDomUtils.addChild((Element)CONTENT, (String)"BUSINESSTYPE", (String)BUSINESSTYPE);
            JDomUtils.addChild((Element)CONTENT, (String)"BIZFLAG", (String)map.get("BIZFLAG"));
            JDomUtils.addChild((Element)CONTENT, (String)"SEQ", (String)map.get("SEQ"));
            JDomUtils.addChild((Element)CONTENT, (String)"APPDATE", (String)DateTimeUtils.format((Date)new Date(), (String)"yyyy-MM-dd"));
            totalAmt = totalAmt.add(noteReceivableInfo.getAmount());
        }
        JDomUtils.getChildElement((Element)EBRECEDETRNRQ_RQBODY, (String)"TOTALCOUNT").addContent(count + "");
        JDomUtils.getChildElement((Element)EBRECEDETRNRQ_RQBODY, (String)"TOTALAMT").addContent(totalAmt + "");
        String encoding = RequestContextUtils.getCharset();
        String str = JDomUtils.root2String((Element)cms, (String)encoding);
        return str;
    }

    public List<NoteReceivableInfo> parse(BankNoteReceivableRequest request, String responseStr) {
        List noteReceivableInfos = request.getNoteReceivableInfos();
        Element root = CIB_DC_Parser.parseString2Root(responseStr);
        Element eb1 = root.getChild("SECURITIES_MSGSRSV1");
        Element EBRECEDETRNRS = eb1.getChild("EBRECEDETRNRS");
        Element STATUS = EBRECEDETRNRS.getChild("STATUS");
        String code = JDomUtils.getChildText((Element)STATUS, (String)"CODE");
        String MESSAGE = JDomUtils.getChildText((Element)STATUS, (String)"MESSAGE");
        if (!"0".equals(code)) {
            EBGNoteReceivableUtils.setPaymentState((List)noteReceivableInfos, (PaymentState)PaymentState.FAIL, (String)code, (String)MESSAGE);
        } else {
            EBGNoteReceivableUtils.setPaymentState((List)noteReceivableInfos, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4e2d", (String)"CancleNoteReceivableImpl_2", (String)"ebg-note-banks-cib-dc", (Object[])new Object[0]), (String)MESSAGE);
        }
        return noteReceivableInfos;
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return null;
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u64a4\u9500", (String)"CancleNoteReceivableImpl_3", (String)"ebg-note-banks-cib-dc", (Object[])new Object[0]);
    }

    public boolean match(NoteReceivableInfo noteReceivableInfo) {
        return true;
    }

    public long getBankInterval() {
        return 0L;
    }
}

