/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.cib.dc.services.note.receivable.payment;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.framework.frame.Sequence;
import kd.ebg.egf.common.utils.datetime.DateTimeUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.note.banks.cib.dc.services.note.receivable.payment.QueryPaymentNoteReceivableImpl;
import kd.ebg.note.banks.cib.dc.services.util.CIB_DC_Packer;
import kd.ebg.note.banks.cib.dc.services.util.CIB_DC_Parser;
import kd.ebg.note.business.noteReceivable.atomic.AbstractNoteReceivableImpl;
import kd.ebg.note.business.noteReceivable.atomic.IQueryNoteReceivable;
import kd.ebg.note.business.noteReceivable.bank.BankNoteReceivableRequest;
import kd.ebg.note.business.noteReceivable.util.EBGNoteReceivableUtils;
import kd.ebg.note.common.entity.biz.status.PaymentState;
import kd.ebg.note.common.model.NoteReceivableInfo;
import org.jdom2.Element;

public class PaymentNoteReceivableImpl
extends AbstractNoteReceivableImpl {
    public int getBatchSize() {
        return 10;
    }

    public Class<? extends IQueryNoteReceivable> defaultQueryClass() {
        return QueryPaymentNoteReceivableImpl.class;
    }

    public String pack(BankNoteReceivableRequest request, String pageTag) {
        List receivableInfos = request.getNoteReceivableInfos();
        NoteReceivableInfo info = (NoteReceivableInfo)receivableInfos.get(0);
        String TRNUID = DateTimeUtils.format((Date)new Date(), (String)"yyyyMMdd") + Sequence.gen16Sequence();
        Element cms = CIB_DC_Packer.buildHeadMessage();
        Element msgsv = JDomUtils.addChild((Element)cms, (String)"SECURITIES_MSGSRQV1");
        Element EBCUEPAYTRNRQ = JDomUtils.addChild((Element)msgsv, (String)"EBCUEPAYTRNRQ");
        JDomUtils.addChild((Element)EBCUEPAYTRNRQ, (String)"TRNUID", (String)TRNUID);
        Element EBCUEPAYTRNRQ_RQBODY = JDomUtils.addChild((Element)EBCUEPAYTRNRQ, (String)"RQBODY");
        JDomUtils.addChild((Element)EBCUEPAYTRNRQ_RQBODY, (String)"TOTALCOUNT");
        JDomUtils.addChild((Element)EBCUEPAYTRNRQ_RQBODY, (String)"TOTALAMT");
        JDomUtils.addChild((Element)EBCUEPAYTRNRQ_RQBODY, (String)"APPDATE", (String)DateTimeUtils.format((Date)new Date(), (String)"yyyy-MM-dd"));
        JDomUtils.addChild((Element)EBCUEPAYTRNRQ_RQBODY, (String)"ACCTID", (String)info.getDrawerAccNo());
        JDomUtils.addChild((Element)EBCUEPAYTRNRQ_RQBODY, (String)"CUETYPE", (String)"01");
        JDomUtils.addChild((Element)EBCUEPAYTRNRQ_RQBODY, (String)"BILLTYPE", (String)info.getDraftType());
        if ("0".equals(info.getAutoAccept())) {
            JDomUtils.addChild((Element)EBCUEPAYTRNRQ_RQBODY, (String)"LQMODE", (String)"SM00");
        } else {
            JDomUtils.addChild((Element)EBCUEPAYTRNRQ_RQBODY, (String)"LQMODE", (String)"SM01");
        }
        JDomUtils.addChild((Element)EBCUEPAYTRNRQ_RQBODY, (String)"MEMO", (String)"");
        int count = 0;
        BigDecimal totalAmt = BigDecimal.ZERO;
        for (NoteReceivableInfo noteReceivableInfo : receivableInfos) {
            noteReceivableInfo.setRqstserialno(TRNUID);
            Element RQBODY_CONTENT = JDomUtils.addChild((Element)EBCUEPAYTRNRQ_RQBODY, (String)"CONTENT");
            JDomUtils.addChild((Element)RQBODY_CONTENT, (String)"INDX", (String)(++count + ""));
            JDomUtils.addChild((Element)RQBODY_CONTENT, (String)"BILLCODE", (String)noteReceivableInfo.getBillNo());
            JDomUtils.addChild((Element)RQBODY_CONTENT, (String)"BILLAMT", (String)(noteReceivableInfo.getAmount() + ""));
            JDomUtils.addChild((Element)RQBODY_CONTENT, (String)"CUEAMT", (String)(noteReceivableInfo.getAmount() + ""));
            JDomUtils.addChild((Element)RQBODY_CONTENT, (String)"AGENTFLAG", (String)"PP01");
            totalAmt = totalAmt.add(noteReceivableInfo.getAmount());
        }
        JDomUtils.getChildElement((Element)EBCUEPAYTRNRQ_RQBODY, (String)"TOTALCOUNT").addContent(count + "");
        JDomUtils.getChildElement((Element)EBCUEPAYTRNRQ_RQBODY, (String)"TOTALAMT").addContent(totalAmt + "");
        String encoding = RequestContextUtils.getCharset();
        String str = JDomUtils.root2String((Element)cms, (String)encoding);
        return str;
    }

    public List<NoteReceivableInfo> parse(BankNoteReceivableRequest request, String responseStr) {
        List receivableInfos = request.getNoteReceivableInfos();
        Element root = CIB_DC_Parser.parseString2Root(responseStr);
        Element eb1 = root.getChild("SECURITIES_MSGSRSV1");
        Element EBDISCNTTRNRS = eb1.getChild("EBCUEPAYTRNRS");
        Element STATUS = EBDISCNTTRNRS.getChild("STATUS");
        String code = JDomUtils.getChildText((Element)STATUS, (String)"CODE");
        String MESSAGE = JDomUtils.getChildText((Element)STATUS, (String)"MESSAGE");
        if (!"0".equals(code)) {
            EBGNoteReceivableUtils.setPaymentState((List)receivableInfos, (PaymentState)PaymentState.FAIL, (String)code, (String)MESSAGE);
        } else {
            EBGNoteReceivableUtils.setPaymentState((List)receivableInfos, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4e2d", (String)"PaymentNoteReceivableImpl_0", (String)"ebg-note-banks-cib-dc", (Object[])new Object[0]), (String)MESSAGE);
        }
        return receivableInfos;
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return null;
    }

    public String getBizDesc() {
        return null;
    }

    public boolean match(NoteReceivableInfo noteReceivableInfo) {
        return true;
    }

    public long getBankInterval() {
        return 0L;
    }
}

