/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.cib.dc.services.note.receivable.signin;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.frame.Sequence;
import kd.ebg.egf.common.utils.datetime.DateTimeUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.note.banks.cib.dc.services.note.receivable.signin.QuerySigninNoteReceivableImpl;
import kd.ebg.note.banks.cib.dc.services.util.CIB_DC_Packer;
import kd.ebg.note.banks.cib.dc.services.util.CIB_DC_Parser;
import kd.ebg.note.business.noteReceivable.atomic.AbstractNoteReceivableImpl;
import kd.ebg.note.business.noteReceivable.atomic.IQueryNoteReceivable;
import kd.ebg.note.business.noteReceivable.bank.BankNoteReceivableRequest;
import kd.ebg.note.business.noteReceivable.util.EBGNoteReceivableUtils;
import kd.ebg.note.common.entity.biz.status.PaymentState;
import kd.ebg.note.common.model.NoteReceivableInfo;
import org.jdom2.Element;

public class SigninNoteReceivableImpl
extends AbstractNoteReceivableImpl {
    public int getBatchSize() {
        return 10;
    }

    public Class<? extends IQueryNoteReceivable> defaultQueryClass() {
        return QuerySigninNoteReceivableImpl.class;
    }

    public String pack(BankNoteReceivableRequest request, String pageTag) {
        List receivableInfos = request.getNoteReceivableInfos();
        NoteReceivableInfo info = (NoteReceivableInfo)receivableInfos.get(0);
        String TRNUID = DateTimeUtils.format((Date)new Date(), (String)"yyyyMMdd") + Sequence.gen16Sequence();
        Element cms = CIB_DC_Packer.buildHeadMessage();
        Element msgsv = JDomUtils.addChild((Element)cms, (String)"SECURITIES_MSGSRQV1");
        Element EBRECEDETRNRQ = JDomUtils.addChild((Element)msgsv, (String)"EBSIGNTRNRQ");
        JDomUtils.addChild((Element)EBRECEDETRNRQ, (String)"TRNUID", (String)TRNUID);
        Element EBSIGNTRNRQ_RQBODY = JDomUtils.addChild((Element)EBRECEDETRNRQ, (String)"RQBODY");
        JDomUtils.addChild((Element)EBSIGNTRNRQ_RQBODY, (String)"TOTALCOUNT");
        JDomUtils.addChild((Element)EBSIGNTRNRQ_RQBODY, (String)"TOTALAMT");
        JDomUtils.addChild((Element)EBSIGNTRNRQ_RQBODY, (String)"SIGNDATE", (String)DateTimeUtils.format((Date)new Date(), (String)"yyyy-MM-dd"));
        JDomUtils.addChild((Element)EBSIGNTRNRQ_RQBODY, (String)"ACCTID", (String)info.getDrawerAccNo());
        JDomUtils.addChild((Element)EBSIGNTRNRQ_RQBODY, (String)"SIGNRSLT", (String)info.getOtherInfo());
        if (!"SU00".equals(info.getOtherInfo())) {
            JDomUtils.addChild((Element)EBSIGNTRNRQ_RQBODY, (String)"RJRSN", (String)info.getExplanation());
            JDomUtils.addChild((Element)EBSIGNTRNRQ_RQBODY, (String)"RJMEMO", (String)info.getExplanation());
        }
        int count = 0;
        BigDecimal totalAmt = BigDecimal.ZERO;
        for (NoteReceivableInfo noteReceivableInfo : receivableInfos) {
            String operationCode = noteReceivableInfo.getOperationCode();
            String BUSINESSTYPE = "";
            if ("02".equals(operationCode)) {
                BUSINESSTYPE = "03";
            } else if ("03".equals(operationCode)) {
                BUSINESSTYPE = "05";
            } else if ("10".equals(operationCode)) {
                BUSINESSTYPE = "07";
            } else if ("19".equals(operationCode)) {
                BUSINESSTYPE = "16";
            } else if ("20".equals(operationCode)) {
                BUSINESSTYPE = "17";
            } else if ("21".equals(operationCode)) {
                BUSINESSTYPE = "18";
            } else {
                throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u7684\u7b7e\u6536\u7c7b\u578b\uff1a%s", (String)"SigninNoteReceivableImpl_3", (String)"ebg-note-banks-cib-dc", (Object[])new Object[0]), operationCode));
            }
            noteReceivableInfo.setRqstserialno(TRNUID);
            Element RQBODY_CONTENT = JDomUtils.addChild((Element)EBSIGNTRNRQ_RQBODY, (String)"CONTENT");
            JDomUtils.addChild((Element)RQBODY_CONTENT, (String)"INDX", (String)(++count + ""));
            JDomUtils.addChild((Element)RQBODY_CONTENT, (String)"BILLCODE", (String)noteReceivableInfo.getBillNo());
            JDomUtils.addChild((Element)RQBODY_CONTENT, (String)"BILLAMT", (String)(noteReceivableInfo.getAmount() + ""));
            JDomUtils.addChild((Element)RQBODY_CONTENT, (String)"BUSINESSTYPE", (String)BUSINESSTYPE);
            JDomUtils.addChild((Element)RQBODY_CONTENT, (String)"ENTRSPAY", (String)"CC00");
            JDomUtils.addChild((Element)RQBODY_CONTENT, (String)"BIZFLAG", (String)noteReceivableInfo.getBankRefKey());
            totalAmt = totalAmt.add(noteReceivableInfo.getAmount());
        }
        JDomUtils.getChildElement((Element)EBSIGNTRNRQ_RQBODY, (String)"TOTALCOUNT").addContent(count + "");
        JDomUtils.getChildElement((Element)EBSIGNTRNRQ_RQBODY, (String)"TOTALAMT").addContent(totalAmt + "");
        String encoding = RequestContextUtils.getCharset();
        String str = JDomUtils.root2String((Element)cms, (String)encoding);
        return str;
    }

    public List<NoteReceivableInfo> parse(BankNoteReceivableRequest request, String responseStr) {
        List receivableInfos = request.getNoteReceivableInfos();
        Element root = CIB_DC_Parser.parseString2Root(responseStr);
        Element eb1 = root.getChild("SECURITIES_MSGSRSV1");
        Element EBRECEDETRNRS = eb1.getChild("EBSIGNTRNRS");
        Element STATUS = EBRECEDETRNRS.getChild("STATUS");
        String code = JDomUtils.getChildText((Element)STATUS, (String)"CODE");
        String MESSAGE = JDomUtils.getChildText((Element)STATUS, (String)"MESSAGE");
        Element RSBODY = EBRECEDETRNRS.getChild("RSBODY");
        Element XFERPRCSTS = RSBODY.getChild("XFERPRCSTS");
        String XFERPRCCODE = JDomUtils.getChildText((Element)XFERPRCSTS, (String)"XFERPRCCODE");
        String DTXFERPRC = JDomUtils.getChildText((Element)XFERPRCSTS, (String)"DTXFERPRC");
        String XFERPRCSTS_MESSAGE = JDomUtils.getChildText((Element)XFERPRCSTS, (String)"MESSAGE");
        if (!"0".equals(code)) {
            EBGNoteReceivableUtils.setPaymentState((List)receivableInfos, (PaymentState)PaymentState.FAIL, (String)code, (String)MESSAGE);
        }
        if ("WAIT_FOR_AUDIT".equals(XFERPRCCODE)) {
            EBGNoteReceivableUtils.setPaymentState((List)receivableInfos, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4e2d", (String)"SigninNoteReceivableImpl_1", (String)"ebg-note-banks-cib-dc", (Object[])new Object[0]), (String)XFERPRCSTS_MESSAGE);
        } else {
            EBGNoteReceivableUtils.setPaymentState((List)receivableInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u7ed3\u679c\u672a\u77e5", (String)"SigninNoteReceivableImpl_2", (String)"ebg-note-banks-cib-dc", (Object[])new Object[0]), (String)XFERPRCSTS_MESSAGE);
        }
        return receivableInfos;
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return null;
    }

    public String getBizDesc() {
        return null;
    }

    public boolean match(NoteReceivableInfo noteReceivableInfo) {
        return true;
    }

    public long getBankInterval() {
        return 0L;
    }
}

