/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.pab.dc.service.note.detail;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.note.banks.pab.dc.service.note.detail.endorseInfo.EndorseImpl;
import kd.ebg.note.banks.pab.dc.service.note.util.PackerUtil;
import kd.ebg.note.banks.pab.dc.service.note.util.ParserUtil;
import kd.ebg.note.business.noteDetail.atomic.AbstractNoteDetailImpl;
import kd.ebg.note.business.noteDetail.bank.BankNoteDetailRequest;
import kd.ebg.note.business.noteDetail.bank.BankNoteDetailRequestBody;
import kd.ebg.note.business.noteDetail.bank.EBBankDetailResponse;
import kd.ebg.note.common.entity.biz.notedetail.Detail;
import kd.ebg.note.common.entity.biz.notedetail.NoteDetailRequest;
import kd.ebg.note.common.entity.biz.notedetail.NoteSidesInfo;

public class NoteHoldImpl
extends AbstractNoteDetailImpl {
    private final EBGLogger logger = EBGLogger.getInstance().getLogger(NoteHoldImpl.class);
    private static boolean isLastPage = false;

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "P70108";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u7968\u636e\u4fe1\u606f\u67e5\u8be2", (String)"NoteDetailImpl_0", (String)"ebg-note-banks-pab-dc", (Object[])new Object[0]);
    }

    public boolean match(NoteDetailRequest noteDetailRequest) {
        return true;
    }

    public long getBankInterval() {
        return 0L;
    }

    public boolean isNeedPage() {
        return true;
    }

    public EBBankDetailResponse doBiz(BankNoteDetailRequest request) {
        int pageNo = request.getBody().getPageNum();
        EBBankDetailResponse response = super.doBiz(request);
        if (isLastPage) {
            response.setKeepFlag("1");
        } else {
            response.setKeepFlag("0");
        }
        return response;
    }

    public String pack(BankNoteDetailRequest request, String pageTag) {
        pageTag = request.getBody().getPageNum() + "";
        if ("info".equals(request.getHeader().getSubBizType())) {
            pageTag = "1";
        }
        BankAcnt ancAcnt = request.getAcnt();
        BankNoteDetailRequestBody body = request.getBody();
        JSONObject root = new JSONObject();
        JSONObject pageInfo = new JSONObject();
        pageInfo.put("pageNo", (Object)pageTag);
        pageInfo.put("pageSize", (Object)"100");
        root.put("pageInfo", (Object)pageInfo);
        JSONObject requestDto = new JSONObject();
        requestDto.put("applAcctNo", (Object)ancAcnt.getAccNo());
        requestDto.put("applyQueryType", (Object)"1");
        requestDto.put("dataSource", (Object)"1");
        if ("info".equals(request.getHeader().getSubBizType())) {
            requestDto.put("billNo", (Object)body.getNoteNo());
            String subRange = request.getBody().getSubRange();
            if ("0".equals(subRange)) {
                requestDto.put("maxBillRangeStart", (Object)"0");
                requestDto.put("minBillRangeStart", (Object)"0");
                requestDto.put("maxBillRangeEnd", (Object)"0");
                requestDto.put("minBillRangeEnd", (Object)"0");
            } else if (!StringUtils.isEmpty((String)subRange)) {
                requestDto.put("maxBillRangeStart", (Object)request.getBody().getStartNo());
                requestDto.put("minBillRangeStart", (Object)request.getBody().getStartNo());
                requestDto.put("maxBillRangeEnd", (Object)request.getBody().getEndNo());
                requestDto.put("minBillRangeEnd", (Object)request.getBody().getEndNo());
            }
        }
        root.put("requestDto", (Object)requestDto);
        return PackerUtil.getPackerResult((String)root.toJSONString(), (String)this.getBizCode());
    }

    public List<Detail> parse(BankNoteDetailRequest request, String rspStr) {
        JSONObject root = ParserUtil.getJsonRoot((String)rspStr);
        ArrayList<Detail> result = new ArrayList<Detail>(16);
        JSONObject retData = root.getJSONObject("retData");
        JSONObject pageInfo = retData.getJSONObject("pageInfo");
        int pageCount = pageInfo.getIntValue("pageCount");
        int pre = request.getBody().getPageNum();
        isLastPage = pre <= pageCount;
        JSONArray list = retData.getJSONArray("list");
        if (list == null) {
            return result;
        }
        for (int i = 0; i < list.size(); ++i) {
            Detail detailInfo = new Detail();
            JSONObject object = (JSONObject)list.get(i);
            String billId = object.getString("billId");
            detailInfo.setBankRefKey(billId);
            String billNo = object.getString("billNo");
            detailInfo.setNoteNo(billNo);
            String billRangeStart = object.getString("billRangeStart");
            detailInfo.setStartNo(billRangeStart);
            String billRangeEnd = object.getString("billRangeEnd");
            detailInfo.setEndNo(billRangeEnd);
            detailInfo.setSubRange(billRangeStart + "-" + billRangeEnd);
            String remitDt = object.getString("remitDt");
            detailInfo.setIssueDate(remitDt);
            String dueDt = object.getString("dueDt");
            detailInfo.setDueDate(dueDt);
            String drwrName = object.getString("drwrName");
            detailInfo.setDrawerAccName(drwrName);
            String drwrAcctNo = object.getString("drwrAcctNo");
            detailInfo.setDrawerAccNo(drwrAcctNo);
            String drwrBankNo = object.getString("drwrBankNo");
            String drwrBankName = object.getString("drwrBankName");
            detailInfo.setDrawerBankName(drwrBankName);
            detailInfo.setDrawerCnapsCode(drwrBankNo);
            String pyeeName = object.getString("pyeeName");
            detailInfo.setPayeeAccName(pyeeName);
            String pyeeAcctNo = object.getString("pyeeAcctNo");
            detailInfo.setPayeeAccNo(pyeeAcctNo);
            String pyeeBankName = object.getString("pyeeBankName");
            detailInfo.setPayeeBankName(pyeeBankName);
            String pyeeBankNo = object.getString("pyeeBankNo");
            detailInfo.setPayeeCnapsCode(pyeeBankNo);
            String acptAcctNo = object.getString("acptAcctNo");
            String acptName = object.getString("acptName");
            detailInfo.setAcceptorAccName(acptName);
            detailInfo.setAcceptorAccNo(acptAcctNo);
            String acptBankName = object.getString("acptBankName");
            detailInfo.setAcceptorBankName(acptBankName);
            String acptBankNo = object.getString("acptBankNo");
            detailInfo.setAcceptorCnapsCode(acptBankNo);
            String billMoney = object.getString("billMoney");
            detailInfo.setAmount(billMoney);
            String rmrk = object.getString("rmrk");
            String billType = object.getString("billType");
            detailInfo.setDraftType(billType);
            detailInfo.setExplain(rmrk);
            String cirStatus = object.getString("cirStatus");
            detailInfo.setCirStatus(cirStatus);
            String billStatus = object.getString("billStatus");
            detailInfo.setNoteStatus(billStatus);
            if ("CS06".equals(billStatus) || "CS05".equals(billStatus)) continue;
            String transId = object.getString("transId");
            String hldrId = object.getString("hldrId");
            String msgId = object.getString("msgId");
            detailInfo.setBankRefKey(billId + "_" + transId + "_" + hldrId + "_" + msgId);
            detailInfo.setCurrency("RMB");
            String isAllowSplitBill = object.getString("isAllowSplitBill");
            detailInfo.setGrdBag(isAllowSplitBill);
            BankNoteDetailRequestBody body = request.getBody();
            detailInfo.setBusinessCode(body.getTranType());
            detailInfo.setIsNewECDS("0");
            result.add(detailInfo);
            try {
                if (!body.getTranType().equals("10")) continue;
                body.setStartNo(billRangeStart);
                body.setEndNo(billRangeEnd);
                EndorseImpl impl = new EndorseImpl();
                EBBankDetailResponse response = impl.doBiz(request);
                List details = response.getDetails();
                Detail detail = (Detail)details.get(0);
                List listSide = detail.getNoteSidesInfo();
                for (int j = 0; j < listSide.size(); ++j) {
                    ((NoteSidesInfo)listSide.get(j)).setResv1(j + 1 + "");
                }
                detailInfo.setNoteSidesInfo(listSide);
                continue;
            }
            catch (Exception e) {
                detailInfo.setIsNoteSidesError("Y");
            }
        }
        return result;
    }
}

