/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.ccb.ccip.service.news.payable.receive;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.frame.Sequence;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.note.banks.ccb.ccip.service.news.LoginUtils;
import kd.ebg.note.banks.ccb.ccip.service.note.util.CCBHCBankResponse;
import kd.ebg.note.banks.ccb.ccip.service.note.util.CommonPacker;
import kd.ebg.note.banks.ccb.ccip.service.note.util.CommonParser;
import kd.ebg.note.banks.ccb.ccip.service.note.util.JDomExtUtils;
import kd.ebg.note.banks.ccb.ccip.service.note.util.PackerUtil;
import kd.ebg.note.business.notePayable.atomic.AbstractQueryNotePayableImpl;
import kd.ebg.note.business.notePayable.bank.BankNotePayableRequest;
import kd.ebg.note.business.notePayable.util.EBGNotePayableUtils;
import kd.ebg.note.common.entity.biz.status.PaymentState;
import kd.ebg.note.common.model.NotePayableInfo;
import org.jdom2.Content;
import org.jdom2.Element;

public class QueryReceiveImpl
extends AbstractQueryNotePayableImpl {
    private final EBGLogger logger = EBGLogger.getInstance().getLogger(QueryReceiveImpl.class);

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return null;
    }

    public String getBizDesc() {
        return null;
    }

    public boolean match(NotePayableInfo notePayableInfo) {
        return false;
    }

    public String pack(BankNotePayableRequest bankNotePayableRequest, String s) {
        LoginUtils.login();
        NotePayableInfo[] notePayableInfos = bankNotePayableRequest.getNotePayableInfosAsArray();
        Element root = new Element("Transaction");
        Element body = JDomExtUtils.addChild((Element)root, (String)"Transaction_Body");
        Element headr = CommonPacker.packCommonHeader((String)"P1CPEQ510", (String)Sequence.genSequence(), (String)"", (String)s);
        Element common = PackerUtil.packComEntity((String)Sequence.genSequence(), (String)"", (String)"0", (String)"200");
        JDomUtils.addChild((Element)body, (Element)common);
        root.addContent((Content)headr);
        JDomExtUtils.addChildCDData((Element)common, (String)"ExgBill_Plc_Bl_CtCd", (String)notePayableInfos[0].getDraftType());
        JDomExtUtils.addChildCDData((Element)common, (String)"Enqr_StDt", (String)LocalDateUtil.formatDate((LocalDateTime)notePayableInfos[0].getInsertTime()));
        JDomExtUtils.addChildCDData((Element)common, (String)"QRY_END_DT", (String)LocalDateUtil.formatDate((LocalDateTime)notePayableInfos[0].getInsertTime()));
        JDomExtUtils.addChildCDData((Element)common, (String)"Btch_No", (String)notePayableInfos[0].getObssid());
        return JDomExtUtils.root2String((Element)root, (String)RequestContextUtils.getCharset());
    }

    public List<NotePayableInfo> parse(BankNotePayableRequest bankNotePayableRequest, String rspStr) {
        List notePayableInfos = bankNotePayableRequest.getNotePayableInfoList();
        CCBHCBankResponse rsp = CommonParser.getFrontResponse((String)rspStr);
        if (!rsp.isSuccess()) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u91d1\u8776\u524d\u7f6e\u673a\u8fd4\u56de\u5f02\u5e38\u3002%1$s %2$s\u3002", (String)"QueryReceiveImpl_0", (String)"ebg-note-banks-ccb-ccip", (Object[])new Object[0]), rsp.getResponseCode(), rsp.getResponseMessage()));
        }
        rspStr = rsp.getBankMsg();
        CCBHCBankResponse bankResp = CommonParser.getBankPreResponse((String)rspStr);
        if (!bankResp.isSuccess()) {
            EBGNotePayableUtils.setPaymentState((List)notePayableInfos, (PaymentState)PaymentState.UNKNOWN, (String)bankResp.getResponseCode(), (String)bankResp.getResponseMessage());
        } else {
            Element root = JDomExtUtils.string2Root((String)rspStr, (String)RequestContextUtils.getCharset());
            Element body = JDomExtUtils.getChildElement((Element)root, (String)"Transaction_Body");
            Element response = JDomExtUtils.getChildElement((Element)body, (String)"response");
            List lists = response.getChildren("BkPjxx_GRP");
            if (lists.size() == 0) {
                this.logger.info("\u8fd4\u56de\u7684\u8282\u70b9\u957f\u5ea6\u4e3a0");
            }
            ArrayList<String> noteIds = new ArrayList<String>(1);
            for (int i = 0; i < notePayableInfos.size(); ++i) {
                NotePayableInfo info = (NotePayableInfo)notePayableInfos.get(i);
                for (Element list : lists) {
                    String BkListNo1 = JDomUtils.getChildTextTrim((Element)list, (String)"Bill_No");
                    String startNo = JDomUtils.getChildTextTrim((Element)list, (String)"SbBll_Rng_Strt_SN");
                    String endNo = JDomUtils.getChildTextTrim((Element)list, (String)"SbBll_Rng_End_SN");
                    String SignToAcpt_Psn_AccNo = JDomUtils.getChildTextTrim((Element)list, (String)"SignToAcpt_Psn_AccNo");
                    String seqNum = BkListNo1 + "_" + startNo + "_" + endNo + "_" + SignToAcpt_Psn_AccNo;
                    if (noteIds.size() > 0 && noteIds.contains(seqNum) || !BkListNo1.equals(info.getBillNo())) continue;
                    noteIds.add(seqNum);
                    String BkFlag2 = JDomUtils.getChildTextTrim((Element)list, (String)"TRN_ST_CD");
                    String BkFlag1 = JDomUtils.getChildTextTrim((Element)list, (String)"EBill_Bl_StCd");
                    String BkSumry = JDomUtils.getChildTextTrim((Element)list, (String)"EBill_Bl_Crcl_IndCd");
                    this.logger.info("\u7968\u53f7\uff1a" + info.getBillNo() + "----BkFlag2:" + BkFlag2 + "----BkFlag1:" + BkFlag1);
                    String bankRefDate = JDomUtils.getChildTextTrim((Element)list, (String)"Pltfrm_Dt");
                    String bankRefKey = JDomUtils.getChildTextTrim((Element)list, (String)"TxnSrlNo");
                    info.setBankRefKey(bankRefKey);
                    info.setBankRefDate(bankRefDate);
                    info.setCirStatus(BkSumry);
                    info.setNoteStatus(BkFlag1);
                    if (BkFlag2.equals("14")) {
                        EBGNotePayableUtils.setPaymentState((NotePayableInfo)info, (PaymentState)PaymentState.SUCCESS, (String)BkListNo1, (String)ResManager.loadKDString((String)"\u7b7e\u6536\u6210\u529f", (String)"QueryReceiveImpl_1", (String)"ebg-note-banks-ccb-ccip", (Object[])new Object[0]));
                        continue;
                    }
                    if (BkFlag2.equals("04")) {
                        EBGNotePayableUtils.setPaymentState((NotePayableInfo)info, (PaymentState)PaymentState.SUBMITED, (String)BkListNo1, (String)String.format(ResManager.loadKDString((String)"%1$s\u5f85\u7b7e\u6536", (String)"QueryReceiveImpl_2", (String)"ebg-note-banks-ccb-ccip", (Object[])new Object[0]), BkSumry));
                        continue;
                    }
                    if (BkFlag2.equals("20") || BkFlag2.equals("21") || BkFlag2.equals("22") || BkFlag2.equals("23") || BkFlag2.equals("24") || BkFlag2.equals("25")) {
                        EBGNotePayableUtils.setPaymentState((NotePayableInfo)info, (PaymentState)PaymentState.FAIL, (String)BkListNo1, (String)BkSumry);
                        info.setNoteStatus(BkFlag1);
                        continue;
                    }
                    if (BkFlag2.equals("15")) {
                        EBGNotePayableUtils.setPaymentState((NotePayableInfo)info, (PaymentState)PaymentState.FAIL, (String)BkListNo1, (String)ResManager.loadKDString((String)"\u7b7e\u6536\u65b9\u9a73\u56de", (String)"QueryReceiveImpl_3", (String)"ebg-note-banks-ccb-ccip", (Object[])new Object[0]));
                        continue;
                    }
                    if (BkFlag2.equals("02") || BkFlag2.equals("01") || BkFlag2.equals("00") || BkFlag2.equals("10")) {
                        EBGNotePayableUtils.setPaymentState((NotePayableInfo)info, (PaymentState)PaymentState.SUBMITED, (String)BkListNo1, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5df2\u63a5\u6536", (String)"QueryReceiveImpl_4", (String)"ebg-note-banks-ccb-ccip", (Object[])new Object[0]));
                        continue;
                    }
                    EBGNotePayableUtils.setPaymentState((NotePayableInfo)info, (PaymentState)PaymentState.UNKNOWN, (String)BkListNo1, (String)String.format(ResManager.loadKDString((String)"\u63d0\u793a\u6536\u7968\u72b6\u6001\u672a\u77e5%s\u3002", (String)"QueryReceiveImpl_5", (String)"ebg-note-banks-ccb-ccip", (Object[])new Object[0]), BkSumry));
                }
            }
        }
        return notePayableInfos;
    }

    public int getBatchSize() {
        return 0;
    }

    public boolean isNeedPage() {
        return true;
    }

    public String getFirstPageTag() {
        return "1";
    }

    public String getNextPageTag(String rspStr, String pageTag) {
        Integer page;
        Integer n = page = Integer.valueOf(Integer.parseInt(pageTag));
        Integer n2 = page = Integer.valueOf(page + 1);
        return page + "";
    }

    public boolean isLastPage(String rspStr, String pageTag) {
        CCBHCBankResponse rsp = CommonParser.getFrontResponse((String)rspStr);
        if (!rsp.isSuccess()) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u91d1\u8776\u524d\u7f6e\u673a\u8fd4\u56de\u5f02\u5e38\uff0c%1$s %2$s\u3002", (String)"AcceptImpl_2", (String)"ebg-note-banks-ccb-ccip", (Object[])new Object[0]), rsp.getResponseCode(), rsp.getResponseMessage()));
        }
        rspStr = rsp.getBankMsg();
        CCBHCBankResponse bankResp = CommonParser.getBankPreResponse((String)rspStr);
        if (!bankResp.isSuccess()) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u5931\u8d25\u3002%1$s %2$s\u3002", (String)"DetailImpl_1", (String)"ebg-note-banks-ccb-ccip", (Object[])new Object[0]), bankResp.getResponseCode(), bankResp.getResponseMessage()));
        }
        Element root = JDomExtUtils.string2Root((String)rspStr, (String)RequestContextUtils.getCharset());
        Element response = JDomExtUtils.getChildElement((Element)root, (String)"Transaction_Header");
        String TOTAL_PAGE = response.getChildTextTrim("TOTAL_PAGE");
        int total_page = Integer.parseInt(TOTAL_PAGE);
        int page = Integer.parseInt(pageTag);
        return page - 1 >= total_page;
    }
}

