/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.icbc.cmp.service.note.payable.accept;

import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.note.banks.icbc.cmp.service.note.util.ICBC_CMP_Packer;
import kd.ebg.note.banks.icbc.cmp.service.note.util.ICBC_CMP_Parser;
import kd.ebg.note.banks.icbc.cmp.service.note.util.NewNoteUtil;
import kd.ebg.note.business.notePayable.atomic.AbstractQueryNotePayableImpl;
import kd.ebg.note.business.notePayable.bank.BankNotePayableRequest;
import kd.ebg.note.business.notePayable.bank.EBBankNotePayableResponse;
import kd.ebg.note.business.notePayable.util.EBGNotePayableUtils;
import kd.ebg.note.common.entity.biz.status.PaymentState;
import kd.ebg.note.common.model.NotePayableInfo;
import org.jdom2.Element;

public class QueryAcceptNotePayableImpl
extends AbstractQueryNotePayableImpl {
    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "QBSACPT";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u63d0\u793a\u627f\u5151\u67e5\u8be2", (String)"QueryAcceptNotePayableImpl_0", (String)"ebg-note-banks-icbc-cmp", (Object[])new Object[0]);
    }

    public boolean match(NotePayableInfo notePayableInfo) {
        return true;
    }

    public String pack(BankNotePayableRequest request, String pageTag) {
        NotePayableInfo[] notePayableInfos = request.getNotePayableInfosAsArray();
        NotePayableInfo notePayableInfo = notePayableInfos[0];
        Element root = ICBC_CMP_Packer.createICBCCMPRoot("QBIINFO");
        Element eb = JDomUtils.getChildElement((Element)root, (String)"eb");
        Element in = JDomUtils.addChild((Element)eb, (String)"in");
        JDomUtils.addChild((Element)in, (String)"BillNo", (String)notePayableInfo.getBillNo());
        JDomUtils.addChild((Element)in, (String)"NextTag", (String)"");
        JDomUtils.addChild((Element)in, (String)"ReqReserved1", (String)"");
        JDomUtils.addChild((Element)in, (String)"ReqReserved2", (String)"");
        String encoding = RequestContextUtils.getCharset();
        String reqstMsg = JDomUtils.root2String((Element)root, (String)encoding);
        return ICBC_CMP_Packer.createMessageWithHead(reqstMsg, "QBIINFO");
    }

    public List<NotePayableInfo> parse(BankNotePayableRequest request, String responseStr) {
        List notePayableInfos = request.getNotePayableInfoList();
        NotePayableInfo info = (NotePayableInfo)notePayableInfos.get(0);
        String retMsgDecoded = ICBC_CMP_Parser.decodeRsp(responseStr, true);
        String encoding = RequestContextUtils.getCharset();
        Element root = JDomUtils.string2Root((String)retMsgDecoded, (String)encoding);
        Element eb = JDomUtils.getChildElement((Element)root, (String)"eb");
        Element pub = JDomUtils.getChildElement((Element)eb, (String)"pub");
        BankResponse headRsp = ICBC_CMP_Parser.parseHeader(pub);
        String bankStatus = "<RetCode>" + headRsp.getResponseCode() + "</RetCode>";
        if (!"0".equals(headRsp.getResponseCode())) {
            EBGNotePayableUtils.setPaymentState((List)notePayableInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u540c\u6b65\u627f\u5151\u7ed3\u679c\u5931\u8d25", (String)"QueryAcceptNotePayableImpl_1", (String)"ebg-note-banks-icbc-cmp", (Object[])new Object[0]), (String)headRsp.getResponseMessage());
            return notePayableInfos;
        }
        Element out = JDomUtils.getChildElement((Element)eb, (String)"out");
        String BillState = JDomUtils.getChildText((Element)out, (String)"BillState");
        info.setNoteStatus(BillState);
        if ("020001".equals(BillState)) {
            EBGNotePayableUtils.setPaymentState((NotePayableInfo)info, (PaymentState)PaymentState.SUBMITED, (String)"020001", (String)ResManager.loadKDString((String)"\u63d0\u793a\u627f\u5151\u5f85\u7b7e\u6536", (String)"QueryAcceptNotePayableImpl_2", (String)"ebg-note-banks-icbc-cmp", (Object[])new Object[0]));
        } else if ("020006".equals(BillState)) {
            EBGNotePayableUtils.setPaymentState((NotePayableInfo)info, (PaymentState)PaymentState.SUCCESS, (String)"020006", (String)ResManager.loadKDString((String)"\u6307\u4ee4\u63d0\u4ea4\u6210\u529f\uff0c\u4eba\u884c\u5904\u7406\u6210\u529f\u3002", (String)"QueryAcceptNotePayableImpl_3", (String)"ebg-note-banks-icbc-cmp", (Object[])new Object[0]));
        } else {
            EBGNotePayableUtils.setPaymentState((NotePayableInfo)info, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)ResManager.loadKDString((String)"\u4ea4\u6613\u72b6\u6001\u672a\u77e5", (String)"QueryAcceptNotePayableImpl_4", (String)"ebg-note-banks-icbc-cmp", (Object[])new Object[0]));
        }
        return notePayableInfos;
    }

    public int getBatchSize() {
        return 1;
    }

    public void configFactory(ConnectionFactory factory) {
        super.configFactory(factory);
        factory.setUri("/servlet/ICBCCMPAPIReqServlet");
        factory.setHttpHeader("Content-Type", "application/x-www-form-urlencoded");
    }

    public EBBankNotePayableResponse doBiz(BankNotePayableRequest request) {
        NotePayableInfo notePayableInfo = (NotePayableInfo)request.getNotePayableInfoList().get(0);
        if (notePayableInfo.getIsNewECDS().equals("0")) {
            NewNoteUtil.changeExcontext();
            kd.ebg.note.banks.icbc.opa.service.note.payable.accept.QueryAcceptNotePayableImpl impl = new kd.ebg.note.banks.icbc.opa.service.note.payable.accept.QueryAcceptNotePayableImpl();
            return impl.doBiz(request);
        }
        return this.doBizNoPage(request);
    }
}

