/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.icbc.cmp.service.note.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.framework.communication.IConnection;
import kd.ebg.egf.common.framework.communication.SSLConnection;
import kd.ebg.egf.common.framework.communication.util.IOUtils;
import kd.ebg.egf.common.framework.conf.IParameter;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.datetime.DateUtil;
import kd.ebg.egf.common.utils.string.StrUtil;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class ICBC_CMP_Packer {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(ICBC_CMP_Packer.class);

    public static Element createICBCCMPRoot(String transCode) {
        EBContext context = EBContext.getContext();
        String fSeqno = context.getLogger_detail_no();
        Element root = JDomUtils.createRoot((String)"CMS");
        Element eb = JDomUtils.addChild((Element)root, (String)"eb");
        Element pub = JDomUtils.addChild((Element)eb, (String)"pub");
        JDomUtils.addChild((Element)pub, (String)"TransCode", (String)transCode);
        IParameter parameter = context.getParameter();
        JDomUtils.addChild((Element)pub, (String)"CIS", (String)parameter.getBankParameter("userID"));
        JDomUtils.addChild((Element)pub, (String)"BankCode", (String)"102");
        JDomUtils.addChild((Element)pub, (String)"ID", (String)parameter.getBankParameter("authNo"));
        String signDate4Test = parameter.getBankParameter("signDate4Test");
        if (StrUtil.isEmpty((String)signDate4Test)) {
            JDomUtils.addChild((Element)pub, (String)"TranDate", (String)LocalDate.now().format(DateTimeFormatter.BASIC_ISO_DATE));
        } else {
            JDomUtils.addChild((Element)pub, (String)"TranDate", (String)signDate4Test);
        }
        JDomUtils.addChild((Element)pub, (String)"TranTime", (String)DateUtil.formatDate((Date)new Date(), (String)"HHmmssSSS"));
        JDomUtils.addChild((Element)pub, (String)"fSeqno", (String)fSeqno);
        return root;
    }

    public static Element createICBCCMPRootForPay(String transCode, String bankBatchSeqId) {
        EBContext context = EBContext.getContext();
        Element root = JDomUtils.createRoot((String)"CMS");
        Element eb = JDomUtils.addChild((Element)root, (String)"eb");
        Element pub = JDomUtils.addChild((Element)eb, (String)"pub");
        JDomUtils.addChild((Element)pub, (String)"TransCode", (String)transCode);
        IParameter parameter = context.getParameter();
        JDomUtils.addChild((Element)pub, (String)"CIS", (String)parameter.getBankParameter("userID"));
        JDomUtils.addChild((Element)pub, (String)"BankCode", (String)"102");
        JDomUtils.addChild((Element)pub, (String)"ID", (String)parameter.getBankParameter("authNo"));
        String signDate4Test = parameter.getBankParameter("signDate4Test");
        if (StrUtil.isEmpty((String)signDate4Test)) {
            JDomUtils.addChild((Element)pub, (String)"TranDate", (String)LocalDate.now().format(DateTimeFormatter.BASIC_ISO_DATE));
        } else {
            JDomUtils.addChild((Element)pub, (String)"TranDate", (String)signDate4Test);
        }
        JDomUtils.addChild((Element)pub, (String)"TranTime", (String)DateUtil.formatDate((Date)new Date(), (String)"HHmmssSSS"));
        JDomUtils.addChild((Element)pub, (String)"fSeqno", (String)bankBatchSeqId);
        return root;
    }

    public static String createMessageWithHead(String xmlcontent, String transCode) {
        return ICBC_CMP_Packer.createMessageWithHead(xmlcontent, transCode, "0.0.0.1");
    }

    public static String createMessageWithHeadNew(String xmlcontent, String transCode) {
        return ICBC_CMP_Packer.createMessageWithHead(xmlcontent, transCode, "0.0.1.0");
    }

    public static String createMessageWithHead(String xmlcontent, String transCode, String version) {
        return ICBC_CMP_Packer.createMessageWithHead(xmlcontent, transCode, version, 0);
    }

    public static String createMessageWithHead(String xmlcontent, String transCode, String version, int zipFlag) {
        EBContext context = EBContext.getContext();
        IParameter parameter = context.getParameter();
        String user_id = parameter.getBankParameter("userID");
        String auth_no = parameter.getBankParameter("authNo");
        String packageID = context.getLogger_detail_no();
        StringBuilder sb = new StringBuilder();
        sb.append("Version=").append(version).append("&");
        sb.append("TransCode=").append(transCode).append("&");
        sb.append("BankCode=").append("102").append("&");
        sb.append("GroupCIS=").append(user_id).append("&");
        sb.append("zipFlag=").append(zipFlag).append("&");
        sb.append("ID=").append(auth_no).append("&");
        sb.append("PackageID=").append(packageID).append("&");
        sb.append("Cert=").append("").append("&");
        sb.append("reqData=").append(xmlcontent);
        return sb.toString();
    }

    /*
     * Exception decompiling
     */
    public static String sign(String reqstMsg) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static String parseSignRspMsg(String signRspMsg) {
        if (StrUtil.isEmpty((String)signRspMsg)) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u7b7e\u540d\u5931\u8d25\uff0c\u7b7e\u540d\u54cd\u5e94\u5185\u5bb9\u4e3a\u7a7a\u3002", (String)"ICBC_CMP_Packer_1", (String)"ebg-note-banks-icbc-cmp", (Object[])new Object[0]));
        }
        int index = signRspMsg.indexOf("errorCode=");
        if (-1 != index) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u7b7e\u540d\u5931\u8d25\uff0c%s\u3002", (String)"ICBC_CMP_Packer_8", (String)"ebg-note-banks-icbc-cmp", (Object[])new Object[0]), signRspMsg));
        }
        Element root = JDomUtils.string2Root((String)("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>" + signRspMsg), (String)"UTF-8");
        Element body = root.getChild("body");
        if (null == body) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u7b7e\u540d\u5931\u8d25\uff0c\u7b7e\u540d\u54cd\u5e94\u5185\u5bb9\u4e2d\u6ca1\u6709body\u8282\u70b9\u3002", (String)"ICBC_CMP_Packer_3", (String)"ebg-note-banks-icbc-cmp", (Object[])new Object[0]));
        }
        Element sign = body.getChild("sign");
        if (null == sign) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u7b7e\u540d\u5931\u8d25\uff0c\u7b7e\u540d\u54cd\u5e94\u5185\u5bb9\u4e2d\u6ca1\u6709sign\u8282\u70b9\u3002", (String)"ICBC_CMP_Packer_4", (String)"ebg-note-banks-icbc-cmp", (Object[])new Object[0]));
        }
        String signed = sign.getTextTrim();
        if (StrUtil.isEmpty((String)signed)) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u7b7e\u540d\u5931\u8d25\uff0c\u7b7e\u540d\u54cd\u5e94\u5185\u5bb9\u4e2dsign\u8282\u70b9\u5185\u5bb9\u4e3a\u7a7a\u3002", (String)"ICBC_CMP_Packer_5", (String)"ebg-note-banks-icbc-cmp", (Object[])new Object[0]));
        }
        logger.info("\u7b7e\u540d\u6210\u529f");
        return signed;
    }

    public static void openConnection(IConnection connection) {
        try {
            EBContext.getContext().setConnection(connection);
            connection.openConnection();
        }
        catch (IOException e) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u6253\u5f00\u8fde\u63a5\u5f02\u5e38\uff1a%s\u3002", (String)"ICBC_CMP_Packer_9", (String)"ebg-note-banks-icbc-cmp", (Object[])new Object[0]), e.getMessage()), (Throwable)e);
        }
    }

    public static boolean isSSLProxyConnection() {
        return EBContext.getContext().getProxyType() != null;
    }

    public static void send(OutputStream outputStream, String requestStr, String bizSeqId) {
        if (ICBC_CMP_Packer.isSSLProxyConnection()) {
            SSLConnection connection = (SSLConnection)EBContext.getContext().getConnection();
            connection.sendMsg(outputStream, requestStr);
        } else {
            IOUtils.sendFully((OutputStream)outputStream, (String)requestStr);
        }
    }

    public static String recv(InputStream inputStream, String bizSeqId) {
        if (ICBC_CMP_Packer.isSSLProxyConnection()) {
            try {
                SSLConnection connection = (SSLConnection)EBContext.getContext().getConnection();
                return connection.getResponse(inputStream);
            }
            catch (Exception e) {
                if (StringUtils.isEmpty((String)e.getMessage())) {
                    throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u83b7\u53d6\u8f93\u5165\u6d41\u5f02\u5e38\u3002", (String)"ICBC_CMP_Packer_7", (String)"ebg-note-banks-icbc-cmp", (Object[])new Object[0]), (Throwable)e);
                }
                if (e instanceof EBServiceException) {
                    throw EBExceiptionUtil.serviceException((String)e.getMessage(), (String)((EBServiceException)e).getErrorCode(), (Throwable)e);
                }
                throw EBExceiptionUtil.serviceException((String)e.getMessage(), (Throwable)e);
            }
        }
        return IOUtils.readFully((InputStream)inputStream);
    }
}

