/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.ccb.dc.services.codeless.detail.endorseInfo;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.framework.bank.info.BankHeader;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.note.banks.ccb.dc.services.CCB_DC_Parser;
import kd.ebg.note.banks.ccb.dc.services.codeless.detail.endorseInfo.NoteInfosImpl;
import kd.ebg.note.business.noteDetail.atomic.codeless.CodeLessAbstractNoteDetailImpl;
import kd.ebg.note.business.noteDetail.bank.BankNoteDetailRequest;
import kd.ebg.note.business.noteDetail.bank.BankNoteDetailRequestBody;
import kd.ebg.note.business.noteDetail.bank.EBBankDetailResponse;
import kd.ebg.note.common.entity.biz.notedetail.Detail;
import org.jdom2.Element;

public class CodelessHoldImpl
extends CodeLessAbstractNoteDetailImpl {
    private final EBGLogger logger = EBGLogger.getInstance().getLogger(CodelessHoldImpl.class);

    public String getDeveloper() {
        return "hhm";
    }

    public String getBizCode() {
        return "6WH273";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u6301\u7968\u67e5\u8be2", (String)"NoteDetailHoldImpl_0", (String)"ebg-note-banks-ccb-dc", (Object[])new Object[0]);
    }

    public String getFirstPageTag() {
        return "1";
    }

    public String getNextPageTag(String rspStr, String pageTag) {
        Integer page;
        Integer n = page = Integer.valueOf(Integer.parseInt(pageTag));
        Integer n2 = page = Integer.valueOf(page + 1);
        return page + "";
    }

    public boolean isNeedPage() {
        return true;
    }

    public boolean isLastPage(String rspStr, String pageTag) {
        boolean flag = false;
        Element root = CCB_DC_Parser.parseString2Root((String)rspStr);
        BankResponse response = CCB_DC_Parser.parseResponse((Element)root);
        String rspCode = response.getResponseCode();
        String pageTotalNumStr = "";
        if ("000000".equals(rspCode)) {
            Element txBody = JDomUtils.getChildElement((Element)root, (String)"TX_INFO");
            pageTotalNumStr = JDomUtils.getChildText((Element)txBody, (String)"TOTAL_PAGE");
            this.logger.info("\u603b\u9875\u6570\u4e3a" + pageTotalNumStr);
            if (StringUtils.isEmpty((String)pageTotalNumStr) || "0".equals(pageTotalNumStr)) {
                flag = true;
            } else {
                String curr_total_page = JDomUtils.getChildText((Element)txBody, (String)"CURR_TOTAL_PAGE");
                Integer pageTotalNum = Integer.parseInt(pageTotalNumStr);
                Integer page = Integer.parseInt(curr_total_page);
                flag = page >= pageTotalNum;
            }
        } else {
            flag = true;
        }
        return flag;
    }

    public List<Detail> getSideImpl(List<Detail> details) throws Exception {
        BankNoteDetailRequest request = new BankNoteDetailRequest();
        NoteInfosImpl impl = new NoteInfosImpl();
        BankHeader header = new BankHeader();
        header.setAcnt(EBContext.getContext().getAcnt());
        header.setSubBizType("reply");
        request.setHeader(header);
        for (Detail detail : details) {
            BankNoteDetailRequestBody body = new BankNoteDetailRequestBody();
            body.setStartNo(detail.getStartNo());
            body.setEndNo(detail.getEndNo());
            body.setNoteNo(detail.getNoteNo());
            body.setDraftType(detail.getDraftType());
            request.setBody(body);
            EBBankDetailResponse response = impl.doBiz(request);
            List noteSidesInfo = ((Detail)response.getDetails().get(0)).getNoteSidesInfo();
            detail.setNoteSidesInfo(noteSidesInfo);
        }
        return details;
    }

    public boolean isCodelessSide() {
        return true;
    }

    public List<Detail> parserUtil(BankNoteDetailRequest request, String responStr) {
        List result = super.parserUtil(request, responStr);
        if (!"hold".equals(request.getHeader().getSubBizType())) {
            return result;
        }
        if (result == null || result.size() == 0) {
            return result;
        }
        ArrayList<Detail> newResult = new ArrayList<Detail>(1);
        for (Detail detail : result) {
            if ("CS06".equals(detail.getNoteStatus()) || "CS05".equals(detail.getNoteStatus())) continue;
            newResult.add(detail);
        }
        return newResult;
    }
}

