/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.ccb.dc.services.codeless.payable.register;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.egf.common.utils.datetime.DateUtil;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.note.banks.ccb.dc.services.CCB_DC_Packer;
import kd.ebg.note.banks.ccb.dc.services.codeless.CommonParser;
import kd.ebg.note.banks.ccb.dc.services.codeless.payable.register.CodelessQueryRegister;
import kd.ebg.note.banks.ccb.dc.services.note.NoteCommonPacker;
import kd.ebg.note.banks.ccb.dc.services.note.payable.register.FileUtil.CCB_DCFileUtil;
import kd.ebg.note.banks.ccb.dc.services.note.payable.register.FileUtil.UploadFileImpl;
import kd.ebg.note.business.notePayable.atomic.AbstractNotePayableImpl;
import kd.ebg.note.business.notePayable.atomic.IQueryNotePayable;
import kd.ebg.note.business.notePayable.bank.BankNotePayableRequest;
import kd.ebg.note.common.model.NotePayableInfo;
import kd.ebg.note.common.utils.PropertiesConstantsUtils;
import org.jdom2.Element;

public class CodelessRegisterImpl
extends AbstractNotePayableImpl {
    private static final EBGLogger loggers = EBGLogger.getInstance().getLogger(CodelessRegisterImpl.class);
    private static final String SEPERATOR = "|";

    public int getBatchSize() {
        return 200;
    }

    public Class<? extends IQueryNotePayable> defaultQueryClass() {
        return CodelessQueryRegister.class;
    }

    public String pack(BankNotePayableRequest request, String pageTag) {
        List infos = request.getNotePayableInfoList();
        if (infos.size() > 30) {
            return this.pack4File(infos);
        }
        String custid = RequestContextUtils.getBankParameterValue((String)"CUST_ID");
        Element header = CCB_DC_Packer.createTransactionHeader((String)"6WH200", (String)((NotePayableInfo)infos.get(0)).getBankBatchSeqId());
        Element tx_info = JDomUtils.addChild((Element)header, (String)"TX_INFO");
        JDomUtils.addChild((Element)tx_info, (String)"Bl_Prtc_SgnSl_MtdCd", (String)"PS01");
        JDomUtils.addChild((Element)tx_info, (String)"Bl_Prtc_Elc_Sgn", (String)(custid + ((NotePayableInfo)infos.get(0)).getBankBatchSeqId()));
        JDomUtils.addChild((Element)tx_info, (String)"Bl_Acpt_Agrm_ID_Inf", (String)((NotePayableInfo)infos.get(0)).getContractNo());
        JDomUtils.addChild((Element)tx_info, (String)"Txn_Tdnum", (String)String.valueOf(infos.size()));
        JDomUtils.addChild((Element)tx_info, (String)"CHNL_CUST_NO", (String)RequestContextUtils.getBankParameterValue((String)"CUST_ID"));
        JDomUtils.addChild((Element)tx_info, (String)"Bl_Rmtr_Unn_Id_No");
        for (NotePayableInfo info : infos) {
            Element grp = JDomUtils.addChild((Element)tx_info, (String)"Bkqryccpsq_GRP");
            LocalDate issueDate = info.getBookingDate();
            if (issueDate == null) {
                throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u83b7\u53d6\u5230\u7684\u51fa\u7968\u65e5\u671f\u4e3a\u7a7a\u3002", (String)"CodelessRegisterImpl_0", (String)"ebg-note-banks-ccb-dc", (Object[])new Object[0]));
            }
            LocalDate dueDate = info.getDueDate();
            if (dueDate == null) {
                throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u83b7\u53d6\u5230\u7684\u7ed3\u675f\u65e5\u671f\u4e3a\u7a7a\u3002", (String)"CodelessRegisterImpl_1", (String)"ebg-note-banks-ccb-dc", (Object[])new Object[0]));
            }
            JDomUtils.addChild((Element)grp, (String)"Bl_Acpt_Agrm_Bl_No", (String)info.getBillNo());
            info.setReserved1(info.getBillNo());
            JDomUtils.addChild((Element)grp, (String)"IssuOfPpr_Dt", (String)issueDate.format(DateTimeFormatter.ofPattern("yyyyMMdd")));
            JDomUtils.addChild((Element)grp, (String)"Bill_ExDat", (String)dueDate.format(DateTimeFormatter.ofPattern("yyyyMMdd")));
            JDomUtils.addChild((Element)grp, (String)"New_Stm_IssuOfPpr_Ind", (String)"1");
            JDomUtils.addChild((Element)grp, (String)"BlGrdBagCrcl_Prmt_Ind", (String)info.getGrdBag());
            JDomUtils.addChild((Element)grp, (String)"EBillFrbdTrsferMarkCd", (String)info.getTransferFlag());
            JDomUtils.addChild((Element)grp, (String)"EBillExpUCndEntrst_Cd", (String)"CC00");
            info.setAutoAccept("1");
            info.setAutoReceive("0");
        }
        return NoteCommonPacker.root2StringSafeMod((Element)header);
    }

    public String pack4File(List<NotePayableInfo> infos) {
        CCB_DCFileUtil fileUtil = new CCB_DCFileUtil();
        String datestr = DateUtil.formatDate((Date)new Date());
        String custid = RequestContextUtils.getBankParameterValue((String)"CUST_ID");
        String fileName = "05" + datestr + "1" + custid + ".txt";
        StringBuilder sBuffer = new StringBuilder();
        sBuffer.append(PropertiesConstantsUtils.getValue((String)"ccbCodelessRegister"));
        sBuffer.append("\r\n");
        for (int i = 0; i < infos.size(); ++i) {
            NotePayableInfo info = infos.get(i);
            sBuffer.append(i + 1).append(SEPERATOR);
            sBuffer.append(info.getBillNo()).append(SEPERATOR);
            sBuffer.append(LocalDateUtil.formatDate((LocalDate)info.getBookingDate())).append(SEPERATOR);
            sBuffer.append(LocalDateUtil.formatDate((LocalDate)info.getDueDate())).append(SEPERATOR);
            sBuffer.append("1").append(SEPERATOR);
            if (StringUtils.isEmpty((String)info.getGrdBag())) {
                sBuffer.append("1").append(SEPERATOR);
            } else {
                sBuffer.append(info.getGrdBag()).append(SEPERATOR);
            }
            sBuffer.append(info.getTransferFlag()).append(SEPERATOR);
            sBuffer.append(info.getExplanation()).append(SEPERATOR);
            sBuffer.append("").append(SEPERATOR);
            sBuffer.append("").append(SEPERATOR);
            sBuffer.append("\r\n");
            info.setReserved1(info.getBillNo());
            info.setAutoAccept("1");
            info.setAutoReceive("0");
        }
        String fileContent = sBuffer.toString();
        Map map = fileUtil.uploadFileMD5(fileName, fileContent);
        if (map == null) {
            loggers.info("upload file fail");
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u6279\u91cf\u51fa\u7968\u4e0a\u4f20\u6587\u4ef6\u5931\u8d25\u3002", (String)"RegisterNotePayableImpl_2", (String)"ebg-note-banks-ccb-dc", (Object[])new Object[0]));
        }
        String absoluteFileName = (String)map.get("fileName");
        String MD5 = (String)map.get("MD5");
        loggers.info("fileName\uff1a" + fileName);
        loggers.info("MD5\uff1a" + MD5);
        if (StringUtils.isEmpty((String)absoluteFileName)) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u6587\u4ef6\u4e0a\u4f20\u5f02\u5e38\uff0c\u83b7\u53d6\u4e0d\u5230\u6570\u636e\u3002", (String)"RegisterNotePayableImpl_3", (String)"ebg-note-banks-ccb-dc", (Object[])new Object[0]));
        }
        UploadFileImpl filename = new UploadFileImpl();
        String finalName = filename.getinfo(absoluteFileName);
        loggers.info("finalName\uff1a" + finalName);
        if (StringUtils.isEmpty((String)fileName)) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u6587\u4ef6\u4e0a\u4f20\u8c03\u7528\u5931\u8d25\u3002", (String)"BatchUtil_3", (String)"ebg-note-banks-ccb-dc", (Object[])new Object[0]));
        }
        Element header = CCB_DC_Packer.createTransactionHeader((String)"6WH218", (String)infos.get(0).getBankBatchSeqId());
        Element txBody = NoteCommonPacker.createTransactionBody((Element)header, (String)"", (String)infos.get(0).getBatchSeqId());
        JDomUtils.addChild((Element)txBody, (String)"CHNL_CUST_NO", (String)RequestContextUtils.getBankParameterValue((String)"QD_ID"));
        JDomUtils.addChild((Element)txBody, (String)"Bl_Rmtr_Unn_Id_No");
        JDomUtils.addChild((Element)txBody, (String)"Bl_Prtc_SgnSl_MtdCd", (String)"PS01");
        JDomUtils.addChild((Element)txBody, (String)"Bl_Prtc_Elc_Sgn", (String)(custid + infos.get(0).getBankBatchSeqId()));
        JDomUtils.addChild((Element)txBody, (String)"Txn_Tdnum", (String)String.valueOf(infos.size()));
        JDomUtils.addChild((Element)txBody, (String)"Bl_Acpt_Agrm_ID_Inf", (String)infos.get(0).getContractNo());
        JDomUtils.addChild((Element)txBody, (String)"MD5_Val", (String)MD5);
        JDomUtils.addChild((Element)txBody, (String)"SEND_FILE", (String)finalName);
        return NoteCommonPacker.root2StringSafeMod((Element)header);
    }

    public List<NotePayableInfo> parse(BankNotePayableRequest request, String responseStr) {
        CommonParser.parsePayable((List)request.getNotePayableInfoList(), (String)responseStr);
        return request.getNotePayableInfoList();
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "6WH200";
    }

    public String getBizDesc() {
        return null;
    }

    public boolean match(NotePayableInfo notePayableInfo) {
        return true;
    }

    public long getBankInterval() {
        return 0L;
    }
}

