/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.gdb.dc.services.util;

import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.conf.ParameterImpl;
import kd.ebg.egf.common.framework.security.manage.AESCipherSecurity;
import kd.ebg.egf.common.framework.security.manage.CipherInfo;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.DesUtil;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.note.banks.gdb.dc.GdbDcMetaDataImpl;
import kd.ebg.note.banks.gdb.dc.services.util.encry.SMUtils;
import kd.ebg.note.common.model.CertInfo;
import kd.ebg.note.common.model.repository.UserCertRepository;
import kd.ebg.note.common.utils.SpringContextUtil;
import org.apache.commons.codec.binary.Base64;

public class SMUtil {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(SMUtil.class);
    private static UserCertRepository userCertRepository = (UserCertRepository)SpringContextUtil.getBean(UserCertRepository.class);

    public static void getEncry() {
        String ecnry = SMUtil.getUserKey(GdbDcMetaDataImpl.PublicKey, ResManager.loadKDString((String)"\u94f6\u884c\u516c\u94a5", (String)"SMUtil_0", (String)"ebg-note-banks-gdb-dc", (Object[])new Object[0]));
        String user = RequestContextUtils.getParameter().getBankParameter("PASSWORD");
        try {
            String result = SMUtils.sm2EncryptOperatorPwd((String)ecnry, (String)user);
            ParameterImpl parameter = (ParameterImpl)EBContext.getContext().getParameter();
            parameter.setBankParameter("PASSWORD", result);
            String chatset = RequestContextUtils.getBankParameterValue((String)GdbDcMetaDataImpl.CHARSET_NOTE);
            if (StringUtils.isEmpty((String)chatset)) {
                chatset = RequestContextUtils.getBankParameterValue((String)"UTF-8");
            }
            String protocol = RequestContextUtils.getBankParameterValue((String)GdbDcMetaDataImpl.PROTOCOL_NOTE);
            parameter.setBankParameter("exchangeProtocol", protocol);
            String port = RequestContextUtils.getBankParameterValue((String)GdbDcMetaDataImpl.PORT_NOTE);
            parameter.setBankParameter("exchangePort", port);
            parameter.setBankParameter("charset", chatset);
            EBContext.getContext().setCharsetName(chatset);
        }
        catch (Throwable e) {
            logger.error(e.getMessage());
            logger.error("\u7528\u6237\u5bc6\u7801\u52a0\u5bc6\u5931\u8d25", e);
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u7528\u6237\u5bc6\u7801\u52a0\u5bc6\u5931\u8d25", (String)"SMUtil_15", (String)"ebg-note-banks-gdb-dc", (Object[])new Object[0]));
        }
    }

    public static String getUserKey(String key, String name) {
        CertInfo certInfo = userCertRepository.findBankLoginCertByBankLoginIDAndBankConfigIDAndCustomID(key, RequestContextUtils.getRequestContext().getBankLoginID(), RequestContextUtils.getCustomId());
        if (certInfo == null) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u83b7\u53d6%s\u5931\u8d25\uff0c\u8bf7\u5148\u914d\u7f6e\u5ba2\u6237\u516c\u94a5\u6587\u4ef6", (String)"SMUtil_5", (String)"ebg-note-banks-gdb-dc", (Object[])new Object[0]), name));
        }
        CipherInfo cipherInfo = SMUtil.getCipherInfo(certInfo.getFileContent());
        byte[] fileContent = DesUtil.decryptProxyCert((byte[])cipherInfo.getFileBytes(), (String)certInfo.getCustomID(), (int)cipherInfo.getCipherVersion(), (String)certInfo.getCertID());
        return SMUtil.getKey(fileContent);
    }

    private static String getKey(byte[] fileContent) {
        return StringUtils.byteToString((byte[])fileContent);
    }

    private static CipherInfo getCipherInfo(String data) {
        AESCipherSecurity security = (AESCipherSecurity)SpringContextUtil.getBean(AESCipherSecurity.class);
        CipherInfo cipherInfo = security.getCipherInfo(data);
        if (cipherInfo.getCipherVersion() == 0) {
            cipherInfo.setFileBytes(java.util.Base64.getDecoder().decode(cipherInfo.getCipherData()));
        } else {
            cipherInfo.setFileBytes(Base64.decodeBase64((String)cipherInfo.getCipherData()));
        }
        return cipherInfo;
    }
}

