/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.cmbc.dc.services.news.receivable.cancle;

import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.note.banks.cmbc.dc.services.news.CodelessUtil;
import kd.ebg.note.banks.cmbc.dc.services.news.receivable.AbstractCmbcNoteReceivableImpl;
import kd.ebg.note.banks.cmbc.dc.services.news.receivable.cancle.QueryCancleReceiveCodelessImpl;
import kd.ebg.note.business.noteReceivable.atomic.IQueryNoteReceivable;
import kd.ebg.note.business.noteReceivable.bank.BankNoteReceivableRequest;
import kd.ebg.note.common.model.NoteReceivableInfo;

public class CancleReceiveCodelessImpl
extends AbstractCmbcNoteReceivableImpl {
    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryNoteReceivable> defaultQueryClass() {
        return QueryCancleReceiveCodelessImpl.class;
    }

    public String getDeveloper() {
        return "hhm";
    }

    public String getBizCode() {
        return "B2eNbsDraftRevocation_R";
    }

    @Override
    public String getRealCode() {
        return "B2eNbsDraftRevocation";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u5e94\u6536\u64a4\u9500", (String)"CancleReceiveCodelessImpl_0", (String)"ebg-note-banks-cmbc-dc", (Object[])new Object[0]);
    }

    public String packerUtil(BankNoteReceivableRequest request, String pageTag) {
        NoteReceivableInfo[] infos = request.getNotePayableInfosAsArray();
        String type = "";
        if ("10".equals(infos[0].getOperationCode())) {
            type = "03";
        } else if ("11".equals(infos[0].getOperationCode())) {
            type = "07";
        } else if ("20".equals(infos[0].getOperationCode())) {
            type = "06";
        }
        String check = CodelessUtil.pack4CheckCancle(infos[0].getDrawerAccNo(), type, infos[0].getBillNo());
        String resp = this.doBussiness(check);
        List<String> billNos = CodelessUtil.parse4CheckCancle(resp);
        if (billNos.contains(infos[0].getBillNo() + "_" + infos[0].getStartNo() + "_" + infos[0].getEndNo())) {
            return super.packerUtil(request, pageTag);
        }
        throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u53ef\u64a4\u9500\u7968\u636e\u5217\u8868\u4e2d\u4e0d\u5b58\u5728\u8be5\u7968\u636e\uff0c\u64a4\u9500\u7533\u8bf7\u5931\u8d25\u3002", (String)"CancleReceiveCodelessImpl_1", (String)"ebg-note-banks-cmbc-dc", (Object[])new Object[0]));
    }
}

