/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.common.framework.frame;

import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.PostConstruct;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.util.ConfigurationUpdateObserver;
import kd.bos.util.StringUtils;
import kd.ebg.egf.common.annotation.Component;
import kd.ebg.egf.common.annotation.Value;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.api.IBankBatchSeqIDCreator;
import kd.ebg.egf.common.framework.bank.api.IBankDetailSeqIDCreator;
import kd.ebg.egf.common.framework.bank.api.IBankService;
import kd.ebg.egf.common.framework.bank.api.IBankServiceDesc;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankConfig;
import kd.ebg.egf.common.model.bank.login.BankLoginConfig;
import kd.ebg.egf.common.utils.CheckUtil;
import kd.ebg.egf.common.utils.JsonUtil;
import kd.ebg.egf.common.utils.file.FieldUtils;
import kd.ebg.egf.common.utils.string.StrUtil;
import kd.ebg.note.common.framework.bank.meta.BankMetaDataCollector;
import kd.ebg.note.common.framework.bank.meta.BankVersionMetaInfo;
import kd.ebg.note.common.framework.frame.AtomicBizMeta;
import kd.ebg.note.common.framework.frame.AtomicBizMetaCollector;
import kd.ebg.note.common.framework.frame.AtomicMetaType;
import kd.ebg.note.common.framework.frame.Bank;
import kd.ebg.note.common.framework.frame.BankVersion;
import kd.ebg.note.common.framework.properties.BankPropertyConfig;
import kd.ebg.note.common.framework.properties.GlobalPropertyConfig;
import kd.ebg.note.common.framework.properties.PropertyConfig;
import kd.ebg.note.common.framework.route.RouteMatchType;
import kd.ebg.note.common.framework.route.RouteMeta;
import kd.ebg.note.common.framework.services.BankInterfaceRouteService;
import kd.ebg.note.common.model.BankInterfaceRoute;
import kd.ebg.note.common.utils.SpringContextUtil;
import org.apache.commons.collections4.CollectionUtils;

@Component
public class BankBundleManager {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(BankBundleManager.class);
    @Value(value="${ebservice.bank.concurrentCount}")
    private String conCountJson;
    private List<BankMetaDataCollector> bankMetaDataCollectorList;
    private List<AtomicBizMetaCollector> atomicBizMetaCollectorList;
    private Map<String, List<BankLoginConfig>> bankVersionMapConfig;
    private Map<String, List<BankConfig>> bankPwdCertMapConfig;
    private Map<String, PropertyConfig> bankVersionMapPropertyConfig;
    private List<AtomicBizMeta> bizMetas;
    private List<AtomicBizMeta> sysMetas;
    private List<Class<? extends IBankServiceDesc>> bizInterfaceList;
    private Map<String, BankVersion> bankVersionMap;
    private Map<String, String> split4SubRange;
    private Map<String, List<String>> bankKeyWordsMap;
    private Map<String, Bank> bankMap;
    private Map<Class<? extends IBankService>, IBankService> bizImplClass2Impl;
    private final GlobalPropertyConfig globalPropertyConfig;
    private final BankInterfaceRouteService routeService;

    public List<String> getKeyWords(String bankVersion) {
        if (this.bankKeyWordsMap == null) {
            this.bankKeyWordsMap = new HashMap<String, List<String>>(16);
        }
        return this.bankKeyWordsMap.get(bankVersion);
    }

    public void setKeyWords(String bankVersion, List<String> list) {
        if (this.bankKeyWordsMap == null) {
            this.bankKeyWordsMap = new HashMap<String, List<String>>(16);
        }
        this.bankKeyWordsMap.put(bankVersion, list);
    }

    public Map<String, String> getSplit4SubRange() {
        return this.split4SubRange;
    }

    public void setSplit4SubRange(Map<String, String> split4SubRange) {
        this.split4SubRange = split4SubRange;
    }

    public String getConCountJson() {
        return this.conCountJson;
    }

    public void setConCountJson(String conCountJson) {
        this.conCountJson = conCountJson;
    }

    public List<BankMetaDataCollector> getBankMetaDataCollectorList() {
        return this.bankMetaDataCollectorList;
    }

    public void setBankMetaDataCollectorList(List<BankMetaDataCollector> bankMetaDataCollectorList) {
        this.bankMetaDataCollectorList = bankMetaDataCollectorList;
    }

    public List<AtomicBizMetaCollector> getAtomicBizMetaCollectorList() {
        return this.atomicBizMetaCollectorList;
    }

    public void setAtomicBizMetaCollectorList(List<AtomicBizMetaCollector> atomicBizMetaCollectorList) {
        this.atomicBizMetaCollectorList = atomicBizMetaCollectorList;
    }

    public Map<String, List<BankLoginConfig>> getBankVersionMapConfig() {
        return this.bankVersionMapConfig;
    }

    public void setBankVersionMapConfig(Map<String, List<BankLoginConfig>> bankVersionMapConfig) {
        this.bankVersionMapConfig = bankVersionMapConfig;
    }

    public Map<String, List<BankConfig>> getBankPwdCertMapConfig() {
        return this.bankPwdCertMapConfig;
    }

    public void setBankPwdCertMapConfig(Map<String, List<BankConfig>> bankPwdCertMapConfig) {
        this.bankPwdCertMapConfig = bankPwdCertMapConfig;
    }

    public Map<String, PropertyConfig> getBankVersionMapPropertyConfig() {
        return this.bankVersionMapPropertyConfig;
    }

    public void setBankVersionMapPropertyConfig(Map<String, PropertyConfig> bankVersionMapPropertyConfig) {
        this.bankVersionMapPropertyConfig = bankVersionMapPropertyConfig;
    }

    public void setBizMetas(List<AtomicBizMeta> bizMetas) {
        this.bizMetas = bizMetas;
    }

    public List<AtomicBizMeta> getSysMetas() {
        return this.sysMetas;
    }

    public void setSysMetas(List<AtomicBizMeta> sysMetas) {
        this.sysMetas = sysMetas;
    }

    public List<Class<? extends IBankServiceDesc>> getBizInterfaceList() {
        return this.bizInterfaceList;
    }

    public void setBizInterfaceList(List<Class<? extends IBankServiceDesc>> bizInterfaceList) {
        this.bizInterfaceList = bizInterfaceList;
    }

    public Map<String, BankVersion> getBankVersionMap() {
        return this.bankVersionMap;
    }

    public void setBankVersionMap(Map<String, BankVersion> bankVersionMap) {
        this.bankVersionMap = bankVersionMap;
    }

    public Map<String, Bank> getBankMap() {
        return this.bankMap;
    }

    public void setBankMap(Map<String, Bank> bankMap) {
        this.bankMap = bankMap;
    }

    public Map<Class<? extends IBankService>, IBankService> getBizImplClass2Impl() {
        return this.bizImplClass2Impl;
    }

    public void setBizImplClass2Impl(Map<Class<? extends IBankService>, IBankService> bizImplClass2Impl) {
        this.bizImplClass2Impl = bizImplClass2Impl;
    }

    public GlobalPropertyConfig getGlobalPropertyConfig() {
        return this.globalPropertyConfig;
    }

    public BankInterfaceRouteService getRouteService() {
        return this.routeService;
    }

    public BankVersion getBankVersionInfo(String bankVersionID) {
        return this.bankVersionMap.get(bankVersionID);
    }

    public BankBundleManager(GlobalPropertyConfig config, BankInterfaceRouteService service, List<BankMetaDataCollector> list, List<AtomicBizMetaCollector> collectors) {
        this.globalPropertyConfig = config;
        this.routeService = service;
        this.bankMetaDataCollectorList = list;
        this.atomicBizMetaCollectorList = collectors;
    }

    @PostConstruct
    public void init() {
        logger.info("\u52a0\u8f7d\u94f6\u884c\u524d\u7f6e\u673a\u5e76\u53d1\u9501\u6570\u91cf...");
        if (!StringUtils.isEmpty((String)this.conCountJson)) {
            JSONObject jasonObject;
            JSONObject bankConCountMap = jasonObject = JSONObject.parseObject((String)this.conCountJson);
            String dLockNum = "";
            for (Map.Entry entry : bankConCountMap.entrySet()) {
                logger.info((String)entry.getKey() + "\u524d\u7f6e\u673a\u5e76\u53d1\u9501\u6570\u91cf\uff1a" + entry.getValue());
                dLockNum = (String)entry.getKey() + "_concurrentCount";
                ConfigurationUpdateObserver.registerInterest((String)dLockNum, (Object)String.valueOf(entry.getValue()));
                ConfigurationUpdateObserver.notify((String)dLockNum);
            }
        }
        logger.info("\u5f00\u59cb\u521d\u59cb\u5316\u4e1a\u52a1\u7cfb\u7edf...");
        this.bizMetas = Lists.newArrayList();
        this.sysMetas = Lists.newArrayList();
        this.bizInterfaceList = Lists.newArrayList();
        this.bankVersionMap = Maps.newHashMap();
        this.bankMap = Maps.newHashMap();
        this.bizImplClass2Impl = Maps.newConcurrentMap();
        this.bankVersionMapConfig = Maps.newHashMap();
        this.bankPwdCertMapConfig = Maps.newHashMap();
        this.bankVersionMapPropertyConfig = Maps.newConcurrentMap();
        this.split4SubRange = Maps.newHashMap();
        Preconditions.checkNotNull(this.atomicBizMetaCollectorList, (Object)ResManager.loadKDString((String)"\u652f\u6301\u7684\u4e1a\u52a1\u63a5\u53e3\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BankBundleManager_0", (String)"ebg-note-common", (Object[])new Object[0]));
        this.atomicBizMetaCollectorList.forEach(this::dealAtomicBizMetaCollector);
        if (CollectionUtils.isNotEmpty(this.bankMetaDataCollectorList)) {
            this.bankMetaDataCollectorList.stream().filter(bankMetaDataCollector -> {
                boolean result = true;
                try {
                    BankPropertyConfig propertyConfig;
                    Preconditions.checkNotNull((Object)bankMetaDataCollector, (Object)ResManager.loadKDString((String)"\u94f6\u884c\u63d2\u4ef6\u5143\u4fe1\u606f\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BankBundleManager_1", (String)"ebg-note-common", (Object[])new Object[0]));
                    BankVersionMetaInfo bankVersionMetaInfo = bankMetaDataCollector.getBankVersionMetaInfo();
                    Preconditions.checkNotNull((Object)bankVersionMetaInfo, (Object)ResManager.loadKDString((String)"\u94f6\u884c\u63d2\u4ef6\u5b9e\u73b0 \u94f6\u884c\u7248\u672c\u5143\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BankBundleManager_2", (String)"ebg-note-common", (Object[])new Object[0]));
                    String bankShortName = bankVersionMetaInfo.getBankShortName();
                    String bankVersionID = bankVersionMetaInfo.getBankVersionID();
                    String bankName = bankVersionMetaInfo.getBankName();
                    List keyNames = bankVersionMetaInfo.getKeyNames();
                    Preconditions.checkState((boolean)StrUtil.isNotBlank((CharSequence)bankShortName), (Object)ResManager.loadKDString((String)"\u94f6\u884c\u7b80\u7801 bankShortName \u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BankBundleManager_3", (String)"ebg-note-common", (Object[])new Object[0]));
                    Preconditions.checkState((boolean)StrUtil.isNotBlank((CharSequence)bankVersionID), (Object)String.format(ResManager.loadKDString((String)"\u94f6\u884c\u63d2\u4ef6\uff1a%s\u94f6\u884c\u7248\u672c\u7b80\u7801 bankVersionID \u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BankBundleManager_21", (String)"ebg-note-common", (Object[])new Object[0]), bankVersionID));
                    Preconditions.checkState((boolean)CheckUtil.checkNumberWord((String)bankVersionID), (Object)ResManager.loadKDString((String)"\u94f6\u884c\u7248\u672c\u7b80\u7801 bankVersionID \u5fc5\u987b\u4e3a\u5b57\u6bcd\u6216\u8005\u6570\u5b57\u3002", (String)"BankBundleManager_6", (String)"ebg-note-common", (Object[])new Object[0]));
                    Preconditions.checkState((boolean)CheckUtil.checkNumberWord((String)bankShortName), (Object)String.format(ResManager.loadKDString((String)"\u94f6\u884c\u63d2\u4ef6\uff1a%s\u94f6\u884c\u7b80\u7801 bankShortName \u5fc5\u987b\u4e3a\u5b57\u6bcd\u6216\u8005\u6570\u5b57\u3002", (String)"BankBundleManager_22", (String)"ebg-note-common", (Object[])new Object[0]), bankVersionID));
                    Preconditions.checkNotNull((Object)keyNames, (Object)String.format(ResManager.loadKDString((String)"\u94f6\u884c\u63d2\u4ef6\uff1a%s\u94f6\u884c\u522b\u540d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BankBundleManager_23", (String)"ebg-note-common", (Object[])new Object[0]), bankVersionID));
                    Preconditions.checkState((boolean)StrUtil.isNotBlank((CharSequence)bankName), (Object)String.format(ResManager.loadKDString((String)"\u94f6\u884c\u63d2\u4ef6\uff1a%s\u94f6\u884c\u540d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BankBundleManager_24", (String)"ebg-note-common", (Object[])new Object[0]), bankVersionID));
                    List bizImplClasses = bankMetaDataCollector.getBizImplClasses();
                    Preconditions.checkNotNull((Object)bizImplClasses, (Object)String.format(ResManager.loadKDString((String)"\u94f6\u884c\u63d2\u4ef6\uff1a%s\u4e1a\u52a1\u5b9e\u73b0\u63a5\u53e3\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BankBundleManager_29", (String)"ebg-note-common", (Object[])new Object[0]), bankVersionID));
                    Preconditions.checkState((!bizImplClasses.isEmpty() ? 1 : 0) != 0, (Object)String.format(ResManager.loadKDString((String)"\u94f6\u884c\u63d2\u4ef6\uff1a%s\u4e1a\u52a1\u5b9e\u73b0\u63a5\u53e3\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BankBundleManager_30", (String)"ebg-note-common", (Object[])new Object[0]), bankVersionID));
                    List bankLoginConfigs = bankMetaDataCollector.getBankLoginConfig();
                    if (Objects.isNull(bankLoginConfigs) || bankLoginConfigs.isEmpty()) {
                        logger.warn("\u94f6\u884c\u63d2\u4ef6 : {} \u6ca1\u6709\u5b9a\u4e49\u8fde\u63a5\u94f6\u884c\u9700\u8981\u7684\u53c2\u6570", new Object[]{bankVersionID});
                    }
                    if (Objects.isNull(propertyConfig = bankMetaDataCollector.getPropertyConfig())) {
                        logger.warn("\u94f6\u884c\u63d2\u4ef6 : {} \u8fd4\u56de\u7684\u63d2\u4ef6\u914d\u7f6e\u4e3a null", new Object[]{bankVersionID});
                    }
                }
                catch (Exception e) {
                    logger.warn("\u94f6\u884c\u63d2\u4ef6\u52a0\u8f7d\u5931\u8d25", new Object[]{e});
                    result = false;
                }
                return result;
            }).forEach(this::dealBankMetaDataCollector);
        }
        logger.info("\u4e1a\u52a1\u63a5\u53e3\u4e2a\u6570 : {}", (Object)this.bizMetas.size());
        this.bizMetas.forEach(meta -> logger.info(meta.toString()));
        logger.info("\u7cfb\u7edf\u63a5\u53e3\u4e2a\u6570 : {}", (Object)this.sysMetas.size());
        this.sysMetas.forEach(meta -> logger.info(meta.toString()));
        if (CollectionUtils.isNotEmpty(this.bankMetaDataCollectorList)) {
            logger.info("\u627e\u5230 {} \u4e2a\u94f6\u884c\u63d2\u4ef6\u5b9e\u73b0", (Object)this.bankMetaDataCollectorList.size());
        } else {
            logger.info("\u627e\u5230 {} \u4e2a\u94f6\u884c\u63d2\u4ef6\u5b9e\u73b0", (Object)"0");
        }
        this.bankVersionMap.keySet().forEach(arg_0 -> ((EBGLogger)logger).info(arg_0));
        logger.info("\u521d\u59cb\u5316\u5b8c\u6210...");
    }

    private void dealAtomicBizMetaCollector(AtomicBizMetaCollector atomicBizMetaCollector) {
        List atomicBizMetas = atomicBizMetaCollector.getAtomicBizMeta();
        if (Objects.nonNull(atomicBizMetas)) {
            atomicBizMetas.forEach(meta -> {
                Preconditions.checkNotNull((Object)meta, (Object)ResManager.loadKDString((String)"\u63a5\u53e3\u5143\u4fe1\u606f\u5bf9\u8c61 AtomicBizMeta \u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BankBundleManager_12", (String)"ebg-note-common", (Object[])new Object[0]));
                Preconditions.checkNotNull((Object)meta.getBizInterface(), (Object)ResManager.loadKDString((String)"\u63a5\u53e3\u5143\u4fe1\u606f\u4e2d \u4e1a\u52a1\u63a5\u53e3 \u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BankBundleManager_13", (String)"ebg-note-common", (Object[])new Object[0]));
                this.bizInterfaceList.add(meta.getBizInterface());
            });
            if (AtomicMetaType.BIZ == atomicBizMetaCollector.type()) {
                this.bizMetas.addAll(atomicBizMetas);
            } else {
                this.sysMetas.addAll(atomicBizMetas);
            }
        }
    }

    private void dealBankMetaDataCollector(BankMetaDataCollector bankMetaDataCollector) {
        BankVersionMetaInfo bankVersionMetaInfo = bankMetaDataCollector.getBankVersionMetaInfo();
        this.dealBankMetaDataCollector(bankMetaDataCollector, bankVersionMetaInfo);
        List metaInfos = bankMetaDataCollector.getBankVersionExtMetaInfos();
        if (metaInfos != null && metaInfos.size() > 0) {
            for (BankVersionMetaInfo info : metaInfos) {
                this.dealBankMetaDataCollector(bankMetaDataCollector, info);
            }
        }
    }

    private void dealBankMetaDataCollector(BankMetaDataCollector bankMetaDataCollector, BankVersionMetaInfo bankVersionMetaInfo) {
        Bank bank;
        String bankShortName = bankVersionMetaInfo.getBankShortName();
        String bankVersionID = bankVersionMetaInfo.getBankVersionID();
        List keyNames = bankVersionMetaInfo.getKeyNames();
        List bizImplClasses = bankMetaDataCollector.getBizImplClasses();
        List batchSeqIDClasses = bankMetaDataCollector.getBatchSeqIDClasses();
        List detailSeqIDClasses = bankMetaDataCollector.getDetailSeqIDClasses();
        List bankLoginConfigs = bankMetaDataCollector.getBankLoginConfig();
        List bankConfigs = bankMetaDataCollector.getBankConfig();
        BankPropertyConfig propertyConfig = bankMetaDataCollector.getPropertyConfig();
        this.bankVersionMapConfig.put(bankVersionID, bankLoginConfigs);
        this.bankPwdCertMapConfig.put(bankVersionID, bankConfigs);
        this.split4SubRange.put(bankVersionID, bankMetaDataCollector.getSplit4SubRange());
        if (Objects.nonNull(propertyConfig)) {
            this.globalPropertyConfig.registryPropertyConfig((PropertyConfig)propertyConfig);
            this.bankVersionMapPropertyConfig.put(bankVersionID, (PropertyConfig)propertyConfig);
        }
        BankVersion bankVersion = new BankVersion();
        bankVersion.setBankLoginConfigs(bankLoginConfigs);
        bankVersion.setBankConfigs(bankConfigs);
        bankVersion.setBankVersionID(bankVersionID);
        bankVersion.setBankName(bankVersionMetaInfo.getBankName());
        bankVersion.setBankVersionMetaInfo(bankVersionMetaInfo);
        bankVersion.setConcurrentCount(bankVersionMetaInfo.getConcurrentCount());
        bankVersion.setBizImplClasses(bizImplClasses);
        bankVersion.setBatchSeqIDClasses(batchSeqIDClasses);
        bankVersion.setDetailSeqIDClasses(detailSeqIDClasses);
        bankVersion.setPropertyConfig((PropertyConfig)propertyConfig);
        bankVersion.setBankVersionName(bankVersionMetaInfo.getBankVersionName());
        bankVersion.setAvailable(true);
        bankVersion.setShowInJdy(bankMetaDataCollector.showInJdy());
        bankVersion.setBankPropertyFunItems(null);
        HashMap implMap = Maps.newHashMap();
        this.bizInterfaceList.forEach(bizInterface -> bizImplClasses.forEach(implClass -> {
            if (bizInterface.isAssignableFrom((Class<?>)implClass)) {
                if (implMap.containsKey(bizInterface)) {
                    List implList = (List)implMap.get(bizInterface);
                    implList.add(implClass);
                } else {
                    ArrayList implList = Lists.newArrayList();
                    implList.add(implClass);
                    implMap.put(bizInterface, implList);
                }
            }
        }));
        bankVersion.setImplMap((Map)implMap);
        this.bankVersionMap.put(bankVersionID, bankVersion);
        if (this.bankMap.containsKey(bankShortName)) {
            bank = this.bankMap.get(bankShortName);
            bank.addBankNameKeyWord(keyNames);
            bank.addBankVersion(bankVersion);
        } else {
            bank = new Bank();
            bank.setBankName(bankVersionMetaInfo.getBankName());
            bank.setBankShortName(bankShortName);
            bank.setBankDescription(bankVersionMetaInfo.getDescription());
            bank.setBankNameKeyWords(keyNames);
            bank.addBankVersion(bankVersion);
            this.bankMap.put(bankShortName, bank);
        }
        for (List implClassList : implMap.values()) {
            this.initBizImpl(implClassList);
        }
    }

    private void initBizImpl(List<Class<? extends IBankService>> implClassList) {
        for (Class<? extends IBankService> implClass : implClassList) {
            if (this.bizImplClass2Impl.containsKey(implClass)) continue;
            try {
                IBankService impl = implClass.newInstance();
                this.bizImplClass2Impl.putIfAbsent(implClass, impl);
            }
            catch (Exception e) {
                logger.warn("\u4e1a\u52a1\u5b9e\u73b0\u7c7b\uff0c\u5b9e\u4f8b\u5316\u5931\u8d25", new Object[]{e});
            }
        }
    }

    public static BankBundleManager getInstance() {
        return (BankBundleManager)SpringContextUtil.getBean(BankBundleManager.class);
    }

    public String getBankShortName(String bankVersionId) {
        for (Map.Entry<String, Bank> entry : this.bankMap.entrySet()) {
            Bank bank = entry.getValue();
            for (BankVersion version : bank.getBankVersions()) {
                if (!version.getBankVersionID().equalsIgnoreCase(bankVersionId)) continue;
                return entry.getKey();
            }
        }
        return null;
    }

    public <T extends IBankService> T getSyncAccountImpl(String bankVersionID, Class<T> bizInterface) {
        if (this.bankVersionMap.containsKey(bankVersionID)) {
            BankVersion bankVersion = this.bankVersionMap.get(bankVersionID);
            List implClassList = (List)bankVersion.getImplMap().get(bizInterface);
            if (Objects.isNull(implClassList) || implClassList.isEmpty()) {
                return null;
            }
            return (T)this.getImpl(bizInterface, implClassList, null);
        }
        return null;
    }

    public <T extends IBankService> T getImplByClassName(String s, Class<T> tClass, String name) {
        if (name == null) {
            throw EBExceiptionUtil.preCheckException((String)String.format(ResManager.loadKDString((String)"s\uff1a%s\u7684\u63a5\u53e3\u5b9e\u73b0\u7c7b\u4e3a\u7a7a\uff0c\u8bf7\u901a\u8fc7\u65e5\u5fd7\u68c0\u67e5", (String)"BankBundleManager_31", (String)"ebg-note-common", (Object[])new Object[0]), s));
        }
        if (this.bankVersionMap.containsKey(s)) {
            BankVersion bankVersion = this.bankVersionMap.get(s);
            List implClassList = (List)bankVersion.getImplMap().get(tClass);
            if (Objects.isNull(implClassList) || implClassList.isEmpty()) {
                throw EBExceiptionUtil.preCheckException((String)String.format(ResManager.loadKDString((String)"s\uff1a%1$s \u94f6\u884c\u4e0d\u652f\u6301\u8be5\u4e1a\u52a1\u63a5\u53e3%2$s\u3002", (String)"BankBundleManager_25", (String)"ebg-note-common", (Object[])new Object[0]), s, tClass.getSimpleName()));
            }
            Class implClass = null;
            implClass = implClassList.stream().filter(impl -> impl.getName().equals(name)).findFirst().orElseThrow(() -> EBExceiptionUtil.preCheckException((String)String.format(ResManager.loadKDString((String)"s\uff1a%1$s \u94f6\u884c\u4e0d\u652f\u6301\u8be5\u4e1a\u52a1\u63a5\u53e3%2$s\u3002", (String)"BankBundleManager_25", (String)"ebg-note-common", (Object[])new Object[0]), s, tClass.getSimpleName())));
            return (T)this.getImpl(implClass);
        }
        throw EBExceiptionUtil.preCheckException((String)String.format(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u7684 s\uff1a%s\u3002", (String)"BankBundleManager_26", (String)"ebg-note-common", (Object[])new Object[0]), s));
    }

    public <T extends IBankServiceDesc> T getImplOrNull(String bankVersionID, Class<T> bizInterface) {
        if (this.bankVersionMap.containsKey(bankVersionID)) {
            BankVersion bankVersion = this.bankVersionMap.get(bankVersionID);
            List implClassList = (List)bankVersion.getImplMap().get(bizInterface);
            if (Objects.isNull(implClassList) || implClassList.isEmpty()) {
                return null;
            }
            return (T)this.getImpl((Class)implClassList.get(0));
        }
        throw EBExceiptionUtil.preCheckException((String)String.format(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u7684 bankVersionID\uff1a%s\u3002", (String)"BankBundleManager_27", (String)"ebg-note-common", (Object[])new Object[0]), bankVersionID));
    }

    public String getBankSplit(String bankVersionID) {
        if (this.split4SubRange.containsKey(bankVersionID)) {
            return this.split4SubRange.get(bankVersionID);
        }
        return ",";
    }

    public <T extends IBankServiceDesc> T getBatchSeqIdImplOrNull(String bankVersionID) {
        if (this.bankVersionMap.containsKey(bankVersionID)) {
            BankVersion bankVersion = this.bankVersionMap.get(bankVersionID);
            List implClassList = bankVersion.getBatchSeqIDClasses();
            if (Objects.isNull(implClassList) || implClassList.isEmpty()) {
                return null;
            }
            IBankBatchSeqIDCreator impl = null;
            try {
                impl = (IBankBatchSeqIDCreator)((Class)implClassList.get(0)).newInstance();
            }
            catch (Exception e) {
                logger.warn("\u4e1a\u52a1\u5b9e\u73b0\u7c7b\uff0c\u5b9e\u4f8b\u5316\u5931\u8d25", new Object[]{e});
            }
            return (T)impl;
        }
        throw EBExceiptionUtil.preCheckException((String)String.format(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u7684 bankVersionID\uff1a%s\u3002", (String)"BankBundleManager_27", (String)"ebg-note-common", (Object[])new Object[0]), bankVersionID));
    }

    public <T extends IBankServiceDesc> T getDetailSeqIdImplOrNull(String bankVersionID) {
        if (this.bankVersionMap.containsKey(bankVersionID)) {
            BankVersion bankVersion = this.bankVersionMap.get(bankVersionID);
            List implClassList = bankVersion.getDetailSeqIDClasses();
            if (Objects.isNull(implClassList) || implClassList.isEmpty()) {
                return null;
            }
            IBankDetailSeqIDCreator impl = null;
            try {
                impl = (IBankDetailSeqIDCreator)((Class)implClassList.get(0)).newInstance();
            }
            catch (Exception e) {
                logger.warn("\u4e1a\u52a1\u5b9e\u73b0\u7c7b\uff0c\u5b9e\u4f8b\u5316\u5931\u8d25", new Object[]{e});
            }
            return (T)impl;
        }
        throw EBExceiptionUtil.preCheckException((String)String.format(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u7684 bankVersionID\uff1a%s\u3002", (String)"BankBundleManager_27", (String)"ebg-note-common", (Object[])new Object[0]), bankVersionID));
    }

    public List<BankLoginConfig> getBankLoginConfig(String bankVersionID) {
        return this.bankVersionMapConfig.get(bankVersionID);
    }

    public List<BankConfig> getBankConfig(String bankVersionID) {
        return this.bankPwdCertMapConfig.get(bankVersionID);
    }

    public IBankService getImpl(Class<? extends IBankService> implClass) {
        if (this.bizImplClass2Impl.containsKey(implClass)) {
            return this.bizImplClass2Impl.get(implClass);
        }
        IBankService impl = null;
        try {
            impl = implClass.newInstance();
        }
        catch (Exception e) {
            logger.warn("\u4e1a\u52a1\u5b9e\u73b0\u7c7b\uff0c\u5b9e\u4f8b\u5316\u5931\u8d25", new Object[]{e});
        }
        this.bizImplClass2Impl.putIfAbsent(implClass, impl);
        return impl;
    }

    private boolean routeMatch(Object request, BankInterfaceRoute route) {
        boolean result = true;
        if (Objects.nonNull(route.getSubBizMatchValue())) {
            result = result && RouteMatchType.getMatchType(route.getSubBizMatchType()).match(route.getSubBizMatchValue(), FieldUtils.getFieldValue((Object)request, (String)"subBizType"));
        } else if (Objects.nonNull(route.getUseMatchValue())) {
            result = result && RouteMatchType.getMatchType(route.getUseMatchType()).match(route.getUseMatchValue(), FieldUtils.getFieldValue((Object)request, (String)"use"));
        } else {
            boolean bl = result = result && RouteMatchType.getMatchType(route.getExplanationMatchType()).match(route.getExplanationMatchValue(), FieldUtils.getFieldValue((Object)request, (String)"explanation"));
        }
        if (Objects.nonNull(route.getExtData())) {
            List routeMetas = JsonUtil.json2Array((String)route.getExtData(), RouteMeta.class);
            for (RouteMeta meta : routeMetas) {
                result = result && RouteMatchType.getMatchType(meta.getMatchType()).match(meta.getMatchFieldValue(), FieldUtils.getFieldValue((Object)request, (String)meta.getMatchFieldName()));
            }
        }
        return result;
    }

    public IBankService getImpl(Class<?> interfaceClass, List<Class<? extends IBankService>> implClassList, Object request) {
        if (implClassList.size() == 1) {
            return this.getImpl(implClassList.get(0));
        }
        String customID = EBContext.getContext().getCustomID();
        String bankVersionID = EBContext.getContext().getBankVersionID();
        BankInterfaceRoute route = this.routeService.getRoute(customID, bankVersionID, interfaceClass.getName());
        IBankService impl = null;
        if (Objects.nonNull(route) && this.routeMatch(request, route)) {
            impl = implClassList.stream().filter(implClass -> implClass.getName().equals(route.getClassName())).findFirst().map(this::getImpl).orElse(null);
        }
        if (Objects.isNull(impl)) {
            this.checkMatchParameterType(interfaceClass, request);
            impl = implClassList.stream().map(this::getImpl).filter(implClassObj -> implClassObj.match(request)).findFirst().orElseThrow(() -> EBExceiptionUtil.preCheckException((String)ResManager.loadKDString((String)"\u6ca1\u6709\u5339\u914d\u7684\u4e1a\u52a1\u5b9e\u73b0\u7c7b\u3002", (String)"BankBundleManager_18", (String)"ebg-note-common", (Object[])new Object[0])));
        }
        return impl;
    }

    private void checkMatchParameterType(Class<?> interfaceClass, Object request) {
        Method[] methods = interfaceClass.getMethods();
        String methodName = "match";
        for (Method method : methods) {
            Class<?> parameterType;
            Class<?>[] parameterTypes;
            if (!"match".equals(method.getName())) continue;
            if (!Objects.nonNull(method) || (parameterTypes = method.getParameterTypes()) == null || parameterTypes.length == 0 || !Objects.nonNull(parameterType = parameterTypes[0])) break;
            Preconditions.checkArgument((boolean)parameterType.isInstance(request), (Object)String.format(ResManager.loadKDString((String)"\u4f20\u5165\u7684\u53c2\u6570\u7c7b\u578b\u4e0d\u6b63\u786e\uff0c\u9884\u671f %1$s\uff0c \u5b9e\u9645 %2$S\u3002", (String)"BankBundleManager_28", (String)"ebg-note-common", (Object[])new Object[0]), parameterType.getSimpleName(), request.getClass().getSimpleName()));
            break;
        }
    }

    public List<String> getBankKeyWords(String bankVersionID) {
        BankVersion bankVersion = this.bankVersionMap.get(bankVersionID);
        if (Objects.nonNull(bankVersion)) {
            return bankVersion.getBankVersionMetaInfo().getKeyNames();
        }
        return Lists.newArrayList();
    }

    public void setBankKeyWords(String bankVersionID, List<String> keyWords) {
        BankVersion bankVersion = this.bankVersionMap.get(bankVersionID);
        bankVersion.getBankVersionMetaInfo().setKeyNames(keyWords);
    }

    public String getBankVersionName(String bankVersionID) {
        BankVersion bankVersion = this.bankVersionMap.get(bankVersionID);
        if (Objects.nonNull(bankVersion)) {
            return bankVersion.getBankVersionName();
        }
        return "";
    }

    public Collection<Bank> getBanks() {
        return this.bankMap.values();
    }

    public Collection<BankVersion> getBankVersions() {
        return this.bankVersionMap.values();
    }

    public List<AtomicBizMeta> getBizMetas() {
        return this.bizMetas;
    }

    public <T extends IBankService> T getImpl(String bankVersionID, Class<T> bizInterface, Object request) {
        if (this.bankVersionMap.containsKey(bankVersionID)) {
            BankVersion bankVersion = this.bankVersionMap.get(bankVersionID);
            List implClassList = (List)bankVersion.getImplMap().get(bizInterface);
            if (Objects.isNull(implClassList) || implClassList.isEmpty()) {
                if (bizInterface.getName().contains("INoteDetailPretreat") || "IPretreat".equals(bizInterface.getSimpleName())) {
                    return null;
                }
                throw EBExceiptionUtil.preCheckException((String)String.format(ResManager.loadKDString((String)"s\uff1a%1$s \u94f6\u884c\u4e0d\u652f\u6301\u8be5\u4e1a\u52a1\u63a5\u53e3%2$s\u3002", (String)"BankBundleManager_25", (String)"ebg-note-common", (Object[])new Object[0]), bankVersionID, bizInterface.getSimpleName()));
            }
            return (T)this.getImpl(bizInterface, implClassList, request);
        }
        throw EBExceiptionUtil.preCheckException((String)String.format(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u7684 bankVersionID\uff1a%s\u3002", (String)"BankBundleManager_27", (String)"ebg-note-common", (Object[])new Object[0]), bankVersionID));
    }
}

