/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.common.framework.properties;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.util.StringUtils;
import kd.ebg.egf.common.annotation.Component;
import kd.ebg.note.common.framework.properties.PropertyChecker;
import kd.ebg.note.common.framework.properties.PropertyConfig;
import kd.ebg.note.common.framework.properties.PropertyConfigItem;
import kd.ebg.note.common.framework.properties.PropertyName;

@Component
public class SystemPropertyConfig
implements PropertyConfig {
    public static final String METHOD_MATCHING = "MATCHING";
    public static final String METHOD_FILTERING = "FILTERING";
    public static final PropertyConfigItem PAYMENT_ALLOW = PropertyConfigItem.builder().key("payment_allow").name(ResManager.loadKDString((String)"\u652f\u4ed8\u901a\u9053\u5f00\u5173", (String)"SystemPropertyConfig_0", (String)"ebg-note-common", (Object[])new Object[0])).desc(ResManager.loadKDString((String)"\u914d\u7f6e\u4e3a'\u5f00'\u65f6,\u652f\u4ed8\u901a\u9053\u5f00\u653e.\u914d\u7f6e\u4e3a'\u5173'\u65f6,\u652f\u4ed8\u901a\u9053\u5173\u95ed.", (String)"SystemPropertyConfig_1", (String)"ebg-note-common", (Object[])new Object[0])).sourceNames(onOffCN).sourceValues(onOffEN).defaultValues(defaultOn).minValueNum(1).maxValueNum(1).checkers(Lists.newArrayList((Object[])new PropertyChecker[]{onOffChecker})).build();
    public static final PropertyConfigItem NOT_PAYMENT_ALLOW = PropertyConfigItem.builder().key("not_payment_allow").name(ResManager.loadKDString((String)"\u975e\u652f\u4ed8\u901a\u9053\u5f00\u5173", (String)"SystemPropertyConfig_2", (String)"ebg-note-common", (Object[])new Object[0])).desc(ResManager.loadKDString((String)"\u914d\u7f6e\u4e3a'\u5f00'\u65f6,\u5176\u4ed6\u901a\u9053\u5f00\u653e.\u914d\u7f6e\u4e3a'\u5173'\u65f6,\u5176\u4ed6\u901a\u9053\u5173\u95ed.", (String)"SystemPropertyConfig_3", (String)"ebg-note-common", (Object[])new Object[0])).sourceNames(onOffCN).sourceValues(onOffEN).defaultValues(defaultOn).minValueNum(1).maxValueNum(1).checkers(Lists.newArrayList((Object[])new PropertyChecker[]{onOffChecker})).build();
    public static final PropertyConfigItem DATECENTER_CHECK = PropertyConfigItem.builder().key("datecenter_check").name(ResManager.loadKDString((String)"\u6570\u636e\u4e2d\u5fc3\u6821\u9a8c", (String)"SystemPropertyConfig_4", (String)"ebg-note-common", (Object[])new Object[0])).desc(ResManager.loadKDString((String)"\u914d\u7f6e\u4e3a'\u5f00'\u65f6,\u6821\u9a8c\u8bf7\u6c42\u7684\u6570\u636e\u4e2d\u5fc3\u6765\u6e90.\u914d\u7f6e\u4e3a'\u5173'\u65f6,\u4e0d\u6821\u9a8c.", (String)"SystemPropertyConfig_5", (String)"ebg-note-common", (Object[])new Object[0])).sourceNames(onOffCN).sourceValues(onOffEN).defaultValues(defaultOff).minValueNum(1).maxValueNum(1).checkers(Lists.newArrayList((Object[])new PropertyChecker[]{onOffChecker})).build();
    public static final PropertyConfigItem ACCESS_MATCHING_METHOD = PropertyConfigItem.builder().key("access_matching_method").name(ResManager.loadKDString((String)"\u8fc7\u6ee4IP\u7684\u89c4\u5219\u3002", (String)"SystemPropertyConfig_6", (String)"ebg-note-common", (Object[])new Object[0])).desc(ResManager.loadKDString((String)"\u8fc7\u6ee4IP\u7684\u89c4\u5219\uff0c\u767d\u540d\u5355\u8868\u793a\u4ec5\u5217\u8868\u4e2d\u7684IP\u53ef\u4ee5\u8bbf\u95ee\uff0c\u9ed1\u540d\u5355\u8868\u793a\u5217\u8868\u4e2d\u7684IP\u4e0d\u53ef\u4ee5\u8bbf\u95ee\u3002", (String)"SystemPropertyConfig_7", (String)"ebg-note-common", (Object[])new Object[0])).sourceNames(Lists.newArrayList((Object[])new String[]{ResManager.loadKDString((String)"\u767d\u540d\u5355", (String)"SystemPropertyConfig_8", (String)"ebg-note-common", (Object[])new Object[0]), ResManager.loadKDString((String)"\u9ed1\u540d\u5355", (String)"SystemPropertyConfig_9", (String)"ebg-note-common", (Object[])new Object[0])})).sourceValues(Lists.newArrayList((Object[])new String[]{"MATCHING", "FILTERING"})).defaultValues(Lists.newArrayList((Object[])new String[]{"MATCHING"})).minValueNum(1).maxValueNum(1).build();
    public static final PropertyConfigItem ACCESS_MATCHING_LIST = PropertyConfigItem.builder().key("access_matching_list").name(ResManager.loadKDString((String)"\u8fc7\u6ee4IP\u5217\u8868", (String)"SystemPropertyConfig_10", (String)"ebg-note-common", (Object[])new Object[0])).desc(ResManager.loadKDString((String)"\u8bbe\u7f6e\u8981\u8fc7\u6ee4\u4f7f\u7528\u7684IP\u5730\u5740\uff0c\u5982\u679c\u8981\u8f93\u5165\u591a\u4e2aIP\u8bf7\u7528;\u6216\u8005\u6362\u884c\u3002\u652f\u6301* \u5339\u914d\uff0c\u4f8b\u5982\uff1a192.168.*.1\uff0c\u5982\u679c\u8981\u5339\u914d\u533a\u95f4\uff0c\u53ef\u4ee5 172.17.5-6.31\u3002", (String)"SystemPropertyConfig_11", (String)"ebg-note-common", (Object[])new Object[0])).minValueNum(0).maxValueNum(20).build();
    public static final PropertyConfigItem DATACENTER_LIST = PropertyConfigItem.builder().key("datacenter_list").name(ResManager.loadKDString((String)"\u5141\u8bb8\u7684\u6570\u636e\u4e2d\u5fc3\u5217\u8868\uff08\u8d26\u5957id\uff09\u3002", (String)"SystemPropertyConfig_12", (String)"ebg-note-common", (Object[])new Object[0])).desc(ResManager.loadKDString((String)"\u5728\u5217\u8868\u4e2d\u7684\u6570\u636e\u4e2d\u5fc3\u624d\u5141\u8bb8\u505a\u4e1a\u52a1\uff0c\u591a\u4e2a\u8bf7\u6362\u884c\u3002", (String)"SystemPropertyConfig_13", (String)"ebg-note-common", (Object[])new Object[0])).minValueNum(0).maxValueNum(20).build();
    public static final PropertyConfigItem QUERYDETAIL_LIST = PropertyConfigItem.builder().key("querydetail_list").name(ResManager.loadKDString((String)"\u5141\u8bb8\u67e5\u8be2\u4ea4\u6613\u660e\u7ec6\u7684\u94f6\u884c\u8d26\u53f7\u3002", (String)"SystemPropertyConfig_14", (String)"ebg-note-common", (Object[])new Object[0])).desc(ResManager.loadKDString((String)"\u5141\u8bb8\u67e5\u8be2\u4ea4\u6613\u660e\u7ec6\u7684\u94f6\u884c\u8d26\u53f7\uff0c\u591a\u4e2a\u8bf7\u6362\u884c\u3002", (String)"SystemPropertyConfig_15", (String)"ebg-note-common", (Object[])new Object[0])).minValueNum(0).maxValueNum(20).build();

    public List<PropertyConfigItem> getAllPropertyConfigItems() {
        return Lists.newArrayList((Object[])new PropertyConfigItem[]{PAYMENT_ALLOW, NOT_PAYMENT_ALLOW, ACCESS_MATCHING_METHOD, ACCESS_MATCHING_LIST, DATACENTER_LIST, DATECENTER_CHECK, QUERYDETAIL_LIST});
    }

    public String getPropertyConfigID() {
        return "common_business";
    }

    public PropertyName getPropertyName() {
        return PropertyName.SYSTEM;
    }

    public String getConfigName() {
        return ResManager.loadKDString((String)"\u7cfb\u7edf\u914d\u7f6e", (String)"SystemPropertyConfig_16", (String)"ebg-note-common", (Object[])new Object[0]);
    }

    public String getConfigDesc() {
        return ResManager.loadKDString((String)"\u7cfb\u7edf\u914d\u7f6e", (String)"SystemPropertyConfig_16", (String)"ebg-note-common", (Object[])new Object[0]);
    }

    public static boolean allowPay() {
        return PAYMENT_ALLOW.getCurrentValueAsBoolean();
    }

    public static boolean allowOtherBiz() {
        return NOT_PAYMENT_ALLOW.getCurrentValueAsBoolean();
    }

    public static boolean isMatchingMode() {
        return METHOD_MATCHING.equalsIgnoreCase(ACCESS_MATCHING_METHOD.getCurrentValue());
    }

    public static List<String> getConfigIpList() {
        return ACCESS_MATCHING_LIST.getCurrentValues();
    }

    public static boolean isDatacenterCheckOpen() {
        return DATECENTER_CHECK.getCurrentValueAsBoolean();
    }

    public static List<String> getDatacenterList() {
        return DATACENTER_LIST.getCurrentValues();
    }

    public static List<String> getQueryDetailList() {
        ArrayList<String> detailAccNoItems = new ArrayList<String>();
        List<String> items = QUERYDETAIL_LIST.getCurrentValues();
        for (int i = 0; i < items.size(); ++i) {
            if (StringUtils.isEmpty((String)items.get(i))) continue;
            detailAccNoItems.add(items.get(i));
        }
        return detailAccNoItems;
    }
}

