/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.common.model.transform;

import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IColumnValuePair;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.ISaveDataTable;
import kd.bos.dataentity.metadata.ISaveMetaRow;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDException;
import kd.bos.orm.datamanager.DataManagerUtils;
import kd.bos.orm.datamanager.IDataManager;
import kd.bos.orm.datamanager.SaveDataSet;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.DTFactoryUtil;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.note.common.model.NotePayableInfo;
import kd.ebg.note.common.model.transform.BatchUpdateCollector;

public class NotePayableTransFormer {
    EBGLogger log = EBGLogger.getInstance().getLogger(NotePayableTransFormer.class);
    private static NotePayableTransFormer instance;
    private final String PAYABLE_ENTITY = "note_payable";
    public static final String SELECT_ALL_PROPERTIES = "status,id,ebg_id,version,custom_id,bank_version_id,bank_login_id,biz_type,sub_biz_type,impl_class_name,query_impl_class_name,package_key,total_count,total_amount,batch_seq_id,detail_seq_id,detail_biz_no,insert_batch_seq,insert_time,request_seq,request_time,update_time,update_batch_seq,update_operation,bill_no,amount,currency,draft_type,transfer_flag,keep_flag,contract_no,invoice_no,contract_obj,auto_accept,auto_receive,booking_date,due_date,issue_date,note_status,other_info,operation_code,operation_name,explanation,drawer_acc_no,drawer_acc_name,drawer_bank_cnaps,drawer_bank_name,drawer_bank_address,drawer_acc_country,drawer_acc_province,drawer_acc_city,drawer_ratings,drawer_agency,drawer_due_date,acceptor_acc_no,acceptor_acc_name,acceptor_bank_cnaps,acceptor_bank_name,acceptor_bank_address,acceptor_acc_country,acceptor_acc_province,acceptor_acc_city,payee_acc_no,payee_acc_name,payee_bank_name,payee_bank_cnaps,payee_bank_address,payee_country,payee_province,payee_city,status_name,status_msg,bank_status,bank_msg,error_msg,bak_status,bak_status_name,bak_status_msg,bak_bank_status,bak_bank_msg,bak_error_msg,package_time,bank_batch_seq_id,bank_detail_seq_id,bank_serial_no,last_submit_time,last_submit_request_seq,submit_count,submit_success_time,last_sync_time,last_sync_request_seq,sync_count,pay_finish_time,to_give_up,obssid,query_type,sequence,reserved2,reserved3,reserved4,reserved1,rqstserialno,rspserialno,isnewecds,grdbag,startno,endno,cirstatus,bankrefdate,bankrefkey,subrange,totalsize,isacceptsamebank,ispayeesamebank ,draftamount,batchtotalamount,isrefuse,acceptor_org,payee_org,balbizno,balcontractno,baleac,baleacname,balamount,balrate,balterm,baltermunit,isonlinebal,acpflg,acpfer,baltyp,balepayac,balepayacname,balcurrency,bankbatchcount,filelist_tag";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NotePayableTransFormer getInstance() {
        Class<NotePayableTransFormer> clazz = NotePayableTransFormer.class;
        synchronized (NotePayableTransFormer.class) {
            if (instance == null) {
                instance = new NotePayableTransFormer();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public DynamicObject transNotePayable(DynamicObject dynamicObject, NotePayableInfo info) {
        Date due;
        LocalDate nowLocal;
        if (dynamicObject == null) {
            dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"note_payable");
        } else {
            dynamicObject.set("id", (Object)info.getId());
        }
        dynamicObject.set("custom_id", (Object)info.getCustomID());
        dynamicObject.set("status", (Object)info.getStatus());
        dynamicObject.set("ebg_id", (Object)info.getEbgID());
        if (info.getVersion() == null) {
            info.setVersion(1);
        }
        dynamicObject.set("version", (Object)info.getVersion());
        dynamicObject.set("bank_version_id", (Object)info.getBankVersionID());
        dynamicObject.set("bank_login_id", (Object)info.getBankLoginID());
        dynamicObject.set("biz_type", (Object)info.getBizType());
        dynamicObject.set("sub_biz_type", (Object)info.getSubBizType());
        dynamicObject.set("impl_class_name", (Object)info.getImplClassName());
        dynamicObject.set("query_impl_class_name", (Object)info.getQueryImplClassName());
        dynamicObject.set("package_key", (Object)info.getPackageKey());
        dynamicObject.set("total_count", (Object)info.getTotalCount());
        dynamicObject.set("total_amount", (Object)info.getTotalAmount());
        dynamicObject.set("batch_seq_id", (Object)info.getBatchSeqId());
        dynamicObject.set("detail_seq_id", (Object)info.getDetailSeqId());
        dynamicObject.set("detail_biz_no", (Object)info.getDetailBizNo());
        dynamicObject.set("insert_batch_seq", (Object)info.getInsertBatchSeq());
        if (info.getInsertTime() != null) {
            Date InsertTime = Date.from(info.getInsertTime().atZone(ZoneId.systemDefault()).toInstant());
            dynamicObject.set("insert_time", (Object)InsertTime);
        }
        dynamicObject.set("request_seq", (Object)info.getRequestSeq());
        if (info.getRequestTime() != null) {
            Date requestTime = Date.from(info.getRequestTime().atZone(ZoneId.systemDefault()).toInstant());
            dynamicObject.set("request_time", (Object)requestTime);
        }
        if (info.getUpdateTime() != null) {
            Date UpdateTime = Date.from(info.getUpdateTime().atZone(ZoneId.systemDefault()).toInstant());
            dynamicObject.set("update_time", (Object)UpdateTime);
        }
        dynamicObject.set("update_batch_seq", (Object)info.getUpdateBatchSeq());
        dynamicObject.set("update_operation", (Object)info.getUpdateOperation());
        dynamicObject.set("bill_no", (Object)info.getBillNo());
        dynamicObject.set("amount", (Object)info.getAmount());
        dynamicObject.set("currency", (Object)info.getCurrency());
        dynamicObject.set("draft_type", (Object)info.getDraftType());
        dynamicObject.set("transfer_flag", (Object)info.getTransferFlag());
        dynamicObject.set("keep_flag", (Object)info.getKeepFlag());
        dynamicObject.set("contract_no", (Object)info.getContractNo());
        dynamicObject.set("invoice_no", (Object)info.getInvoiceNo());
        dynamicObject.set("contract_obj", (Object)info.getContractObj());
        dynamicObject.set("auto_accept", (Object)info.getAutoAccept());
        dynamicObject.set("auto_receive", (Object)info.getAutoReceive());
        if (info.getBookingDate() != null) {
            nowLocal = info.getBookingDate();
            due = Date.from(nowLocal.atStartOfDay(ZoneOffset.ofHours(8)).toInstant());
            dynamicObject.set("booking_date", (Object)due);
        }
        if (info.getDueDate() != null) {
            nowLocal = info.getDueDate();
            due = Date.from(nowLocal.atStartOfDay(ZoneOffset.ofHours(8)).toInstant());
            dynamicObject.set("due_date", (Object)due);
        }
        if (info.getIssueDate() != null) {
            nowLocal = info.getIssueDate();
            due = Date.from(nowLocal.atStartOfDay(ZoneOffset.ofHours(8)).toInstant());
            dynamicObject.set("issue_date", (Object)due);
        }
        dynamicObject.set("note_status", (Object)info.getNoteStatus());
        dynamicObject.set("other_info", (Object)info.getOtherInfo());
        dynamicObject.set("operation_code", (Object)info.getOperationCode());
        dynamicObject.set("operation_name", (Object)info.getOperationName());
        dynamicObject.set("explanation", (Object)info.getExplanation());
        dynamicObject.set("drawer_acc_no", (Object)info.getDrawerAccNo());
        dynamicObject.set("drawer_acc_name", (Object)info.getDrawerAccName());
        dynamicObject.set("drawer_bank_cnaps", (Object)info.getDrawerBankCnaps());
        dynamicObject.set("drawer_bank_name", (Object)info.getDrawerBankName());
        dynamicObject.set("drawer_bank_address", (Object)info.getDrawerBankAddress());
        dynamicObject.set("drawer_acc_country", (Object)info.getDrawerAccCountry());
        dynamicObject.set("drawer_acc_province", (Object)info.getDrawerAccProvince());
        dynamicObject.set("drawer_acc_city", (Object)info.getDrawerAccCity());
        dynamicObject.set("drawer_ratings", (Object)info.getDrawerCreditRatings());
        dynamicObject.set("drawer_agency", (Object)info.getDrawerCreditRatingsAgency());
        if (info.getDrawerCreditRatingsDueDate() != null) {
            nowLocal = info.getDrawerCreditRatingsDueDate();
            due = Date.from(nowLocal.atStartOfDay(ZoneOffset.ofHours(8)).toInstant());
            dynamicObject.set("drawer_due_date", (Object)due);
        }
        dynamicObject.set("acceptor_acc_no", (Object)info.getAcceptorAccNo());
        dynamicObject.set("acceptor_acc_name", (Object)info.getAcceptorAccName());
        dynamicObject.set("acceptor_bank_cnaps", (Object)info.getAcceptorBankCnaps());
        dynamicObject.set("acceptor_bank_name", (Object)info.getAcceptorBankName());
        dynamicObject.set("acceptor_bank_address", (Object)info.getAcceptorBankAddress());
        dynamicObject.set("acceptor_acc_country", (Object)info.getAcceptorAccCountry());
        dynamicObject.set("acceptor_acc_province", (Object)info.getAcceptorAccProvince());
        dynamicObject.set("acceptor_acc_city", (Object)info.getAcceptorAccCity());
        dynamicObject.set("payee_acc_no", (Object)info.getPayeeAccNo());
        dynamicObject.set("payee_acc_name", (Object)info.getPayeeAccName());
        dynamicObject.set("payee_bank_name", (Object)info.getPayeeBankName());
        dynamicObject.set("payee_bank_cnaps", (Object)info.getPayeeBankCnaps());
        dynamicObject.set("payee_bank_address", (Object)info.getPayeeBankAddress());
        dynamicObject.set("payee_country", (Object)info.getPayeeCountry());
        dynamicObject.set("payee_province", (Object)info.getPayeeProvince());
        dynamicObject.set("payee_city", (Object)info.getPayeeCity());
        dynamicObject.set("status_name", (Object)info.getStatusName());
        dynamicObject.set("status_msg", (Object)info.getStatusMsg());
        dynamicObject.set("bank_status", (Object)info.getBankStatus());
        dynamicObject.set("bank_msg", (Object)info.getBankMsg());
        dynamicObject.set("error_msg", (Object)info.getErrorMsg());
        dynamicObject.set("bak_status", (Object)info.getBakStatus());
        dynamicObject.set("bak_status_name", (Object)info.getBakStatusName());
        dynamicObject.set("bak_status_msg", (Object)info.getBakStatusMsg());
        dynamicObject.set("bak_bank_status", (Object)info.getBakBankStatus());
        dynamicObject.set("bak_bank_msg", (Object)info.getBakBankMsg());
        dynamicObject.set("bak_error_msg", (Object)info.getBakErrorMsg());
        if (info.getPackageTime() != null) {
            Date PackageTime = Date.from(info.getPackageTime().atZone(ZoneId.systemDefault()).toInstant());
            dynamicObject.set("package_time", (Object)PackageTime);
        }
        dynamicObject.set("bank_batch_seq_id", (Object)info.getBankBatchSeqId());
        dynamicObject.set("bank_detail_seq_id", (Object)info.getBankDetailSeqId());
        dynamicObject.set("bank_serial_no", (Object)info.getBankSerialNo());
        if (info.getLastSubmitTime() != null) {
            Date LastSubmitTime = Date.from(info.getLastSubmitTime().atZone(ZoneId.systemDefault()).toInstant());
            dynamicObject.set("last_submit_time", (Object)LastSubmitTime);
        }
        dynamicObject.set("last_submit_request_seq", (Object)info.getLastSubmitRequestSeq());
        dynamicObject.set("submit_count", (Object)info.getSubmitCount());
        if (info.getSubmitSuccessTime() != null) {
            Date ubmitSuccessTime = Date.from(info.getSubmitSuccessTime().atZone(ZoneId.systemDefault()).toInstant());
            dynamicObject.set("submit_success_time", (Object)ubmitSuccessTime);
        }
        if (info.getLastSyncTime() != null) {
            Date LastSyncTime = Date.from(info.getLastSyncTime().atZone(ZoneId.systemDefault()).toInstant());
            dynamicObject.set("last_sync_time", (Object)LastSyncTime);
        }
        dynamicObject.set("last_sync_request_seq", (Object)info.getLastSyncRequestSeq());
        dynamicObject.set("sync_count", (Object)info.getSyncCount());
        if (info.getPayFinishTime() != null) {
            Date PayFinishTime = Date.from(info.getPayFinishTime().atZone(ZoneId.systemDefault()).toInstant());
            dynamicObject.set("pay_finish_time", (Object)PayFinishTime);
        }
        dynamicObject.set("to_give_up", (Object)info.getToGiveUp());
        dynamicObject.set("obssid", (Object)info.getObssid());
        dynamicObject.set("query_type", (Object)info.getQueryType());
        dynamicObject.set("sequence", (Object)info.getSequence());
        dynamicObject.set("reserved2", (Object)info.getReserved2());
        dynamicObject.set("reserved3", (Object)info.getReserved3());
        dynamicObject.set("reserved4", (Object)info.getReserved4());
        dynamicObject.set("reserved1", (Object)info.getReserved1());
        dynamicObject.set("rqstserialno", (Object)info.getRqstserialno());
        dynamicObject.set("rspserialno", (Object)info.getRspserialno());
        dynamicObject.set("isnewecds", (Object)info.getIsNewECDS());
        dynamicObject.set("grdbag", (Object)info.getGrdBag());
        dynamicObject.set("startno", (Object)info.getStartNo());
        dynamicObject.set("endno", (Object)info.getEndNo());
        dynamicObject.set("cirstatus", (Object)info.getCirStatus());
        dynamicObject.set("bankrefdate", (Object)info.getBankRefDate());
        dynamicObject.set("bankrefkey", (Object)info.getBankRefKey());
        dynamicObject.set("subrange", (Object)info.getSubRange());
        dynamicObject.set("totalsize", (Object)info.getTotalSize());
        dynamicObject.set("isacceptsamebank", (Object)info.getIsAcceptSameBank());
        dynamicObject.set("ispayeesamebank", (Object)info.getIsPayeeSameBank());
        dynamicObject.set("draftamount", (Object)info.getDraftAmount());
        dynamicObject.set("batchtotalamount", (Object)info.getBatchTotalAmount());
        dynamicObject.set("isrefuse", (Object)info.getIsRefuse());
        dynamicObject.set("acceptor_org", (Object)info.getAcceptorOrg());
        dynamicObject.set("payee_org", (Object)info.getPayeeOrg());
        dynamicObject.set("balbizno", (Object)info.getBalBizNo());
        dynamicObject.set("balcontractno", (Object)info.getBalContractNo());
        dynamicObject.set("baleac", (Object)info.getBalEac());
        dynamicObject.set("baleacname", (Object)info.getBalEacName());
        dynamicObject.set("balamount", (Object)info.getBalAmount());
        dynamicObject.set("balrate", (Object)info.getBalRate());
        dynamicObject.set("balterm", (Object)info.getBalTerm());
        dynamicObject.set("baltermunit", (Object)info.getBalTermUnit());
        dynamicObject.set("isonlinebal", (Object)info.getIsOnlineBal());
        dynamicObject.set("acpflg", (Object)info.getAcpFlg());
        dynamicObject.set("acpfer", (Object)info.getAcpFer());
        dynamicObject.set("baltyp", (Object)info.getBalTyp());
        dynamicObject.set("balepayac", (Object)info.getBalEpayAc());
        dynamicObject.set("balepayacname", (Object)info.getBalEpayAcName());
        dynamicObject.set("balcurrency", (Object)info.getBalCurrency());
        dynamicObject.set("bankbatchcount", (Object)info.getBankBatchCount());
        if (StringUtils.isNotEmpty((String)info.getFileListTag())) {
            dynamicObject.set("filelist_tag", (Object)info.getFileListTag());
        }
        return dynamicObject;
    }

    public DynamicObject transNotePayable(NotePayableInfo info) {
        return this.transNotePayable(null, info);
    }

    public NotePayableInfo packNotePayable(DynamicObject dynamicObject) {
        NotePayableInfo notePayableInfo = new NotePayableInfo();
        String time = "";
        notePayableInfo.setId(dynamicObject.getLong("id"));
        notePayableInfo.setStatus(dynamicObject.getInt("status"));
        notePayableInfo.setEbgID(dynamicObject.getString("ebg_id"));
        notePayableInfo.setVersion(dynamicObject.getInt("version"));
        notePayableInfo.setCustomID(dynamicObject.getString("custom_id"));
        notePayableInfo.setBankVersionID(dynamicObject.getString("bank_version_id"));
        notePayableInfo.setBankLoginID(dynamicObject.getString("bank_login_id"));
        notePayableInfo.setBizType(dynamicObject.getString("biz_type"));
        notePayableInfo.setSubBizType(dynamicObject.getString("sub_biz_type"));
        notePayableInfo.setImplClassName(dynamicObject.getString("impl_class_name"));
        notePayableInfo.setQueryImplClassName(dynamicObject.getString("query_impl_class_name"));
        notePayableInfo.setPackageKey(dynamicObject.getString("package_key"));
        notePayableInfo.setTotalCount(dynamicObject.getInt("total_count"));
        notePayableInfo.setTotalAmount(dynamicObject.getBigDecimal("total_amount"));
        notePayableInfo.setBatchSeqId(dynamicObject.getString("batch_seq_id"));
        notePayableInfo.setDetailSeqId(dynamicObject.getString("detail_seq_id"));
        notePayableInfo.setDetailBizNo(dynamicObject.getString("detail_biz_no"));
        notePayableInfo.setInsertBatchSeq(dynamicObject.getString("insert_batch_seq"));
        time = dynamicObject.getString("insert_time");
        if (!this.isEmpty(time)) {
            notePayableInfo.setInsertTime(DTFactoryUtil.parseDateTime((String)time));
        }
        notePayableInfo.setRequestSeq(dynamicObject.getString("request_seq"));
        time = dynamicObject.getString("request_time");
        if (!this.isEmpty(time)) {
            notePayableInfo.setRequestTime(DTFactoryUtil.parseDateTime((String)time));
        }
        if (!this.isEmpty(time = dynamicObject.getString("update_time"))) {
            notePayableInfo.setUpdateTime(DTFactoryUtil.parseDateTime((String)time));
        }
        notePayableInfo.setUpdateBatchSeq(dynamicObject.getString("update_batch_seq"));
        notePayableInfo.setUpdateOperation(dynamicObject.getString("update_operation"));
        notePayableInfo.setBillNo(dynamicObject.getString("bill_no"));
        notePayableInfo.setAmount(dynamicObject.getBigDecimal("amount"));
        notePayableInfo.setCurrency(dynamicObject.getString("currency"));
        notePayableInfo.setDraftType(dynamicObject.getString("draft_type"));
        notePayableInfo.setTransferFlag(dynamicObject.getString("transfer_flag"));
        notePayableInfo.setKeepFlag(dynamicObject.getString("keep_flag"));
        notePayableInfo.setContractNo(dynamicObject.getString("contract_no"));
        notePayableInfo.setInvoiceNo(dynamicObject.getString("invoice_no"));
        notePayableInfo.setContractObj(dynamicObject.getString("contract_obj"));
        notePayableInfo.setAutoAccept(dynamicObject.getString("auto_accept"));
        notePayableInfo.setAutoReceive(dynamicObject.getString("auto_receive"));
        time = dynamicObject.getString("booking_date");
        if (!this.isEmpty(time)) {
            notePayableInfo.setBookingDate(DTFactoryUtil.parseDate((String)time));
        }
        if (!this.isEmpty(time = dynamicObject.getString("due_date"))) {
            notePayableInfo.setDueDate(DTFactoryUtil.parseDate((String)time));
        }
        if (!this.isEmpty(time = dynamicObject.getString("issue_date"))) {
            notePayableInfo.setIssueDate(DTFactoryUtil.parseDate((String)time));
        }
        notePayableInfo.setNoteStatus(dynamicObject.getString("note_status"));
        notePayableInfo.setOtherInfo(dynamicObject.getString("other_info"));
        notePayableInfo.setOperationCode(dynamicObject.getString("operation_code"));
        notePayableInfo.setOperationName(dynamicObject.getString("operation_name"));
        notePayableInfo.setExplanation(dynamicObject.getString("explanation"));
        notePayableInfo.setDrawerAccNo(dynamicObject.getString("drawer_acc_no"));
        notePayableInfo.setDrawerAccName(dynamicObject.getString("drawer_acc_name"));
        notePayableInfo.setDrawerBankCnaps(dynamicObject.getString("drawer_bank_cnaps"));
        notePayableInfo.setDrawerBankName(dynamicObject.getString("drawer_bank_name"));
        notePayableInfo.setDrawerBankAddress(dynamicObject.getString("drawer_bank_address"));
        notePayableInfo.setDrawerAccCountry(dynamicObject.getString("drawer_acc_country"));
        notePayableInfo.setDrawerAccProvince(dynamicObject.getString("drawer_acc_province"));
        notePayableInfo.setDrawerAccCity(dynamicObject.getString("drawer_acc_city"));
        notePayableInfo.setDrawerCreditRatings(dynamicObject.getString("drawer_ratings"));
        notePayableInfo.setDrawerCreditRatingsAgency(dynamicObject.getString("drawer_agency"));
        time = dynamicObject.getString("drawer_due_date");
        if (!this.isEmpty(time)) {
            notePayableInfo.setDrawerCreditRatingsDueDate(DTFactoryUtil.parseDate((String)time));
        }
        notePayableInfo.setAcceptorAccNo(dynamicObject.getString("acceptor_acc_no"));
        notePayableInfo.setAcceptorAccName(dynamicObject.getString("acceptor_acc_name"));
        notePayableInfo.setAcceptorBankCnaps(dynamicObject.getString("acceptor_bank_cnaps"));
        notePayableInfo.setAcceptorBankName(dynamicObject.getString("acceptor_bank_name"));
        notePayableInfo.setAcceptorBankAddress(dynamicObject.getString("acceptor_bank_address"));
        notePayableInfo.setAcceptorAccCountry(dynamicObject.getString("acceptor_acc_country"));
        notePayableInfo.setAcceptorAccProvince(dynamicObject.getString("acceptor_acc_province"));
        notePayableInfo.setAcceptorAccCity(dynamicObject.getString("acceptor_acc_city"));
        notePayableInfo.setPayeeAccNo(dynamicObject.getString("payee_acc_no"));
        notePayableInfo.setPayeeAccName(dynamicObject.getString("payee_acc_name"));
        notePayableInfo.setPayeeBankName(dynamicObject.getString("payee_bank_name"));
        notePayableInfo.setPayeeBankCnaps(dynamicObject.getString("payee_bank_cnaps"));
        notePayableInfo.setPayeeBankAddress(dynamicObject.getString("payee_bank_address"));
        notePayableInfo.setPayeeCountry(dynamicObject.getString("payee_country"));
        notePayableInfo.setPayeeProvince(dynamicObject.getString("payee_province"));
        notePayableInfo.setPayeeCity(dynamicObject.getString("payee_city"));
        notePayableInfo.setStatusName(dynamicObject.getString("status_name"));
        notePayableInfo.setStatusMsg(dynamicObject.getString("status_msg"));
        notePayableInfo.setBankStatus(dynamicObject.getString("bank_status"));
        notePayableInfo.setBankMsg(dynamicObject.getString("bank_msg"));
        notePayableInfo.setErrorMsg(dynamicObject.getString("error_msg"));
        notePayableInfo.setBakStatus(dynamicObject.getInt("bak_status"));
        notePayableInfo.setBakStatusName(dynamicObject.getString("bak_status_name"));
        notePayableInfo.setBakStatusMsg(dynamicObject.getString("bak_status_msg"));
        notePayableInfo.setBakBankStatus(dynamicObject.getString("bak_bank_status"));
        notePayableInfo.setBakBankMsg(dynamicObject.getString("bak_bank_msg"));
        notePayableInfo.setBakErrorMsg(dynamicObject.getString("bak_error_msg"));
        time = dynamicObject.getString("package_time");
        if (!this.isEmpty(time)) {
            notePayableInfo.setPackageTime(DTFactoryUtil.parseDateTime((String)time));
        }
        notePayableInfo.setBankBatchSeqId(dynamicObject.getString("bank_batch_seq_id"));
        notePayableInfo.setBankDetailSeqId(dynamicObject.getString("bank_detail_seq_id"));
        notePayableInfo.setBankSerialNo(dynamicObject.getString("bank_serial_no"));
        time = dynamicObject.getString("last_submit_time");
        if (!this.isEmpty(time)) {
            notePayableInfo.setLastSubmitTime(DTFactoryUtil.parseDateTime((String)time));
        }
        notePayableInfo.setLastSubmitRequestSeq(dynamicObject.getString("last_submit_request_seq"));
        notePayableInfo.setSubmitCount(dynamicObject.getInt("submit_count"));
        time = dynamicObject.getString("submit_success_time");
        if (!this.isEmpty(time)) {
            notePayableInfo.setSubmitSuccessTime(DTFactoryUtil.parseDateTime((String)time));
        }
        if (!this.isEmpty(time = dynamicObject.getString("last_sync_time"))) {
            notePayableInfo.setLastSyncTime(DTFactoryUtil.parseDateTime((String)time));
        }
        notePayableInfo.setLastSyncRequestSeq(dynamicObject.getString("last_sync_request_seq"));
        notePayableInfo.setSyncCount(dynamicObject.getInt("sync_count"));
        time = dynamicObject.getString("pay_finish_time");
        if (!this.isEmpty(time)) {
            notePayableInfo.setPayFinishTime(DTFactoryUtil.parseDateTime((String)time));
        }
        notePayableInfo.setToGiveUp(dynamicObject.getString("to_give_up"));
        notePayableInfo.setObssid(dynamicObject.getString("obssid"));
        notePayableInfo.setQueryType(dynamicObject.getString("query_type"));
        notePayableInfo.setSequence(dynamicObject.getString("sequence"));
        notePayableInfo.setReserved2(dynamicObject.getString("reserved2"));
        notePayableInfo.setReserved3(dynamicObject.getString("reserved3"));
        notePayableInfo.setReserved4(dynamicObject.getString("reserved4"));
        notePayableInfo.setReserved1(dynamicObject.getString("reserved1"));
        notePayableInfo.setRqstserialno(dynamicObject.getString("rqstserialno"));
        notePayableInfo.setRspserialno(dynamicObject.getString("rspserialno"));
        notePayableInfo.setIsNewECDS(dynamicObject.getString("isnewecds"));
        notePayableInfo.setGrdBag(dynamicObject.getString("grdbag"));
        notePayableInfo.setStartNo(dynamicObject.getString("startno"));
        notePayableInfo.setEndNo(dynamicObject.getString("endno"));
        notePayableInfo.setCirStatus(dynamicObject.getString("cirstatus"));
        notePayableInfo.setBankRefKey(dynamicObject.getString("bankrefkey"));
        notePayableInfo.setBankRefDate(dynamicObject.getString("bankrefdate"));
        notePayableInfo.setSubRange(dynamicObject.getString("subrange"));
        notePayableInfo.setTotalSize(dynamicObject.getInt("totalsize"));
        notePayableInfo.setIsAcceptSameBank(dynamicObject.getString("isacceptsamebank"));
        notePayableInfo.setIsPayeeSameBank(dynamicObject.getString("ispayeesamebank"));
        notePayableInfo.setDraftAmount(dynamicObject.getBigDecimal("draftamount"));
        notePayableInfo.setBatchTotalAmount(dynamicObject.getBigDecimal("batchtotalamount"));
        notePayableInfo.setIsRefuse(dynamicObject.getString("isrefuse"));
        notePayableInfo.setAcceptorOrg(dynamicObject.getString("acceptor_org"));
        notePayableInfo.setPayeeOrg(dynamicObject.getString("payee_org"));
        String balamount = dynamicObject.getString("balamount");
        if (!"0".equals(balamount)) {
            notePayableInfo.setBalAmount(dynamicObject.getBigDecimal("balamount"));
        }
        notePayableInfo.setBalBizNo(dynamicObject.getString("balbizno"));
        notePayableInfo.setBalContractNo(dynamicObject.getString("balcontractno"));
        notePayableInfo.setBalEac(dynamicObject.getString("baleac"));
        notePayableInfo.setBalEacName(dynamicObject.getString("baleacname"));
        notePayableInfo.setBalRate(dynamicObject.getString("balrate"));
        notePayableInfo.setBalTerm(dynamicObject.getString("balterm"));
        notePayableInfo.setBalTermUnit(dynamicObject.getString("baltermunit"));
        notePayableInfo.setIsOnlineBal(dynamicObject.getString("isonlinebal"));
        notePayableInfo.setAcpFlg(dynamicObject.getString("acpflg"));
        notePayableInfo.setAcpFer(dynamicObject.getString("acpfer"));
        notePayableInfo.setBalTyp(dynamicObject.getString("baltyp"));
        notePayableInfo.setBalEpayAc(dynamicObject.getString("balepayac"));
        notePayableInfo.setBalEpayAcName(dynamicObject.getString("balepayacname"));
        notePayableInfo.setBalCurrency(dynamicObject.getString("balcurrency"));
        notePayableInfo.setBankBatchCount(dynamicObject.getInt("bankbatchcount"));
        notePayableInfo.setFileListTag(dynamicObject.getString("filelist_tag"));
        return notePayableInfo;
    }

    private boolean isEmpty(String str) {
        return str == null || str.length() == 0;
    }

    public BatchUpdateCollector getBatchUpdateCollector(SaveDataSet saveDataSet) {
        BatchUpdateCollector batchUpdateCollector = new BatchUpdateCollector();
        ArrayList<Object[]> parasList = new ArrayList<Object[]>();
        Iterator dataTableIterator = saveDataSet.getTables().iterator();
        ISaveDataTable dataTable = (ISaveDataTable)dataTableIterator.next();
        ISaveMetaRow[] saveMetaRows = dataTable.getSaveRows();
        Iterator iSaveMetaRowIterable = Arrays.stream(saveMetaRows).iterator();
        while (iSaveMetaRowIterable.hasNext()) {
            List privateDirtyValues = ((ISaveMetaRow)iSaveMetaRowIterable.next()).getDirtyValues();
            ArrayList<Object> paras = new ArrayList<Object>();
            StringBuilder sql = new StringBuilder();
            int version = 0;
            long id = 0L;
            sql.append("UPDATE ");
            sql.append(dataTable.getSchema().getName());
            sql.append(" SET ");
            for (IColumnValuePair field : privateDirtyValues) {
                String columName = field.getColumn().getName();
                if (Objects.equals(columName.toLowerCase(Locale.ENGLISH), "fid")) {
                    id = (Long)field.getValue();
                    continue;
                }
                if (Objects.equals(columName.toLowerCase(Locale.ENGLISH), "fversion")) {
                    version = (Integer)field.getValue();
                    continue;
                }
                sql.append(columName).append("=?,");
                paras.add(field.getValue());
            }
            sql.append("fversion=fversion+1 ");
            sql.append("WHERE fversion=? and Fid=?");
            paras.add(version);
            paras.add(id);
            parasList.add(paras.toArray());
            if (!this.isEmpty(batchUpdateCollector.getSql())) continue;
            batchUpdateCollector.setSql(sql.toString());
        }
        batchUpdateCollector.setListParas(parasList);
        return batchUpdateCollector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateWithVersion(DynamicObject[] dynamicObjects, List<NotePayableInfo> notePayableInfos) {
        IDataEntityType type = dynamicObjects[0].getDataEntityType();
        IDataManager dataManager = DataManagerUtils.getDataManager((IDataEntityType)type);
        TXHandle h = TX.required();
        try {
            for (int i = 0; i < dynamicObjects.length; ++i) {
                SaveDataSet saveDataSet = (SaveDataSet)dataManager.getSaveDataSet(Collections.singletonList(dynamicObjects[i]).toArray(), true);
                BatchUpdateCollector batchUpdateCollector = this.getBatchUpdateCollector(saveDataSet);
                int[] result = DB.executeBatch((DBRoute)DBRoute.of((String)dataManager.getDataEntityType().getDBRouteKey()), (String)batchUpdateCollector.getSql(), (List)batchUpdateCollector.getListParas());
                if (result[0] == 0) {
                    throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u5f53\u524d\u4ed8\u6b3e\u8bb0\u5f55\u66f4\u65b0\u5931\u8d25\uff0c\u53ef\u80fd\u539f\u56e0\uff1a\u4e0e\u6570\u636e\u5e93\u4e2d\u4ed8\u6b3e\u8bb0\u5f55\u7248\u672c\u53f7\u4e0d\u5339\u914d\u3002", (String)"NoteReceivableTransFormer_0", (String)"ebg-note-common", (Object[])new Object[0]));
                }
                notePayableInfos.get(i).setVersion(notePayableInfos.get(i).getVersion() + 1);
            }
        }
        catch (Throwable ex) {
            this.log.error("\u6570\u636e\u5e93\u5f02\u5e38", ex);
            h.markRollback();
            if (ex instanceof EBServiceException) {
                throw EBExceiptionUtil.serviceException((String)ex.getMessage(), (Throwable)ex);
            }
            if (ex instanceof KDException) {
                this.log.error("\u6570\u636e\u5e93\u5f02\u5e38" + ((KDException)ex).getMessage());
            }
        }
        finally {
            if (h != null) {
                try {
                    h.close();
                }
                catch (Throwable i) {}
            }
        }
    }
}

