/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.common.model.transform;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IColumnValuePair;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.ISaveDataTable;
import kd.bos.dataentity.metadata.ISaveMetaRow;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDException;
import kd.bos.orm.datamanager.DataManagerUtils;
import kd.bos.orm.datamanager.IDataManager;
import kd.bos.orm.datamanager.SaveDataSet;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.DTFactoryUtil;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.note.common.model.NoteReceivableInfo;
import kd.ebg.note.common.model.transform.BatchUpdateCollector;

public class NoteReceivableTransFormer {
    EBGLogger log = EBGLogger.getInstance().getLogger(NoteReceivableTransFormer.class);
    private static NoteReceivableTransFormer instance;
    private final String PAYABLE_ENTITY = "note_receivable";
    public static final String SELECT_ALL_PROPERTIES = "status,id,ebg_id,version,custom_id,bank_version_id,bank_login_id,biz_type,sub_biz_type,impl_class_name,query_impl_class_name,package_key,total_count,total_amount,batch_seq_id,detail_seq_id,detail_biz_no,insert_batch_seq,insert_time,request_seq,request_time,update_time,update_batch_seq,update_operation,bill_no,rate_type,discount_rate,discount_amount,loan_amount,other_info,operation_code,operation_name,amount,currency,draft_type,transfer_flag,keep_flag,contract_no,booking_date,due_date,issue_date,note_status,explanation,drawer_acc_no,drawer_acc_name,drawer_bank_cnaps,drawer_bank_name,drawer_bank_address,drawer_acc_countrys,drawer_acc_province,drawer_acc_city,drawer_ratings,drawer_agency,drawer_due_date,acceptor_acc_no,acceptor_acc_name,acceptor_bank_cnaps,acceptor_bank_name,acceptor_bank_address,acceptor_acc_country,acceptor_acc_province,acceptor_acc_city,payee_acc_no,payee_acc_name,payee_bank_name,payee_bank_cnaps,payee_bank_address,payee_country,payee_province,payee_city,bank_ref_key,bank_ref_date,pay_agency,redemption_s_date,redemption_e_date,dis_red_rate,increase_rate,add_day,status_name,status_msg,bank_status,bank_msg,error_msg,bak_status,bak_status_name,bak_status_msg,bak_bank_status,bak_bank_msg,bak_error_msg,package_time,bank_batch_seq_id,bank_detail_seq_id,bank_serial_no,last_submit_time,last_submit_request_seq,submit_count,submit_success_time,last_sync_time,last_sync_request_seq,sync_count,pay_finish_time,to_give_up,impa_type,obssid,query_type,sequence,reserved1,reserved2,reserved3,reserved4,discount_type,discount_accno,discount_accname,rqstserialno,rspserialno,isnewecds,grdbag,startno,endno,cirstatus,interest,subrange,totalsize,ispayeesamebank,draftamount,batchtotalamount,settleway,cleartype,isrefuse,invc_type,invc_amt,invc_no,invc_code,invc_date,invc_chk_no,orgstartno,orgendno,autoaccept,autoreceive,increaserateper,registernmae,registeracno,registerbankname,isacceptsamebank,filelist_tag,bankbatchcount";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NoteReceivableTransFormer getInstance() {
        Class<NoteReceivableTransFormer> clazz = NoteReceivableTransFormer.class;
        synchronized (NoteReceivableTransFormer.class) {
            if (instance == null) {
                instance = new NoteReceivableTransFormer();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public DynamicObject transNoteReceivable(DynamicObject dynamicObject, NoteReceivableInfo info) {
        Date due;
        LocalDate nowLocal;
        if (dynamicObject == null) {
            dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"note_receivable");
        } else {
            dynamicObject.set("id", (Object)info.getId());
        }
        dynamicObject.set("status", (Object)info.getStatus());
        dynamicObject.set("ebg_id", (Object)info.getEbgID());
        if (info.getVersion() == null) {
            info.setVersion(1);
        }
        dynamicObject.set("custom_id", (Object)info.getCustomID());
        dynamicObject.set("version", (Object)info.getVersion());
        dynamicObject.set("bank_version_id", (Object)info.getBankVersionID());
        dynamicObject.set("bank_login_id", (Object)info.getBankLoginID());
        dynamicObject.set("biz_type", (Object)info.getBizType());
        dynamicObject.set("sub_biz_type", (Object)info.getSubBizType());
        dynamicObject.set("impl_class_name", (Object)info.getImplClassName());
        dynamicObject.set("query_impl_class_name", (Object)info.getQueryImplClassName());
        dynamicObject.set("package_key", (Object)info.getPackageKey());
        dynamicObject.set("total_count", (Object)info.getTotalCount());
        dynamicObject.set("total_amount", (Object)info.getTotalAmount());
        dynamicObject.set("batch_seq_id", (Object)info.getBatchSeqId());
        dynamicObject.set("detail_seq_id", (Object)info.getDetailSeqId());
        dynamicObject.set("detail_biz_no", (Object)info.getDetailBizNo());
        dynamicObject.set("insert_batch_seq", (Object)info.getInsertBatchSeq());
        if (info.getInsertTime() != null) {
            Date InsertTime = Date.from(info.getInsertTime().atZone(ZoneId.systemDefault()).toInstant());
            dynamicObject.set("insert_time", (Object)InsertTime);
        }
        dynamicObject.set("request_seq", (Object)info.getRequestSeq());
        if (info.getRequestTime() != null) {
            Date requestTime = Date.from(info.getRequestTime().atZone(ZoneId.systemDefault()).toInstant());
            dynamicObject.set("request_time", (Object)requestTime);
        }
        if (info.getUpdateTime() != null) {
            Date UpdateTime = Date.from(info.getUpdateTime().atZone(ZoneId.systemDefault()).toInstant());
            dynamicObject.set("update_time", (Object)UpdateTime);
        }
        dynamicObject.set("update_batch_seq", (Object)info.getUpdateBatchSeq());
        dynamicObject.set("update_operation", (Object)info.getUpdateOperation());
        dynamicObject.set("bill_no", (Object)info.getBillNo());
        dynamicObject.set("rate_type", (Object)info.getRateType());
        dynamicObject.set("discount_rate", (Object)info.getDisCountRate());
        if (StringUtils.isNotEmpty((String)info.getDisCountAmount())) {
            BigDecimal discountAmount = new BigDecimal(info.getDisCountAmount());
            dynamicObject.set("discount_amount", (Object)discountAmount);
        }
        dynamicObject.set("discount_type", (Object)info.getDiscountType());
        dynamicObject.set("discount_accno", (Object)info.getDiscountAccNo());
        dynamicObject.set("discount_accname", (Object)info.getDiscountAccName());
        dynamicObject.set("loan_amount", (Object)info.getLoanAmount());
        dynamicObject.set("other_info", (Object)info.getOtherInfo());
        dynamicObject.set("operation_code", (Object)info.getOperationCode());
        dynamicObject.set("operation_name", (Object)info.getOperationName());
        dynamicObject.set("amount", (Object)info.getAmount());
        dynamicObject.set("currency", (Object)info.getCurrency());
        dynamicObject.set("draft_type", (Object)info.getDraftType());
        dynamicObject.set("transfer_flag", (Object)info.getTransferFlag());
        dynamicObject.set("keep_flag", (Object)info.getKeepFlag());
        dynamicObject.set("contract_no", (Object)info.getContractNo());
        if (info.getBookingDate() != null) {
            nowLocal = info.getBookingDate();
            due = Date.from(nowLocal.atStartOfDay(ZoneOffset.ofHours(8)).toInstant());
            dynamicObject.set("booking_date", (Object)due);
        }
        if (info.getDueDate() != null) {
            nowLocal = info.getDueDate();
            due = Date.from(nowLocal.atStartOfDay(ZoneOffset.ofHours(8)).toInstant());
            dynamicObject.set("due_date", (Object)due);
        }
        if (info.getIssueDate() != null) {
            nowLocal = info.getIssueDate();
            due = Date.from(nowLocal.atStartOfDay(ZoneOffset.ofHours(8)).toInstant());
            dynamicObject.set("issue_date", (Object)due);
        }
        dynamicObject.set("note_status", (Object)info.getNoteStatus());
        dynamicObject.set("explanation", (Object)info.getExplanation());
        dynamicObject.set("drawer_acc_no", (Object)info.getDrawerAccNo());
        dynamicObject.set("drawer_acc_name", (Object)info.getDrawerAccName());
        dynamicObject.set("drawer_bank_cnaps", (Object)info.getDrawerBankCnaps());
        dynamicObject.set("drawer_bank_name", (Object)info.getDrawerBankName());
        dynamicObject.set("drawer_bank_address", (Object)info.getDrawerBankAddress());
        dynamicObject.set("drawer_acc_countrys", (Object)info.getDrawerAccCountry());
        dynamicObject.set("drawer_acc_province", (Object)info.getDrawerAccProvince());
        dynamicObject.set("drawer_acc_city", (Object)info.getDrawerAccCity());
        dynamicObject.set("drawer_ratings", (Object)info.getDrawerCreditRatings());
        dynamicObject.set("drawer_agency", (Object)info.getDrawerCreditRatingsAgency());
        if (info.getDrawerCreditRatingsDueDate() != null) {
            nowLocal = info.getDrawerCreditRatingsDueDate();
            due = Date.from(nowLocal.atStartOfDay(ZoneOffset.ofHours(8)).toInstant());
            dynamicObject.set("drawer_due_date", (Object)due);
        }
        dynamicObject.set("acceptor_acc_no", (Object)info.getAcceptorAccNo());
        dynamicObject.set("acceptor_acc_name", (Object)info.getAcceptorAccName());
        dynamicObject.set("acceptor_bank_cnaps", (Object)info.getAcceptorBankCnaps());
        dynamicObject.set("acceptor_bank_name", (Object)info.getAcceptorBankName());
        dynamicObject.set("acceptor_bank_address", (Object)info.getAcceptorBankAddress());
        dynamicObject.set("acceptor_acc_country", (Object)info.getAcceptorAccCountry());
        dynamicObject.set("acceptor_acc_province", (Object)info.getAcceptorAccProvince());
        dynamicObject.set("acceptor_acc_city", (Object)info.getAcceptorAccCity());
        dynamicObject.set("payee_acc_no", (Object)info.getPayeeAccNo());
        dynamicObject.set("payee_acc_name", (Object)info.getPayeeAccName());
        dynamicObject.set("payee_bank_name", (Object)info.getPayeeBankName());
        dynamicObject.set("payee_bank_cnaps", (Object)info.getPayeeBankCnaps());
        dynamicObject.set("payee_bank_address", (Object)info.getPayeeBankAddress());
        dynamicObject.set("payee_country", (Object)info.getPayeeCountry());
        dynamicObject.set("payee_province", (Object)info.getPayeeProvince());
        dynamicObject.set("payee_city", (Object)info.getPayeeCity());
        dynamicObject.set("bank_ref_key", (Object)info.getBankRefKey());
        dynamicObject.set("bank_ref_date", (Object)info.getBankRefDate());
        dynamicObject.set("pay_agency", (Object)info.getPayAgency());
        if (info.getRedemptionSDate() != null) {
            nowLocal = info.getRedemptionSDate();
            due = Date.from(nowLocal.atStartOfDay(ZoneOffset.ofHours(8)).toInstant());
            dynamicObject.set("redemption_s_date", (Object)due);
        }
        if (info.getRedemptionEDate() != null) {
            nowLocal = info.getRedemptionEDate();
            due = Date.from(nowLocal.atStartOfDay(ZoneOffset.ofHours(8)).toInstant());
            dynamicObject.set("redemption_e_date", (Object)due);
        }
        dynamicObject.set("dis_red_rate", (Object)info.getDisRedRate());
        dynamicObject.set("increase_rate", (Object)info.getIncreaseRate());
        dynamicObject.set("add_day", (Object)info.getAddDay());
        dynamicObject.set("status_name", (Object)info.getStatusName());
        dynamicObject.set("status_msg", (Object)info.getStatusMsg());
        dynamicObject.set("bank_status", (Object)info.getBankStatus());
        dynamicObject.set("bank_msg", (Object)info.getBankMsg());
        dynamicObject.set("error_msg", (Object)info.getErrorMsg());
        dynamicObject.set("bak_status", (Object)info.getBakStatus());
        dynamicObject.set("bak_status_name", (Object)info.getBakStatusName());
        dynamicObject.set("bak_status_msg", (Object)info.getBakStatusMsg());
        dynamicObject.set("bak_bank_status", (Object)info.getBakBankStatus());
        dynamicObject.set("bak_bank_msg", (Object)info.getBakBankMsg());
        dynamicObject.set("bak_error_msg", (Object)info.getBakErrorMsg());
        if (info.getPackageTime() != null) {
            Date PackageTime = Date.from(info.getPackageTime().atZone(ZoneId.systemDefault()).toInstant());
            dynamicObject.set("package_time", (Object)PackageTime);
        }
        dynamicObject.set("bank_batch_seq_id", (Object)info.getBankBatchSeqId());
        dynamicObject.set("bank_detail_seq_id", (Object)info.getBankDetailSeqId());
        dynamicObject.set("bank_serial_no", (Object)info.getBankSerialNo());
        if (info.getLastSubmitTime() != null) {
            Date LastSubmitTime = Date.from(info.getLastSubmitTime().atZone(ZoneId.systemDefault()).toInstant());
            dynamicObject.set("last_submit_time", (Object)LastSubmitTime);
        }
        dynamicObject.set("last_submit_request_seq", (Object)info.getLastSubmitRequestSeq());
        dynamicObject.set("submit_count", (Object)info.getSubmitCount());
        if (info.getSubmitSuccessTime() != null) {
            Date SubmitSuccessTime = Date.from(info.getSubmitSuccessTime().atZone(ZoneId.systemDefault()).toInstant());
            dynamicObject.set("submit_success_time", (Object)SubmitSuccessTime);
        }
        if (info.getLastSyncTime() != null) {
            Date LastSyncTime = Date.from(info.getLastSyncTime().atZone(ZoneId.systemDefault()).toInstant());
            dynamicObject.set("last_sync_time", (Object)LastSyncTime);
        }
        dynamicObject.set("last_sync_request_seq", (Object)info.getLastSyncRequestSeq());
        dynamicObject.set("sync_count", (Object)info.getSyncCount());
        if (info.getPayFinishTime() != null) {
            Date PayFinishTime = Date.from(info.getPayFinishTime().atZone(ZoneId.systemDefault()).toInstant());
            dynamicObject.set("pay_finish_time", (Object)PayFinishTime);
        }
        dynamicObject.set("to_give_up", (Object)info.getToGiveUp());
        dynamicObject.set("impa_type", (Object)info.getImpaType());
        dynamicObject.set("obssid", (Object)info.getObssid());
        dynamicObject.set("sequence", (Object)info.getSequence());
        dynamicObject.set("reserved1", (Object)info.getReserved1());
        dynamicObject.set("reserved2", (Object)info.getReserved2());
        dynamicObject.set("reserved3", (Object)info.getReserved3());
        dynamicObject.set("reserved4", (Object)info.getReserved4());
        dynamicObject.set("rqstserialno", (Object)info.getRqstserialno());
        dynamicObject.set("rspserialno", (Object)info.getRspserialno());
        dynamicObject.set("isnewecds", (Object)info.getIsNewECDS());
        dynamicObject.set("grdbag", (Object)info.getGrdBag());
        dynamicObject.set("startno", (Object)info.getStartNo());
        dynamicObject.set("endno", (Object)info.getEndNo());
        dynamicObject.set("cirstatus", (Object)info.getCirStatus());
        dynamicObject.set("interest", (Object)info.getInterest());
        dynamicObject.set("subrange", (Object)info.getSubRange());
        dynamicObject.set("totalsize", (Object)info.getTotalSize());
        dynamicObject.set("ispayeesamebank", (Object)info.getIsPayeeSameBank());
        dynamicObject.set("draftamount", (Object)info.getDraftAmount());
        dynamicObject.set("batchtotalamount", (Object)info.getBatchTotalAmount());
        dynamicObject.set("settleway", (Object)info.getSettleWay());
        dynamicObject.set("cleartype", (Object)info.getClearType());
        dynamicObject.set("isrefuse", (Object)info.getIsRefuse());
        dynamicObject.set("invc_type", (Object)info.getInvcType());
        dynamicObject.set("invc_no", (Object)info.getInvcNo());
        dynamicObject.set("invc_code", (Object)info.getInvcCode());
        dynamicObject.set("invc_amt", (Object)info.getInvcAmt());
        dynamicObject.set("invc_date", (Object)info.getInvcDate());
        dynamicObject.set("invc_chk_no", (Object)info.getInvcChkNo());
        dynamicObject.set("orgstartno", (Object)info.getOrgStartNo());
        dynamicObject.set("orgendno", (Object)info.getOrgEndNo());
        dynamicObject.set("autoaccept", (Object)info.getAutoAccept());
        dynamicObject.set("autoreceive", (Object)info.getAutoReceive());
        dynamicObject.set("increaserateper", (Object)info.getIncreaseRate());
        dynamicObject.set("registernmae", (Object)info.getRegisterNmae());
        dynamicObject.set("registeracno", (Object)info.getRegisterAcno());
        dynamicObject.set("registerbankname", (Object)info.getRegisterBankName());
        dynamicObject.set("bankbatchcount", (Object)info.getBankBatchCount());
        dynamicObject.set("isacceptsamebank", (Object)info.getIsAcceptSameBank());
        if (StringUtils.isNotEmpty((String)info.getFileListTag())) {
            dynamicObject.set("filelist_tag", (Object)info.getFileListTag());
        }
        return dynamicObject;
    }

    public DynamicObject transNoteReceivable(NoteReceivableInfo info) {
        return this.transNoteReceivable(null, info);
    }

    public NoteReceivableInfo packNoteReceivable(DynamicObject dynamicObject) {
        NoteReceivableInfo noteReceivableInfo = new NoteReceivableInfo();
        String time = "";
        noteReceivableInfo.setId(dynamicObject.getLong("id"));
        noteReceivableInfo.setStatus(dynamicObject.getInt("status"));
        noteReceivableInfo.setEbgID(dynamicObject.getString("ebg_id"));
        noteReceivableInfo.setVersion(dynamicObject.getInt("version"));
        noteReceivableInfo.setCustomID(dynamicObject.getString("custom_id"));
        noteReceivableInfo.setBankVersionID(dynamicObject.getString("bank_version_id"));
        noteReceivableInfo.setBankLoginID(dynamicObject.getString("bank_login_id"));
        noteReceivableInfo.setBizType(dynamicObject.getString("biz_type"));
        noteReceivableInfo.setSubBizType(dynamicObject.getString("sub_biz_type"));
        noteReceivableInfo.setImplClassName(dynamicObject.getString("impl_class_name"));
        noteReceivableInfo.setQueryImplClassName(dynamicObject.getString("query_impl_class_name"));
        noteReceivableInfo.setPackageKey(dynamicObject.getString("package_key"));
        noteReceivableInfo.setTotalCount(dynamicObject.getInt("total_count"));
        noteReceivableInfo.setTotalAmount(dynamicObject.getBigDecimal("total_amount"));
        noteReceivableInfo.setBatchSeqId(dynamicObject.getString("batch_seq_id"));
        noteReceivableInfo.setDetailSeqId(dynamicObject.getString("detail_seq_id"));
        noteReceivableInfo.setDetailBizNo(dynamicObject.getString("detail_biz_no"));
        noteReceivableInfo.setInsertBatchSeq(dynamicObject.getString("insert_batch_seq"));
        noteReceivableInfo.setDiscountType(dynamicObject.getString("discount_type"));
        noteReceivableInfo.setDiscountAccNo(dynamicObject.getString("discount_accno"));
        noteReceivableInfo.setDiscountAccName(dynamicObject.getString("discount_accname"));
        time = dynamicObject.getString("insert_time");
        if (!this.isEmpty(time)) {
            noteReceivableInfo.setInsertTime(DTFactoryUtil.parseDateTime((String)time));
        }
        noteReceivableInfo.setRequestSeq(dynamicObject.getString("request_seq"));
        time = dynamicObject.getString("request_time");
        if (!this.isEmpty(time)) {
            noteReceivableInfo.setRequestTime(DTFactoryUtil.parseDateTime((String)time));
        }
        if (!this.isEmpty(time = dynamicObject.getString("update_time"))) {
            noteReceivableInfo.setUpdateTime(DTFactoryUtil.parseDateTime((String)time));
        }
        noteReceivableInfo.setUpdateBatchSeq(dynamicObject.getString("update_batch_seq"));
        noteReceivableInfo.setUpdateOperation(dynamicObject.getString("update_operation"));
        noteReceivableInfo.setBillNo(dynamicObject.getString("bill_no"));
        noteReceivableInfo.setRateType(dynamicObject.getString("rate_type"));
        noteReceivableInfo.setDisCountRate(dynamicObject.getString("discount_rate"));
        noteReceivableInfo.setDisCountAmount(dynamicObject.getString("discount_amount"));
        noteReceivableInfo.setLoanAmount(dynamicObject.getString("loan_amount"));
        noteReceivableInfo.setOtherInfo(dynamicObject.getString("other_info"));
        noteReceivableInfo.setOperationCode(dynamicObject.getString("operation_code"));
        noteReceivableInfo.setOperationName(dynamicObject.getString("operation_name"));
        noteReceivableInfo.setAmount(dynamicObject.getBigDecimal("amount"));
        noteReceivableInfo.setCurrency(dynamicObject.getString("currency"));
        noteReceivableInfo.setDraftType(dynamicObject.getString("draft_type"));
        noteReceivableInfo.setTransferFlag(dynamicObject.getString("transfer_flag"));
        noteReceivableInfo.setKeepFlag(dynamicObject.getString("keep_flag"));
        noteReceivableInfo.setContractNo(dynamicObject.getString("contract_no"));
        time = dynamicObject.getString("booking_date");
        if (!this.isEmpty(time)) {
            noteReceivableInfo.setBookingDate(DTFactoryUtil.parseDate((String)time));
        }
        if (!this.isEmpty(time = dynamicObject.getString("due_date"))) {
            noteReceivableInfo.setDueDate(DTFactoryUtil.parseDate((String)time));
        }
        if (!this.isEmpty(time = dynamicObject.getString("issue_date"))) {
            noteReceivableInfo.setIssueDate(DTFactoryUtil.parseDate((String)time));
        }
        noteReceivableInfo.setNoteStatus(dynamicObject.getString("note_status"));
        noteReceivableInfo.setExplanation(dynamicObject.getString("explanation"));
        noteReceivableInfo.setDrawerAccNo(dynamicObject.getString("drawer_acc_no"));
        noteReceivableInfo.setDrawerAccName(dynamicObject.getString("drawer_acc_name"));
        noteReceivableInfo.setDrawerBankCnaps(dynamicObject.getString("drawer_bank_cnaps"));
        noteReceivableInfo.setDrawerBankName(dynamicObject.getString("drawer_bank_name"));
        noteReceivableInfo.setDrawerBankAddress(dynamicObject.getString("drawer_bank_address"));
        noteReceivableInfo.setDrawerAccCountry(dynamicObject.getString("drawer_acc_countrys"));
        noteReceivableInfo.setDrawerAccProvince(dynamicObject.getString("drawer_acc_province"));
        noteReceivableInfo.setDrawerAccCity(dynamicObject.getString("drawer_acc_city"));
        noteReceivableInfo.setDrawerCreditRatings(dynamicObject.getString("drawer_ratings"));
        noteReceivableInfo.setDrawerCreditRatingsAgency(dynamicObject.getString("drawer_agency"));
        time = dynamicObject.getString("drawer_due_date");
        if (!this.isEmpty(time)) {
            noteReceivableInfo.setDrawerCreditRatingsDueDate(DTFactoryUtil.parseDate((String)time));
        }
        noteReceivableInfo.setAcceptorAccNo(dynamicObject.getString("acceptor_acc_no"));
        noteReceivableInfo.setAcceptorAccName(dynamicObject.getString("acceptor_acc_name"));
        noteReceivableInfo.setAcceptorBankCnaps(dynamicObject.getString("acceptor_bank_cnaps"));
        noteReceivableInfo.setAcceptorBankName(dynamicObject.getString("acceptor_bank_name"));
        noteReceivableInfo.setAcceptorBankAddress(dynamicObject.getString("acceptor_bank_address"));
        noteReceivableInfo.setAcceptorAccCountry(dynamicObject.getString("acceptor_acc_country"));
        noteReceivableInfo.setAcceptorAccProvince(dynamicObject.getString("acceptor_acc_province"));
        noteReceivableInfo.setAcceptorAccCity(dynamicObject.getString("acceptor_acc_city"));
        noteReceivableInfo.setPayeeAccNo(dynamicObject.getString("payee_acc_no"));
        noteReceivableInfo.setPayeeAccName(dynamicObject.getString("payee_acc_name"));
        noteReceivableInfo.setPayeeBankName(dynamicObject.getString("payee_bank_name"));
        noteReceivableInfo.setPayeeBankCnaps(dynamicObject.getString("payee_bank_cnaps"));
        noteReceivableInfo.setPayeeBankAddress(dynamicObject.getString("payee_bank_address"));
        noteReceivableInfo.setPayeeCountry(dynamicObject.getString("payee_country"));
        noteReceivableInfo.setPayeeProvince(dynamicObject.getString("payee_province"));
        noteReceivableInfo.setPayeeCity(dynamicObject.getString("payee_city"));
        noteReceivableInfo.setBankRefKey(dynamicObject.getString("bank_ref_key"));
        noteReceivableInfo.setBankRefDate(dynamicObject.getString("bank_ref_date"));
        noteReceivableInfo.setPayAgency(dynamicObject.getString("pay_agency"));
        time = dynamicObject.getString("redemption_s_date");
        if (!this.isEmpty(time)) {
            noteReceivableInfo.setRedemptionSDate(DTFactoryUtil.parseDate((String)time));
        }
        if (!this.isEmpty(time = dynamicObject.getString("redemption_e_date"))) {
            noteReceivableInfo.setRedemptionEDate(DTFactoryUtil.parseDate((String)time));
        }
        noteReceivableInfo.setDisRedRate(dynamicObject.getString("dis_red_rate"));
        noteReceivableInfo.setIncreaseRate(dynamicObject.getString("increase_rate"));
        noteReceivableInfo.setAddDay(dynamicObject.getInt("add_day"));
        noteReceivableInfo.setStatusName(dynamicObject.getString("status_name"));
        noteReceivableInfo.setStatusMsg(dynamicObject.getString("status_msg"));
        noteReceivableInfo.setBankStatus(dynamicObject.getString("bank_status"));
        noteReceivableInfo.setBankMsg(dynamicObject.getString("bank_msg"));
        noteReceivableInfo.setErrorMsg(dynamicObject.getString("error_msg"));
        noteReceivableInfo.setBakStatus(dynamicObject.getInt("bak_status"));
        noteReceivableInfo.setBakStatusName(dynamicObject.getString("bak_status_name"));
        noteReceivableInfo.setBakStatusMsg(dynamicObject.getString("bak_status_msg"));
        noteReceivableInfo.setBakBankStatus(dynamicObject.getString("bak_bank_status"));
        noteReceivableInfo.setBakBankMsg(dynamicObject.getString("bak_bank_msg"));
        noteReceivableInfo.setBakErrorMsg(dynamicObject.getString("bak_error_msg"));
        time = dynamicObject.getString("package_time");
        if (!this.isEmpty(time)) {
            noteReceivableInfo.setPackageTime(DTFactoryUtil.parseDateTime((String)time));
        }
        noteReceivableInfo.setBankBatchSeqId(dynamicObject.getString("bank_batch_seq_id"));
        noteReceivableInfo.setBankDetailSeqId(dynamicObject.getString("bank_detail_seq_id"));
        noteReceivableInfo.setBankSerialNo(dynamicObject.getString("bank_serial_no"));
        time = dynamicObject.getString("last_submit_time");
        if (!this.isEmpty(time)) {
            noteReceivableInfo.setLastSubmitTime(DTFactoryUtil.parseDateTime((String)time));
        }
        noteReceivableInfo.setLastSubmitRequestSeq(dynamicObject.getString("last_submit_request_seq"));
        noteReceivableInfo.setSubmitCount(dynamicObject.getInt("submit_count"));
        time = dynamicObject.getString("submit_success_time");
        if (!this.isEmpty(time)) {
            noteReceivableInfo.setSubmitSuccessTime(DTFactoryUtil.parseDateTime((String)time));
        }
        if (!this.isEmpty(time = dynamicObject.getString("last_sync_time"))) {
            noteReceivableInfo.setLastSyncTime(DTFactoryUtil.parseDateTime((String)time));
        }
        noteReceivableInfo.setLastSyncRequestSeq(dynamicObject.getString("last_sync_request_seq"));
        noteReceivableInfo.setSyncCount(dynamicObject.getInt("sync_count"));
        time = dynamicObject.getString("pay_finish_time");
        if (!this.isEmpty(time)) {
            noteReceivableInfo.setPayFinishTime(DTFactoryUtil.parseDateTime((String)time));
        }
        noteReceivableInfo.setToGiveUp(dynamicObject.getString("to_give_up"));
        noteReceivableInfo.setImpaType(dynamicObject.getString("impa_type"));
        noteReceivableInfo.setObssid(dynamicObject.getString("obssid"));
        noteReceivableInfo.setSequence(dynamicObject.getString("sequence"));
        noteReceivableInfo.setReserved1(dynamicObject.getString("reserved1"));
        noteReceivableInfo.setReserved2(dynamicObject.getString("reserved2"));
        noteReceivableInfo.setReserved3(dynamicObject.getString("reserved3"));
        noteReceivableInfo.setReserved4(dynamicObject.getString("reserved4"));
        noteReceivableInfo.setRqstserialno(dynamicObject.getString("rqstserialno"));
        noteReceivableInfo.setRspserialno(dynamicObject.getString("rspserialno"));
        noteReceivableInfo.setIsNewECDS(dynamicObject.getString("isnewecds"));
        noteReceivableInfo.setGrdBag(dynamicObject.getString("grdbag"));
        noteReceivableInfo.setStartNo(dynamicObject.getString("startno"));
        noteReceivableInfo.setEndNo(dynamicObject.getString("endno"));
        noteReceivableInfo.setCirStatus(dynamicObject.getString("cirstatus"));
        noteReceivableInfo.setInterest(dynamicObject.getString("interest"));
        noteReceivableInfo.setSubRange(dynamicObject.getString("subrange"));
        noteReceivableInfo.setTotalSize(dynamicObject.getInt("totalsize"));
        noteReceivableInfo.setIsPayeeSameBank(dynamicObject.getString("ispayeesamebank"));
        noteReceivableInfo.setDraftAmount(dynamicObject.getBigDecimal("draftamount"));
        noteReceivableInfo.setBatchTotalAmount(dynamicObject.getBigDecimal("batchtotalamount"));
        noteReceivableInfo.setSettleWay(dynamicObject.getString("settleway"));
        noteReceivableInfo.setClearType(dynamicObject.getString("cleartype"));
        noteReceivableInfo.setIsRefuse(dynamicObject.getString("isrefuse"));
        noteReceivableInfo.setInvcType(dynamicObject.getString("invc_type"));
        noteReceivableInfo.setInvcAmt(dynamicObject.getString("invc_amt"));
        noteReceivableInfo.setInvcNo(dynamicObject.getString("invc_no"));
        noteReceivableInfo.setInvcCode(dynamicObject.getString("invc_code"));
        noteReceivableInfo.setInvcDate(dynamicObject.getString("invc_date"));
        noteReceivableInfo.setInvcChkNo(dynamicObject.getString("invc_chk_no"));
        noteReceivableInfo.setOrgStartNo(dynamicObject.getString("orgstartno"));
        noteReceivableInfo.setOrgEndNo(dynamicObject.getString("orgendno"));
        noteReceivableInfo.setAutoAccept(dynamicObject.getString("autoaccept"));
        noteReceivableInfo.setAutoReceive(dynamicObject.getString("autoreceive"));
        noteReceivableInfo.setIncreaseRatePer(dynamicObject.getString("increaserateper"));
        noteReceivableInfo.setRegisterNmae(dynamicObject.getString("registernmae"));
        noteReceivableInfo.setRegisterAcno(dynamicObject.getString("registeracno"));
        noteReceivableInfo.setRegisterBankName(dynamicObject.getString("registerbankname"));
        noteReceivableInfo.setBankBatchCount(dynamicObject.getInt("bankbatchcount"));
        noteReceivableInfo.setIsAcceptSameBank(dynamicObject.getString("isacceptsamebank"));
        noteReceivableInfo.setFileListTag(dynamicObject.getString("filelist_tag"));
        return noteReceivableInfo;
    }

    private boolean isEmpty(String str) {
        return str == null || str.length() == 0;
    }

    public BatchUpdateCollector getBatchUpdateCollector(SaveDataSet saveDataSet) {
        BatchUpdateCollector batchUpdateCollector = new BatchUpdateCollector();
        ArrayList<Object[]> parasList = new ArrayList<Object[]>();
        Iterator dataTableIterator = saveDataSet.getTables().iterator();
        ISaveDataTable dataTable = (ISaveDataTable)dataTableIterator.next();
        ISaveMetaRow[] saveMetaRows = dataTable.getSaveRows();
        Iterator iSaveMetaRowIterable = Arrays.stream(saveMetaRows).iterator();
        while (iSaveMetaRowIterable.hasNext()) {
            List privateDirtyValues = ((ISaveMetaRow)iSaveMetaRowIterable.next()).getDirtyValues();
            ArrayList<Object> paras = new ArrayList<Object>();
            StringBuilder sql = new StringBuilder();
            int version = 0;
            long id = 0L;
            sql.append("UPDATE ");
            sql.append(dataTable.getSchema().getName());
            sql.append(" SET ");
            for (IColumnValuePair field : privateDirtyValues) {
                String columName = field.getColumn().getName();
                if (Objects.equals(columName.toLowerCase(Locale.ENGLISH), "fid")) {
                    id = (Long)field.getValue();
                    continue;
                }
                if (Objects.equals(columName.toLowerCase(Locale.ENGLISH), "fversion")) {
                    version = (Integer)field.getValue();
                    continue;
                }
                sql.append(columName).append("=?,");
                paras.add(field.getValue());
            }
            sql.append("fversion=fversion+1 ");
            sql.append("WHERE fversion=? and Fid=?");
            paras.add(version);
            paras.add(id);
            parasList.add(paras.toArray());
            if (!this.isEmpty(batchUpdateCollector.getSql())) continue;
            batchUpdateCollector.setSql(sql.toString());
        }
        batchUpdateCollector.setListParas(parasList);
        return batchUpdateCollector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateWithVersion(DynamicObject[] dynamicObjects, List<NoteReceivableInfo> noteReceivableInfos) {
        IDataEntityType type = dynamicObjects[0].getDataEntityType();
        IDataManager dataManager = DataManagerUtils.getDataManager((IDataEntityType)type);
        TXHandle h = TX.required();
        try {
            for (int i = 0; i < dynamicObjects.length; ++i) {
                SaveDataSet saveDataSet = (SaveDataSet)dataManager.getSaveDataSet(Collections.singletonList(dynamicObjects[i]).toArray(), true);
                BatchUpdateCollector batchUpdateCollector = this.getBatchUpdateCollector(saveDataSet);
                int[] result = DB.executeBatch((DBRoute)DBRoute.of((String)dataManager.getDataEntityType().getDBRouteKey()), (String)batchUpdateCollector.getSql(), (List)batchUpdateCollector.getListParas());
                if (result[0] == 0) {
                    throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u5f53\u524d\u4ed8\u6b3e\u8bb0\u5f55\u66f4\u65b0\u5931\u8d25\uff0c\u53ef\u80fd\u539f\u56e0\uff1a\u4e0e\u6570\u636e\u5e93\u4e2d\u4ed8\u6b3e\u8bb0\u5f55\u7248\u672c\u53f7\u4e0d\u5339\u914d", (String)"NoteReceivableTransFormer_10", (String)"ebg-note-common", (Object[])new Object[0]));
                }
                noteReceivableInfos.get(i).setVersion(noteReceivableInfos.get(i).getVersion() + 1);
            }
        }
        catch (Throwable ex) {
            this.log.error("\u6570\u636e\u5e93\u5f02\u5e38", ex);
            h.markRollback();
            if (ex instanceof EBServiceException) {
                throw EBExceiptionUtil.serviceException((String)ex.getMessage(), (Throwable)ex);
            }
            if (ex instanceof KDException) {
                this.log.error("\u6570\u636e\u5e93\u5f02\u5e38" + ((KDException)ex).getMessage());
            }
        }
        finally {
            if (h != null) {
                try {
                    h.close();
                }
                catch (Throwable i) {}
            }
        }
    }
}

