/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.common.utils;

import com.google.common.collect.Maps;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.util.ReflectionUtils;
import kd.ebg.egf.common.annotation.Autowired;
import kd.ebg.egf.common.annotation.Bean;
import kd.ebg.egf.common.annotation.Component;
import kd.ebg.egf.common.annotation.Configuration;
import kd.ebg.egf.common.annotation.Service;
import kd.ebg.egf.common.annotation.Value;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.file.PropertiesUtils;
import kd.ebg.note.common.utils.ReflectUtil;

public class BeanFactory {
    static final String PREFIX_EGF = "kd.ebg.egf";
    public static final String prefixScan = "kd.ebg.note";
    EBGLogger logger = EBGLogger.getInstance().getLogger(BeanFactory.class);
    private static Map<String, Object> container = Maps.newHashMapWithExpectedSize((int)16);
    private static Map<String, Class> classCache = Maps.newHashMapWithExpectedSize((int)16);
    private static BeanFactory instance;

    public static synchronized BeanFactory getInstance() {
        if (instance == null) {
            instance = new BeanFactory();
        }
        return instance;
    }

    public void init() {
        this.logger.monitorInfo(ResManager.loadKDString((String)"\u7535\u7968\u8fdb\u884c\u521d\u59cb\u5316\u3002", (String)"BeanFactory_0", (String)"ebg-note-common", (Object[])new Object[0]));
        try {
            Set componentClassSet = ReflectUtil.getTypesAnnotatedWith(Component.class);
            this.intClassCache(componentClassSet);
            this.logger.monitorInfo(ResManager.loadKDString((String)"\u7535\u7968\u8fdb\u884c\u521d\u59cb\u5316Component\u3002", (String)"BeanFactory_1", (String)"ebg-note-common", (Object[])new Object[0]));
            Set serviceClassSet = ReflectUtil.getTypesAnnotatedWith(Service.class);
            this.intClassCache(serviceClassSet);
            this.logger.monitorInfo(ResManager.loadKDString((String)"\u7535\u7968\u8fdb\u884c\u521d\u59cb\u5316Service\u3002", (String)"BeanFactory_2", (String)"ebg-note-common", (Object[])new Object[0]));
            Set configClassSet = ReflectUtil.getTypesAnnotatedWith(Configuration.class);
            this.intClassCache(configClassSet);
            this.logger.monitorInfo(ResManager.loadKDString((String)"\u7535\u7968\u8fdb\u884c\u521d\u59cb\u5316Configuration\u3002", (String)"BeanFactory_3", (String)"ebg-note-common", (Object[])new Object[0]));
        }
        catch (Exception e) {
            this.logger.monitorInfo(String.format(ResManager.loadKDString((String)"\u94f6\u4f01\u4e91\u7535\u7968%s", (String)"BeanFactory_10", (String)"ebg-note-common", (Object[])new Object[0]), e.getMessage()));
            this.logger.monitorInfo(EBExceiptionUtil.stackTraceString((StackTraceElement[])e.getStackTrace()));
        }
        catch (Throwable t) {
            this.logger.monitorInfo(String.format(ResManager.loadKDString((String)"\u94f6\u4f01\u4e91\u7535\u7968\u521d\u59cb\u5316\u5f02\u5e38%s\u3002", (String)"BeanFactory_11", (String)"ebg-note-common", (Object[])new Object[0]), t.getMessage()));
        }
        for (Map.Entry<String, Class> entry : classCache.entrySet()) {
            try {
                String clazzName = entry.getKey();
                if (clazzName.equalsIgnoreCase("org.springframework.scheduling.quartz.SchedulerFactoryBean") || container.containsKey(clazzName)) continue;
                container.put(clazzName, this.construct(entry.getValue()));
            }
            catch (Exception e) {
                this.logger.monitorInfo(String.format(ResManager.loadKDString((String)"\u521d\u59cb\u5316\u5f02\u5e38\uff1a%s\u3002", (String)"BeanFactory_12", (String)"ebg-note-common", (Object[])new Object[0]), e.getMessage()));
                this.logger.monitorInfo(EBExceiptionUtil.stackTraceString((StackTraceElement[])e.getStackTrace()));
            }
            catch (Throwable t) {
                this.logger.monitorInfo(String.format(ResManager.loadKDString((String)"\u94f6\u4f01\u4e91\u7535\u7968\u521d\u59cb\u5316\u5f02\u5e382%s\u3002", (String)"BeanFactory_13", (String)"ebg-note-common", (Object[])new Object[0]), t.getMessage()));
            }
        }
    }

    private void intClassCache(Set<Class<?>> classSet) {
        for (Class<?> c : classSet) {
            Method[] methods;
            classCache.put(c.getName(), c);
            for (Method method : methods = c.getDeclaredMethods()) {
                if (!method.isAnnotationPresent(Bean.class)) continue;
                Parameter[] parameters = method.getParameters();
                Object[] objs = new Object[parameters.length];
                for (int i = 0; i < parameters.length; ++i) {
                    Object propertiedValue;
                    if (!parameters[i].isAnnotationPresent(Value.class)) continue;
                    Value valueAnnoation = parameters[i].getAnnotation(Value.class);
                    String value = valueAnnoation.value();
                    objs[i] = propertiedValue = Objects.requireNonNull(PropertiesUtils.getValue((String)value, parameters[i].getType()));
                }
                try {
                    Class<?> clz = method.getReturnType();
                    classCache.put(clz.getName(), clz);
                    Object implBean = method.invoke(this.construct(c), objs);
                    container.put(clz.getName(), implBean);
                }
                catch (Exception e) {
                    this.logger.monitorInfo(EBExceiptionUtil.stackTraceString((StackTraceElement[])e.getStackTrace()));
                    throw new EBServiceException((Throwable)e);
                }
                catch (Throwable t) {
                    this.logger.monitorInfo(String.format(ResManager.loadKDString((String)"\u94f6\u4f01\u4e91\u7535\u7968\u521d\u59cb\u5316\u5f02\u5e383%s\u3002", (String)"BeanFactory_14", (String)"ebg-note-common", (Object[])new Object[0]), t.getMessage()));
                    this.logger.monitorInfo(EBExceiptionUtil.stackTraceString((StackTraceElement[])t.getStackTrace()));
                }
            }
        }
    }

    public Object construct(Class clazz) {
        if (container.containsKey(clazz.getName())) {
            return container.get(clazz.getName());
        }
        Object bean = null;
        try {
            Constructor<?>[] constructors;
            for (Constructor<?> constructor : constructors = clazz.getConstructors()) {
                Parameter[] parameters = constructor.getParameters();
                Class<?>[] classTypes = constructor.getParameterTypes();
                if (classTypes.length == 0) {
                    if (Modifier.isAbstract(clazz.getModifiers())) continue;
                    bean = clazz.newInstance();
                    this.Autowired(bean);
                    continue;
                }
                Object[] objs = new Object[parameters.length];
                for (int i = 0; i < parameters.length; ++i) {
                    if (parameters[i].getType().getName().startsWith(PREFIX_EGF)) {
                        try {
                            objs[i] = BeanFactory.initBean(parameters[i].getType());
                        }
                        catch (Throwable t) {
                            throw EBExceiptionUtil.preCheckException((Throwable)t);
                        }
                    }
                    if (classCache.containsKey(parameters[i].getType().getName())) {
                        if (!container.containsKey(parameters[i].getType().getName())) {
                            container.put(parameters[i].getType().getName(), this.construct(parameters[i].getType()));
                        }
                        objs[i] = container.get(parameters[i].getType().getName());
                        continue;
                    }
                    if (parameters[i].isAnnotationPresent(Value.class)) {
                        Object propertiedValue;
                        Value valueAnnoation = parameters[i].getAnnotation(Value.class);
                        String value = valueAnnoation.value();
                        objs[i] = propertiedValue = Objects.requireNonNull(PropertiesUtils.getValue((String)value, parameters[i].getType()));
                        continue;
                    }
                    if (!List.class.isAssignableFrom(parameters[i].getType())) continue;
                    Parameter param = parameters[i];
                    ParameterizedType pt = (ParameterizedType)param.getParameterizedType();
                    Class clz = (Class)pt.getActualTypeArguments()[0];
                    ArrayList clzList = new ArrayList(16);
                    Set clzImplSet = ReflectUtil.getSubTypesOf((Class)clz);
                    if (clzImplSet != null) {
                        for (Class c : clzImplSet) {
                            if (Modifier.isAbstract(c.getModifiers())) continue;
                            clzList.add(c.newInstance());
                        }
                    }
                    objs[i] = clzList;
                }
                bean = constructor.newInstance(objs);
                this.Autowired(bean);
            }
        }
        catch (Exception e) {
            this.logger.monitorInfo(EBExceiptionUtil.stackTraceString((StackTraceElement[])e.getStackTrace()));
            return null;
        }
        catch (Throwable t) {
            this.logger.monitorInfo(String.format(ResManager.loadKDString((String)"\u94f6\u4f01\u4e91\u7535\u7968\u521d\u59cb\u5316\u5f02\u5e384%s\u3002", (String)"BeanFactory_15", (String)"ebg-note-common", (Object[])new Object[0]), t.getMessage()));
        }
        return bean;
    }

    public void Autowired(Object bean) {
        Field[] fields;
        for (Field field : fields = bean.getClass().getDeclaredFields()) {
            if (field.isAnnotationPresent(Autowired.class)) {
                ReflectionUtils.makeAccessible((Field)field);
                Class<?> fieldClazz = field.getType();
                if (List.class.isAssignableFrom(fieldClazz)) {
                    ParameterizedType pt = (ParameterizedType)field.getGenericType();
                    Class clz = (Class)pt.getActualTypeArguments()[0];
                    ArrayList clzList = new ArrayList(16);
                    Set clzImplSet = ReflectUtil.getSubTypesOf((Class)clz);
                    try {
                        if (clzImplSet != null) {
                            for (Class c : clzImplSet) {
                                clzList.add(c.newInstance());
                            }
                        }
                        field.set(bean, clzList);
                    }
                    catch (Exception e) {
                        this.logger.monitorInfo(EBExceiptionUtil.stackTraceString((StackTraceElement[])e.getStackTrace()));
                    }
                    continue;
                }
                String clazzName = fieldClazz.getName();
                if (clazzName.contains(PREFIX_EGF)) {
                    try {
                        field.set(bean, BeanFactory.initBean(fieldClazz));
                    }
                    catch (Throwable t) {
                        throw EBExceiptionUtil.preCheckException((Throwable)t);
                    }
                }
                if (!classCache.containsKey(clazzName)) continue;
                if (!container.containsKey(clazzName)) {
                    container.put(clazzName, this.construct(fieldClazz));
                }
                try {
                    field.set(bean, container.get(clazzName));
                }
                catch (Exception e) {
                    this.logger.monitorInfo(EBExceiptionUtil.stackTraceString((StackTraceElement[])e.getStackTrace()));
                }
                continue;
            }
            if (!field.isAnnotationPresent(Value.class)) continue;
            Value valueAnnoation = field.getAnnotation(Value.class);
            String value = valueAnnoation.value();
            Object propertiedValue = Objects.requireNonNull(PropertiesUtils.getValue((String)value, field.getType()));
            ReflectionUtils.makeAccessible((Field)field);
            try {
                field.set(bean, propertiedValue);
            }
            catch (IllegalAccessException e) {
                this.logger.monitorInfo(EBExceiptionUtil.stackTraceString((StackTraceElement[])e.getStackTrace()));
            }
        }
        if (classCache.containsKey(bean.getClass().getName()) && !container.containsKey(bean.getClass().getName())) {
            container.put(bean.getClass().getName(), bean);
        }
    }

    public static synchronized <T> T initBean(Class<T> requiredType) {
        if (!container.containsKey(requiredType.getName())) {
            try {
                T t = requiredType.newInstance();
                container.put(requiredType.getName(), t);
                return t;
            }
            catch (Exception e) {
                throw EBExceiptionUtil.serviceException((Throwable)e);
            }
        }
        return (T)container.get(requiredType.getName());
    }

    public static <T> T getBean(Class<T> requiredType) {
        if (container.containsKey(requiredType.getName())) {
            Object obj = container.get(requiredType.getName());
            return (T)obj;
        }
        return null;
    }

    public static <T> T getBean(String beanName) {
        if (container.containsKey(beanName)) {
            Object obj = container.get(beanName);
            return (T)obj;
        }
        return null;
    }
}

