/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.mservice;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.RateLimiter;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.bill.IBillWebApiPlugin;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.api.ApiResult;
import kd.bos.entity.api.WebApiContext;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.entity.base.EBException;
import kd.ebg.egf.common.entity.base.EBRequest;
import kd.ebg.egf.common.entity.base.EBRequestEnhance;
import kd.ebg.egf.common.entity.base.EBResponse;
import kd.ebg.egf.common.entity.service.EBBaseRequest;
import kd.ebg.egf.common.entity.service.EBServiceRequest;
import kd.ebg.egf.common.entity.service.EBServiceResponse;
import kd.ebg.egf.common.exception.EBBaseException;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.exception.EBSecurityException;
import kd.ebg.egf.common.framework.frame.Sequence;
import kd.ebg.egf.common.framework.security.util.EBFrontUtil;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.log.MDCUtil;
import kd.ebg.egf.common.utils.JsonUtil;
import kd.ebg.egf.common.utils.string.StrUtil;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.note.common.entity.biz.notedetail.NoteDetailRequest;
import kd.ebg.note.common.entity.biz.noteinfo.NoteInfoRequest;
import kd.ebg.note.common.entity.biz.notepayable.NotePayableRequest;
import kd.ebg.note.common.entity.biz.notereceivable.NoteReceivableRequest;
import kd.ebg.note.common.entity.biz.noteupdate.NoteStatusUpdateRequest;
import kd.ebg.note.common.entity.biz.querynotepayable.QueryNotePayableRequest;
import kd.ebg.note.common.entity.biz.querynotereceivable.QueryNoteReceivableRequest;
import kd.ebg.note.common.front.api.biz.EBResponseCode;
import kd.ebg.note.common.front.api.boot.utils.FrontCheckUtil;
import kd.ebg.note.common.utils.SpringContextUtil;
import kd.ebg.note.mservice.facade.config.FacadeProperties;
import kd.ebg.note.mservice.facade.utils.CommonUtils;
import kd.ebg.note.mservice.facade.utils.LogUtil;
import net.sf.json.JSONObject;
import org.slf4j.MDC;

public class EBGateway
implements IBillWebApiPlugin {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(EBGateway.class);
    private static final String BANK_VERSION_ID = "bankVersionID";
    private static EBGateway instance = new EBGateway();
    private static final long maxWaitTime = 30L;
    private static final RateLimiter globalRateLimiter = RateLimiter.create((double)1000.0);
    private static final AtomicInteger rateLimiterRejectCount = new AtomicInteger(0);
    private static final ConcurrentHashMap<String, RateLimiter> customRateLimiter = new ConcurrentHashMap();
    private FacadeProperties properties;

    public static EBGateway getInstance() {
        return instance;
    }

    private synchronized RateLimiter createForCustom(String customId) {
        RateLimiter rateLimiter = customRateLimiter.get(customId);
        if (Objects.isNull(rateLimiter)) {
            rateLimiter = RateLimiter.create((double)100.0);
            customRateLimiter.put(customId, rateLimiter);
        }
        return rateLimiter;
    }

    public ApiResult doCustomService(WebApiContext ctx) {
        return ApiResult.success((Object)"");
    }

    public ApiResult doCustomService(Map<String, Object> params) {
        MDCUtil.clearBussinessMDC();
        long currentMs = System.currentTimeMillis();
        ApiResult result = new ApiResult();
        EBServiceResponse response = null;
        String responseData = "";
        String jsonMap = JSONObject.fromObject(params).toString();
        EBServiceRequest request = (EBServiceRequest)JsonUtil.json2Obj((String)jsonMap, EBServiceRequest.class);
        this.properties = (FacadeProperties)SpringContextUtil.getBean(FacadeProperties.class);
        try {
            String customID = RequestContext.get().getTenantId();
            if (StringUtils.isEmpty((String)customID)) {
                throw new EBSecurityException(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u79df\u6237[%s]\u4e0d\u5b58\u5728\u3002", (String)"EBGateway_0", (String)"ebg-note-mservice", (Object[])new Object[0]), customID));
            }
            request.setCustomerID(customID);
            boolean tryAcquire = globalRateLimiter.tryAcquire(30L, TimeUnit.SECONDS);
            if (!tryAcquire) {
                rateLimiterRejectCount.incrementAndGet();
                throw new EBSecurityException(ResManager.loadKDString((String)"\u5168\u5c40\u9650\u6d41", (String)"EBGateway_1", (String)"ebg-note-mservice", (Object[])new Object[0]));
            }
            RateLimiter rateLimiter = customRateLimiter.get(request.getCustomerID());
            if (Objects.isNull(rateLimiter)) {
                rateLimiter = this.createForCustom(request.getCustomerID());
            }
            if (!rateLimiter.tryAcquire(30L, TimeUnit.SECONDS)) {
                logger.warn("\u79df\u6237:{} \u89e6\u53d1\u9650\u6d41", new Object[]{request.getCustomerID()});
                throw new EBSecurityException(ResManager.loadKDString((String)"\u5355\u79df\u6237\u9650\u6d41", (String)"EBGateway_2", (String)"ebg-note-mservice", (Object[])new Object[0]));
            }
            FrontCheckUtil.checkRequest((EBBaseRequest)request);
            if (this.properties.isTimeLimitCheck() && !FrontCheckUtil.checkTimeLimited((EBBaseRequest)request, (long)this.properties.getTimeLimit(), (long)this.properties.getTimeTolerate())) {
                throw new EBSecurityException(String.format(ResManager.loadKDString((String)"\u8bf7\u6c42\u65f6\u6548:\u8bf7\u6c42\u65f6\u95f4\u6233\u4e0d\u80fd\u8d85\u8fc7\u94f6\u4f01\u670d\u52a1\u5668\u65f6\u95f4\u6216\u8bf7\u6c42\u95f4\u9694\u592a\u4e45,%s", (String)"EBGateway_9", (String)"ebg-note-mservice", (Object[])new Object[0]), Math.abs(System.currentTimeMillis() - request.getTimestamp()) + "ms"));
            }
            boolean isIgnoreCheckSign = Boolean.parseBoolean(System.getProperty("ignoreCheckSign"));
            if ("register".equalsIgnoreCase(request.getBizType())) {
                isIgnoreCheckSign = true;
            }
            if (!isIgnoreCheckSign) {
                LogUtil.infoRequest((EBBaseRequest)request);
                boolean isValid = EBFrontUtil.decryptAndVerifyEBSecurityRequest((EBServiceRequest)request);
                if (!isValid) {
                    throw new EBSecurityException(ResManager.loadKDString((String)"\u9a8c\u8bc1\u7b7e\u540d\u672a\u901a\u8fc7\u3002", (String)"EBGateway_4", (String)"ebg-note-mservice", (Object[])new Object[0]));
                }
            }
            EBRequestEnhance ebRequestEnhance = (EBRequestEnhance)JsonUtil.json2Obj((String)request.getData(), EBRequestEnhance.class);
            LogUtil.debugRequest((EBBaseRequest)request);
            String data = request.getData();
            Preconditions.checkArgument((boolean)StrUtil.isNotBlank((CharSequence)data), (Object)ResManager.loadKDString((String)"data \u4e3a\u7a7a\u3002", (String)"EBGateway_5", (String)"ebg-note-mservice", (Object[])new Object[0]));
            String bizType = request.getBizType();
            String customId = request.getCustomerID();
            String requestSeqID = "";
            String bizSeqID = Sequence.gen18Sequence();
            String batchSeqId = ebRequestEnhance.getBody().getBatchSeqId();
            if (!StringUtils.isEmpty((String)batchSeqId)) {
                bizSeqID = batchSeqId;
            }
            if ("ping".equalsIgnoreCase(ebRequestEnhance.getHeader().getBizType())) {
                MDC.put((String)BANK_VERSION_ID, (String)ebRequestEnhance.getHeader().getExtData());
            }
            requestSeqID = String.valueOf(ebRequestEnhance.getHeader().getRequestTime());
            ebRequestEnhance.setLogRequestSeqId(requestSeqID);
            ebRequestEnhance.setCustomId(customId);
            ebRequestEnhance.setLogBizSeqId(bizSeqID);
            String logger_bank_no = Sequence.gen18Sequence();
            EBContext context = EBContext.builder().createTime(System.currentTimeMillis()).customID(customId).logRequestSeqID(requestSeqID).bizName(bizType).subBizName(bizType).bankVersionID("").logBizSeqID(bizSeqID).bizSeqID(Sequence.gen18Sequence()).requestSeqID(Sequence.genSequence()).loggerBatchNo(bizSeqID).loggerDetailNo(bizSeqID).loggerBankNo(logger_bank_no).build();
            EBContext.setContext((EBContext)context);
            JSONObject object = new JSONObject();
            object.put((Object)"loggerBatchNo", (Object)bizSeqID);
            object.put((Object)"loggerDetailNo", (Object)bizSeqID);
            object.put((Object)"loggerBankNo", (Object)logger_bank_no);
            ebRequestEnhance.getHeader().setExtData(object.toString());
            MDCUtil.initMDC();
            logger.infoRequest("\u8bf7\u6c42\u6570\u636e: \n{}", (Object)CommonUtils.prettyJson(data));
            EBResponse ebResponse = null;
            try {
                switch (bizType) {
                    case "queryNoteDetail": {
                        ebResponse = (EBResponse)DispatchServiceHelper.invokeBizService((String)"ebg", (String)"note", (String)"queryNoteDetail", (String)"queryNoteDetail", (Object[])new Object[]{EBGateway.getRequest(NoteDetailRequest.class, data, ebRequestEnhance)});
                        break;
                    }
                    case "queryNoteInfo": {
                        ebResponse = (EBResponse)DispatchServiceHelper.invokeBizService((String)"ebg", (String)"note", (String)"queryNoteInfo", (String)"queryNoteInfo", (Object[])new Object[]{EBGateway.getRequest(NoteInfoRequest.class, data, ebRequestEnhance)});
                        break;
                    }
                    case "notePayable": {
                        ebResponse = (EBResponse)DispatchServiceHelper.invokeBizService((String)"ebg", (String)"note", (String)"notePayable", (String)"notePayable", (Object[])new Object[]{EBGateway.getRequest(NotePayableRequest.class, data, ebRequestEnhance)});
                        break;
                    }
                    case "queryNotePayable": {
                        ebResponse = (EBResponse)DispatchServiceHelper.invokeBizService((String)"ebg", (String)"note", (String)"queryNotePayable", (String)"queryNotePayable", (Object[])new Object[]{EBGateway.getRequest(QueryNotePayableRequest.class, data, ebRequestEnhance)});
                        break;
                    }
                    case "noteReceivable": {
                        ebResponse = (EBResponse)DispatchServiceHelper.invokeBizService((String)"ebg", (String)"note", (String)"noteReceivable", (String)"noteReceivable", (Object[])new Object[]{EBGateway.getRequest(NoteReceivableRequest.class, data, ebRequestEnhance)});
                        break;
                    }
                    case "queryNoteReceivable": {
                        ebResponse = (EBResponse)DispatchServiceHelper.invokeBizService((String)"ebg", (String)"note", (String)"queryNoteReceivable", (String)"queryNoteReceivable", (Object[])new Object[]{EBGateway.getRequest(QueryNoteReceivableRequest.class, data, ebRequestEnhance)});
                        break;
                    }
                    case "noteStatusUpdate": {
                        ebResponse = (EBResponse)DispatchServiceHelper.invokeBizService((String)"ebg", (String)"note", (String)"noteStatusUpdate", (String)"noteStatusUpdate", (Object[])new Object[]{EBGateway.getRequest(NoteStatusUpdateRequest.class, data, ebRequestEnhance)});
                        break;
                    }
                    default: {
                        throw new EBBaseException(ResManager.loadKDString((String)"\u672a\u77e5\u7684\u4e1a\u52a1\u7c7b\u578b\u3002", (String)"EBGateway_6", (String)"ebg-note-mservice", (Object[])new Object[0]));
                    }
                }
            }
            catch (Throwable e) {
                logger.monitorInfo("ebgnote" + e.getMessage());
                logger.error(e.getMessage());
                response = new EBServiceResponse();
                response.setVersion(request.getVersion());
                response.setResponseCode(EBResponseCode.BIZ_ERROR.getResponseCode());
                response.setResponseMsg(EBResponseCode.BIZ_ERROR.getResponseMessage());
                EBException ebException = new EBException();
                ebException.setParams(EBExceiptionUtil.stackTrace((StackTraceElement[])e.getStackTrace()));
                ebException.setMessage(e.getMessage());
                if (ebResponse != null) {
                    ebResponse.setException(ebException);
                    responseData = JsonUtil.toJsonLine((Object)ebResponse);
                } else {
                    ebResponse = new EBResponse();
                }
                this.setContextResponse();
                logger.infoResponse("\u54cd\u5e94\u7ed3\u679c\uff1a\n{}", (Object)CommonUtils.prettyJson(responseData));
                response.setData(responseData);
                EBFrontUtil.encryptResponse((EBServiceRequest)request, (EBServiceResponse)response);
            }
            response = new EBServiceResponse();
            response.setVersion(request.getVersion());
            String responseCode = null;
            String responseMsg = null;
            if (Objects.isNull(ebResponse.getException())) {
                responseCode = EBResponseCode.BIZ_SUCCESS.getResponseCode();
                responseMsg = EBResponseCode.BIZ_SUCCESS.getResponseMessage();
            } else {
                EBException ebException = ebResponse.getException();
                if (ebException.getInnerException() != null) {
                    if (ebException.getInnerException().equals("preException")) {
                        responseCode = EBResponseCode.BASE_ERROR.getResponseCode();
                        responseMsg = EBResponseCode.BASE_ERROR.getResponseMessage() + "," + ebException.getMessage();
                    } else if (ebException.getInnerException().equals("serviceException")) {
                        responseCode = EBResponseCode.BIZ_ERROR.getResponseCode();
                        responseMsg = EBResponseCode.BIZ_ERROR.getResponseMessage() + "," + ebException.getMessage();
                    }
                } else {
                    responseCode = EBResponseCode.DUBBO_ERROR.getResponseCode();
                    responseMsg = EBResponseCode.DUBBO_ERROR.getResponseMessage();
                }
            }
            response.setResponseCode(responseCode);
            response.setResponseMsg(responseMsg);
            responseData = JsonUtil.toJsonLine((Object)ebResponse);
            this.setContextResponse();
            logger.infoResponse("\u54cd\u5e94\u7ed3\u679c\uff1a\n{}", (Object)CommonUtils.prettyJson(responseData));
            response.setData(responseData);
            EBFrontUtil.encryptResponse((EBServiceRequest)request, (EBServiceResponse)response);
        }
        catch (Exception e) {
            logger.monitorInfo("ebgnote2" + e.getMessage());
            logger.error(e.getMessage());
            response = new EBServiceResponse();
            response.setVersion(request.getVersion());
            response.setResponseCode(EBResponseCode.SECURITY_ERROR.getResponseCode());
            response.setResponseMsg(EBResponseCode.SECURITY_ERROR.getResponseMessage());
            EBResponse ebResponse = new EBResponse();
            EBException ebException = new EBException();
            ebException.setErrorCode(EBResponseCode.SECURITY_ERROR.getResponseCode());
            ebException.setMessage(e.getMessage());
            ebException.setParams(EBExceiptionUtil.stackTrace((StackTraceElement[])e.getStackTrace()));
            ebResponse.setException(ebException);
            responseData = JsonUtil.toJsonLine((Object)ebResponse);
            this.setContextResponse();
            logger.info("\u54cd\u5e94\u7ed3\u679c\uff1a\n{}", (Object)CommonUtils.prettyJson(responseData));
            response.setData(responseData);
            EBFrontUtil.encryptResponse((EBServiceRequest)request, (EBServiceResponse)response);
        }
        boolean isIgnoreSign = Boolean.parseBoolean(System.getProperty("ignoreSign"));
        if (!isIgnoreSign) {
            EBFrontUtil.signResponse((EBServiceResponse)response, (EBBaseRequest)request);
        }
        if (response.getResponseCode().equals(EBResponseCode.BIZ_SUCCESS.getResponseCode())) {
            result.setErrorCode("success");
            result.setData((Object)response);
            result.setSuccess(true);
        } else {
            result.setErrorCode("fail");
            result.setData((Object)response);
            result.setSuccess(false);
        }
        long cost = System.currentTimeMillis() - currentMs;
        MDC.put((String)"bussiness_type", (String)"bussiness_process");
        logger.info("API\u8bf7\u6c42{},\u5904\u7406\u8017\u65f6\uff1a{}ms", new Object[]{request.getBizType(), cost});
        return result;
    }

    private void setContextResponse() {
        try {
            EBContext.getContext().setType("response");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public static <T extends EBRequest> T getRequest(Class<T> requestClass, String data, EBRequestEnhance ebRequestEnhance) {
        EBRequest request = (EBRequest)JsonUtil.json2Obj((String)data, requestClass);
        request.getHeader().setCustomId(ebRequestEnhance.getCustomId());
        request.getHeader().setLogBizSeqID(ebRequestEnhance.getLogBizSeqId());
        request.getHeader().setLogRequestSeqID(ebRequestEnhance.getLogRequestSeqId());
        request.getHeader().setExtData(ebRequestEnhance.getHeader().getExtData());
        return (T)request;
    }
}

