/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.mservice.boot.appstarter;

import java.util.List;
import kd.bos.framework.lifecycle.appstart.AppStarter;
import kd.bos.util.CollectionUtils;
import kd.ebg.egf.common.cache.CosmicCache;
import kd.ebg.egf.common.log.BizLogType;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.log.MDCUtil;
import kd.ebg.note.common.framework.frame.BankBundleManager;
import kd.ebg.note.common.framework.info.BankVersionInfo;
import kd.ebg.note.common.utils.BeanFactory;
import kd.ebg.note.mservice.boot.appstarter.EBApplication;
import kd.ebg.note.mservice.boot.configuration.FrameworkInfoConfiguration;

public class EBGAppStarter
implements AppStarter {
    EBGLogger logger = EBGLogger.getInstance().getLogger(EBGAppStarter.class);

    public void start() {
        this.init();
    }

    public void init() {
        try {
            MDCUtil.initBizLogMDC((BizLogType)BizLogType.NOTE_APP_STARTER);
            this.logger.info("\u7535\u7968\u4e91\u542f\u52a8\u521d\u59cb\u5316 ====>");
            BeanFactory.getInstance().init();
            this.logger.info("====> Bean\u5bb9\u5668\u521d\u59cb\u5316\u5b8c\u6210");
            BankBundleManager bankBundleManager = (BankBundleManager)BeanFactory.getBean(BankBundleManager.class);
            bankBundleManager.init();
            this.logger.info("====> \u52a0\u8f7d\u94f6\u884c\u63d2\u4ef6\u5b8c\u6210");
            FrameworkInfoConfiguration infoConfiguration = (FrameworkInfoConfiguration)BeanFactory.getBean(FrameworkInfoConfiguration.class);
            List<BankVersionInfo> bankVersionInfoList = infoConfiguration.frameworkInfoToRedis();
            this.logger.info("====> \u94f6\u884c\u63d2\u4ef6\u5143\u6570\u636e\u5b58\u5165Redis\u5b8c\u6210");
            EBApplication application = (EBApplication)BeanFactory.getBean(EBApplication.class);
            application.run();
            this.logger.info("====> \u7535\u7968\u4e91\u6846\u67b6\u52a0\u8f7d\u5b8c\u6210");
            this.removeEbgParamsCache(bankVersionInfoList);
            this.logger.info("====> \u7535\u7968\u5143\u6570\u636e\u7f13\u5b58\u79fb\u9664\u5b8c\u6210");
        }
        catch (Exception e) {
            this.logger.error("\u7535\u7968\u4e91\u521d\u59cb\u5316\u9636\u6bb5\u51fa\u73b0\u5f02\u5e38\uff1a", (Throwable)e);
        }
        catch (Throwable t) {
            this.logger.error("\u7535\u7968\u4e91\u521d\u59cb\u5316\u9636\u6bb5\u51fa\u73b0\u5f02\u5e38\uff1a", t);
        }
    }

    private void removeEbgParamsCache(List<BankVersionInfo> bankVersionInfoList) {
        if (CollectionUtils.isNotEmpty(bankVersionInfoList)) {
            String prefix = "note_ebg_params_";
            for (BankVersionInfo bankVersionInfo : bankVersionInfoList) {
                CosmicCache.cosmicCache.remove(prefix + bankVersionInfo.getBankVersionID());
            }
        }
    }
}

