/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.mservice.boot.handler;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Objects;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.util.StringUtils;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.entity.base.EBException;
import kd.ebg.egf.common.entity.base.EBHeader;
import kd.ebg.egf.common.entity.base.EBRequest;
import kd.ebg.egf.common.entity.base.EBResponse;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.biz.EBServiceMethod;
import kd.ebg.egf.common.framework.frame.Sequence;
import kd.ebg.egf.common.framework.service.acnt.BankAcntService;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.JsonUtil;
import kd.ebg.egf.common.utils.string.StrUtil;
import kd.ebg.note.common.framework.properties.SystemPropertyConfig;
import kd.ebg.note.common.utils.ReflectUtil;
import org.slf4j.MDC;

public class EBServiceHandler<REQ extends EBRequest, RSP extends EBResponse> {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(EBServiceHandler.class);
    private final Class<REQ> requestClass;
    private final Class<RSP> responseClass;
    private final EBServiceMethod<REQ, RSP> serviceMethod;
    private final String method;
    private static final String BIZ_NAME_KEY = "bizName";
    private static final String BIZ_SEQ_KEY = "bizSeqID";

    EBServiceHandler(String method, EBServiceMethod<REQ, RSP> serviceMethod, Class<REQ> requestClass, Class<RSP> responseClass) {
        this.method = method;
        this.serviceMethod = serviceMethod;
        this.requestClass = requestClass;
        this.responseClass = responseClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String handler(String content, String customID) {
        String bizSeqID = Sequence.gen18Sequence();
        MDC.put((String)BIZ_NAME_KEY, (String)this.method);
        MDC.put((String)BIZ_SEQ_KEY, (String)bizSeqID);
        EBRequest request = (EBRequest)JsonUtil.json2Obj((String)content, this.requestClass);
        EBHeader header = request.getHeader();
        String accountNo = header.getAccNo();
        String customId = header.getCustomId();
        String bankVersion = "";
        String bankLogin = header.getBankVersion();
        if (!StringUtils.isEmpty((String)bankLogin)) {
            bankVersion = bankLogin.split("-")[0];
        } else if (accountNo != null) {
            bankVersion = "";
        }
        EBContext context = EBContext.builder().createTime(System.currentTimeMillis()).customID(customID).requestSeqID("").bizName(header.getBizType()).subBizName(header.getSubBizType()).bankVersionID(bankVersion).bizSeqID(bizSeqID).requestSeqID(Sequence.gen18Sequence()).build();
        EBContext.setContext((EBContext)context);
        String accNo = header.getAccNo();
        if ("ping".equalsIgnoreCase(header.getBizType())) {
            JSONObject obj = JSON.parseObject((String)header.getExtData());
            bankVersion = obj.getString("bankVersionID");
            bankLogin = obj.getString("bankLoginID");
            context.setBankLoginID(bankLogin);
            context.setBankVersionID(bankVersion);
        }
        logger.info("\u8c03\u7528\u4e86 {}", (Object)this.method);
        if ("detail".equalsIgnoreCase(this.method) && !this.checkQueryDetail(accNo)) {
            throw EBExceiptionUtil.preCheckException((String)String.format(ResManager.loadKDString((String)"\u5f53\u524d\u8d26\u53f7\uff1a%s,\u4e0d\u5141\u8bb8\u67e5\u8be2\u4ea4\u6613\u660e\u7ec6", (String)"EBServiceHandler_7", (String)"ebg-note-mservice", (Object[])new Object[0]), accNo));
        }
        if (this.serviceMethod.needCheckAccNo()) {
            if (StrUtil.isBlank((CharSequence)accNo)) {
                throw EBExceiptionUtil.preCheckException((String)ResManager.loadKDString((String)"\u672a\u5728\u8bf7\u6c42\u5934\u4e2d\u627e\u5230\u5e10\u53f7\u3002", (String)"EBServiceHandler_2", (String)"ebg-note-mservice", (Object[])new Object[0]));
            }
            if (StringUtils.isEmpty((String)bankLogin)) {
                BankAcnt acnt = BankAcntService.getInstance().selectByCustomIDAndAccNo(accNo, customID);
                if (null == acnt) {
                    throw EBExceiptionUtil.preCheckException((String)String.format(ResManager.loadKDString((String)"\u4f7f\u7528\u4e86\u94f6\u4f01\u4e91\u4e2d\u672a\u7ef4\u62a4\u7684\u8d26\u53f7:%s\u3002", (String)"EBServiceHandler_8", (String)"ebg-note-mservice", (Object[])new Object[0]), accNo));
                }
                logger.info("\u94f6\u4f01\u5e73\u53f0\u4e2d\u6709\u8fd9\u4e2a\u8d26\u53f7: " + acnt.getAccNo());
                context.setBankAcnt(acnt);
                context.setBankLoginID(acnt.getBankLoginId());
                context.setBankVersionID(acnt.getBankVersionId());
            } else {
                context.setBankLoginID(bankLogin);
                context.setBankVersionID(bankVersion);
            }
        }
        this.recordInvoke(context);
        EBResponse response = null;
        try {
            response = this.serviceMethod.executeClientRequest(request, context);
            response.setHeader(header);
            EBHeader rspHeader = response.getHeader();
            rspHeader.setResponseTime(System.currentTimeMillis());
            header.setResponseTime(System.currentTimeMillis());
            String string = JsonUtil.toJson((Object)response);
            return string;
        }
        catch (Throwable t) {
            logger.error("\u94f6\u4f01\u4e2d\u95f4\u4ef6\u629b\u5411\u4e1a\u52a1\u7cfb\u7edf\u7684\u5f02\u5e38:" + t.getMessage(), t);
            if (Objects.isNull(header)) {
                header = new EBHeader();
                header.setOperationName(this.method);
            }
            header.setResponseTime(System.currentTimeMillis());
            response = (EBResponse)ReflectUtil.newInstance(this.responseClass);
            response.setHeader(header);
            LocalDateTime returnTime = LocalDateTime.now();
            EBHeader rspHeader = response.getHeader();
            rspHeader.setResponseTime(System.currentTimeMillis());
            EBException ebException = new EBException();
            ebException.setMessage(t.getMessage());
            response.setException(ebException);
            String string = JsonUtil.toJson((Object)response);
            return string;
        }
        finally {
            logger.info("\u7ed3\u675f {}", (Object)this.method);
        }
    }

    private void recordInvoke(EBContext context) {
        String accNo = "";
        String bankVersionID = "";
        String bankLoginID = "";
        if (!Objects.isNull(context.getBankAcnt())) {
            accNo = context.getBankAcnt().getAccNo();
            bankVersionID = context.getBankVersionID();
            bankLoginID = context.getBankLoginID();
        }
        String bizName = context.getBizName();
        String subBizName = context.getSubBizName();
        String customID = context.getCustomID();
        String requestSeqID = context.getRequestSeqID();
        String bizSeqID = context.getBizSeqID();
    }

    private BankAcnt convertAdress(BankAcnt acnt) {
        if (StrUtil.isBlank((CharSequence)acnt.getBankAddress())) {
            throw EBExceiptionUtil.preCheckException((String)String.format(ResManager.loadKDString((String)"\u8bf7\u7ef4\u62a4%1$s\u5e10\u53f7%2$s\u7684[\u94f6\u884c\u5730\u5740]\u6216\u8005\u5f00\u6237\u5730\u533a\u4fe1\u606f[\u56fd\u5bb6\u3001\u7701\u4efd\u548c\u57ce\u5e02\u540d\u79f0]\u3002", (String)"EBServiceHandler_9", (String)"ebg-note-mservice", (Object[])new Object[0]), acnt.getBankName(), acnt.getAccNo()));
        }
        return acnt;
    }

    private boolean checkQueryDetail(String accNo) {
        List queryDetailAcntList = SystemPropertyConfig.getQueryDetailList();
        if (queryDetailAcntList != null && queryDetailAcntList.size() > 0) {
            return queryDetailAcntList.contains(accNo);
        }
        return true;
    }
}

