/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.boc.net.service.codeless.errorCode;

import java.io.InputStream;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.utils.file.ClassPathResource;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.DataFormatter;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class BankCodeValidator {
    private static final String fileName = "bocnetcode.xlsx";
    private static final Map<String, Set<String>> outerCodeCache = new ConcurrentHashMap<String, Set<String>>();
    private static final Map<String, Set<String>> innerCodeCache = new ConcurrentHashMap<String, Set<String>>();
    private static final DataFormatter dataFormatter = new DataFormatter();
    public static BankCodeValidator instance;

    public static BankCodeValidator getInstance() {
        if (null == instance) {
            instance = new BankCodeValidator();
        }
        return instance;
    }

    private BankCodeValidator() {
        BankCodeValidator.loadAllSheets();
    }

    public static boolean validateOuterCode(String code, String rspcod) {
        return BankCodeValidator.validate(code, rspcod, outerCodeCache);
    }

    public static boolean validateInnerCode(String code, String rspcod) {
        boolean codeCheck = BankCodeValidator.validate(code, rspcod, innerCodeCache);
        if (!codeCheck) {
            return BankCodeValidator.validate("common", rspcod, innerCodeCache);
        }
        return codeCheck;
    }

    private static boolean validate(String code, String rspcod, Map<String, Set<String>> cache) {
        if (rspcod == null || rspcod.isEmpty()) {
            return false;
        }
        Set<String> codes = cache.get(code);
        return codes != null && codes.contains(rspcod);
    }

    private static void loadAllSheets() {
        try (InputStream in = new ClassPathResource(fileName).getInputStream();
             XSSFWorkbook workbook = new XSSFWorkbook(in);){
            int sheetCount = workbook.getNumberOfSheets();
            for (int i = 0; i < sheetCount; ++i) {
                Sheet sheet = workbook.getSheetAt(i);
                String sheetName = sheet.getSheetName();
                Set<String> outerCodes = BankCodeValidator.extractColumnData(sheet, 2);
                Set<String> innerCodes = BankCodeValidator.extractColumnData(sheet, 4);
                outerCodeCache.put(sheetName, outerCodes);
                innerCodeCache.put(sheetName, innerCodes);
            }
        }
        catch (Throwable e) {
            throw EBExceiptionUtil.serviceException((String)"reload  Excel error", (Throwable)e);
        }
    }

    private static Set<String> extractColumnData(Sheet sheet, int columnIndex) {
        HashSet<String> result = new HashSet<String>();
        Iterator rowIterator = sheet.iterator();
        if (!rowIterator.hasNext()) {
            return result;
        }
        rowIterator.next();
        while (rowIterator.hasNext()) {
            Row row = (Row)rowIterator.next();
            Cell cell = row.getCell(columnIndex, Row.MissingCellPolicy.CREATE_NULL_AS_BLANK);
            String cellValue = dataFormatter.formatCellValue(cell).trim();
            if (cellValue.isEmpty()) continue;
            result.add(cellValue);
        }
        return Collections.unmodifiableSet(result);
    }
}

