/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.boc.net.service.codeless.payable.register;

import java.time.format.DateTimeFormatter;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.framework.frame.Sequence;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.note.banks.boc.net.service.BocNetUtils;
import kd.ebg.note.banks.boc.net.service.Packer;
import kd.ebg.note.banks.boc.net.service.codeless.errorCode.CodeUtil;
import kd.ebg.note.banks.boc.net.service.codeless.payable.QueryPayableImpl;
import kd.ebg.note.banks.boc.net.service.login.LoginAccess;
import kd.ebg.note.banks.boc.net.service.login.LoginAccessManager;
import kd.ebg.note.business.notePayable.atomic.AbstractNotePayableImpl;
import kd.ebg.note.business.notePayable.atomic.IQueryNotePayable;
import kd.ebg.note.business.notePayable.bank.BankNotePayableRequest;
import kd.ebg.note.business.notePayable.util.EBGNotePayableUtils;
import kd.ebg.note.common.entity.biz.status.PaymentState;
import kd.ebg.note.common.model.NotePayableInfo;
import org.jdom2.Element;

public class CodelessRegisterImpl
extends AbstractNotePayableImpl {
    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryNotePayable> defaultQueryClass() {
        return QueryPayableImpl.class;
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "b2e0704";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u94f6\u627f\u51fa\u7968", (String)"CodelessRegisterImpl_0", (String)"ebg-note-banks-boc-net", (Object[])new Object[0]);
    }

    public void configFactory(ConnectionFactory factory) {
        factory.setUri("/B2EC/E2BServlet");
    }

    public boolean match(NotePayableInfo notePayableInfo) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String pack4Business(BankNotePayableRequest request, String s) {
        LoginAccess la = LoginAccessManager.searchLock();
        List infos = request.getNotePayableInfoList();
        try {
            String requestStr;
            String token = "test".equals(EBContext.getContext().getBankLoginID()) ? "testToken" : la.getToken();
            Element root = BocNetUtils.createRoot();
            Element head = JDomUtils.addChild((Element)root, (String)"head");
            JDomUtils.addChild((Element)head, (String)"termid", (String)RequestContextUtils.getBankParameterValue((String)"termid"));
            JDomUtils.addChild((Element)head, (String)"trnid", (String)Packer.getTrnid());
            JDomUtils.addChild((Element)head, (String)"custid", (String)RequestContextUtils.getBankParameterValue((String)"custid"));
            JDomUtils.addChild((Element)head, (String)"cusopr", (String)RequestContextUtils.getBankParameterValue((String)"cusopr"));
            JDomUtils.addChild((Element)head, (String)"trncod", (String)"b2e0685");
            JDomUtils.addChild((Element)head, (String)"token", (String)token);
            Element trans = JDomUtils.addChild((Element)root, (String)"trans");
            Element trn = JDomUtils.addChild((Element)trans, (String)"trn-b2e0685-rq");
            JDomUtils.addChild((Element)trn, (String)"ceitinfo");
            for (int i = 0; i < infos.size(); ++i) {
                Element rq = JDomUtils.addChild((Element)trn, (String)"b2e0685-rq");
                Element drawee = JDomUtils.addChild((Element)rq, (String)"drawee");
                JDomUtils.addChild((Element)drawee, (String)"actacn", (String)((NotePayableInfo)infos.get(0)).getDrawerAccNo());
                JDomUtils.addChild((Element)rq, (String)"insid", (String)((NotePayableInfo)infos.get(i)).getBankDetailSeqId());
                Element toactn = JDomUtils.addChild((Element)rq, (String)"toactn");
                JDomUtils.addChild((Element)toactn, (String)"payeebankcnaps", (String)((NotePayableInfo)infos.get(i)).getPayeeBankCnaps());
                JDomUtils.addChild((Element)toactn, (String)"actacn", (String)((NotePayableInfo)infos.get(i)).getPayeeAccNo());
                JDomUtils.addChild((Element)toactn, (String)"actnam", (String)((NotePayableInfo)infos.get(i)).getPayeeAccName());
                JDomUtils.addChild((Element)toactn, (String)"toorgcode");
                Element acceptor = JDomUtils.addChild((Element)rq, (String)"acceptor");
                JDomUtils.addChild((Element)acceptor, (String)"acpbnk", (String)((NotePayableInfo)infos.get(i)).getAcceptorBankCnaps());
                JDomUtils.addChild((Element)acceptor, (String)"actorgcode");
                JDomUtils.addChild((Element)acceptor, (String)"actnam", (String)((NotePayableInfo)infos.get(i)).getAcceptorAccName());
                JDomUtils.addChild((Element)acceptor, (String)"actacn", (String)((NotePayableInfo)infos.get(i)).getAcceptorAccNo());
                JDomUtils.addChild((Element)rq, (String)"bookdate", (String)((NotePayableInfo)infos.get(i)).getBookingDate().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
                JDomUtils.addChild((Element)rq, (String)"duedate", (String)((NotePayableInfo)infos.get(i)).getDueDate().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
                JDomUtils.addChild((Element)rq, (String)"amount", (String)((NotePayableInfo)infos.get(i)).getAmount().toPlainString());
                JDomUtils.addChild((Element)rq, (String)"transferflg", (String)((NotePayableInfo)infos.get(i)).getTransferFlag());
                JDomUtils.addChild((Element)rq, (String)"memo", (String)((NotePayableInfo)infos.get(i)).getExplanation());
                this.checkRegister((NotePayableInfo)infos.get(i));
                JDomUtils.addChild((Element)rq, (String)"autoacp", (String)((NotePayableInfo)infos.get(i)).getAutoAccept());
                JDomUtils.addChild((Element)rq, (String)"autorec", (String)((NotePayableInfo)infos.get(i)).getAutoReceive());
                JDomUtils.addChild((Element)rq, (String)"splitable", (String)((NotePayableInfo)infos.get(i)).getGrdBag());
            }
            String string = requestStr = JDomUtils.root2String((Element)root, (String)RequestContextUtils.getCharset());
            return string;
        }
        finally {
            la.unavailableRelease();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String pack4Bank(BankNotePayableRequest request, String s) {
        LoginAccess la = LoginAccessManager.searchLock();
        List infos = request.getNotePayableInfoList();
        try {
            String requestStr;
            String token = la.getToken();
            Element root = BocNetUtils.createRoot();
            Element head = JDomUtils.addChild((Element)root, (String)"head");
            JDomUtils.addChild((Element)head, (String)"termid", (String)RequestContextUtils.getBankParameterValue((String)"termid"));
            JDomUtils.addChild((Element)head, (String)"trnid", (String)Packer.getTrnid());
            JDomUtils.addChild((Element)head, (String)"custid", (String)RequestContextUtils.getBankParameterValue((String)"custid"));
            JDomUtils.addChild((Element)head, (String)"cusopr", (String)RequestContextUtils.getBankParameterValue((String)"cusopr"));
            JDomUtils.addChild((Element)head, (String)"trncod", (String)"b2e0704");
            JDomUtils.addChild((Element)head, (String)"token", (String)token);
            Element trans = JDomUtils.addChild((Element)root, (String)"trans");
            Element trn = JDomUtils.addChild((Element)trans, (String)"trn-b2e0704-rq");
            JDomUtils.addChild((Element)trn, (String)"ceitinfo");
            Element drawee = JDomUtils.addChild((Element)trn, (String)"drawee");
            JDomUtils.addChild((Element)drawee, (String)"actacn", (String)((NotePayableInfo)infos.get(0)).getDrawerAccNo());
            if (infos.size() > 50) {
                throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u51fa\u7968\u4e0d\u80fd\u8d85\u8fc750\u7b14", (String)"CodelessRegisterImpl_1", (String)"ebg-note-banks-boc-net", (Object[])new Object[0]));
            }
            for (int i = 0; i < infos.size(); ++i) {
                Element rq = JDomUtils.addChild((Element)trn, (String)"b2e0704-rq");
                JDomUtils.addChild((Element)rq, (String)"insid", (String)((NotePayableInfo)infos.get(i)).getBankDetailSeqId());
                Element toactn = JDomUtils.addChild((Element)rq, (String)"toactn");
                JDomUtils.addChild((Element)toactn, (String)"payeebankcnaps", (String)((NotePayableInfo)infos.get(i)).getPayeeBankCnaps());
                JDomUtils.addChild((Element)toactn, (String)"actacn", (String)((NotePayableInfo)infos.get(i)).getPayeeAccNo());
                JDomUtils.addChild((Element)toactn, (String)"actnam", (String)((NotePayableInfo)infos.get(i)).getPayeeAccName());
                JDomUtils.addChild((Element)toactn, (String)"toorgcode");
                Element acceptor = JDomUtils.addChild((Element)rq, (String)"acceptor");
                JDomUtils.addChild((Element)acceptor, (String)"acpbnk", (String)((NotePayableInfo)infos.get(i)).getAcceptorBankCnaps());
                JDomUtils.addChild((Element)acceptor, (String)"actorgcode");
                JDomUtils.addChild((Element)acceptor, (String)"actnam", (String)((NotePayableInfo)infos.get(i)).getAcceptorAccName());
                JDomUtils.addChild((Element)rq, (String)"bookdate", (String)((NotePayableInfo)infos.get(i)).getBookingDate().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
                JDomUtils.addChild((Element)rq, (String)"duedate", (String)((NotePayableInfo)infos.get(i)).getDueDate().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
                JDomUtils.addChild((Element)rq, (String)"amount", (String)((NotePayableInfo)infos.get(i)).getAmount().toPlainString());
                JDomUtils.addChild((Element)rq, (String)"transferflg", (String)((NotePayableInfo)infos.get(i)).getTransferFlag());
                String sequence = Sequence.genSequence();
                JDomUtils.addChild((Element)rq, (String)"memo", (String)((NotePayableInfo)infos.get(i)).getExplanation());
                ((NotePayableInfo)infos.get(i)).setSequence(sequence);
                this.checkRegister((NotePayableInfo)infos.get(i));
                JDomUtils.addChild((Element)rq, (String)"autoacp", (String)((NotePayableInfo)infos.get(i)).getAutoAccept());
                JDomUtils.addChild((Element)rq, (String)"autorec", (String)((NotePayableInfo)infos.get(i)).getAutoReceive());
                JDomUtils.addChild((Element)rq, (String)"splitable", (String)((NotePayableInfo)infos.get(i)).getGrdBag());
            }
            String string = requestStr = JDomUtils.root2String((Element)root, (String)RequestContextUtils.getCharset());
            return string;
        }
        finally {
            la.unavailableRelease();
        }
    }

    public String pack(BankNotePayableRequest bankNotePayableRequest, String s) {
        NotePayableInfo[] infos = bankNotePayableRequest.getNotePayableInfosAsArray();
        if (infos[0].getDraftType().equals("AC01")) {
            return this.pack4Bank(bankNotePayableRequest, s);
        }
        return this.pack4Business(bankNotePayableRequest, s);
    }

    public List<NotePayableInfo> parse(BankNotePayableRequest request, String responseStr) {
        String bankCode;
        String bankCode1;
        List notePayableInfos = request.getNotePayableInfoList();
        NotePayableInfo info = (NotePayableInfo)notePayableInfos.get(0);
        Element root = JDomUtils.string2Root((String)responseStr, (String)RequestContextUtils.getCharset());
        Element trans = root.getChild("trans");
        String code = "";
        if (info.getDraftType().equals("AC01")) {
            bankCode1 = "b2e0704-rs";
            bankCode = "trn-b2e0704-rs";
            code = "b2e0704";
        } else {
            bankCode1 = "b2e0685-rs";
            bankCode = "trn-b2e0685-rs";
            code = "b2e0685";
        }
        Element trn = trans.getChild(bankCode);
        if (trn == null) {
            Element b2eerror = trans.getChild("trn-b2eerror-rs");
            Element status = b2eerror.getChild("status");
            String rspcod = status.getChildTextTrim("rspcod");
            String rspmsg = status.getChildTextTrim("rspmsg");
            EBGNotePayableUtils.setPaymentState((List)notePayableInfos, (PaymentState)PaymentState.UNKNOWN, (String)rspcod, (String)rspmsg);
            return notePayableInfos;
        }
        Element status = trn.getChild("status");
        String rspcod = status.getChildTextTrim("rspcod");
        String rspmsg = status.getChildTextTrim("rspmsg");
        LoginAccessManager.searchLock().checkTokenValid(rspcod);
        if (CodeUtil.validateOuterCode(code, rspcod)) {
            EBGNotePayableUtils.setPaymentState((List)notePayableInfos, (PaymentState)PaymentState.FAIL, (String)rspcod, (String)rspmsg);
        } else if (!"B001".equals(rspcod) && !"B054".equals(rspcod)) {
            EBGNotePayableUtils.setPaymentState((List)notePayableInfos, (PaymentState)PaymentState.UNKNOWN, (String)rspcod, (String)rspmsg);
        } else {
            List list = trn.getChildren(bankCode1);
            int size = list.size();
            for (int i = 0; i < size; ++i) {
                Element rs = (Element)list.get(i);
                String insid = rs.getChildTextTrim("insid");
                Element another_status = rs.getChild("status");
                String another_rspcod = another_status.getChildTextTrim("rspcod");
                String another_rspmsg = another_status.getChildTextTrim("rspmsg");
                String obssid = rs.getChildText("obssid");
                for (NotePayableInfo notePayableInfo : notePayableInfos) {
                    if (!insid.equals(notePayableInfo.getBankDetailSeqId()) && !insid.equals("12345678910")) continue;
                    notePayableInfo.setObssid(obssid);
                    notePayableInfo.setRspserialno(obssid);
                    if ("B001".equals(another_rspcod) || "B266".equals(another_rspcod)) {
                        EBGNotePayableUtils.setPaymentState((NotePayableInfo)notePayableInfo, (PaymentState)PaymentState.SUBMITED, (String)another_rspcod, (String)another_rspmsg);
                        continue;
                    }
                    if (StringUtils.isEmpty((String)obssid) && ("B5002".equals(another_rspcod) || "B5012".equals(another_rspcod))) {
                        EBGNotePayableUtils.setPaymentState((NotePayableInfo)notePayableInfo, (PaymentState)PaymentState.FAIL, (String)another_rspcod, (String)another_rspmsg);
                        continue;
                    }
                    if (CodeUtil.validateInnerCode(code, another_rspcod)) {
                        EBGNotePayableUtils.setPaymentState((NotePayableInfo)notePayableInfo, (PaymentState)PaymentState.FAIL, (String)another_rspcod, (String)another_rspmsg);
                        continue;
                    }
                    EBGNotePayableUtils.setPaymentState((NotePayableInfo)notePayableInfo, (PaymentState)PaymentState.UNKNOWN, (String)another_rspcod, (String)another_rspmsg);
                }
            }
        }
        return notePayableInfos;
    }

    private void checkRegister(NotePayableInfo notePayableInfo) {
        if (!notePayableInfo.getAutoReceive().equals(notePayableInfo.getAutoAccept())) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u81ea\u52a8\u627f\u5151\u548c\u81ea\u52a8\u51fa\u7968\u5fc5\u987b\u4fdd\u6301\u4e00\u81f4", (String)"CodelessRegisterImpl_3", (String)"ebg-note-banks-boc-net", (Object[])new Object[0]));
        }
    }
}

