/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.boc.net.service.codeless.payable.revocation;

import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.note.banks.boc.net.service.Packer;
import kd.ebg.note.banks.boc.net.service.codeless.errorCode.CodeUtil;
import kd.ebg.note.banks.boc.net.service.codeless.payable.QueryPayableImpl;
import kd.ebg.note.banks.boc.net.service.login.LoginAccess;
import kd.ebg.note.banks.boc.net.service.login.LoginAccessManager;
import kd.ebg.note.business.notePayable.atomic.AbstractNotePayableImpl;
import kd.ebg.note.business.notePayable.atomic.IQueryNotePayable;
import kd.ebg.note.business.notePayable.bank.BankNotePayableRequest;
import kd.ebg.note.business.notePayable.util.EBGNotePayableUtils;
import kd.ebg.note.common.entity.biz.status.PaymentState;
import kd.ebg.note.common.model.NotePayableInfo;
import org.jdom2.Element;

public class RevocationImpl
extends AbstractNotePayableImpl {
    public int getBatchSize() {
        return 0;
    }

    public Class<? extends IQueryNotePayable> defaultQueryClass() {
        return QueryPayableImpl.class;
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "b2e0688";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u64a4\u7968", (String)"RevocationImpl_0", (String)"ebg-note-banks-boc-net", (Object[])new Object[0]);
    }

    public boolean match(NotePayableInfo notePayableInfo) {
        return false;
    }

    public void configFactory(ConnectionFactory factory) {
        factory.setUri("/B2EC/E2BServlet");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String pack(BankNotePayableRequest bankNotePayableRequest, String s) {
        LoginAccess la = LoginAccessManager.searchLock();
        try {
            String requestStr;
            List notePayableInfoList = bankNotePayableRequest.getNotePayableInfoList();
            NotePayableInfo info = (NotePayableInfo)notePayableInfoList.get(0);
            String token = "test".equals(EBContext.getContext().getBankLoginID()) ? "testToken" : la.getToken();
            Element root = Packer.getHeader((String)token, (String)this.getBizCode());
            Element trans = JDomUtils.addChild((Element)root, (String)"trans");
            Element trn = JDomUtils.addChild((Element)trans, (String)"trn-b2e0688-rq");
            JDomUtils.addChild((Element)trn, (String)"ceitinfo");
            Element rq = JDomUtils.addChild((Element)trn, (String)"b2e0688-rq");
            JDomUtils.addChild((Element)trn, (String)"ceitinfo");
            JDomUtils.addChild((Element)rq, (String)"actacn", (String)info.getDrawerAccNo());
            JDomUtils.addChild((Element)rq, (String)"insid", (String)info.getBankBatchSeqId());
            JDomUtils.addChild((Element)rq, (String)"draftno", (String)info.getBillNo());
            JDomUtils.addChild((Element)rq, (String)"scbintvl", (String)info.getSubRange());
            String string = requestStr = JDomUtils.root2String((Element)root, (String)RequestContextUtils.getCharset());
            return string;
        }
        finally {
            la.unavailableRelease();
        }
    }

    public List<NotePayableInfo> parse(BankNotePayableRequest request, String responseStr) {
        List notePayableInfos = request.getNotePayableInfoList();
        Element root = JDomUtils.string2Root((String)responseStr, (String)RequestContextUtils.getCharset());
        Element trans = root.getChild("trans");
        Element trn = trans.getChild("trn-b2e0688-rs");
        if (trn == null) {
            Element b2eerror = trans.getChild("trn-b2eerror-rs");
            Element status = b2eerror.getChild("status");
            String rspcod = status.getChildTextTrim("rspcod");
            String rspmsg = status.getChildTextTrim("rspmsg");
            EBGNotePayableUtils.setPaymentState((List)notePayableInfos, (PaymentState)PaymentState.UNKNOWN, (String)rspcod, (String)rspmsg);
            return notePayableInfos;
        }
        Element status = trn.getChild("status");
        String rspcod = status.getChildTextTrim("rspcod");
        String rspmsg = status.getChildTextTrim("rspmsg");
        LoginAccessManager.searchLock().checkTokenValid(rspcod);
        if (CodeUtil.validateOuterCode("b2e0688", rspcod)) {
            EBGNotePayableUtils.setPaymentState((List)notePayableInfos, (PaymentState)PaymentState.FAIL, (String)rspcod, (String)rspmsg);
        } else if (!"B001".equals(rspcod)) {
            EBGNotePayableUtils.setPaymentState((List)notePayableInfos, (PaymentState)PaymentState.UNKNOWN, (String)rspcod, (String)rspmsg);
        } else {
            List list = trn.getChildren("b2e0688-rs");
            int size = list.size();
            for (int i = 0; i < size; ++i) {
                Element rs = (Element)list.get(i);
                String draftno = rs.getChildTextTrim("draftno");
                Element another_status = rs.getChild("status");
                String another_rspcod = another_status.getChildTextTrim("rspcod");
                String another_rspmsg = another_status.getChildTextTrim("rspmsg");
                String obssid = rs.getChildText("obssid");
                for (NotePayableInfo notePayableInfo : notePayableInfos) {
                    if (!draftno.equals(notePayableInfo.getBillNo()) && !draftno.equals("12345678910")) continue;
                    notePayableInfo.setObssid(obssid);
                    notePayableInfo.setRspserialno(obssid);
                    if ("B001".equals(another_rspcod) || "B266".equals(another_rspcod)) {
                        EBGNotePayableUtils.setPaymentState((NotePayableInfo)notePayableInfo, (PaymentState)PaymentState.SUBMITED, (String)another_rspcod, (String)another_rspmsg);
                        notePayableInfo.setQueryType("revocation");
                        continue;
                    }
                    if (StringUtils.isEmpty((String)obssid) && ("B5002".equals(another_rspcod) || "B5012".equals(another_rspcod))) {
                        EBGNotePayableUtils.setPaymentState((NotePayableInfo)notePayableInfo, (PaymentState)PaymentState.FAIL, (String)another_rspcod, (String)another_rspmsg);
                        continue;
                    }
                    if (CodeUtil.validateInnerCode("b2e0688", another_rspcod)) {
                        EBGNotePayableUtils.setPaymentState((NotePayableInfo)notePayableInfo, (PaymentState)PaymentState.FAIL, (String)another_rspcod, (String)another_rspmsg);
                        continue;
                    }
                    EBGNotePayableUtils.setPaymentState((NotePayableInfo)notePayableInfo, (PaymentState)PaymentState.UNKNOWN, (String)another_rspcod, (String)another_rspmsg);
                }
            }
        }
        return notePayableInfos;
    }
}

