/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.boc.net.service.codeless.receivable.payment;

import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.framework.frame.Sequence;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.note.banks.boc.net.service.BocNetUtils;
import kd.ebg.note.banks.boc.net.service.Packer;
import kd.ebg.note.banks.boc.net.service.Parser;
import kd.ebg.note.banks.boc.net.service.codeless.errorCode.CodeUtil;
import kd.ebg.note.banks.boc.net.service.codeless.receivable.QueryReceiveImpl;
import kd.ebg.note.banks.boc.net.service.login.LoginAccess;
import kd.ebg.note.banks.boc.net.service.login.LoginAccessManager;
import kd.ebg.note.business.noteReceivable.atomic.AbstractNoteReceivableImpl;
import kd.ebg.note.business.noteReceivable.atomic.IQueryNoteReceivable;
import kd.ebg.note.business.noteReceivable.bank.BankNoteReceivableRequest;
import kd.ebg.note.business.noteReceivable.util.EBGNoteReceivableUtils;
import kd.ebg.note.common.entity.biz.status.PaymentState;
import kd.ebg.note.common.model.NoteReceivableInfo;
import org.jdom2.Element;

public class PaymentImpl
extends AbstractNoteReceivableImpl {
    public int getBatchSize() {
        return 0;
    }

    public Class<? extends IQueryNoteReceivable> defaultQueryClass() {
        return QueryReceiveImpl.class;
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "b2e0695";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u63d0\u793a\u4ed8\u6b3e", (String)"PaymentImpl_0", (String)"ebg-note-banks-boc-net", (Object[])new Object[0]);
    }

    public boolean match(NoteReceivableInfo noteReceivableInfo) {
        return true;
    }

    public void configFactory(ConnectionFactory factory) {
        factory.setUri("/B2EC/E2BServlet");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String pack(BankNoteReceivableRequest request, String s) {
        List noteReceivableInfos = request.getNoteReceivableInfos();
        LoginAccess la = LoginAccessManager.searchLock();
        try {
            String token = "test".equals(EBContext.getContext().getBankLoginID()) ? "testToken" : la.getToken();
            Element root = BocNetUtils.createRoot();
            Element head = JDomUtils.addChild((Element)root, (String)"head");
            JDomUtils.addChild((Element)head, (String)"termid", (String)RequestContextUtils.getBankParameterValue((String)"termid"));
            JDomUtils.addChild((Element)head, (String)"trnid", (String)Packer.getTrnid());
            JDomUtils.addChild((Element)head, (String)"custid", (String)RequestContextUtils.getBankParameterValue((String)"custid"));
            JDomUtils.addChild((Element)head, (String)"cusopr", (String)RequestContextUtils.getBankParameterValue((String)"cusopr"));
            JDomUtils.addChild((Element)head, (String)"trncod", (String)"b2e0695");
            JDomUtils.addChild((Element)head, (String)"token", (String)token);
            Element trans = JDomUtils.addChild((Element)root, (String)"trans");
            Element trn = JDomUtils.addChild((Element)trans, (String)"trn-b2e0695-rq");
            JDomUtils.addChild((Element)trn, (String)"ceitinfo");
            for (int i = 0; i < noteReceivableInfos.size(); ++i) {
                Element rq = JDomUtils.addChild((Element)trn, (String)"b2e0695-rq");
                JDomUtils.addChild((Element)rq, (String)"actacn", (String)request.getAcnt().getAccNo());
                JDomUtils.addChild((Element)rq, (String)"draftno", (String)((NoteReceivableInfo)noteReceivableInfos.get(i)).getBillNo());
                JDomUtils.addChild((Element)rq, (String)"scbintvl", (String)((NoteReceivableInfo)noteReceivableInfos.get(i)).getSubRange());
                JDomUtils.addChild((Element)rq, (String)"amount", (String)(((NoteReceivableInfo)noteReceivableInfos.get(i)).getAmount() + ""));
                JDomUtils.addChild((Element)rq, (String)"overduereason", (String)("21".equals(((NoteReceivableInfo)noteReceivableInfos.get(i)).getOperationCode()) ? ((NoteReceivableInfo)noteReceivableInfos.get(i)).getExplanation() : ""));
                JDomUtils.addChild((Element)rq, (String)"memo", (String)((NoteReceivableInfo)noteReceivableInfos.get(i)).getExplanation());
                String sequence = Sequence.genSequence();
                JDomUtils.addChild((Element)rq, (String)"insid", (String)sequence);
            }
            String string = JDomUtils.root2String((Element)root, (String)RequestContextUtils.getCharset());
            return string;
        }
        finally {
            la.unavailableRelease();
        }
    }

    public List<NoteReceivableInfo> parse(BankNoteReceivableRequest request, String responseStr) {
        List noteReceivableInfos = request.getNoteReceivableInfos();
        Element root = JDomUtils.string2Root((String)responseStr, (String)RequestContextUtils.getCharset());
        Parser.parserB2eError((Element)root);
        Element trans = root.getChild("trans");
        Element trn = trans.getChild("trn-b2e0695-rs");
        Element status = trn.getChild("status");
        String rspcod = status.getChildTextTrim("rspcod");
        String rspmsg = status.getChildTextTrim("rspmsg");
        LoginAccessManager.searchLock().checkTokenValid(rspcod);
        if (CodeUtil.validateOuterCode("b2e0695", rspcod)) {
            EBGNoteReceivableUtils.setPaymentState((List)noteReceivableInfos, (PaymentState)PaymentState.FAIL, (String)rspcod, (String)rspmsg);
        } else if (!"B001".equals(rspcod)) {
            EBGNoteReceivableUtils.setPaymentState((List)noteReceivableInfos, (PaymentState)PaymentState.UNKNOWN, (String)rspcod, (String)rspmsg);
        } else {
            List list = trn.getChildren("b2e0695-rs");
            int size = list.size();
            block0: for (int i = 0; i < size; ++i) {
                Element rs = (Element)list.get(i);
                Element anotherStatus = rs.getChild("status");
                String another_rspcod = anotherStatus.getChildTextTrim("rspcod");
                String another_rspmsg = anotherStatus.getChildTextTrim("rspmsg");
                String obssid = rs.getChildTextTrim("obssid");
                String draftno = rs.getChildTextTrim("draftno");
                for (NoteReceivableInfo noteReceivableInfo : noteReceivableInfos) {
                    if (!draftno.equals(noteReceivableInfo.getBillNo())) continue;
                    noteReceivableInfo.setObssid(obssid);
                    noteReceivableInfo.setBankRefKey(obssid);
                    if ("B001".equals(another_rspcod) || "B266".equals(another_rspcod)) {
                        EBGNoteReceivableUtils.setPaymentState((NoteReceivableInfo)noteReceivableInfo, (PaymentState)PaymentState.SUBMITED, (String)another_rspcod, (String)another_rspmsg);
                        continue block0;
                    }
                    if (StringUtils.isEmpty((String)obssid) && ("B5002".equals(another_rspcod) || "B5012".equals(another_rspcod))) {
                        EBGNoteReceivableUtils.setPaymentState((NoteReceivableInfo)noteReceivableInfo, (PaymentState)PaymentState.FAIL, (String)another_rspcod, (String)another_rspmsg);
                        continue block0;
                    }
                    if (CodeUtil.validateInnerCode("code", another_rspcod)) {
                        EBGNoteReceivableUtils.setPaymentState((NoteReceivableInfo)noteReceivableInfo, (PaymentState)PaymentState.FAIL, (String)another_rspcod, (String)another_rspmsg);
                        continue block0;
                    }
                    EBGNoteReceivableUtils.setPaymentState((NoteReceivableInfo)noteReceivableInfo, (PaymentState)PaymentState.UNKNOWN, (String)another_rspcod, (String)another_rspmsg);
                    continue block0;
                }
            }
        }
        return noteReceivableInfos;
    }
}

