/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.boc.net.service.note.payable.accept;

import java.time.format.DateTimeFormatter;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.note.banks.boc.net.service.BocNetUtils;
import kd.ebg.note.banks.boc.net.service.Packer;
import kd.ebg.note.banks.boc.net.service.login.LoginAccess;
import kd.ebg.note.banks.boc.net.service.login.LoginAccessManager;
import kd.ebg.note.banks.boc.net.service.note.util.NoteSendMsgHelper;
import kd.ebg.note.business.notePayable.atomic.AbstractQueryNotePayableImpl;
import kd.ebg.note.business.notePayable.bank.BankNotePayableRequest;
import kd.ebg.note.business.notePayable.util.EBGNotePayableUtils;
import kd.ebg.note.common.entity.biz.status.PaymentState;
import kd.ebg.note.common.model.NotePayableInfo;
import org.jdom2.Element;

public class QueryAcceptNotePayableImpl
extends AbstractQueryNotePayableImpl {
    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "b2e0113";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u63d0\u793a\u627f\u5151\u67e5\u8be2", (String)"QueryAcceptNotePayableImpl_0", (String)"ebg-note-banks-boc-net", (Object[])new Object[0]);
    }

    public void configFactory(ConnectionFactory factory) {
        factory.setUri("/B2EC/E2BServlet");
    }

    public boolean match(NotePayableInfo notePayableInfo) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String pack(BankNotePayableRequest request, String pageTag) {
        List infos = request.getNotePayableInfoList();
        LoginAccess la = LoginAccessManager.searchLock();
        try {
            String token = la.getToken();
            Element root = BocNetUtils.createRoot();
            Element head = JDomUtils.addChild((Element)root, (String)"head");
            JDomUtils.addChild((Element)head, (String)"termid", (String)RequestContextUtils.getBankParameterValue((String)"termid"));
            JDomUtils.addChild((Element)head, (String)"trnid", (String)Packer.getTrnid());
            JDomUtils.addChild((Element)head, (String)"custid", (String)RequestContextUtils.getBankParameterValue((String)"custid"));
            JDomUtils.addChild((Element)head, (String)"cusopr", (String)RequestContextUtils.getBankParameterValue((String)"cusopr"));
            JDomUtils.addChild((Element)head, (String)"trncod", (String)"b2e0113");
            JDomUtils.addChild((Element)head, (String)"token", (String)token);
            Element trans = JDomUtils.addChild((Element)root, (String)"trans");
            Element trn = JDomUtils.addChild((Element)trans, (String)"trn-b2e0113-rq");
            if (infos.size() > 1) {
                throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u8bf7\u6c42\u6700\u591a\u4e3a1\u7b14\u3002", (String)"QueryAcceptNotePayableImpl_1", (String)"ebg-note-banks-boc-net", (Object[])new Object[0]));
            }
            Element rq = JDomUtils.addChild((Element)trn, (String)"b2e0113-rq");
            JDomUtils.addChild((Element)rq, (String)"ibknum", (String)"");
            JDomUtils.addChild((Element)rq, (String)"actacn", (String)((NotePayableInfo)infos.get(0)).getDrawerAccNo());
            JDomUtils.addChild((Element)rq, (String)"draftno", (String)((NotePayableInfo)infos.get(0)).getBillNo());
            JDomUtils.addChild((Element)rq, (String)"draweename", (String)((NotePayableInfo)infos.get(0)).getDrawerAccName());
            JDomUtils.addChild((Element)rq, (String)"acceptorname", (String)((NotePayableInfo)infos.get(0)).getAcceptorAccName());
            JDomUtils.addChild((Element)rq, (String)"toname", (String)((NotePayableInfo)infos.get(0)).getPayeeAccName());
            JDomUtils.addChild((Element)rq, (String)"drafttype", (String)((NotePayableInfo)infos.get(0)).getDraftType());
            JDomUtils.addChild((Element)rq, (String)"transtype", (String)"002");
            Element datescope = JDomUtils.addChild((Element)rq, (String)"datescope");
            JDomUtils.addChild((Element)datescope, (String)"from", (String)"");
            JDomUtils.addChild((Element)datescope, (String)"to", (String)"");
            if (((NotePayableInfo)infos.get(0)).getDueDate() != null) {
                Element duedatescope = JDomUtils.addChild((Element)rq, (String)"duedatescope");
                JDomUtils.addChild((Element)duedatescope, (String)"from", (String)((NotePayableInfo)infos.get(0)).getDueDate().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
                JDomUtils.addChild((Element)duedatescope, (String)"to", (String)((NotePayableInfo)infos.get(0)).getDueDate().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
            }
            if (((NotePayableInfo)infos.get(0)).getAmount() != null) {
                Element amountscope = JDomUtils.addChild((Element)rq, (String)"amountscope");
                JDomUtils.addChild((Element)amountscope, (String)"from", (String)((NotePayableInfo)infos.get(0)).getAmount().toString());
                JDomUtils.addChild((Element)amountscope, (String)"to", (String)((NotePayableInfo)infos.get(0)).getAmount().toString());
            }
            JDomUtils.addChild((Element)rq, (String)"begnum", (String)"1");
            JDomUtils.addChild((Element)rq, (String)"recnum", (String)"50");
            String string = JDomUtils.root2String((Element)root, (String)RequestContextUtils.getCharset());
            return string;
        }
        finally {
            la.unavailableRelease();
        }
    }

    public List<NotePayableInfo> parse(BankNotePayableRequest request, String responseStr) {
        Element root = JDomUtils.string2Root((String)responseStr, (String)RequestContextUtils.getCharset());
        List infos = request.getNotePayableInfoList();
        Element trans = root.getChild("trans");
        Element trn = trans.getChild("trn-b2e0113-rs");
        if (trn == null) {
            Element b2eerror = trans.getChild("trn-b2eerror-rs");
            Element status = b2eerror.getChild("status");
            String rspcod = status.getChildTextTrim("rspcod");
            String rspmsg = status.getChildTextTrim("rspmsg");
            EBGNotePayableUtils.setPaymentState((List)infos, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)rspcod, (String)rspmsg);
            return infos;
        }
        Element status = trn.getChild("status");
        String rspcod = status.getChildTextTrim("rspcod");
        String rspmsg = status.getChildTextTrim("rspmsg");
        String totalnum = trn.getChildTextTrim("totalnum");
        LoginAccessManager.searchLock().checkTokenValid(rspcod);
        if (!"B001".equals(rspcod)) {
            EBGNotePayableUtils.setPaymentState((List)infos, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)rspcod, (String)rspmsg);
        } else {
            List list = trn.getChildren("b2e0113-rs");
            int size = list.size();
            for (int i = 0; i < size; ++i) {
                Element rs = (Element)list.get(i);
                List statusAll = rs.getChildren("status");
                Element status01 = (Element)statusAll.get(0);
                Element status02 = (Element)statusAll.get(1);
                String bankStatue = status02.getText();
                String another_rspcod = status01.getChildTextTrim("rspcod");
                String another_rspmsg = status01.getChildTextTrim("rspmsg");
                String draftno = rs.getChildTextTrim("draftno");
                String msgseq = rs.getChildTextTrim("msgseq");
                if (!"B001".equals(another_rspcod)) {
                    EBGNotePayableUtils.setPaymentState((List)infos, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)another_rspcod, (String)another_rspmsg);
                    continue;
                }
                String msg = new NoteSendMsgHelper().sendAndRecvMsg0114(msgseq, "002", ((NotePayableInfo)infos.get(0)).getDrawerAccNo());
                String receiptOrNot = this.parseMsg(msg, ((NotePayableInfo)infos.get(0)).getSequence());
                if ("notMatch".equals(receiptOrNot)) continue;
                if ("SU00".equals(receiptOrNot)) {
                    EBGNotePayableUtils.setPaymentState((List)infos, (PaymentState)PaymentState.SUCCESS, (String)rspcod, (String)ResManager.loadKDString((String)"\u63d0\u793a\u627f\u5151\u5df2\u7b7e\u6536", (String)"QueryAcceptNotePayableImpl_2", (String)"ebg-note-banks-boc-net", (Object[])new Object[0]));
                    ((NotePayableInfo)infos.get(0)).setNoteStatus("020006");
                    continue;
                }
                if ("SU01".equals(receiptOrNot)) {
                    EBGNotePayableUtils.setPaymentState((List)infos, (PaymentState)PaymentState.FAIL, (String)rspcod, (String)ResManager.loadKDString((String)"\u624b\u52a8\u63d0\u793a\u627f\u5151\u906d\u5bf9\u65b9\u62d2\u7edd\u3002", (String)"QueryAcceptNotePayableImpl_3", (String)"ebg-note-banks-boc-net", (Object[])new Object[0]));
                    ((NotePayableInfo)infos.get(0)).setNoteStatus("010004");
                    continue;
                }
                if (!StringUtils.isEmpty((String)receiptOrNot)) continue;
                EBGNotePayableUtils.setPaymentState((List)infos, (PaymentState)PaymentState.SUBMITED, (String)rspcod, (String)ResManager.loadKDString((String)"\u63d0\u793a\u627f\u5151\u5f85\u7b7e\u6536", (String)"QueryAcceptNotePayableImpl_4", (String)"ebg-note-banks-boc-net", (Object[])new Object[0]));
                ((NotePayableInfo)infos.get(0)).setNoteStatus("020001");
            }
        }
        return infos;
    }

    private String parseMsg(String rsp, String sequence) {
        Element root1 = JDomUtils.string2Root((String)rsp, (String)RequestContextUtils.getCharset());
        Element trans1 = root1.getChild("trans");
        Element trn1 = trans1.getChild("trn-b2e0114-rs");
        Element status1 = trn1.getChild("status");
        String rspcod1 = status1.getChildTextTrim("rspcod");
        LoginAccessManager.searchLock().checkTokenValid(rspcod1);
        if (!"B001".equals(rspcod1)) {
            return "notMatch";
        }
        Element rs1 = trn1.getChild("b2e0114-rs");
        List status = rs1.getChildren("status");
        Element status01 = (Element)status.get(0);
        String another_rspcod = status01.getChildTextTrim("rspcod");
        if (!"B001".equals(another_rspcod)) {
            return "notMatch";
        }
        Element acceptor = rs1.getChild("acceptinfo");
        String memo = acceptor.getChildTextTrim("askmemo");
        String bacflg = rs1.getChildTextTrim("bacflg");
        if (sequence.equals(memo)) {
            return bacflg;
        }
        return "notMatch";
    }

    public int getBatchSize() {
        return 0;
    }
}

