/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.cmb.opa.service.note.payable.register.file;

import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.file.CleanPathUtil;
import kd.ebg.note.banks.cmb.opa.service.BankBusinessConfig;
import kd.ebg.note.banks.cmb.opa.service.note.util.PostUtil;

public class DCHelper {
    private static final String BOUNDARY_PREFIX = "--";
    private static final String LINE_END = "\r\n";
    static EBGLogger logger = EBGLogger.getInstance().getLogger(DCHelper.class);

    public static String sendFileMsg(String content, String filePath, String funcode) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        String loginName = RequestContextUtils.getBankParameterValue((String)"lgnnam");
        map.put("UID", loginName);
        logger.info("UID\uff1a" + loginName);
        String encoding = RequestContextUtils.getCharset();
        if (BankBusinessConfig.isSaasCloud()) {
            map.put("INSPLAT", "KINGDEE");
            map.put("ALG", "SM");
        }
        if (BankBusinessConfig.isNormal()) {
            map.put("ALG", "SM");
        }
        map.put("FUNCODE", funcode);
        HashMap<String, String> filePathMap = new HashMap<String, String>();
        String paramName = "multipartFile";
        filePathMap.put(paramName, filePath);
        String url = PostUtil.getUrl();
        logger.info("\u8bbf\u95ee\u7684\u94f6\u884c\u5730\u5740\uff1a" + url);
        try {
            map.put("DATA", URLEncoder.encode(content, encoding));
            String res = DCHelper.doPostFileUp(url, map, filePathMap);
            System.out.println("res:  " + res);
            return res;
        }
        catch (Exception e) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u4ea4\u4e92\u5931\u8d25", (String)"PostUtil_0", (String)"ebg-note-banks-cmb-opa", (Object[])new Object[0]), (Throwable)e);
        }
    }

    public static String getTime() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
        return dateFormat.format(new Date());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String doPostFileUp(String httpUrl, Map<String, Object> paramValues, Map<String, String> filePathMap) throws Exception {
        String result;
        BufferedReader br;
        OutputStream os;
        InputStream is;
        HttpURLConnection connection;
        block24: {
            connection = null;
            is = null;
            os = null;
            br = null;
            result = null;
            try {
                String temp;
                StringBuilder sbf;
                URL url = new URL(httpUrl);
                SSLContext sslcontext = SSLContext.getInstance("SSL");
                TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                tmf.init((KeyStore)null);
                X509TrustManager defaultTm = null;
                for (TrustManager tm : tmf.getTrustManagers()) {
                    if (!(tm instanceof X509TrustManager)) continue;
                    defaultTm = (X509TrustManager)tm;
                    break;
                }
                sslcontext.init(null, new TrustManager[]{defaultTm}, new SecureRandom());
                HttpsURLConnection.setDefaultSSLSocketFactory(sslcontext.getSocketFactory());
                connection = (HttpURLConnection)url.openConnection();
                connection.setRequestMethod("POST");
                connection.setConnectTimeout(15000);
                connection.setReadTimeout(60000);
                connection.setInstanceFollowRedirects(true);
                connection.setDoOutput(true);
                connection.setDoInput(true);
                String boundary = "CDCBoundary" + System.currentTimeMillis();
                connection.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + boundary);
                try (DataOutputStream out = new DataOutputStream(connection.getOutputStream());){
                    if (paramValues != null && !paramValues.isEmpty()) {
                        for (Map.Entry<String, Object> entry : paramValues.entrySet()) {
                            DCHelper.writeSimpleFormField(boundary, out, entry);
                        }
                    }
                    if (filePathMap != null && !filePathMap.isEmpty()) {
                        for (Map.Entry<String, String> filePath : filePathMap.entrySet()) {
                            DCHelper.writeFile(filePath.getKey(), filePath.getValue(), boundary, out);
                        }
                    }
                    String endStr = BOUNDARY_PREFIX + boundary + BOUNDARY_PREFIX + LINE_END;
                    out.write(endStr.getBytes());
                    out.flush();
                }
                if (connection.getResponseCode() != 200) {
                    is = connection.getErrorStream();
                    br = new BufferedReader(new InputStreamReader(is, "UTF-8"));
                    sbf = new StringBuilder();
                    temp = null;
                    while ((temp = br.readLine()) != null) {
                        sbf.append(temp);
                        sbf.append(LINE_END);
                    }
                    result = sbf.toString();
                    break block24;
                }
                is = connection.getInputStream();
                br = new BufferedReader(new InputStreamReader(is, "UTF-8"));
                sbf = new StringBuilder();
                temp = null;
                boolean firstLine = true;
                while ((temp = br.readLine()) != null) {
                    if (!firstLine) {
                        firstLine = false;
                        sbf.append(LINE_END);
                    }
                    sbf.append(temp);
                }
                result = sbf.toString();
            }
            catch (Throwable throwable) {
                DCHelper.safeClose(br);
                DCHelper.safeClose(os);
                DCHelper.safeClose(is);
                DCHelper.safeClose(connection);
                throw throwable;
            }
        }
        DCHelper.safeClose(br);
        DCHelper.safeClose(os);
        DCHelper.safeClose(is);
        DCHelper.safeClose(connection);
        return result;
    }

    public static void safeClose(HttpURLConnection connection) {
        if (connection != null) {
            try {
                connection.disconnect();
            }
            catch (Exception e) {
                logger.error("IOException", (Throwable)e);
            }
        }
    }

    public static void safeClose(BufferedReader br) {
        if (br != null) {
            try {
                br.close();
            }
            catch (IOException e) {
                logger.error("IOException", (Throwable)e);
            }
        }
    }

    public static void safeClose(OutputStream os) {
        if (os != null) {
            try {
                os.close();
            }
            catch (IOException e) {
                logger.error("IOException", (Throwable)e);
            }
        }
    }

    public static void safeClose(InputStream is) {
        if (is != null) {
            try {
                is.close();
            }
            catch (IOException e) {
                logger.error("IOException", (Throwable)e);
            }
        }
    }

    private static void writeSimpleFormField(String boundary, DataOutputStream out, Map.Entry<String, Object> entry) throws IOException {
        String boundaryStr = BOUNDARY_PREFIX + boundary + LINE_END;
        out.write(boundaryStr.getBytes());
        String contentDispositionStr = String.format("Content-Disposition: form-data; name=\"%s\"", entry.getKey()) + LINE_END + LINE_END;
        out.write(contentDispositionStr.getBytes());
        String valueStr = entry.getValue().toString() + LINE_END;
        out.write(valueStr.getBytes());
    }

    private static void writeFile(String paramName, String filePath, String boundary, DataOutputStream out) throws IOException {
        String boundaryStr = BOUNDARY_PREFIX + boundary + LINE_END;
        out.write(boundaryStr.getBytes());
        String fileName = new File(CleanPathUtil.cleanString((String)filePath)).getName();
        String contentDispositionStr = String.format("Content-Disposition: form-data; name=\"%s\"; filename=\"%s\"", paramName, fileName) + LINE_END;
        out.write(contentDispositionStr.getBytes());
        String contentType = "Content-Type: application/octet-stream\r\n\r\n";
        out.write(contentType.getBytes());
        File file = new File(CleanPathUtil.cleanString((String)filePath));
        try (FileInputStream fis = new FileInputStream(file);){
            int readLen;
            byte[] buffer = new byte[1024];
            while ((readLen = fis.read(buffer)) != -1) {
                out.write(buffer, 0, readLen);
            }
            out.write(LINE_END.getBytes());
        }
    }
}

