/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.cmb.opa.service.note.util;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.note.banks.cmb.opa.service.note.util.MsgParser;
import kd.ebg.note.banks.cmb.opa.service.note.util.ParserPayable;
import kd.ebg.note.business.noteReceivable.util.EBGNoteReceivableUtils;
import kd.ebg.note.common.entity.biz.status.PaymentState;
import kd.ebg.note.common.model.NoteReceivableInfo;

public class ParserReceivable {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(ParserPayable.class);

    public static void parsePay(List<NoteReceivableInfo> receivableInfos, String rspStr) {
        if (rspStr.contains("ErrMsg")) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u5f02\u5e38\uff1a%s\u3002", (String)"ParserReceivable_0", (String)"ebg-note-banks-cmb-opa", (Object[])new Object[0]), rspStr));
        }
        String res = MsgParser.getReceMsg((String)rspStr, (EBGLogger)logger);
        BankResponse response = MsgParser.getResponse((String)res, (EBGLogger)logger);
        if ("ET3SD49".equals(response.getResponseCode())) {
            EBGNoteReceivableUtils.setPaymentState(receivableInfos, (PaymentState)PaymentState.FAIL, (String)response.getResponseCode(), (String)response.getResponseMessage());
            return;
        }
        if (!"SUC0000".equals(response.getResponseCode())) {
            EBGNoteReceivableUtils.setPaymentState(receivableInfos, (PaymentState)PaymentState.UNKNOWN, (String)response.getResponseCode(), (String)response.getResponseMessage());
            return;
        }
        JSONObject request = JSONObject.parseObject((String)res);
        JSONObject resp = request.getJSONObject("response");
        JSONObject body = resp.getJSONObject("body");
        JSONArray batchBusOprZ1 = body.getJSONArray("batchBusOprZ1");
        JSONObject object = batchBusOprZ1.getJSONObject(0);
        String bchSts = object.getString("bchSts");
        String rjcCod = object.getString("rjcCod");
        String rjcRsn = object.getString("rjcRsn");
        if (!StringUtils.isEmpty((String)rjcCod) && !"SUC0000".equals(rjcCod)) {
            EBGNoteReceivableUtils.setPaymentState(receivableInfos, (PaymentState)PaymentState.UNKNOWN, (String)rjcCod, (String)rjcRsn);
        } else {
            EBGNoteReceivableUtils.setPaymentState(receivableInfos, (PaymentState)PaymentState.SUBMITED, (String)bchSts, (String)"");
        }
    }

    public static void parsePayResult(List<NoteReceivableInfo> receivableInfos, String rspStr) {
        if (rspStr.contains("ErrMsg")) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u5f02\u5e38\uff1a%s\u3002", (String)"ParserReceivable_0", (String)"ebg-note-banks-cmb-opa", (Object[])new Object[0]), rspStr));
        }
        String res = MsgParser.getReceMsg((String)rspStr, (EBGLogger)logger);
        BankResponse response = MsgParser.getResponse((String)res, (EBGLogger)logger);
        if (!"SUC0000".equals(response.getResponseCode())) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u5f02\u5e38\uff1a%s\u3002", (String)"ParserReceivable_0", (String)"ebg-note-banks-cmb-opa", (Object[])new Object[0]), response.getResponseMessage()));
        }
        JSONObject request = JSONObject.parseObject((String)res);
        JSONObject resp = request.getJSONObject("response");
        JSONObject body = resp.getJSONObject("body");
        JSONArray cltTrsDetailEdcOutDto = body.getJSONArray("cltTrsDetailEdcOutDto");
        JSONObject DTO = cltTrsDetailEdcOutDto.getJSONObject(cltTrsDetailEdcOutDto.size() - 1);
        JSONObject object = DTO.getJSONObject("intSrchZ1");
        String oprStp = object.getString("oprStp");
        String rstFlg = object.getString("rstFlg");
        String rjcCod = object.getString("rjcCod");
        String rjcRsn = object.getString("rjcRsn");
        JSONObject billFrontInfo = DTO.getJSONObject("billFrontInfoEdcDto");
        JSONObject cltTrsDetailInfoDto = DTO.getJSONObject("cltTrsDetailInfoDto");
        if (cltTrsDetailInfoDto != null) {
            String hasDiv = cltTrsDetailInfoDto.getString("hasDiv");
            if ("Y".equals(hasDiv)) {
                receivableInfos.get(0).setIsRefuse("1");
            } else {
                receivableInfos.get(0).setIsRefuse("0");
            }
        }
        if (billFrontInfo != null) {
            String bilNbr = billFrontInfo.getString("bilNbr");
            receivableInfos.get(0).setBillNo(bilNbr);
            String bilSbs = billFrontInfo.getString("bilSbs");
            receivableInfos.get(0).setStartNo(bilSbs);
            String bilSbe = billFrontInfo.getString("bilSbe");
            receivableInfos.get(0).setEndNo(bilSbe);
            String bilSts = billFrontInfo.getString("bilSts");
            receivableInfos.get(0).setNoteStatus(bilSts);
            String trdSts = billFrontInfo.getString("trdSts");
            receivableInfos.get(0).setCirStatus(trdSts);
            receivableInfos.get(0).setSubRange(bilSbs + "-" + bilSbe);
        }
        if ("AUT".equals(oprStp)) {
            EBGNoteReceivableUtils.setPaymentState(receivableInfos, (PaymentState)PaymentState.SUBMITED, (String)oprStp, (String)ResManager.loadKDString((String)"\u5f85\u5ba1\u6279", (String)"ParserReceivable_2", (String)"ebg-note-banks-cmb-opa", (Object[])new Object[0]));
        } else if ("OPR".equals(oprStp)) {
            EBGNoteReceivableUtils.setPaymentState(receivableInfos, (PaymentState)PaymentState.SUBMITED, (String)oprStp, (String)rstFlg);
        } else if (!"FIN".equals(oprStp) && !"NTE".equals(oprStp)) {
            EBGNoteReceivableUtils.setPaymentState(receivableInfos, (PaymentState)PaymentState.UNKNOWN, (String)oprStp, (String)oprStp);
        } else if (StringUtils.isEmpty((String)rstFlg)) {
            if (cltTrsDetailInfoDto != null) {
                String busSts = cltTrsDetailInfoDto.getString("busSts");
                if ("note_cancle".equals(receivableInfos.get(0).getSubBizType()) && "SY".equals(busSts)) {
                    EBGNoteReceivableUtils.setPaymentState(receivableInfos, (PaymentState)PaymentState.SUCCESS, (String)rstFlg, (String)"");
                } else {
                    EBGNoteReceivableUtils.setPaymentState(receivableInfos, (PaymentState)PaymentState.SUBMITED, (String)oprStp, (String)rstFlg);
                }
            } else {
                EBGNoteReceivableUtils.setPaymentState(receivableInfos, (PaymentState)PaymentState.SUBMITED, (String)oprStp, (String)rstFlg);
            }
        } else if ("S".equals(rstFlg)) {
            EBGNoteReceivableUtils.setPaymentState(receivableInfos, (PaymentState)PaymentState.SUCCESS, (String)rstFlg, (String)"");
        } else if ("F".equals(rstFlg) || "R".equals(rstFlg) || "C".equals(rstFlg) || "T".equals(rstFlg) || "D".equals(rstFlg)) {
            EBGNoteReceivableUtils.setPaymentState(receivableInfos, (PaymentState)PaymentState.FAIL, (String)rjcCod, (String)rjcRsn);
        } else if (cltTrsDetailInfoDto != null) {
            String busSts2 = cltTrsDetailInfoDto.getString("busSts");
            String ansCod = cltTrsDetailInfoDto.getString("ansCod");
            if (!"note_signin".equals(receivableInfos.get(0).getSubBizType()) && !"note_cancle".equals(receivableInfos.get(0).getSubBizType()) && !"nonnegotiable_cancle".equals(receivableInfos.get(0).getSubBizType()) && "SU01".equals(ansCod) && "SA".equals(busSts2)) {
                EBGNoteReceivableUtils.setPaymentState(receivableInfos, (PaymentState)PaymentState.FAIL, (String)rjcCod, (String)rjcRsn);
            }
        }
    }
}

