/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.icbc.opa.service.note.detail.endorseInfo;

import com.icbc.api.BizContent;
import com.icbc.api.DefaultIcbcClient;
import com.icbc.api.IcbcRequest;
import com.icbc.api.request.MybankEnterpriseBillQbasicbillRequestV1;
import com.icbc.api.response.MybankEnterpriseBillQbasicbillResponseV1;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.frame.Sequence;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.datetime.DateTimeUtils;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.note.banks.icbc.opa.service.note.detail.endorseInfo.EndorseRequestInfo;
import kd.ebg.note.banks.icbc.opa.service.note.util.GetStore;
import kd.ebg.note.common.entity.biz.notedetail.Detail;
import kd.ebg.note.common.entity.biz.notedetail.NoteSidesInfo;
import kd.ebg.note.common.framework.utils.ParserUtils;
import net.sf.json.JSONObject;

public class EndorseInfoImpl {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(EndorseInfoImpl.class);

    public static Detail getMessage(EndorseRequestInfo requestInfo) {
        String acntNo = "";
        String startNo = "";
        String endNo = "";
        String billNo = "";
        String URI = "mybank/enterprise/bill/qbasicbill/V1";
        String BASE_URL = GetStore.getBaseUrl();
        DefaultIcbcClient client = GetStore.getClient();
        try {
            MybankEnterpriseBillQbasicbillRequestV1.MybankEnterpriseBillQbasicbillRequestBizV1 bizContent = new MybankEnterpriseBillQbasicbillRequestV1.MybankEnterpriseBillQbasicbillRequestBizV1();
            MybankEnterpriseBillQbasicbillRequestV1 bankRequest = new MybankEnterpriseBillQbasicbillRequestV1();
            bizContent.setTransCode("QBASICBILL");
            String signDate4Test = RequestContextUtils.getParameter().getBankParameter("signDate4Test");
            boolean isProduct = StringUtils.isEmpty((String)signDate4Test);
            Date date = new Date();
            if (isProduct) {
                bizContent.setTranDate(DateTimeUtils.format((Date)date, (String)"yyyyMMdd"));
            } else {
                bizContent.setTranDate(signDate4Test);
            }
            bizContent.setTranTime(DateTimeUtils.format((Date)date, (String)"HHmmssSSS"));
            bizContent.setLanguage("zh_CN");
            bizContent.setfSeqNo(Sequence.gen18Sequence());
            ArrayList<MybankEnterpriseBillQbasicbillRequestV1.MybankEnterpriseBillQbasicbillRequestRdV1> rds = new ArrayList<MybankEnterpriseBillQbasicbillRequestV1.MybankEnterpriseBillQbasicbillRequestRdV1>(1);
            acntNo = requestInfo.getAccNo();
            startNo = requestInfo.getStartNo();
            endNo = requestInfo.getEndNo();
            billNo = requestInfo.getBillNo();
            MybankEnterpriseBillQbasicbillRequestV1.MybankEnterpriseBillQbasicbillRequestRdV1 rd = new MybankEnterpriseBillQbasicbillRequestV1.MybankEnterpriseBillQbasicbillRequestRdV1();
            rd.setAcctNo(acntNo);
            rd.setPackNo(billNo);
            rd.setRangeBgn(startNo);
            rd.setRangeEnd(endNo);
            rds.add(rd);
            bizContent.setRd(rds);
            bankRequest.setServiceUrl(BASE_URL + URI);
            bankRequest.setBizContent((BizContent)bizContent);
            logger.info("\u67e5\u8be2\u7968\u636e\u6b63\u80cc\u9762\u4fe1\u606f\u8bf7\u6c42\u53c2\u6570:\n" + JSONObject.fromObject((Object)bankRequest).toString());
            MybankEnterpriseBillQbasicbillResponseV1 response = (MybankEnterpriseBillQbasicbillResponseV1)client.execute((IcbcRequest)bankRequest);
            logger.info("\u67e5\u8be2\u7968\u636e\u6b63\u80cc\u9762\u4fe1\u606f\u94f6\u884c\u54cd\u5e94\u53c2\u6570:\n" + JSONObject.fromObject((Object)response).toString());
            return EndorseInfoImpl.parseEndorseInfo(response);
        }
        catch (Exception e) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u67e5\u8be2\u7968\u636e\u6b63\u80cc\u9762\u4fe1\u606f\u7ed3\u679c\u672a\u77e5", (String)"EndorseInfoImpl_0", (String)"ebg-note-banks-icbc-opa", (Object[])new Object[0]));
        }
    }

    public static Detail parseEndorseInfo(MybankEnterpriseBillQbasicbillResponseV1 response) {
        if (!response.isSuccess()) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u67e5\u8be2\u7968\u636e\u80cc\u9762\u4fe1\u606f\u94f6\u884c\u8fd4\u56de\u4fe1\u606f\u9519\u8bef", (String)"EndorseInfoImpl_1", (String)"ebg-note-banks-icbc-opa", (Object[])new Object[0]));
        }
        Detail result = new Detail();
        List rds = response.getRd();
        MybankEnterpriseBillQbasicbillResponseV1.MybankEnterpriseBillQbasicbillResponseRdV1 rd = (MybankEnterpriseBillQbasicbillResponseV1.MybankEnterpriseBillQbasicbillResponseRdV1)rds.get(0);
        String packNo = rd.getPackNo();
        result.setNoteNo(packNo);
        String rangeBgn = rd.getRangeBgn();
        result.setStartNo(rangeBgn);
        String rangeEnd = rd.getRangeEnd();
        result.setEndNo(rangeEnd);
        String rangeAmt = rd.getRangeAmt();
        if (StringUtils.isEmpty((String)rangeAmt)) {
            result.setAmount("0");
        } else {
            result.setAmount(String.valueOf(ParserUtils.convertCentStr2Yuan((String)rangeAmt)));
        }
        String cdTp = rd.getCdTp();
        result.setDraftType(cdTp);
        String dueDate = rd.getDueDate();
        result.setDueDate(dueDate);
        String issueDate = rd.getIssueDate();
        result.setIssueDate(issueDate);
        String drawerAcctNo = rd.getDrawerAcctNo();
        result.setDrawerAccNo(drawerAcctNo);
        String drawerAcctName = rd.getDrawerAcctName();
        result.setDrawerAccName(drawerAcctName);
        String drawerSvcr = rd.getDrawerSvcr();
        result.setDrawerCnapsCode(drawerSvcr);
        String drawerBranchName = rd.getDrawerBranchName();
        result.setDrawerBankName(drawerBranchName);
        String acceptAccNo = rd.getAcceptAccNo();
        result.setAcceptorAccNo(acceptAccNo);
        String acceptBankName = rd.getAccptrBranchName();
        result.setAcceptorBankName(acceptBankName);
        String acceptCustomerName = rd.getAcceptCustomerName();
        result.setAcceptorAccName(acceptCustomerName);
        String acceptSvcr = rd.getAcceptSvcr();
        result.setAcceptorCnapsCode(acceptSvcr);
        String payeeAcctNo = rd.getPayeeAcctNo();
        result.setPayeeAccNo(payeeAcctNo);
        String payeeAcctName = rd.getPayeeAcctName();
        result.setPayeeAccName(payeeAcctName);
        String payeeSvcr = rd.getPayeeSvcr();
        result.setPayeeCnapsCode(payeeSvcr);
        String payeeBranchName = rd.getPayeeBranchName();
        result.setPayeeBankName(payeeBranchName);
        String holderAcctNo = rd.getHolderAcctNo();
        result.setHolderAccNo(holderAcctNo);
        String holderSvcr = rd.getHolderSvcr();
        result.setHolderCnapsCode(holderSvcr);
        String holderAcctName = rd.getHolderAcctName();
        result.setPreHolderName(holderAcctName);
        String billStatus = rd.getBillStatus();
        result.setNoteStatus(billStatus);
        String rangeStage = rd.getRangeStage();
        result.setCirStatus(rangeStage);
        String notNegotiableFlag = rd.getNotNegotiableFlag();
        result.setTransferFlag(notNegotiableFlag);
        String billTypeFlag = rd.getBillTypeFlag();
        if ("BF02".equals(billTypeFlag)) {
            result.setGrdBag("0");
        } else {
            result.setGrdBag("1");
        }
        ArrayList<NoteSidesInfo> list = new ArrayList<NoteSidesInfo>(1);
        int i = 0;
        List rs = rd.getRs();
        for (MybankEnterpriseBillQbasicbillResponseV1.MybankEnterpriseBillQbasicbillResponseRsV1 content : rs) {
            if (!content.getEndorType().equals("ET05")) continue;
            NoteSidesInfo info = new NoteSidesInfo();
            info.setInitiatorAcNo(content.getApplyAcctNo());
            info.setInitiatorName(content.getApplyName());
            info.setInitiatorBankCnaps(content.getApplySvcr());
            info.setInitiatorORG(content.getApplyCredit());
            info.setOpponentAcNo(content.getReplyAcctNo());
            info.setOpponentName(content.getReplyAcctName());
            info.setSignDate(content.getActDate());
            info.setTransferFlag(content.getNotNegotiablendor());
            info.setBusinessCode("10");
            info.setResv1(i + "");
            list.add(info);
            ++i;
        }
        for (i = 0; i < list.size(); ++i) {
            NoteSidesInfo info = (NoteSidesInfo)list.get(i);
            info.setResv1(list.size() - i + "");
        }
        result.setNoteSidesInfo(list);
        return result;
    }
}

