/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.icbc.opa.service.note.receivable.signin;

import com.icbc.api.BizContent;
import com.icbc.api.DefaultIcbcClient;
import com.icbc.api.IcbcRequest;
import com.icbc.api.request.MybankEnterpriseBillSigcmtbillRequestV1;
import com.icbc.api.response.MybankEnterpriseBillSigcmtbillResponseV1;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.datetime.DateTimeUtils;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.note.banks.icbc.opa.service.note.receivable.signin.QuerySigninNoteReceivableImpl;
import kd.ebg.note.banks.icbc.opa.service.note.util.GetStore;
import kd.ebg.note.business.noteReceivable.atomic.AbstractNoteReceivableImpl;
import kd.ebg.note.business.noteReceivable.atomic.IQueryNoteReceivable;
import kd.ebg.note.business.noteReceivable.bank.BankNoteReceivableRequest;
import kd.ebg.note.business.noteReceivable.bank.EBBankNoteReceivableResponse;
import kd.ebg.note.business.noteReceivable.util.EBGNoteReceivableUtils;
import kd.ebg.note.common.entity.biz.status.PaymentState;
import kd.ebg.note.common.model.NoteReceivableInfo;
import net.sf.json.JSONObject;

public class SigninNoteReceivableImpl
extends AbstractNoteReceivableImpl {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(SigninNoteReceivableImpl.class);

    public long getBankInterval() {
        return 0L;
    }

    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryNoteReceivable> defaultQueryClass() {
        return QuerySigninNoteReceivableImpl.class;
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u7968\u636e\u7b7e\u6536", (String)"SigninNoteReceivableImpl_0", (String)"ebg-note-banks-icbc-opa", (Object[])new Object[0]);
    }

    public boolean match(NoteReceivableInfo noteReceivableInfo) {
        return true;
    }

    public EBBankNoteReceivableResponse doBiz(BankNoteReceivableRequest request) {
        String URI = "mybank/enterprise/bill/sigcmtbill/V1";
        String BASE_URL = GetStore.getBaseUrl();
        DefaultIcbcClient client = GetStore.getClient();
        List infos = request.getNoteReceivableInfos();
        NoteReceivableInfo info = (NoteReceivableInfo)infos.get(0);
        try {
            MybankEnterpriseBillSigcmtbillRequestV1.MybankEnterpriseBillSigcmtbillRequestBizV1 bizContent = new MybankEnterpriseBillSigcmtbillRequestV1.MybankEnterpriseBillSigcmtbillRequestBizV1();
            MybankEnterpriseBillSigcmtbillRequestV1 bankRequest = new MybankEnterpriseBillSigcmtbillRequestV1();
            bizContent.setTransCode("SIGCMTBILL");
            String signDate4Test = RequestContextUtils.getParameter().getBankParameter("signDate4Test");
            boolean isProduct = StringUtils.isEmpty((String)signDate4Test);
            Date date = new Date();
            if (isProduct) {
                bizContent.setTranDate(DateTimeUtils.format((Date)date, (String)"yyyyMMdd"));
            } else {
                bizContent.setTranDate(signDate4Test);
            }
            bizContent.setTranTime(DateTimeUtils.format((Date)date, (String)"HHmmssSSS"));
            bizContent.setLanguage("zh_CN");
            bizContent.setfSeqNo(request.getBankBatchSeqID());
            bizContent.setSignOper(info.getOtherInfo());
            ArrayList<MybankEnterpriseBillSigcmtbillRequestV1.MybankEnterpriseBillSigcmtbillRequestRdV1> rds = new ArrayList<MybankEnterpriseBillSigcmtbillRequestV1.MybankEnterpriseBillSigcmtbillRequestRdV1>(1);
            MybankEnterpriseBillSigcmtbillRequestV1.MybankEnterpriseBillSigcmtbillRequestRdV1 rd = new MybankEnterpriseBillSigcmtbillRequestV1.MybankEnterpriseBillSigcmtbillRequestRdV1();
            rd.setSignAcctNo(info.getDrawerAccNo());
            rd.setPackNo(info.getBillNo());
            rd.setRangeBgn(info.getStartNo());
            rd.setRangeEnd(info.getEndNo());
            String code = info.getOperationCode();
            String transCode = "NES_AC_02";
            if ("02".equals(code)) {
                transCode = "NES_AC_02";
            } else if ("03".equals(code)) {
                transCode = "NES_RB_02";
            } else if ("10".equals(code)) {
                transCode = "NES_ED_02";
            } else if ("18".equals(code)) {
                transCode = "NES_PD_02";
            } else if ("20".equals(code)) {
                transCode = "CPR_PS_02";
            }
            rd.setBusiType(transCode);
            if (info.getOtherInfo().equals("SU01")) {
                rd.setSignResult("CP06");
                rd.setReason(info.getExplanation());
            }
            rds.add(rd);
            bizContent.setRd(rds);
            bankRequest.setServiceUrl(BASE_URL + URI);
            bankRequest.setBizContent((BizContent)bizContent);
            logger.info("\u7b7e\u6536\u94f6\u884c\u8bf7\u6c42\u53c2\u6570:\n" + JSONObject.fromObject((Object)bankRequest).toString());
            try {
                MybankEnterpriseBillSigcmtbillResponseV1 response = (MybankEnterpriseBillSigcmtbillResponseV1)client.execute((IcbcRequest)bankRequest);
                logger.info("\u7b7e\u6536\u94f6\u884c\u8fd4\u56de\u53c2\u6570:\n" + JSONObject.fromObject((Object)response).toString());
                return this.parse(request, response);
            }
            catch (Exception e) {
                logger.error("\u53d1\u9001\u5f02\u5e38\uff1a", (Throwable)e);
                EBContext.getContext().setThrowableAfterSend((Throwable)e);
                return null;
            }
        }
        catch (Exception e) {
            logger.error("\u5f02\u5e38\uff1a", (Throwable)e);
            String causeMsg = Objects.nonNull(e.getCause()) ? "||" + e.getCause().toString() : "";
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u5931\u8d25 %s", (String)"NoteDetailImpl_10", (String)"ebg-note-banks-icbc-opa", (Object[])new Object[0]), e.getMessage() + causeMsg));
        }
    }

    public EBBankNoteReceivableResponse parse(BankNoteReceivableRequest rqst, MybankEnterpriseBillSigcmtbillResponseV1 response) {
        List infos = rqst.getNoteReceivableInfos();
        if (!response.isSuccess()) {
            int code = response.getReturnCode();
            if (code < 0) {
                EBGNoteReceivableUtils.setPaymentState((List)infos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u7ed3\u679c\u672a\u77e5", (String)"SigninNoteReceivableImpl_5", (String)"ebg-note-banks-icbc-opa", (Object[])new Object[0]), (String)response.getReturnMsg());
            } else {
                EBGNoteReceivableUtils.setPaymentState((List)infos, (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u7b7e\u6536\u5931\u8d25", (String)"SigninNoteReceivableImpl_1", (String)"ebg-note-banks-icbc-opa", (Object[])new Object[0]), (String)response.getReturnMsg());
            }
            return new EBBankNoteReceivableResponse(infos);
        }
        String innerCode = response.getResult();
        String batSerialNo = response.getBatSerialNo();
        for (NoteReceivableInfo info : infos) {
            info.setBankRefKey(info.getBankBatchSeqId());
            info.setRspserialno(batSerialNo);
        }
        switch (innerCode) {
            case "6": {
                EBGNoteReceivableUtils.setPaymentState((List)infos, (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u88ab\u94f6\u884c\u62d2\u7edd", (String)"SigninNoteReceivableImpl_2", (String)"ebg-note-banks-icbc-opa", (Object[])new Object[0]), (String)response.getReturnMsg());
            }
            case "7": {
                EBGNoteReceivableUtils.setPaymentState((List)infos, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u6307\u4ee4\u63d0\u4ea4\u6210\u529f", (String)"SigninNoteReceivableImpl_3", (String)"ebg-note-banks-icbc-opa", (Object[])new Object[0]), (String)response.getReturnMsg());
            }
            case "9": {
                EBGNoteReceivableUtils.setPaymentState((List)infos, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4e2d", (String)"SigninNoteReceivableImpl_4", (String)"ebg-note-banks-icbc-opa", (Object[])new Object[0]), (String)response.getReturnMsg());
            }
        }
        EBGNoteReceivableUtils.setPaymentState((List)infos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u7ed3\u679c\u672a\u77e5", (String)"SigninNoteReceivableImpl_5", (String)"ebg-note-banks-icbc-opa", (Object[])new Object[0]), (String)response.getReturnMsg());
        return new EBBankNoteReceivableResponse(infos);
    }

    public String pack(BankNoteReceivableRequest bankNoteReceivableRequest, String s) {
        return null;
    }

    public List<NoteReceivableInfo> parse(BankNoteReceivableRequest bankNoteReceivableRequest, String s) {
        return null;
    }
}

