/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.business.noteReceivable;

import com.google.common.base.Preconditions;
import java.net.MalformedURLException;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.entity.base.EBRequest;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.biz.EBServiceMethod;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.log.MDCUtil;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.string.StrUtil;
import kd.ebg.note.business.noteReceivable.util.NoteReceivableConvert;
import kd.ebg.note.business.noteReceivable.util.QueryNoteReceivableUtil;
import kd.ebg.note.business.util.AccessUtils;
import kd.ebg.note.business.util.CacheQueryPayStorage;
import kd.ebg.note.common.entity.biz.querynotereceivable.QueryNoteReceivableRequest;
import kd.ebg.note.common.entity.biz.querynotereceivable.QueryNoteReceivableResponse;
import kd.ebg.note.common.entity.biz.status.PaymentState;
import kd.ebg.note.common.framework.services.NoteReceivableInfoService;
import kd.ebg.note.common.model.NoteReceivableInfo;
import org.slf4j.MDC;

public class QueryNoteReceivableMethod
implements EBServiceMethod<QueryNoteReceivableRequest, QueryNoteReceivableResponse> {
    private EBGLogger logger = EBGLogger.getInstance().getLogger(QueryNoteReceivableMethod.class);

    public QueryNoteReceivableResponse executeClientRequest(QueryNoteReceivableRequest request, EBContext context) throws MalformedURLException {
        AccessUtils.checkQueryAllowed((EBContext)context);
        MDCUtil.clearBussinessMDC();
        MDCUtil.initMDC();
        MDC.put((String)"bussiness_type", (String)"bussiness_process");
        String batchSeqID = request.getBody().getBatchSeqId();
        String reserved1 = request.getBody().getReserved1();
        Preconditions.checkArgument((boolean)StrUtil.isNotBlank((CharSequence)batchSeqID), (Object)ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u6279\u6b21\u6d41\u6c34\u53f7\u3002", (String)"QueryNoteReceivableMethod_0", (String)"ebg-note-business", (Object[])new Object[0]));
        List infos = NoteReceivableInfoService.getInstance().selectByBatchSeqID(batchSeqID);
        if (infos.isEmpty()) {
            throw EBExceiptionUtil.preCheckException((String)"unknown_batch", (String)String.format(ResManager.loadKDString((String)"\u672a\u627e\u5230\u8be5\u6279\u6b21\u53f7\uff1a%s\u3002", (String)"QueryNoteReceivableMethod_3", (String)"ebg-note-business", (Object[])new Object[0]), batchSeqID));
        }
        String customId = request.getHeader().getCustomId();
        String key = customId + batchSeqID;
        boolean isHasSubmitting = infos.stream().anyMatch(info -> info.getStatus().intValue() == PaymentState.SUBMITTING.getId());
        if (!CacheQueryPayStorage.checkRepeat((String)key)) {
            if ("unittest".equals(reserved1)) {
                Set paymentInfoSet = QueryNoteReceivableUtil.setOfPay((List)infos);
                QueryNoteReceivableUtil.async((Set)paymentInfoSet, (EBRequest)request, (BankAcnt)context.getAcnt(), (String)reserved1);
            } else if (isHasSubmitting) {
                LocalDateTime submitSuccessTime = ((NoteReceivableInfo)infos.get(0)).getUpdateTime();
                Duration duration = Duration.between(submitSuccessTime, LocalDateTime.now());
                long minutes = duration.toMinutes();
                if (minutes > 20L) {
                    for (NoteReceivableInfo info2 : infos) {
                        if (info2.getStatus().intValue() != PaymentState.SUBMITTING.getId()) continue;
                        info2.setStatus(Integer.valueOf(PaymentState.UNKNOWN.getId()));
                        info2.setStatusName(PaymentState.UNKNOWN.getEnName());
                        info2.setStatusMsg(String.format(ResManager.loadKDString((String)"\u63d0\u4ea4\u4e2d\u72b6\u6001\u5df2\u6301\u7eed\u8d85\u8fc720\u5206\u949f\u3002", (String)"QueryNoteReceivableMethod_4", (String)"ebg-note-business", (Object[])new Object[0]), PaymentState.UNKNOWN.getCnName()));
                    }
                    Set paymentInfoSet = QueryNoteReceivableUtil.setOfPay((List)infos);
                    QueryNoteReceivableUtil.async((Set)paymentInfoSet, (EBRequest)request, (BankAcnt)context.getAcnt(), (String)reserved1);
                }
            } else if (((NoteReceivableInfo)infos.get(0)).getStatus().intValue() != PaymentState.PACKAGED.getId()) {
                if (!this.isNeedQuery(infos)) {
                    if ("forceQuery".equals(reserved1)) {
                        Set paymentInfoSet = QueryNoteReceivableUtil.setOfPay((List)infos);
                        QueryNoteReceivableUtil.async((Set)paymentInfoSet, (EBRequest)request, (BankAcnt)context.getAcnt(), (String)reserved1);
                    }
                } else {
                    Set paymentInfoSet = QueryNoteReceivableUtil.setOfPay((List)infos);
                    QueryNoteReceivableUtil.async((Set)paymentInfoSet, (EBRequest)request, (BankAcnt)context.getAcnt(), (String)reserved1);
                }
            }
        } else {
            if ("unittest".equals(reserved1)) {
                Set paymentInfoSet = QueryNoteReceivableUtil.setOfPay((List)infos);
                QueryNoteReceivableUtil.async((Set)paymentInfoSet, (EBRequest)request, (BankAcnt)context.getAcnt(), (String)reserved1);
            }
            this.logger.info("\u5f53\u524d\u6279\u6b21\u5df2\u7ecf\u5b58\u5728\u540c\u6b65\u67e5\u8be2\u7684\u8bf7\u6c42\uff0c\u672c\u6b21\u8bf7\u6c42\u4e0d\u751f\u6548");
        }
        return NoteReceivableConvert.convertToResponse((List<NoteReceivableInfo>)infos, request);
    }

    public boolean isNeedQuery(List<NoteReceivableInfo> infos) {
        for (NoteReceivableInfo info : infos) {
            if (info.getStatus().intValue() == PaymentState.SUCCESS.getId() || info.getStatus().intValue() == PaymentState.FAIL.getId()) continue;
            return true;
        }
        return false;
    }

    public boolean needCheckAccNo() {
        return true;
    }

    public String bizName() {
        return "queryNoteReceivable";
    }
}

